//
//  XTHtmlTagFont.m
//  TadsTerp
//
//  Created by Rune Berg on 20/08/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTagFont.h"
#import "XTOutputFormatterProtocol.h"
#import "XTHtmlColor.h"
#import "XTHtmlUtils.h"


@implementation XTHtmlTagFont

+ (NSString *)name
{
	return @"font";
}

+ (BOOL)standalone
{
	return NO;
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [XTFormattingSpecification specificationFrom:formattingSpec];

	[XTHtmlUtils extractHtmlFontSizeFromTag:self toFormattingSpec:res];
	[XTHtmlUtils extractHtmlFontFaceFromTag:self toFormattingSpec:res];
	[XTHtmlUtils extractHtmlFontColorFromTag:self toFormattingSpec:res];

	NSString *bgColorAttr = [self attributeAsString:@"bgcolor"];
	if (bgColorAttr != nil) {
		res.backgroundColor = [XTHtmlColor forAttributeValue:bgColorAttr];
	}
	
	//TODO !!! inherited behaviour like htmltags.cpp l.3408 ?
	
	return res;
}

@end
