//
//  XTHtmlTagCredit.m
//  XTads
//
//  Created by Rune Berg on 11/01/2021.
//  Copyright © 2021 Rune Berg. All rights reserved.
//

#import "XTHtmlTagCredit.h"
#import "XTBaseTextHandler.h"
#import "XTHtmlTagText.h"


@implementation XTHtmlTagCredit

+ (NSString *)name
{
	return @"credit";
}

- (id)init
{
	self = [super init];
	if (self) {
		XTHtmlTagText *tagPrefix = [XTHtmlTagText tagWithText:@"—"];
		[self appendToContents:tagPrefix];
	}
	return self;
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [XTFormattingSpecification specificationFrom:formattingSpec];
	res.credit = YES;
	return res;
}

@end
