//
//  XTHtmlSpecialSpace.m
//  XTads
//
//  Created by Rune Berg on 01/11/2016.
//  Copyright © 2016 Rune Berg. All rights reserved.
//

#import "XTHtmlTagSpecialSpace.h"
#import "XTAllocDeallocCounter.h"
#import "XTBaseTextHandler.h"


@implementation XTHtmlTagSpecialSpace

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

+ (id)tagWithChar:(unichar)ch
{
	XTHtmlTagSpecialSpace *ss = [[XTHtmlTagSpecialSpace alloc] initWithChar:ch];
	return ss;
}

- (id)initWithChar:(unichar)ch
{
	self = [super init];
	if (self != nil) {
		_ch = ch;
	}
	return self;
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler
{
	NSArray *formattedElements = [formatter handleHtmlTagSpecialSpace:self];
	[textHandler receiveFormattedElements:formattedElements];
}

@end
