//
//  XTHtmlBlockQuoteTag.m
//  TadsTerp
//
//  Created by Rune Berg on 08/08/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTagBlockQuote.h"
#import "XTHtmlTag_private.h"
#import "XTHtmlTagContainer_private.h"
#import "XTBaseTextHandler.h"


@interface XTHtmlTagBlockQuote ()

@property NSUInteger blockquoteLevel;

@end


@implementation XTHtmlTagBlockQuote

+ (NSString *)name
{
	return @"blockquote";
}

+ (NSArray<NSString *>*)nameSynonyms
{
	return @[@"bq"];
}

+ (BOOL)standalone
{
	return NO;
}

- (BOOL)blockLevel
{
	BOOL res = [self isAllowed];
	return res;
}

- (BOOL)blockLevelSpacingBefore
{
	BOOL res = [self isAllowed];
	return res;
}

- (BOOL)blockLevelSpacingAfter
{
	BOOL res = [self isAllowed];
	return res;
}

- (void)onParsing:(NSObject<XTOutputTextParserProtocol> *)parser
{
	[super onParsing:parser];
	
	if ([self isAllowed]) {
		self.blockquoteLevel = [self.container getBlockquoteNestingLevel] + 1;
	}
}

- (NSUInteger)getBlockquoteNestingLevel
{
	return self.blockquoteLevel;
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [XTFormattingSpecification specificationFrom:formattingSpec];
	
	// <blockquote>, <bq> are not allowed in lists (unlike browsers)
	if (! [self isAllowed]) {
		return res;
	}

	res.blockquoteLevel = [self getBlockquoteNestingLevel];
	return res;
}

- (BOOL)isAllowed
{
	// see HTML TADS' htmltags.h - int allowed_in_list() const { return FALSE; }
	BOOL res = (! [self isInList]);
	return res;
}

@end
