//
//  XTHtmlTagText.m
//  XTads
//
//  Created by Rune Berg on 12/05/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTHtmlTagText.h"
#import "XTBaseTextHandler.h"


@implementation XTHtmlTagText

- (instancetype)initWithText:(NSString *)text
{
	self = [super init];
	if (self) {
		_text = text;
	}
	return self;
}

+ (NSString *)name
{
	return @"xtads-text";
}

+ (instancetype)tagWithText:(NSString *)text
{
	XTHtmlTagText *tag = [[XTHtmlTagText alloc] initWithText:text];
	return tag;
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler;
{
	NSArray *formattedElements = [formatter handleHtmlTagText:self];
	[textHandler receiveFormattedElements:formattedElements];
}

@end
