#include <adv.t>
#include <std.t>

startroom : room
  sdesc = "Fireplace"
  ldesc = "You are standing in front of a brick fireplace.  Above the
  fireplace is a dusty mantle. A wall calendar hangs over the mantle. "
;

fireplace : decoration
  location = startroom
  noun = 'fireplace' 'fire'
  adjective = 'brick'
  sdesc = "fireplace"
  ldesc = "A warm fire crackles and glows in the fireplace."
;

mantle : decoration
  location = startroom
  noun = 'mantle'
  adjective = 'dusty'
  sdesc = "mantle"
  ldesc = "The mantle is covered with a thick layer of dust."
;

dust : decoration
  location = startroom
  noun = 'dust'
  sdesc = "dust"
  adesc = "some dust"
  ldesc = "The dust has clearly been undisturbed for years."
;

invitation : readable
  location = startroom
  noun = 'invitation'
  adjective = 'party'
  sdesc = "party invitation"
  ldesc = "You are cordially invited to attend a Halloween costume ball
  at the haunted mansion.  The party starts at 8PM.  RSVP."
;
  
photo : readable
  location = startroom
  noun = 'photo'
  adjective = 'autographed' 'autograph'
  sdesc = "autographed photo"
  adesc = "an autographed photo"
  ldesc = "This black and white photo of a snow-capped mountain appears
  to be autographed in the lower-right corner.  Although the handwriting
  is messy, you could probably read the message if you tried."
  readdesc = "Reality is better than our best fantasies.  -- Ansel
  Adams"
;

calendar : fixeditem, readable
  location = startroom
  noun = 'calendar'
  adjective = 'wall'
  sdesc = "wall calendar"
  ldesc = "The calendar is turned to the month of December.  All the
  Saturdays are circled in red."
;
