////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: TravelVerb 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _TRAVEL_VERB_H_
#define _TRAVEL_VERB_H_

#pragma C+

#include <deepverb.h>
#include <darkverb.h>

/*
 *   Travel verbs  - these verbs allow the player to move about.
 *   All travel verbs have the property isTravelVerb set true.
 */
class TravelVerb: DarkVerb
    isTravelVerb = true
;

dVerb: TravelVerb
    verb = 'd' 'down' 'go down'
    sDesc = "go down"
    action(actor) = { actor.travelTo(self.travelDir(actor)); }
    travelDir(actor) = { return actor.location.down; }
;
eVerb: TravelVerb
    verb = 'e' 'east' 'go east'
    sDesc = "go east"
    action(actor) = { actor.travelTo(self.travelDir(actor)); }
    travelDir(actor) = { return actor.location.east; }
;
inVerb: TravelVerb
    verb = 'in' 'go in' 'enter' 'go to' 'go into'
    sDesc = "enter"
    doAction = 'Enter'
    ioAction(inPrep) = 'EnterIn'
    ioAction(onPrep) = 'EnterOn'
    ioAction(withPrep) = 'EnterWith'
    action(actor) = { actor.travelTo(self.travelDir(actor)); }
    travelDir(actor) = { return actor.location.in; }
;
nVerb: TravelVerb
    verb = 'n' 'north' 'go north'
    sDesc = "go north"
    action(actor) = { actor.travelTo(self.travelDir(actor)); }
    travelDir(actor) = { return actor.location.north; }
;
neVerb: TravelVerb
    verb = 'ne' 'northeast' 'go ne' 'go northeast'
    sDesc = "go northeast"
    action(actor) = { actor.travelTo(self.travelDir(actor)); }
    travelDir(actor) = { return actor.location.ne; }
;
nwVerb: TravelVerb
    verb = 'nw' 'northwest' 'go nw' 'go northwest'
    sDesc = "go northwest"
    action(actor) = { actor.travelTo(self.travelDir(actor)); }
    travelDir(actor) = { return actor.location.nw; }
;
outVerb: TravelVerb
    verb = 'out' 'go out' 'exit' 'leave'
    sDesc = "go out"
    action(actor) = { actor.travelTo(self.travelDir(actor)); }
    travelDir(actor) = { return actor.location.out; }
;
sVerb: TravelVerb
    verb = 's' 'south' 'go south'
    sDesc = "go south"
    action(actor) = { actor.travelTo(self.travelDir(actor)); }
    travelDir(actor) = { return actor.location.south; }
;
seVerb: TravelVerb
    verb = 'se' 'southeast' 'go se' 'go southeast'
    sDesc = "go southeast"
    action(actor) = { actor.travelTo(self.travelDir(actor)); }
    travelDir(actor) = { return actor.location.se; }
;
swVerb: TravelVerb
    verb = 'sw' 'southwest' 'go sw' 'go southwest'
    sDesc = "go southwest"
    action(actor) = { actor.travelTo(self.travelDir(actor)); }
    travelDir(actor) = { return actor.location.sw; }
;
uVerb: TravelVerb
    verb = 'u' 'up' 'go up'
    sDesc = "go up"
    action(actor) = { actor.travelTo(self.travelDir(actor)); }
    travelDir(actor) = { return actor.location.up; }
;
wVerb: TravelVerb
    verb = 'w' 'west' 'go west'
    sDesc = "go west"
    action(actor) = { actor.travelTo(self.travelDir(actor)); }
    travelDir(actor) = { return actor.location.west; }
;

#pragma C-

#endif /* _TRAVEL_VERB_H_ */
