////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Prep 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _PREP_H_
#define _PREP_H_

#pragma C+

/*
 *  Prep: object
 *
 *  A preposition.  The preposition property specifies the
 *  vocabulary word.
 */
class Prep: object
    sdesc = {self.sDesc;}   // used as a parser hook for Alt version.
;

aboutPrep: Prep
    preposition = 'about'
    sDesc = "about"
;
aroundPrep: Prep
    preposition = 'around'
    sDesc = "around"
;
atPrep: Prep
    preposition = 'at'
    sDesc = "at"
;
behindPrep: Prep
    preposition = 'behind'
    sDesc = "behind"
;
betweenPrep: Prep
    preposition = 'between' 'inbetween'
    sDesc = "between"
;
dirPrep: Prep
    preposition = 'north' 'south' 'east' 'west' 'up' 'down' 'northeast' 'ne'
                  'northwest' 'nw' 'southeast' 'se' 'southwest' 'sw'
                  'n' 's' 'e' 'w' 'u' 'd'
    sDesc = "north"         // Shouldn't ever need this, but just in case
;
forPrep: Prep
    preposition = 'for'
    sDesc = "for"
;
fromPrep: Prep
    preposition = 'from'
    sDesc = "from"
;
inPrep: Prep
    preposition = 'in' 'into' 'downin'
    sDesc = "in"
;
ofPrep: Prep
    preposition = 'of'
    sDesc = "of"
;
offPrep: Prep
    preposition = 'off' 'offof'
    sDesc = "off"
;
onPrep: Prep
    preposition = 'on' 'onto' 'downon' 'upon'
    sDesc = "on"
;
outPrep: Prep
    preposition = 'out' 'outof'
    sDesc = "out"
;
overPrep: Prep
    preposition = 'over'
    sDesc = "over"
;
thruPrep: Prep
    preposition = 'through' 'thru'
    sDesc = "through"
;
toPrep: Prep
    preposition = 'to'
    sDesc = "to"
;
underPrep: Prep
    preposition = 'under' 'beneath'
    sDesc = "under"
;
withPrep: Prep
    preposition = 'with'
    sDesc = "with"
;

#pragma C-

#endif /* _PREP_H_ */
