////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: switchPlayer() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _SWITCH_PLAYER_T_
#define _SWITCH_PLAYER_T_

#pragma C+

/*
 *  switchPlayer: function
 *
 *  Switch the player character to a new actor.  This function uses the
 *  parserSetMe() built-in function to change the parser's internal
 *  record of the player character object, and in addition performs some
 *  necessary modifications to the outgoing and incoming player character
 *  objects.  First, because the player character object is by convention
 *  never part of its room's contents list, we add the outgoing actor to
 *  its location's contents list, and remove the incoming actor from its
 *  location's contents list.  Second, we remove the vocabulary words
 *  "me" and "myself" from the outgoing object, and add them to the
 *  incoming object.
 */
switchPlayer: function(newPlayer) {
    /* if this is the same as the current player character, do nothing */
    if (parserGetMe() == newPlayer)
        return;

    /* 
     *   add the outgoing player character to its location's contents --
     *   it's going to be an ordinary actor from now on, so it should be
     *   in its location's contents list 
     */
    if (parserGetMe() != nil && parserGetMe().location != nil)
        parserGetMe().location.contents += parserGetMe();

    /* 
     *   remove the incoming player character from its location's contents
     *   -- by convention, the active player character is never in its
     *   location's contents list 
     */
    if (newPlayer != nil && newPlayer.location != nil)
        newPlayer.location.contents -= newPlayer;

    /* 
     *   remove "me" and "myself" from the old object's vocabulary -- it's
     *   no longer "me" from the player's perspective 
     */
    delword(parserGetMe(), &noun, 'me');
    delword(parserGetMe(), &noun, 'myself');

    /* establish the new player character object in the parser */
    parserSetMe(newPlayer);

    /* add "me" and "myself" to the new player character's vocabulary */
    addword(newPlayer, &noun, 'me');
    addword(newPlayer, &noun, 'myself');
}

#pragma C-

#endif /* _SWITCH_PLAYER_T_ */
