////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: _rand() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef __RAND_T_
#define __RAND_T_

#pragma C+

/*
 *  _rand: function(x)
 *
 *  This is a modified version of the built-in random number generator, which
 *  may improve upon the standard random number generator's statistical
 *  performance in many cases.  To use this replacement, simply call _rand
 *  instead of rand in your code.
 */
_rand: function(x) {
    return (((rand(16*x)-1)/16)+1);
}

#pragma C-

#endif /* __RAND_T_ */
