////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: quitGame() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _QUIT_GAME_T_
#define _QUIT_GAME_T_

#include <global.t>

#pragma C+

/*
 *  quitGame: function
 *
 *  This is a simple cover function for the built-in function quit().
 *  This cover function displays any outcaptured display.
 */
quitGame: function {
    local ret, str;

    /* Capture any outcapture text and display it. */
    str = nestOutcapture(nil, true);
    say(str);

    /* quit */
    ret = quit();

    /* if outcapturing was set then reset it. */
    if (global.outcaptureStatus != nil)
        nestOutcapture(true);
        
    /* return the line of text */
    return ret;
}

#pragma C-

#endif /* _QUIT_GAME_T_ */
