////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: preparse() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _PREPARSE_T_
#define _PREPARSE_T_

#include <global.t>

#pragma C+

/*
 *  preparse: function(cmd)
 *
 *  This replacement implements the processing of preparse objects. It
 *  allows for the definition of multiple preparse routines. 
 */
preparse: function(cmd) {
	local o, p, ret;
	
	// Set Command Phase
	global.setCommandPhase(CP_PARSING);
	
	global.cmdDoWords = [];
	global.cmdIoWords = [];
	
	p = global.preparseObjList;
	o = car( p );
	while(o) {
	    if (proptype(o, &ppoMethod) != DTY_NIL) {
    		ret = o.ppoMethod( cmd );
		    if (ret != true) return ret;
	    }
		p = cdr( p );
		o = car( p );
	}
	return true;
}

#pragma C-

#endif /* _PREPARSE_T_ */
