////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: preCommand() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _PRE_COMMAND_T_
#define _PRE_COMMAND_T_

#include <stringizer.h>
#include <gactor.t>
#include <gcmdstring.t>
#include <gcmdwordlist.t>
#include <gdolist.t>
#include <giobj.t>
#include <gprep.t>
#include <gverb.t>
#include <nestoutcapture.t>
#include <global.t>

#pragma C+

preCommand: function(actor, verb, doList, prep, iobj) {
    local i, len, dobj, ret, str;

    // Move Floating objects to their containers
    moveFloating(actor);

    // Set Command Phase and elements
    global.setCommandPhase(CP_PRECOMMAND);
        
    // Set the global command elements
    gActor(actor);
    gVerb(verb);
    gDoList(doList);
    gPrep(prep);
    gIobj(iobj);
    
    /*  
     *  Set the global command string only when the player has entered
     *  a command. This avoids saving a command string in cases where
     *  execCommand() has generated the action.
     */
    if (length(gCmdWordList())) {
        str = Stringizer.buildCmdString(actor, gCmdWordList());
        gCmdString(str);
    }
    
    if (length(doList) == 0 && iobj == nil) 
        nestOutcapture(true);
        
    /* 
     *  Validate the command 
     */
    len = length(doList);
    for (i = 1; i <= len; i++) {
        dobj = doList[i];
        
        gDobj(doList[i]);
        ret = checkAccessibility(actor, verb, dobj, prep, iobj, i);
        if (dobj) dobj.sensedByPreferred = nil;
        if (iobj) iobj.sensedByPreferred = nil;
        if (ret == nil) abort;
    }
}

/*
 *  checkAccessibility(actor, verb, dobj, prep, iobj)
 *
 *  Function determines the accessibility of the action under
 *  consideration for the objects involved. The indirect object is
 *  checked first, followed by the direct object. The function will 
 *  check the command for all multiple direct objects before passing
 *  control.
 *
 *  If the command fails to pass testScope() for the specified
 *  action, objects, and filter then the verb.cantReach() method is
 *  called and the function returns nil.
 *
 *  If the command passes testScope() for the specified 
 *  action, objects, and filter then it returns true.
 */
checkAccessibility: function(actor, verb, dobj, prep, iobj, seqno) {
    if (iobj != nil) {
        
        if (!iobj.sensedByPreferred) {
            /*
             *  Checking the indirect object accessibility
             */
            if (!verb.validIoSense(actor, iobj, seqno))
            {
                verb.cantReach(actor, nil, [iobj], prep);
                return nil;
            }
        }
    }
    
    if (dobj != nil) {
        if (!dobj.sensedByPreferred) {
            /*
             *  Checking the direct object accessibility
             */
            if (!verb.validDoSense(actor, dobj, seqno))
            {
                verb.cantReach(actor, [dobj], nil, prep);
                return nil;
            }
        }
    }
    return true;
}

#pragma C-

#endif /* _PRE_COMMAND_T_ */
