////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: numberedCleanup() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _NUMBERED_CLEANUP_T_
#define _NUMBERED_CLEANUP_T_

#pragma C+

/*
 *  numberedCleanup: function
 *
 *  This function is used as a fuse to delete objects created by the
 *  numberedObject class in reponse to calls to its newNumbered
 *  method.  Whenever that method creates a new object, it sets up a fuse
 *  call to this function to delete the object at the end of the turn in
 *  which it created the object.
 */
numberedCleanup: function(obj) {
    delete obj;
}

#pragma C-

#endif /* _NUMBERED_CLEANUP_T_ */
