////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: nestOutcapture() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _NEST_OUTCAPTURE_T_
#define _NEST_OUTCAPTURE_T_

#include <stack.h>
#include <global.t>

#pragma C+

/*
 *  nestOutcapture: function(parm)
 *
 *  This is a simple cover function for the built-in function 
 *  outcapture(). The function takes either true or nil as a 
 *  parameter. If true then outcapture() nesting is turned on 
 */
nestOutcapture: function(parm, ...) {
    local ret, str = '', saveStr, term;
    
    if (argcount > 1) term = getarg(2);
    
    // Create a LIFO stacks for outcapture status and text
    if (global.outcaptureStatusStack == nil){ 
        global.outcaptureStatusStack = new Stack; 
        global.outcaptureStringStack = new Stack;
    }
    
    /*
     *  SET
     *
     *  If parm is true we first capture any pending outcapture() text,
     *  push the old status and text onto stacks, then turn outcapture
     *  on, setting the status to the new value.
     */
    if (parm) {
        /* Capture any higher-level outcapture */
        if (global.outcaptureStatus != nil) {
            str = outcapture(global.outcaptureStatus);
            global.outcaptureStatusStack.push(global.outcaptureStatus);
            global.outcaptureStringStack.push(str);
        }
        global.outcaptureStatus = outcapture(true);
    } else if (global.outcaptureStatus != nil) {
    /*
     *  GET
     *
     *  Parm is nil. We check for any current outcapture, retrieve it,
     *  then pop the status and text for any pending outcapture.
     */
        if (term) {
            local tmpStr;
            
            // Get any pending outcapture for this nesting-level
            tmpStr = outcapture(global.outcaptureStatus);
            
            // Change the stacks to FIFO
            global.outcaptureStatusStack.isLIFO = nil;
            global.outcaptureStringStack.isLIFO = nil;  
            
            // Dump the stacks
            while(global.outcaptureStatus != nil) {
                global.outcaptureStatus =
                    global.outcaptureStatusStack.pop;
                saveStr = global.outcaptureStringStack.pop;
                if (saveStr != nil)
                    str += saveStr;
            }
            
            // display the outcapture string.
            str += tmpStr;
            
            // Change the stacks back to LIFO
            global.outcaptureStatusStack.isLIFO = true;
            global.outcaptureStringStack.isLIFO = true;  
            
        } else {
            str = outcapture(global.outcaptureStatus);
            global.outcaptureStatus = global.outcaptureStatusStack.pop;
            saveStr = global.outcaptureStringStack.pop;
            global.outcaptureStatus = outcapture(true);
            say(saveStr);
        }
    }
    return str;
}

#pragma C-

#endif /* _NEST_OUTCAPTURE_T_ */
