////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: isIndistinguishable() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _IS_INDISTINGUISHABLE_T_
#define _IS_INDISTINGUISHABLE_T_

#pragma C+

/*
 *  isIndistinguishable: function(obj1, obj2)
 *
 *  Returns true if the two objects are indistinguishable for the purposes
 *  of listing.  The two objects are equivalent if they both have the
 *  isEquivalent property set to true, they both have the same immediate
 *  superclass, and their other listing properties match (in particular,
 *  wearer and (isLamp and lightsOn) match for both objects).
 */
isIndistinguishable: function(obj1, obj2) {
    return (firstsc(obj1) == firstsc(obj2)
            && obj1.wearer == obj2.wearer
            && ((obj1.isLamp && obj1.lightsOn)
                 == (obj2.isLamp && obj2.lightsOn)));
}

#pragma C-

#endif /* _IS_INDISTINGUISHABLE_T_ */
