////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: checkReach() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _CHECK_REACH_T_
#define _CHECK_REACH_T_

#include <integer.h>
#include <string.h>

#pragma C+

/*
 *   checkReach: determines whether the object obj can be reached by
 *   actor in location loc, using the verb v.  This routine returns true
 *   if obj is a special object (numObj or strObj), if obj is in actor's
 *   inventory or actor's location, or if it's in the 'reachable' list for
 *   loc.  
 */
checkReach: function(loc, actor, v, obj) {
    if (obj == numObj || obj == strObj)
        return;
        
    if (!(actor.isCarrying(obj) || 
    (obj.isIn(actor.location) && obj.isVisible(actor)))) {
        if (find(loc.reachable, obj) != nil)
             return;
        "%You% can't reach "; obj.theDesc; " from "; loc.theDesc; ". ";
        exit;
    }
}

#pragma C-

#endif /* _CHECK_REACH_T_ */
