////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Wall 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _WALL_H_
#define _WALL_H_

#include <floating.h>
#include <fixeditem.h>

#pragma C+

/*
 *  Wall is a special item that appears in every room (hence
 *  the non-standard location property).  This object is included
 *  mostly for completeness, so that the player can refer to the
 *  floor; otherwise, it doesn't do much.  Dropping an item on the
 *  floor, for example, moves it to the current room.
 */
class Wall: Floating, FixedItem
	aDesc = "<<self.theDesc>>"
    foundIn = {
        if (parserGetMe().location == self)
            return self.sitLoc;
        else
            return parserGetMe().location;
    }
    ioPutOn(actor, dobj) = {
        dobj.doDrop(actor);
    }
    ioPutIn(actor, dobj) = {
        dobj.doDrop(actor);
    }
    ioThrowAt(actor, dobj) = {
        "Thrown. ";
        dobj.moveInto(actor.location);
    }
;

nWall: Wall
	noun = 'wall'
	adjective = 'north' 'n'
	sDesc = "north wall"
;

neWall: Wall
	noun = 'wall'
	adjective = 'northeast' 'north-east' 'ne'
	sDesc = "northeast wall"
;

nwWall: Wall
	noun = 'wall'
	adjective = 'northwest' 'north-west' 'nw'
	sDesc = "northwest wall"
;

sWall: Wall
	noun = 'wall'
	adjective = 'south' 's'
	sDesc = "south wall"
;

seWall: Wall
	noun = 'wall'
	adjective = 'southeast' 'south-east' 'se'
	sDesc = "southeast wall"
;

swWall: Wall
	noun = 'wall'
	adjective = 'southwest' 'south-west' 'sw'
	sDesc = "southwest wall"
;

eWall: Wall
	noun = 'wall'
	adjective = 'east' 'e'
	sDesc = "east wall"
;

wWall: Wall
	noun = 'wall'
	adjective = 'west' 'w'
	sDesc = "west wall"
;

ceiling: Wall
	noun = 'ceiling'
	sDesc = "ceiling"
;

#pragma C-

#endif /* _WALL_H_ */
