////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Transparent 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _TRANSPARENT_H_
#define _TRANSPARENT_H_

#include <itemcount.t>
#include <listcont.t>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/
 
/*
 *  Transparent: object
 *
 *  An object whose contents are visible, even when the object is
 *  closed.  Whether the contents are reachable is decided in the
 *  normal fashion.  This class is useful for Items such as glass
 *  bottles, whose contents can be seen when the bottle is closed
 *  but cannot be reached.
 */
class Transparent: object
    isTransparent = true
    material = glass
    lDesc = {
        if (itemCount(self.contents) != 0) {
            "In "; self.theDesc; " %you% see%s% "; listCont(self); ". ";
        } else {
            "There's nothing in "; self.theDesc; ". ";
        }
    }
    verGrab(obj) = {
        if (self.isOpenable && !self.isOpen)
            "%You% will have to open << self.theDesc >> first. ";
    }
    doOpen(actor) = {
        self.isOpen = true;
        "Opened. ";
    }
    verDoLookin(actor) = {}
    doLookin(actor) = { self.doSearch(actor); }
    verDoSearch(actor) = {}
    doSearch(actor) = {
        if (itemCount(self.contents) != 0)
            "In <<self.theDesc>> %you% see%s% <<listCont(self)>>. ";
        else
            "There's nothing in <<self.theDesc>>. ";
    }
    cantHear(vantage, target) = {        
        if (vantage.canSenseObj(sight, target))
            "%You% must open <<self.theDesc>> first.";
        else self.cantSee(vantage, target);
    }        
    cantSmell(vantage, target) = {
        if (vantage.canSenseObj(sight, target))
            "%You% must open <<self.theDesc>> first.";
        else self.cantSee(vantage, target);
    }        
    cantTouch(vantage, target) = {
        if (vantage.canSenseObj(sight, target))
            "%You% must open <<self.theDesc>> first. ";
        else self.cantSee(vantage, target);
    }
;

#pragma C-

#endif /* _TRANSPARENT_H_ */
