////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Raisable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _RAISABLE_H_
#define _RAISABLE_H_

#include <itemcount.t>
#include <listcont.t>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  Raisable: object
 *
 *  A class that can be raised and lowered.  The isRaisable
 *  property is set to true.  
 */
class Raisable: object
    isRaisable = true
    isRaised = true                        // "lowered"
    setIsRaised(setting) = {
        /* update my status */
        self.isRaised = setting;

        /* 
         *   if there's another side to this object, and its status is not
         *   already set to the new setting, update it as well (we don't
         *   update it if it's already been updated, since otherwise we'd
         *   recurse forever calling back and forth between the two sides) 
         */
        if (self.otherSide != nil && self.otherSide.isRaised != setting)
            self.otherSide.setIsRaised(setting);
    }
    verDoLower(actor) = {
        if (!self.isRaised) {
            caps(); self.theDesc; " <<self.isDesc>> already lowered! ";
        } else if (self.isLockable && self.isLocked) {
            "\^<<self.itIsDesc>> locked. ";
        }
    }
    doLower(actor) = {
        "Lowered. ";
        self.setIsRaised(nil);
    }
    verDoRaise(actor) = {
        if (self.isRaised) {
            caps(); self.theDesc; " <<self.isDesc>> already raised! ";
        } else if (self.isLockable && self.isLocked) {
            "\^<<self.itIsDesc>> locked. ";
        }
    }
    doRaise(actor) = {
        "Raised. ";
        self.setIsRaised(true);
    }
;

#pragma C-

#endif /* _RAISABLE_H_ */
