////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Passage 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _PASSAGE_H_
#define _PASSAGE_H_

#include <floatingdestination.h>
#include <passageway.h>

#pragma C+

/*
 *  Passage: FloatingDestination, Passageway
 *
 *  A Passage is a Destination that does not impede progress.
 *  Unlike the Passageway, a Passage is Floating and should not have its
 *  location attribute coded. Instead, use the foundIn list to indicate
 *  the rooms in which the Passage is to be found. 
 *
 *  To make a simple two-sided Passage you need only code both room
 *  objects in the foundIn list of the Passage: 
 *
 *      foundIn = [ hallway, kitchen ]
 *  
 *  To make a one-sided Passage, code the foundIn list with the room
 *  object in which the Passage is to be found, and the foundIn list
 *  with the room object to which the Passage leads:
 *
 *      foundIn = hallway 
 *      leadsTo  = kitchen 
 *
 *  If you want a Passage that returns rooms different from those it is
 *  found in, simply code both the foundIn list and foundIn list 
 *  accordingly, each element of the foundIn list must have a 
 *  corresponding foundIn element:
 *
 *      foundIn = [ hallway, kitchen ]
 *      leadsTo  = [ foyer, hallway ]
 *
 *  From the hallway the Passage leads to the foyer, but from the kitchen
 *  it leads to the hallway.
 */
class Passage: FloatingDestination, Passageway
; 

#pragma C-

#endif  /* _PASSAGE_H_ */
