////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Numbered 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _NUMBERED_H_
#define _NUMBERED_H_

#include <numberedcleanup.t>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  Numbered: object
 *
 *  This class can be added to a class list for an object to allow it to
 *  be used as a generic numbered object.  You can create a single object
 *  with this class, and then the player can refer to that object with
 *  any number.  For example, you can create a single "button" object
 *  that the player can refer to with "button 100" or "button 1000"
 *  or any other number.  If you want to limit the range of acceptable
 *  numbers, override the numIsValid method so that it displays
 *  an appropriate error message and returns nil for invalid numbers.
 *  If you want to use a separate object to handle references to the object
 *  with a plural ("look at buttons"), override newNumberedPlural to
 *  return the object to handle these references; by default, the original
 *  object is used to handle plurals.
 */

class Numbered: object
    isNumbered = true
    adjective = '#'
    anyValue(n) = { return n; }
    cleanUp = { delete self; }
    newNumberedPlural(a, v) = { return self; }
    newNumbered(a, v, n) = {
        local obj;
        
        if (n == nil)
            return self.newNumberedPlural(a, v);
        if (!self.numIsValid(n))
            return nil;
        obj = new self;
        obj.value = n;
        setfuse(numberedCleanup, 0, obj);
        return obj;
    }
    numIsValid(n) = { return true; }
    dobjGen(a, v, i, p) = {
        if (self.value == nil) {
            "You'll have to be more specific about which one you mean.";
            exit;
        }
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

#pragma C-

#endif /* _NUMBERED_H_
