////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: NestedRoomDisplayable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _NESTED_ROOM_DISPLAYABLE_H_
#define _NESTED_ROOM_DISPLAYABLE_H_

#include <roomdisplayable.h>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  NestedRoomDisplayable: RoomDisplayable
 */
class NestedRoomDisplayable: RoomDisplayable
    lookAround(verbosity) = {
        self.dispBeginsDesc;
        self.statusRoot;
        self.dispEndsDesc;
        
        self.location.nrmLkAround(verbosity);
    }
    statusRoot = {
        "<<self.location.sDesc>>, 
        <<gActor().posture.desc>> 
        <<self.boardingPrep>> 
        <<self.theDesc>>";
    }
;

#pragma C-

#endif /* _NESTED_ROOM_DISPLAYABLE_H_ */
