////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Lightsource 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _LIGHTSOURCE_H_
#define _LIGHTSOURCE_H_

#include <item.h>

#pragma C+

/*
 *  Lightsource: Item
 *
 *  A portable lamp, candle, match, or other source of light.  The
 *  light source can be turned on and off with the lightsOn property.
 *  If lightsOn is true, the object provides light, otherwise it's
 *  just an ordinary object.  Note that this object provides a doTurnon
 *  method to provide appropriate behavior for a switchable light source,
 *  such as a flashlight or a Room's electric lights.  However, this object
 *  does not provide a verDoTurnon method, so by default it can't be
 *  switched on and off.  To create something like a flashlight that should
 *  be a Lightsource that can be switched on and off, simply include both
 *  Lightsource and SwitchItem in the superclass list, and be sure
 *  that Lightsource precedes SwitchItem in the superclass list,
 *  because the doTurnon method provided by Lightsource should
 *  override the one provided by SwitchItem.  The doTurnon method
 *  provided here turns on the light source (by setting its isActive
 *  property to true, and then describes the room if it was previously
 *  dark.
 */
class Lightsource: Item
    isLamp = true
    lightsOn = nil
    invDesc = {
        /* show any additional information about the item */
        if (self.lightsOn)
            " (providing light)";
    }
    doTurnon(actor) = {
        local wasLit = actor.location.isLit(actor);
        
        // turn on the light
        self.isActive = true;
        self.lightsOn = true;
        "%You% switch%es% on _dobj_";
        
        // if the room wasn't previously lit, and it is now, describe it
        if (actor.location.isLit(actor) && !wasLit) {
            ", lighting the area.\b";
            actor.location.enterRoom(actor);
        }
        else
            ".";
    }
;

#pragma C-

#endif /* _LIGHTSOURCE_H_ */
