////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: KeyedGateway 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _KEYED_GATEWAY_H_
#define _KEYED_GATEWAY_H_

#include <keyedlockable.h>
#include <gateway.h>

#pragma C+

/*
 *  KeyedGateway: KeyedLockable, Gateway
 *
 *  This is just a normal Gateway that inherits the KeyedLockable
 *  mix-in.
 *
 *  Fill in the other properties (otherSide and leadsTo) as usual. If
 *  the Doorway has a key, set property myKey to the key 
 *  object.
 */
class KeyedGateway: KeyedLockable, Gateway
    isLocked = true
;

#pragma C-

#endif /* _KEYED_GATEWAY_H_ */
