////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: FoodItem 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _FOOD_ITEM_H_
#define _FOOD_ITEM_H_

#include <item.h>

#pragma C+

/*
 *  FoodItem: Item
 *
 *  An object that can be eaten.  When eaten, the object is removed from
 *  the game, and global.lastMealTime is decremented by the
 *  foodValue property.  By default, the foodValue property
 *  is global.eatTime, which is the time between meals.  So, the
 *  default fooditem will last for one "nourishment interval."
 */
class FoodItem: Item
    verDoEat(actor) = {
        self.verifyRemove(actor);
    }
    doEat(actor) = {
        "That was delicious! ";
        global.lastMealTime = global.lastMealTime - self.foodValue;
        self.moveInto(nil);
    }
    foodValue = { return global.eatTime; }
;

#pragma C-

#endif /* _FOOD_ITEM_H_ */
