////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: FixedItem 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _FIXED_ITEM_H_
#define _FIXED_ITEM_H_

#include <fixture.h>
#include <item.h>

#pragma C+

/*
 *  FixedItem: Fixture, Item
 *
 *  Note that a FixedItem is sometimes part of a movable object;
 *  this can be done to make one object part of another, ensuring that
 *  they cannot be separated.  By default, the functions that list a Room's
 *  contents do not automatically describe FixedItem objects (because
 *  the isListed property is set to nil).  Instead, the game author
 *  will generally describe the FixedItem objects separately as part of
 *  the Room's lDesc.  
 */
class FixedItem: Fixture, Item
    bulk    = 0             // no actual bulk
    weight  = 0             // no actual weight
;

#pragma C-

#endif /* _FIXED_ITEM_H_ */
