////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: ChairTravelable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _CHAIR_TRAVELABLE_H_
#define _CHAIR_TRAVELABLE_H_

#include <nestedroomtravelable.h>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  ChairTravelable: NestedRoomTravelable
 *
 *  Rules for travel, boarding and unboarding, in a Chair-style room.
 *
 *  This class allows an actor to sit on the object, setting the actor
 *  posture to "sitting". The actor can also stand on the object,
 *  but it is too small for an actor to lie in/on (See BedTravelable).
 */
class ChairTravelable: NestedRoomTravelable
    boardingPosture = sitting
    verDoLieon(actor) = {
        "\^<<self.thedesc>> isn't big enough for %you% to lie
        <<self.boardingPrep>>. ";
    }
    
    verDoSiton(actor) = {
        if (actor.location == self && actor.posture == sitting) {
            "%You're% already <<actor.posture.desc>> 
            <<self.boardingPrep>> <<self.theDesc>>! ";
        }
    }
    doSiton(actor) = {
        if (actor.location != self)
            actor.travelTo(self);
        actor.posture = sitting;
        "Okay, %you're% now <<actor.posture.desc>> 
        <<self.boardingPrep>> <<self.theDesc>>. ";
    }
    
    verDoStandon(actor) = {
        if (actor.location == self && actor.posture == standing) {
            "%You're% already <<actor.posture.desc>> 
            <<self.boardingPrep>> <<self.theDesc>>! ";
        }
    }
    doStandon(actor) = {
        if (actor.location != self)
            actor.travelTo(self);
        actor.posture = standing;
        "Okay, %you're% now <<actor.posture.desc>> 
        <<self.boardingPrep>> <<self.theDesc>>. ";
    }
    doSynonym('Lieon') = 'Liein'
    doSynonym('Siton') = 'Sitin'
    doSynonym('Standon') = 'Standin'
;

#pragma C-

#endif /* _CHAIR_TRAVELABLE_H_ */
