////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: BedTravelable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _BED_TRAVELABLE_H_
#define _BED_TRAVELABLE_H_

#include <chairtravelable.h>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  BedTravelable: ChairTravelable
 *
 *  Rules for "Bed-style" travel, boarding, and unboarding.
 *
 *  This class allows an actor to lie in/on the object, changing the
 *  actor posture to "lying". The actor can also sit on this object,
 *  as well as stand.
 */
class BedTravelable: ChairTravelable
    boardingPosture = lying
    verDoLieon(actor) = {
        if (actor.location == self 
        && actor.posture == lying) {
            "%You're% already <<actor.posture.desc>> 
            <<self.boardingPrep>> <<self.theDesc>>! ";
        }
    }
    doLieon(actor) = {
        actor.travelTo(self);
        actor.posture = lying;
        "Okay, %you're% now <<actor.posture.desc>> 
        <<self.boardingPrep>> <<self.theDesc>>. ";
    }
;

#pragma C-

#endif /* _BED_TRAVELABLE_H_ */
