////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Classes 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _CLASSES_H_
#define _CLASSES_H_

// Marker Classes
#include <hidden.h>

// Common Mix-in Classes
#include <composite.h>
#include <fixture.h>
#include <floating.h>
#include <floatingdestination.h>
#include <destination.h>
#include <keyedlockable.h>
#include <lockable.h>
#include <numbered.h>
#include <openable.h>
#include <raisable.h>
#include <readable.h>
#include <wearable.h>

// Root Classes
#include <object.h>
#include <thing.h>

// Item Classes
#include <item.h>
#include <fooditem.h>
#include <keyitem.h>
#include <lightsource.h>
#include <seethruitem.h>

#include <transparent.h>

// Hider Classes
#include <hider.h>
#include <behindhider.h>
#include <searchhider.h>
#include <underhider.h>

// Readable Classes
#include <readableitem.h>
#include <wysiwyg.h>
#include <wysiwygtable.h>

// Wearable Classes
#include <clothingitem.h>
#include <sackitem.h>

// FixedItem Classes
#include <fixeditem.h>
#include <buttonitem.h>
#include <decoration.h>
#include <dialitem.h>
#include <distantitem.h>
#include <switchitem.h>
#include <wall.h>

// Destination Classes
#include <passageway.h>
#include <passage.h>
#include <doorway.h>
#include <lockabledoorway.h>
#include <keyeddoorway.h>
#include <door.h>
#include <lockabledoor.h>
#include <keyeddoor.h>
#include <gateway.h>
#include <lockablegateway.h>
#include <keyedgateway.h>
#include <gate.h>
#include <lockablegate.h>
#include <keyedgate.h>

// Surface & Container Classes
#include <surface.h>
#include <qsurface.h>
#include <container.h>
#include <qcontainer.h>
#include <openablecontainer.h>
#include <lockablecontainer.h>
#include <keyedcontainer.h>

// Actor Classes
#include <animate.h>
#include <actor.h>
#include <follower.h>
#include <player.h>

// Room Classes
#include <room.h>
#include <roomable.h>
#include <roomactionable.h>
#include <roomdisplayable.h>
#include <roomtravelable.h>

// DarkRoom Classes
#include <darkroom.h>
#include <darkroomable.h>
#include <darkroomactionable.h>
#include <darkroomdisplayable.h>
#include <darkroomtravelable.h>

// NestedRoom Classes
#include <nestedroom.h>
#include <nestedroomable.h>
#include <nestedroomActionable.h>
#include <nestedroomdisplayable.h>
#include <nestedroomtravelable.h>

// ChairItem Classes
#include <chairitem.h>
#include <chairable.h>
#include <chairactionable.h>
#include <chairdisplayable.h>
#include <chairtravelable.h>

// BedItem Classes
#include <beditem.h>
#include <bedable.h>
#include <bedTravelable.h>

// Vehicle Classes
#include <vehicle.h>
#include <vehicular.h>
#include <vehicularactionable.h>
#include <vehicularcontainer.h>
#include <vehicularsurface.h>
#include <vehiculartravelable.h>

// Enterable Classes
#include <enterable.h>
#include <enterabledisplayable.h>
#include <enterableactionable.h>
#include <enterableopenable.h>

// Sensing Classes
#include <material.h>
#include <sense.h>
#include <connection.h>
#include <connector.h>

// Support Classes
#include <callback.h>
#include <clock.h>
#include <eventgenerator.h>
#include <integer.h>
#include <interface.h>
#include <listgroup.h>
#include <listgroupmessage.h>
#include <listgroupparencount.h>
#include <message.h>
#include <posture.h>
#include <preparseobj.h>
#include <stack.h>
#include <string.h>
#include <stringizer.h>
#include <vector.h>

#endif /* _CLASSES_H_ */
