/* The Auto-Save Reminder Module:
 *	This module asks the player if he wants to save his game every
 * x turns, where x is what you have defined AUTO_SAVE_REMINDER to be.
 */


modify global
  remind = true
  remindfirst = nil
  reminder =
  {
	if(not remind) return(nil);
	"\b\(It has been ";
	say(cvtstr(AUTO_SAVE_REMINDER));
	" turns since your last save.
	This might be a good time to save again.  Do it? (Y/N)\) >";
	if (yorn())
        saveVerb.saveGame(Me);
        if (not remindfirst)
	{
	  "\b(These reminders can be turned off and on by typing 'remind'.)\n";
          self.remindfirst := true;
	}
	notify(self, #reminder, AUTO_SAVE_REMINDER*1);
        "\b";
  }
;

remindVerb: sysverb
  verb = 'remind'
  action( actor ) =
  {
     global.remind := (not global.remind);
     if (global.remind <> nil)
       notify(global, #reminder, AUTO_SAVE_REMINDER*1+1);
     else
       unnotify(global, #reminder);
  }
;