/* Expansion for t2combat, for use with RAP.
 */

#include "rap10k.t"
#include "rap10p.t"

#define COMBAT_RAP true

// rBuildMap() is called by t2combat's preinit, when COMBAT_RAP_DEFINED
// is defined.
// Therefore, #include this file before you include std, if you're using
// std. (Or else you must call rBuildMap() explicitly.)

rKillingPlayer: rCond
  sdesc = "rKillingPlayer"
  rTrue(a,p) =
  {
    return (a.combatant = Me);
  }

  rPlans(a,p) =
    [
      [rBe rAttacking Me]
    ]
;

/* This is a condition which is satisfied when the rapper is
 * attacking.
 */
rAttacking: rCond
    sdesc = "rAttacking"
    rTrue(a,p) = {
        return (a.combatant = p);
    }
    rPlans(a,p) = {
        return(
            [
                [rBe rAttackable p
                 rBe rCanAttack p
                 rDo rAttack p]
            ]
        );
    }
;

/* This defines attackable objects as those which are actors.
 */

rAttackable: rCond
    sdesc = "rAttackable"
    rTrue(a,p) = {
        return (isclass(p, movableActor));
    }
;

/* This defines objects which are in the range of the rapper's attack.
 */
rCanAttack: rCond
    sdesc = "rCanAttack"
    rTrue(a,p) = {
        return (a.canAttack(p));
    }

    /* These plans may need to be modified, depending on the
     * particular conditions you have placed on canAttack().
     * This default works for the default, where attackability
     * means the same thing as reachability.
     */
    rPlans(a,p) = {
        // find closet room-level location of object
        local l;
        l:=p;
        while (not isclass(l,room)) l:=l.location;
        return(
            [
                [rBe rIn l]
            ]
        );
    }
;

/* This defines the execution of an attack.
 */
rAttack: rAct
    sdesc = "rAttack"
    rPreDesc(a,p) =  nil
    rActionCode(a,p)= {
        a.attack(p);
    }
;

/* Monsters don't ask politely when they want something the player
 * is carrying. Instead, they attack.
 */
modify rNotHeld
    rPlans(a,p) = {
        if (Me.isCarrying(p))
            return(
                [
                [rBe rAttacking Me]
                ]
            );
        else
            return(nil);
    }
;

