/* ex:set ts=4 sw=4:
 *
 * utility.t: useful functions for TADS programmers
 *
 * This module contains a number of useful functions for my enhanced TADS
 * libraries.
 *
 * This module is Copyright (c) 1994 Jeff Laing.  Permission to use any or all
 * of this code in other TADS games is granted provided credit is given in
 * your "CREDITS" command for this code and that you leave this copyright
 * message in the source whenever distributed.  Please make all changes in
 * a backward compatible manner (where possible) and make them available
 * for free (like I did ;-)
 */
utilityVersion : versionTag
	id="$Id: utility.t_v 1.2 1994/04/22 00:53:40 jeffl Exp jeffl $\n"
	author='Jeff Laing'
	func='utility functions'
;

/*
 * announce the contents of a list - this is only really useful for
 * debugging purposes since its not a pretty output.
 */
saylist : function( list )
{
	local i, item, len;
	len := length(list);
	i := 1;
	while (i<=len) {
		item := list[i];
		"[<<item.sdesc>>]";
		i := i + 1;
	}
	"\n";
}

/*
 * return a list of all objects in 'loc' which have the specified property
 */
allwithprop: function( loc, prop )
{
	local temp, res, o;
	temp := loc.contents;
	res := [];
	while (o:=car(temp)) {
		temp := cdr(temp);
		if (loc.(prop)) res := res + o;
	}
	return(res);
}
