/* ex:set ts=4 sw=4:
 *
 * bodypart.t: control of your unmentionables
 *
 * This module provides a slightly more complicated set of object classes
 * for body parts - the sort of thing that every player has but doesn't
 * want to show up in inventory lists, etc.
 *
 * This was originally implemented so that my port of Dungeon would allow
 * the player to turn the knobs with their hands.  It also allows things
 * like 'inflate boat with mouth' and the more obscure 'turn hidden debug
 * control on'.  It seems quite frivolous to mention that "touch toes" can
 * now say "Toes?  I still have toes?" ;-)
 *
 * Note that this now requires 'wallpaper.t' as thats a part of my standard
 * frame-work these days.  I have no idea whether it will be hard to integrate
 * into the standard TADS libraries otherwise.  'wallpaper.t' should be
 * available from the same place as 'bodypart.t'
 *
 * This module is Copyright (c) 1994 Jeff Laing.  Permission to use any or all
 * of this code in other TADS games is granted provided credit is given in
 * your "CREDITS" command for this code and that you leave this copyright
 * message in the source whenever distributed.  Please make all changes in
 * a backward compatible manner (where possible) and make them available
 * for free (like I did ;-)
 */
bodypartVersion : versionTag
	id="$Id: bodypart.t_v 1.7 1994/05/01 02:11:21 jeffl Exp jeffl $\n"
	author='Jeff Laing'
	func='bodypart support'
;

/*
 * any object which is tagged as a bodypart will effectively sit in the
 * players pocket (i.e. it will be with them always) but will not be shown
 * in things like inventory lists, "all" won't mention it, etc
 */
class bodypart : wallpaper

	// this prevents contlist() from including us
	isListed = nil

	// by definition, they are a part of the player
	location=Me

	// can it be reached by 'manipulative' verbs?
	isReachable(actor) =	(self.location=Me)

	// called by inspectVerb.validDoList - floaters are probably visible
	isVisible(actor) = 		(self.location=Me)

	// doesn't weigh anything - without this you get funny bugs if you
	// accidentally allow body parts to be dropped  - this should really
	// be fixed in adv.t:thing
	bulk=0
	weight=0

	// don't let a bodypart be removed from its container (Me)
	replace verifyRemove(a) = {
		"Sorry, cant remove that.  Its a body part!";
	}

	// don't allow us to do unexpected things
	noCanDoMsg = "Sorry, I dont know how to do that"
	dobjGen(a,v,i,p) = { self.noCanDoMsg; exit; }
	iobjGen(a,v,o,p) = { self.noCanDoMsg; exit; }

	// inspect isn't unexpected
	verDoInspect(a)	=	{}
;

/*
 * replace the default object mechanism so that it never returns body
 * parts.  the user can still specify them explicitly if they like
 */
modify class Actor

	// ensure that the actors body-parts dont get included
	visibleObjects(actor) = 
	{
		local i, o, len, list, list2;
		list := inherited.visibleObjects(actor);
		len := length(list);
		list2 := [];
		for (i:=1; i<=len; i++) {
			o := list[i];
			if (not isclass(o,bodypart)) list2 := list2 + o;
		}
        return( list2 );
    }

	// ensure that the actors body-parts dont get included
	takeableObjects(actor) = 
	{
		local i, o, len, list, list2;
		list := inherited.takeableObjects(actor);
		len := length(list);
		list2 := [];
		for (i:=1; i<=len; i++) {
			o := list[i];
			if (not isclass(o,bodypart)) list2 := list2 + o;
		}
        return( list2 );
    }
;

// define a special class so we can refer to either/both hands
class hands : bodypart
	noun='hand'
	plural='hands'

	noCanDoMsg = "Sorry, not with my hands you don't"

	// you can open things with hands
	verIoOpenWith(a) =		{}
	ioOpenWith(a,dobj) =	(dobj.doOpen(a))

	// 'put hand in <o>' becomes 'look in <o>'
	verDoPutIn(a,io) =		(io.verDoLookin(a))
	doPutIn(a,io) =			(io.doLookin(a))
;

modify class openable
	// make sure 'open <o> with hands' is acceptable
	verDoOpenWith(a,i) =	(self.verDoOpen(a))
	doOpenWith(a,i) =		(self.doOpen(a))
;

modify class doorway
	// make sure 'open <door> with hands' is acceptable
	verDoOpenWith(a,i) =	(self.verDoOpen(a))
	doOpenWith(a,i) =		(self.doOpen(a))
;

lefthand: hands
	adjective='left'
	sdesc="left hand"
	ldesc="It looks just like your right hand.  Only backwards!"
;

righthand: hands
	adjective='right'
	sdesc="right hand"
	ldesc="It looks just like your left hand.  Only backwards!"
;
