/* ex:set ts=4 sw=4:
 *
 * actor.t: non-player-characters who actually play
 *
 * This module provides a slightly more sophisticated set of actors
 * in a TADS world.  Unlike the default actor (defined in adv.t) who
 * refuses to do anything, these should behave reasonably
 *
 * This module is Copyright (c) 1994 Jeff Laing.  Permission to use any or all
 * of this code in other TADS games is granted provided credit is given in
 * your "CREDITS" command for this code and that you leave this copyright
 * message in the source whenever distributed.  Please make all changes in
 * an backward compatible manner (where possible) and make them available
 * for free (like I did ;-)
 */
actorVersion : versionTag
	id="$Id: actor.t_v 1.2 1994/04/13 09:20:13 jeffl Exp jeffl $\n"
	author='Jeff Laing'
	func='real actors'
;

/*
 * we add new format strings to the system
 */
formatstring 'yourself' fmtYourself;
formatstring 'actor'	fmtActor;		// used in obscure back-referencing

/*
 * allow user to go "SAY 'WORDS' TO <actor>"
 */
modify sayVerb
    ioAction(toPrep) = 'SayTo'
;

modify thing
    verDoSayTo( actor, io ) =	(self.verDoSay(actor))
	verIoSayTo( actor ) = "I don't know how to talk to <<self.adesc>>?"
;

modify class basicStrObj
	verDoSayTo( actor, io ) =	{}
	doSayTo(a,io)			=	(self.doSay(a))
;

/*
 * we need to modify the player so that 
 */
modify class basicMe

	/*** format strings ***/
	fmtYourself = "yourself"	// ... %have% hurt %yourself%
	fmtActor = "you"

	// other actors trying to pick us up is weird
	verDoTake(a) = "You dodge aside and <<a.thedesc>> can't grab you.\n"

	// they can give things to us - all we do is let them put it into us
	verIoGiveTo(a) =	{}
	ioGiveTo(a,d) =		(d.doGiveTo(a,self))

	// being shown to things is confusing
	verDoShowTo(a,i) =	"You don't like the idea of being shown around.\n"

	// being shown things is different
	ioShowTo(a,o) =		"That didn't help much.\n"

	// talking to the player just does it.
	verIoSayTo(a) =		{}
	ioSayTo(a,o) =		{ "Okay, \""; say( o.value ); "\"."; }

	// if someone tries to take something from us, we react
    verGrab( item ) =
    {
		"If you want to give <<item.thedesc>> up, type
		\"give <<item.thedesc>> to %actor%\".";
    }
;

class maleactor : humanactor
	isHim=true

	/*** format strings ***/
    fmtYour = "his"			// %Your% throat hurts
    fmtYoure = "he's"		// %Youre% not carrying ...
    fmtYoum = "him"			// ... and won't let %youm% have it
    fmtYouve = "he's"		// %You've% already got it
	fmtYourself = "himself"	// ... %have% hurt %yourself%
;

class femaleactor : humanactor
	isHer=true

	/*** format strings ***/
    fmtYour = "her"			// %Your% throat hurts
    fmtYoure = "she's"		// %Youre% not carrying ...
    fmtYoum = "her"			// ... and won't let %youm% have it
    fmtYouve = "she's"		// %You've% already got it
	fmtYourself = "herself"	// ... %have% hurt %yourself%
;

/* 
 * in fact, this class can be used for non-humans - its really only
 * intended as a hook to pin all the things which are applicable to
 * people (like fixing thedesc to say "Jack is here" rather than "The jack
 * is here") rather than robots "The robot is here"
 */
class humanactor: realactor

	/*** format strings ***/
    fmtYou =	{self.sdesc;}		// %You% has done it now!
	fmtActor =	{self.sdesc;}		// %actor% is holding it

	/*** simple descriptions ***/
	adesc=		{self.sdesc;}
	thedesc=	{self.sdesc;}

	/* slightly more human-related messages */
	verDoTake(a) =
		"<<self.thedesc>> slaps %you% soundly.  I wouldn't try that again
		if I were %youm%."

	verDoEat(a) =
		"What %do% %you% think this is?  A \"survival in the snow\"
		movie?"
;

/*
 * now all our actors are sub-classes of the standard movableActor
 */
class realactor : movableActor

	// reset all the format properties to those conducive with a robot
	// for this level - we are basically sexless at this level
    fmtYou = "it"			// %You% %have% done it now!
    fmtYour = "its"			// %Your% throat hurts
    fmtYoure = "it's"		// %Youre% not carrying ...
    fmtYoum = "it"			// ... and won't let %youm% have it
    fmtYouve = "it's"		// %You've% already got it
	fmtYourself = "itself"	// ... %have% hurt %yourself%

	fmtActor = {self.thedesc;}

    fmtS = "s"				// until %you% get%s out of
    fmtEs = "es"			// %You% miss%es%.
    fmtHave = "has"			// %You% %have% the following items.
    fmtDo = "does"			// %You% %do%n't have ....
    fmtAre = "is"			// %You% %are% empty-handed.

	// describe the actor
	ldesc={
		caps();self.thedesc;" thinks %you% %are% rude to stare so.\n";
	}

	// this method is called if the player types "ACTOR, command" in which
	// case "v,d,p,i" will specify the command to be performed.  If we don't
	// want to do it, we need to 'exit'
	actorAction( v, d, p, i ) = {
		if (v.issysverb) {
			"\^<<self.sdesc>> says 'Do it yourself!'\n";
			exit;
		}

		"\(<<self.sdesc>>.actorAction(<<v.sdesc>>,";
		if (d<>nil) "<<d.sdesc>>"; ",";
		if (p<>nil) "<<p.sdesc>>"; ",";
		if (i<>nil) "<<i.sdesc>>"; ")\)\n";
	}

	actorDesc = {
		caps(); self.adesc; " is here. "; self.actorcontents;
	}

	// look (at actor)
	actorcontents =
	{
		local list;
		list := contlist(self);
		if (length(list)>0) {
			caps();
			self.thedesc;" seems to have ";listlist(list);". ";
		}
		listfixedcontents( self );
	}

	// bug fix
	travelTo(room) = {
		if (room<>nil) pass travelTo;
	}

	// This method will be called whenever an unanticipated verb is used
	// with us as the direct object.
	dobjGen(a,v,i,p) = {
		"\(realactor(<<self.sdesc>>).dobjGen(<<a.sdesc>>,<<v.sdesc>>,";
		if (i<>nil) "<<i.sdesc>>"; ",";
		if (p<>nil) "<<p.sdesc>>"; ")\)\n";
		"I don't think <<self.thedesc>> wants %you% to do that.\n";
		exit;
	}

	// This method will be called whenever an unanticipated verb is used
	// with us as the indirect object.
	iobjGen(a,v,i,p) = {
		"\(realactor(<<self.sdesc>>).iobjGen(<<a.sdesc>>,<<v.sdesc>>,";
		if (i<>nil) "<<i.sdesc>>"; ",";
		if (p<>nil) "<<p.sdesc>>"; ")\)\n";
		"I don't think <<self.thedesc>> wants %you% to do that.\n";
		exit;
	}

	// the default actor will take anything that you hand to them.
	verIoGiveTo(a) = {}
	ioGiveTo(a,d) = {
		d.moveInto(self);
		"\^"; self.thedesc; " accepts "; d.thedesc; " gladly.\n";
	}

	verDoTake(a) = "I don't think <<self.thedesc>> wants %you% to do that."
	verDoDrop(a) = "This is a bug. %You% can't be holding <<self.thedesc>>."

	// INSPECT me
	verDoInspect(a) = {}
	doInspect(a) = (self.ldesc)

	// talking to an actor just does it.
	verIoSayTo(a) =		{}
	ioSayTo(a,o) =		{ "Okay, \""; say( o.value ); "\"."; }

	// telling an actor about something is basically pretty pointless but
	// legal.
	verDoTellAbout(a,i) = {} 	// tell me about <i>
	doTellAbout(a,i) =
		"%You% can tell from the blank stare that <<self.thedesc>> doesn't care"

	// actors don't mind being told about - but don't actually do anything.
	// ideally, they would install something into the object being told so
	// that later ASK <o> ABOUT <i> would work.
	verIoTellAbout(a) = {}		// tell <o> about me
	ioTellAbout(a,d) = {
		"<<self.thedesc>> ears seem to tingle.\n";
		d.doTellAbout(a,self);
	}

	// actors don't mind being told about - but don't actually do anything.
	// ideally, they would install something into the object being told so
	// that later ASK <o> ABOUT <i> would work.
	verDoShowTo(a,i) = {}	// show me to <o>
	doShowTo(a,i) = {
		"<<self.thedesc>> feels like an object on display.\n";
		i.ioShowTo(a,self);
	}

	// showing an actor something is basically pretty pointless but legal.
	// The actor should remember the object for future reference or maybe
	// react if it is a piece of evidence.
	verIoShowTo(a) = {}		// show <o> to me
	ioShowTo(a,d) = {		// player/actor, show d to actor
		if (a=Me) {
			"%You% can tell from the blank stare that
			<<self.thedesc>> doesn't care";
		} else {
			"\^<<a.thedesc>> shows <<self.thedesc>> <<d.thedesc>>.";
		}
	}

	// FOLLOW actor
	verDoFollow(a) = {}
	//doFollow(a) = {
		//"<<self.sdesc>>.doFollow(<<a.sdesc>>)\n";
	//}

	// PUSH
	verDoPush(a) = "<<self.thedesc>> doesn't enjoy being pushed around."

	// (UN)WEAR actor
	verDoWear(a) = "You can't think <<self.thedesc>> is clothing?"
	doSynonym('Wear')='Unwear'

	// verIoRemoveFrom(a) -- remove something from me
	// verDoRemoveFrom(a,i) -- remove me from <i>
	// verGrab(obj) --  take from me
	// verIoPutIn(a) --  put things IN me
	// verDoPutIn(a,i) --  put me IN <i>
	// verIoPutOn(a) --  put things ON me
	// verDoPutOn(a,i) --  put me ON <i>
	// verIoTakeOut(a) --  take things OUT OF me
	// verDoTakeOut(a,i) --  take me OUT OF <i>
	// verIoTakeOff(a) --  take things OFF me
	// verIoPlugIn(a) --  plug things into me
	// verDoPlugIn(a,i) --  plug me into <i>
	// verIoUnplugFrom(a) --  unplug things from me
	// verDoUnplugFrom(a,i) --  unplug me from <i>
	// verDoLookin(a) -- actor s is trying to look inside me
	// verDoLookThru(a) --  look through me
	// verDoLookUnder(a) --  look under me
	// verDoLookBehind(a) -- look behind me
	// verDoRead(a) -- read me
	// verDoTurn(a) -- turn me
	// verDoTurnWith(a,i) -- turn me with <i>
	// verDoTurnTo(a,i) -- turn me to <i>
	// verDoTurnOn(a) -- turn me on
	// verDoTurnOff(a) -- turn me off
	// verDoUnboard(a) -- disembarking from me?
	// verDoAttackWith(a,i) -- attack me with <i>
	// verIoAttackWith(a) -- attack something with me
	// verDoDrink(a) -- drink me
	// verDoGiveTo(a,i) -- give me to <i>
	// verDoPull(a) -- pull me
	// verDoThrowAt(a,i) -- throw me at <i>
	// verIoThrowAt(a) -- throw something at me   ???
	// verDoThrowTo(a,i) -- throw me to <i>
	// verDoThrow(a) -- throw me
	// verDoShowTo(a,i) -- show me to <i>
	// verIoShowTo(a) -- show things to me
	// verDoClean(a) -- clean me
	// verDoCleanWith(a,i) -- clean me with <i>
	// verDoMove(a) -- move me
	// verIoMoveTo(a) -- move thing to me
	// verIoMoveWith(a) -- move thing with me
	// verDoTouch(a) -- touch me
	// verDoPoke(a) -- poke me
	// verDoSearch(a) -- search me
	// verDoRead(a) -- read me
	// verDoSwitch(a) -- switch me
	// verDoFlip(a) -- flip me
	// verDoFollow(a) -- follow me
	// verDoOpen(a) -- open me
	// verDoClose(a) -- close me
	// verDoLock(a) - lock me
	// verDoLockWith(a,i) lock me with <i>
	// verDoUnlock(a) - unlock me
	// verDoUnlockWith(a,i) -- unlock me with <i>
	// verDoBoard(a) -- board me
	// verIoUnlockWith(a) -- unlock something with me
	// verIoLockWith(a) -- lock something with me

	// verDoJump(a) -- jump me
	// verIoTypeOn(a) -- type something on me
	// verIoDetachFrom(a) -- detach something from me
	// verDoDetachFrom(a,i) -- detach me from <i>

	// climb
	// show to
	// say
	// fasten
	// unfasten
	// centre
	// enter
	// enter on 
	// enter in
	// enter with
;
