/*
 * Polyadventure
 *
 * A remake of the various versions of the classic Adventure game by Don
 * Woods and Willie Crowther, based on their sources.  Currently, the 350,
 * 550, and 551-point versions are implemented.  See the creditsVerb in this
 * file for more information.
 *
 * Please document all changes in the history so we know who did what.
 *
 * This source code is copylefted under the terms of the GNU Public
 * License.  Essentially, this means that you are free to do whatever
 * you wish with this source code, provided you do not charge any
 * money for it or for any derivative works.
 *
 *
 * Contributors (see history.t for current e-mail addresses)
 *
 *      dmb     In real life:   David M. Baggett
 *
 *      djp     In real life:   David J. Picton
 *
 *      bjs     In real life:   Bennett J. Standeven
 *
 * Modification History
 *
 * CCR
 * ===
 *
 * 1-Jan-93     dmb     rec.arts.int-fiction BETA release (source only)
 *                      For beta testing only -- not for general
 *                      distribution.
 *
 * AD551
 * =====
 *
 * 14-Apr-99    djp     Initial release of Adventure 551 (1.01)
 *
 * 23-Apr-99    djp     New release (1.10) of Adventure 551.
 *
 *                      Changes since version 1.10:
 *                      * Fixed the output from the 'credits' command.
 *
 * 15-Jul-99    djp     New release (2.00)
 *                      Changes in this version
 *                      * Note that some objects need to be worn in order to
 *                        achieve the desired effect.
 *
 * POLYADV
 * =======
 *
 * 24-Aug-99    bjs     Pre-release version 0.00
 *              bjs     550-point extensions.
 *
 *          djp+bjs     Incorporated ad551 mods up to 2.20
 *
 * 3-Mar-00     djp     Initial beta release - Version 1.00
 *                      * Added 'commands' command.
 *
 * 18-Sep-00    djp     Version 2.00: New version with 701-point game
 *                      Changes in this version:
 *                      * Added mention of 701-point mode where appropriate
 *              
 * 8-Jun-01     djp     Version 2.05: bugfix release
 *                      Changes in this version
 *                      * Updated copyright information.
 *                      * Made the help information somewhat
 *                        version-dependent.
 *
 * 17-Aug-01    djp     Version 2.06: bugfix release with e-mail address update
 *                      Changes in this version
 *                      * Minor correction to 'help' text.
 *
 * 13-Jan-03    djp     Version 2.09 rev C: bugfixes and code tidy-up
 *                      Changes in this version
 *                      * Minor correction to 'help' text.
 *
 * 31-May-03    djp     Version 2.10: minor bugfixes and enhancements
 *
 * 12-Aug-03    bjs     Version 2.11: added 580-point mode.
 *              
 * 23-Jul-04    djp     Version 3.00.  Addition of a new game mode (701+).
 * 
 * 12-Apr-05    djp     Version 3.10: Bugfixes and enhancements
 *                      * Changes in help info concerning the depositing
 *                        of treasures and the use of elvish magic.
 * 22-Oct-13    djp     Version 3.21A: corrected the contact email
 *                      address
 *
 */

/*
 * Print some helpful information.  (Called by helpVerb, in ccr-verb.t)
 */
help: function
{
        P(); I(); "Welcome to Polyadv - a TADS port of the Colossal Cave
        Adventure programs.  Type \"credits\" for information
        on authorship and copyright.";

        P(); I(); "Two commands are provided to give you an easier game.
        The \"novice\" command will make your lamp last longer before you
        have to change the batteries.  This will cost you 5 points.  The
        \"nodwarves\" command will get rid of the dwarves and pirate, and
        this will also cost you 5 points.  (The \"nodwarves\" command will
        also place a certain treasure where the pirate would normally
        hide it, but you won't be given any clues about where to find the
        treasure.)";

        P(); I(); "I know of places, actions, and things.  You can guide
        me using commands that are complete sentences. To move, try
        commands like \"forest,\" \"building,\" \"downstream,\"
        \"enter,\" \"east,\" \"west,\" \"north,\" \"south,\" \"up,\"
        \"down,\" \"enter building,\" \"climb pole,\" etc.  To go back
        to your previous location, you can usually type \"back\".";

        P(); I(); "I know about a few special objects, like a black rod
        hidden in the cave.  These objects can be manipulated using
        some of the action words that I know.  Usually you will need
        to give a verb followed by an object (along with descriptive
        adjectives when desired), but sometimes I can infer the
        object from the verb alone.  Some objects also imply verbs;
        in particular, \"inventory\" implies \"take inventory\",
        which causes me to give you a list of what you're carrying.
        Some objects have side effects; for instance, the rod scares
        the bird.  Note that some objects in the extended versions
        have desirable effects only when worn. ";

        P(); I(); "A word about magic.  In contrast to the Inform port,
        this game will allow you to use magic words which you've seen in
        previous games. ";  
        if(global.newgame) {
            "But elvish magic only works for humans if you use it in the
            right place - where elves have used the same magic before.  And
            elvish magic words can only be used if you've heard the correct
            pronunciation. ";
        }
        if(global.game550) {
            if(global.newgame)"Also, "; else "But take care: "; 
            "it can be dangerous to use certain words before
            you've seen them. ";
        }

        P(); I(); "Many commands have abbreviations.  For example, you can
        type \"i\" in place of \"inventory,\" \"x object\" instead of
        \"examine object,\" etc. ";

        P(); I();; "Usually people having trouble moving just need to try a
        few more words.  Usually people trying unsuccessfully to
        manipulate an object are attempting something beyond their
        (or my!) capabilities and should try a completely different
        tack.";

        P(); I();"To see if any hints are available at your current
        location, type \"hint\" and reply to any prompts.  I'll warn you
        in advance how it will affect your score to accept each hint.";

        P(); I(); "To speed the game you can sometimes walk a long distance
        with a single word.  For example, \"building\" usually gets
        you to the building from anywhere above ground except when
        lost in the forest.  Also, note that cave passages turn a lot,
        and that leaving a room to the north does not guarantee
        entering the next from the south.";

        P(); I(); "A word about my understanding of English.  I understand
        simple sentences in natural English, such as \"take bottle\" or
        \"kill the monster with the knife\".  I will always
        try very hard to do whatever you say, but you must bear in mind that
        computers don't quite have the understanding of language that humans
        do!  Here are a few suggestions.";

        P(); I(); "To scarf up everything movable at a given location, say
        \"take all\".
        Also, you can specify several objects by using commas or \"and\" and
        several commands separated by \".\" or \"then\", e.g.
        \"take abc,def and xyz then burn witch.  take ashes.\"";

        P(); I(); "It is sometimes useful to use adjectives to distinguish
        between objects, e.g. \"take black frammitz. drop green frammitz\".
        It is often necessary to use prepositions, particularly when
        using containers, e.g. \"put crown in knapsack\".";

        P(); I(); "Another form of command which is sometimes useful involves
        a request to a character, e.g. \"giant, west\".  For example, most
        creatures can be fed with a command of the form \"actor, eat food\",
        as an alternative to \"feed food to actor\" or \"feed actor with
        food\". ";

        P(); I(); "If you misspell a word, you can usually correct it using
        the \"oops\" command.  For example, if you typed \"put grey raincoat
        in green nkapsack\" you can correct the error with \"oops knapsack\"";

        P(); I(); "If you want to end your adventure early, type \"quit\".
        To suspend your adventure such that you can continue later,
        type \"save,\" and to resume a saved game, type \"restore.\"
        To see how well you're doing, type \"score\".  To display the
        credits for this version of Adventure, type \"credits\". ";

        if (global.game701p) {
            "Most treasures must be left safely in the building for full 
            credit, though you get partial credit just for taking them. ";
        }
        else {
            "To get full credit for a treasure, you must have left it safely in
            the building, though you get partial credit just for taking it.  ";
        }

        if (global.newgame) {
            "But beware: in this game version you will find that leaving 
            something in a *safe* place is trickier than you think!  ";
        }

        "Some non-treasure items are best left near where you find them. ";

        P(); I(); "You lose points for getting killed, or for quitting,
        though the former costs you more.   There are points based
        on how much (if any) of the cave you've managed to explore; in
        particular, there is a bonus just for getting in (to
        distinguish the beginners from the rest of the pack), and
        there are other ways to determine whether you've been through
        some of the more harrowing sections.";

        if(global.newgame) {
            P(); I();
            "In addition to getting yourself killed, you can also be wounded or
            injured in various (non-lethal) ways.  If you get burnt, poisoned,
            electrocuted or whatever, you can check on your current state of
            health by typing \"health\" or \"diagnose\".  Note that 
            recuperation takes place faster outside in the fresh air!";
        }

        P(); I(); "When you've collected all the treasures, I'll let you know.
        Just keep exploring for a while.
        If something interesting happens, it means you're getting a
        bonus and have an opportunity to garner many more points in the 
        master's section.";

        P(); I(); "You can control the way I format my messages with the
        \"space\" and \"indent\" commands. These turn on and off
        blank spaces between paragraphs and indentation at the
        beginnings of paragraphs. Finally, you may specify \"brief\",
        which tells me never to repeat the full description of a
        place unless you explicitly ask me to.  (The \"verbose\"
        command turns this off.)";

        P(); I(); "Good luck!";
}
/*
 * Commands.
 */

commandsVerb: sysverb
        verb = 'commands'
        action(actor) = {
            "For full information about
            authorship and copyright, please type \"credits\".\b";

            "Type the \"game350\", \"game550\", \"game551\", \"game580\", or
            \"game701\" command to
            restart the game in the 350, 550, 551, 580 or 701-point mode.
            Type \"game701+\" to restart the game in the 701+ point mode
            (like the 701-point game, but with a new extension).\b";

            "Type \"novice\" in the first turn to make your lamp last
            longer.  Type \"nodwarves\" if you want to play without the
            dwarves or pirate.  Type \"noresurrect\" if you want
            to play without reincarnations.\b";

            "Type \"help\" for more detailed help information.\b";

            "Type \"hint\" to find out if a hint is available at your
            location.\b";

            "Type \"back\" to go back to your previous location.\b";
#ifdef WIZARD
            "A summary of the more important \"wizard mode\" commands is
            given below.  For full details, see the README file in the
            source distribution.\b";
            "Type \"scoretotal\" to display a summary of scoring totals.\b";
            "Type \"lamplife\" to display the number of turns left for your
            lamp, or \"lamplife <number>\" to set the number of turns.\b";
            "Type \"purloin <object>\" to take an object out of thin air.\b";
            "Type \"gonear <object>\" to go to the room which contains the
            object.\b";
            "Type \"pirloc\" to display the locations of the pirate and
            dwarves.\b";
#endif
        }

;

/*
 * Credits command.
 */

creditsVerb: sysverb
        verb = 'credits'
        action(actor) = {
        P(); I();
        "ADVENTURE was originally developed by William Crowther, and later
        substantially rewritten and expanded by Don Woods at Stanford Univ.
        Crowther's original version was modelled on a real cavern, called
        Bedquilt Cave, which is a part of Kentucky's Mammoth Cave system.
        That version of the game included the main maze and a portion of the
        third-level (Complex Junction - Bedquilt -  Swiss Cheese rooms, etc.),
        but not much more.";

        P(); I();
        "Don Woods and some others at Stanford later rewrote portions of
        the original program, and greatly expanded the cave.  That version
        of the game is recognizable by the maximum score of 350 points.";

        P(); I();
        "Some major additions were done throughout 1978 by David Long while
        at the University of Chicago, Graduate School of Business.
        Long's additions include the seaside entrance and all of
        the cave on the \"far side\" of Lost River.
        The castle problem was added in late 1984 by an anonymous writer.
        This version has a total score of 551 points.";

        P(); I();
        "Thanks are owed to Roger Matus and David Feldman, both of U. of C.,
        for several suggestions, including the Rainbow Room, the telephone
        booth, and the fearsome Wumpus.  Further thanks go to J. R. Carlson
        for many debugging suggestions.  Most thanks (and apologies)
        go to Thomas Malory, Charles Dodgson, the Grimm Brothers, Dante,
        Homer, Frank Baum and especially Anon., the real authors of
        ADVENTURE.";

        P(); I();
        "Another extended version, with 550 points, was independently
        developed in late 1979 by David Platt of the Honeywell Los
        Angelos Development Center.  Platt also completely rewrote
        the database. In 1984 the program was ported to UNIX C by Ken
        Wellsch. The extensions are drawn from the database source code.";

        P(); I();
        "This version was further extended by Mike Goetz, in his CP/M port.
        Again, the extensions use the database source code. ";
        
        P(); I();
        "This port also includes a 701-point version which combines
        the 551-point game (except the endgame) with all of the extensions
        in the 550-point game. ";

        P(); I();
        "This version is Copyright (c) 1999 Bennett J.\ Standeven, 
        1999-2001 David
        J.\ Picton, and 1993 David M.\ Baggett, and is derived in part from
        David Baggett's port (Colossal Cave Revisited) of the original
        350-point game by Crowther/Woods. The 551-point extensions were
        added by David J. Picton, and the 550/580-point extensions by Bennett
        Standeven.  The 701-point and 701+ point versions were added by
        David Picton. ";

        P(); I();
        "Credit is also due to Sean Barrett's game \"Appallatron: 
        Annoytron III\" for the inspiration behind an new form 
        of travel in the 701+ point version.  Hopefully you'll find this
        version challenging, rather than annoying. ";

        P(); I();
        "The source code contains a modified version of Kevin Forchione's
        parseword package, Copyright (c) 1999, 2000. ";


        P(); I();
        "This program is free software; you can
        redistribute it and/or modify it under the terms of
        version 2 of the GNU General Public License as
        published by the Free Software Foundation.";

        P(); I();
        "This program is distributed in the hope that it
        will be useful, but WITHOUT ANY WARRANTY; without
        even the implied warranty of MERCHANTABILITY or
        FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
        General Public License for more details.";

        P(); I();
        "For a copy of the GNU General Public License, write to the
        Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
        USA.";

        P(); I(); "If you want to report a bug or typo, be sure to
        include the version number of the copy you are
        playing, as well as the configuration of the machine
        you are running it on."; P();

        "All bug reports, constructive criticism and feedback should be
        directed to David Picton via the e-mail address:"; P();
        "djpicton@gmail.com";
        abort; /* doesn't count as a turn */
        }
;

