/*
 * The Legend Lives!
 *
 * Executable and source code are
 *
 *                 Copyright (C) 1995 by David M. Baggett
 *
 * All rights reserved, except as follows:
 * 
 *    Electronic redistribution is permitted, but only if not for profit.
 *    Specifically, you may provide copies in electronic form ONLY if you
 *    do not charge anything beyond the distribution media cost AND if you
 *    do not alter the source code in any way.
 *
 * Note that the author reserves all rights to derivative works and
 * products.  This includes ports and enhanced versions.  The author will
 * typically grant permission for these when asked, but this will be
 * dealt with on a case by case basis only.
 *
 */


printnote: function(num)
{
	local i, o, notes, len;

	notes := global.footlist;
	len := length(notes);
	i := 1;
	while (i <= len) {
		o := notes[i];
		if (o.footnum = num) {
			"["; say(num); "]:\ "; o.footnote;
			return;
		}
		i := i + 1;
	}

	// No footnote found with that number.
	"No such footnote.";
}

note: function(o)
{
	if (o.footnum = nil) {
		o.footnum := global.footnumber;
		global.footnumber := global.footnumber + 1;
	}

	"["; say(o.footnum); "]";
}

footnoteVerb: deepverb
	sdesc = "get footnote information for"
	verb = 'footnote' 'note'
	doAction = 'Footnote'
;

