// D:\sw\game_design\tads3\cromGame3\crom_obj.t

// *******************************************************
// crom_part.t
// This file contains custom designed room parts for use in
// the game. 
// 
// 
// *******************************************************

// allow this file to be included only once in any project
#pragma once

#ifndef CROMPART_T
#define CROMPART_T
  // ... see endif at end of file.... this block defines everything one time only, regardless of numbers of includes

//#ifndef CROMFUN3_T
//#include <cromfun3.t> // main
//#endif

#ifndef ADV3_H
#include <adv3.h>
#endif

// checks for if a variable was NOT defined from file en_us.h
// .. and if so then include the file to define that variable, method, etc.
#ifndef singleDir
#include <en_us.h>
// #error "You can put an error here too if the variable <> something. Boooo!!"
#endif

// ************ REUSABLE ROOM PARTS **********************

// plug this into the room's "roomParts" array if needed
defaultOrdinaryBrickWall : RoomPart '(black) (brick) (mansion) wall/fence' 'wall'
  "An ordinary enough wall made of bricks stacked fifteen feet high and painted black. "
;

// plug this into the room's "roomParts" array if needed
defaultMansionOutsideFloor : Floor 'ground/floor' 'ground'
   "The ground here is made of cobblestone and mortar. "
   putDestMessage = &putDestFloor
   dobjFor(Examine){
     verify(){ inherited(); }
     check(){ inherited(); }
   //inherited();
   // verify(){}
   // check(){}
   action(){ 
    inherited; // from Thing.t dobjFor(Examine)...        
    //local i = new CustomRoomLister('On the ground {you/he} see{s}', '.');
    //local i = new CustomRoomLister('{You/He} see{s}', ' on the ground. ');
    //local myInfoTab = gActor.senseInfoTable(sight);
    //say(i.showList(gActor, nil, gActor.location.contents, 0, 0, myInfoTab, nil));         
    }
   }
;

defaultMansionRoofFloor: Floor '(mansion) (green) (black) (tile) (shingle) roof/ground/floor' 'roof'
   "The roof is made of green and black shingles. "
   putDestMessage = &putDestFloor
;

defaultMansionDrivewayFloor : Floor '(concrete) (cement) ground/floor/driveway' 'ground'
  "The driveway is made of cement. "
  putDestMessage = &putDestFloor
;

// fromPOV(pov, propToCall, [args]) // in thing.t
//    {
//        /* push the new point of view */
//        pushPOV(pov); // calls method in pov.t
//
//        /* make sure we pop the point of view no matter how we leave */
//        try
//        {
//            /* call the method */
//            self.(propToCall)(args...); // jumps to mainExamine() in thing.t
//        }
//        finally
//        {
//            /* restore the enclosing point of view on the way out */
//            popPOV();
//        }
//    }

// mainExamine(){
//  ... 
//  basicExamine(); // in thing.t
// }

// basicExamine(); 

// class CommandReportMessage: CommandReport, MessageResult  ... report. t 
//

// class MessageResult: object (from exec.t)

// examineStatus() ... called from thing.t to method in travel.t
//  examinePartContents(&descContentsLister)
//  ... loc.contents

// // show the contents of the containing location 
//      self.(listerProp).showList(gActor, self, loc.contents, 0, 0,
//                                   gActor.visibleInfoTable(), nil);
// popPOV() // from pov.t


defaultCromSky : Distant, RoomPart 
  name = 'sky'
  vocabWords = '(blue) (black) (dark) (bright) (daytime) (nighttime) (day) (night) sky'
  desc = "An ordinary sky. " // TO DO: change for day time / night time based on world clock
;

defaultCromNorthWall: DefaultWall
;

defaultCromSouthWall: DefaultWall
;

defaultCromEastWall: DefaultWall
;

defaultCromWestWall: DefaultWall
;

defaultCromGround : Floor
  name = 'floor' 
  // isPlural = true
  vocabWords = 'floor/ground'
  desc = "The ground here looks ordinary enough. "
  putDestMessage = &putDestFloor
;


// ************ SPECIFIC ROOM PARTS **********************

// class ClimbableWall : Attachable, RoomPart, Thing .. see: crom_obj.t

// NOTE: add this wall1 obj to roomParts of startRoom (i.e. roomParts = [defaultMansionOutsideFloor, wall1] )
//wall1 : ClimbableWall   
//  // location = startRoom // ** NOTE *** : Add back in if necessary - remmed out 
//  OtherWall = wall2
//  OtherRoom = drivewayRoom // testRoom // pixyland
//  DestinationDirection = 'UP' // note: default is up already in this class so we don't *need* to set this up 
//;

// NOTE: add this wall1 obj to roomParts of testRoom (i.e. roomParts = [defaultMansionOutsideFloor, wall2] )
//wall2 : ClimbableWall
// // location = drivewayRoom // testRoom // pixyland
//  OtherWall = wall1
//  OtherRoom = startRoom
//  DestinationDirection = 'UP'
//;

//innerMansionRoom2RoomHole: ClimbableWall
// //  location = innerMansionRoom2Room
//   name = 'hole'
//  vocabWords = '(big) (ordinary) (grey) (gray) (rock) (stone) hole/well/wall'
//   desc = "Just an ordinary looking hole in the floor. "
//   OtherWall = innerMansionRoom2RoomHole2
//   OtherRoom = innerMansionRoom3Room
//   DestinationDirection = 'DOWN'
//;

//innerMansionRoom2RoomHole2: ClimbableWall
//  // location = innerMansionRoom3Room
//   name = 'hole'
//   vocabWords = '(big) (ordinary) (grey) (gray) (rock) (stone) hole/well/wall'
//   desc = "Just an ordinary looking hole in the ceiling. "
//   OtherWall = innerMansionRoom2RoomHole
//   OtherRoom = innerMansionRoom2Room
//   DestinationDirection = 'UP'
//;


//garageGutter: ClimbableWall
//  // location = westEndDrivewayRoom
//   name = 'gutter'
//   vocabWords = '(rusty) (silver) (gray) (grey) (metal) (rain) gutter/raingutter'
//   desc = "A rusty silver metal gutter. "
//   OtherWall = garageGutter2
//   OtherRoom = mansionGarageRoofRoom
//   DestinationDirection = 'UP'
//;

//garageGutter2: ClimbableWall
//  // location = mansionGarageRoofRoom
//  name = 'gutter'
//   vocabWords = '(rusty) (silver) (gray) (grey) (metal) (rain) gutter/raingutter'
//   desc = "A rusty silver metal gutter. "
//   OtherWall = garageGutter
//   OtherRoom = westEndDrivewayRoom
//   DestinationDirection = 'DOWN'
//;

// see crom_obj.t for class unclimbableWall
// this is our default outer mansion wall
//wall3 : unclimbableWall   
//;

//wall4 : ClimbableWall
// //location = roadside021Room
// OtherWall = wall5
// OtherRoom = sideOfMansionGarageRoom
// DestinationDirection = 'UP'
//;

//wall5 : ClimbableWall
//  //location = sideOfMansionGarageRoom
//  OtherWall = wall4
//  OtherRoom = roadside021Room // testRoom // pixyland
//  DestinationDirection = 'UP' // note: default is up already in this class so we don't *need* to set this up 
//;






#endif  
// endif of... #ifndef CROMPART_T

