/* crom_body.t
 *
 * Was part of crom_obj.t but that file got too large
 * so put some object classes in crom_body.t instead.
 *
 * This file includes class BodyPart, BasicSoul, etc.
 * Also includes some default body part objects for use
 * in building NPC's & player characters. 
 *
 */

// allow this file to be included only once in any project
#pragma once

#ifndef ADV3_H
#include <adv3.h>
#endif

// checks for if a variable was NOT defined from file en_us.h
// .. and if so then include the file to define that variable, method, etc.
#ifndef singleDir
#include <en_us.h>
// #error "You can put an error here too if the variable <> something. "
#endif

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
 + class: Male                     +
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
class Male: Thing
  is_A_Girl = 0 // will show up as nil
  is_A_Little_Girl = 0
  isHim = true
  isHer = nil
  isShe = nil
  attractsGirl = 0 // 0-100
  /* classes must override
   * When AudreyGirl hasSexWith gDobj == Male, this
   * routine is called and it should usually check to
   * see if permission is granted and so on. If the Male
   * isn't willing, it should usually fail.
   */
  girlRequestsSex(oWho){
       "He\'s not interested in you. ";       
  }
  /*
   *  This is when the Male NPC requests it of the girl.
   */
  fuckGirl(oWho){ 
       // override
       if(
          (!oWho.ofKind(Female))
         ){
           if(self == gPlayerChar) "Don\'t you know what a girl looks like? ";
           exit;
       }
       // request
       oWho.boyRequestsSex(self);
  }
  // this is when the girl replies back with a "yes" to the above method call
  girlAcceptsSexRequest(oWho){
      if(oWho == gPlayerChar){
          "He\'s glad you accepted! ";
      }
      // do something - there is full consent. Male class objects must override
  }
  getPenis(){
      local oCock = nil;
      foreach(local obj in self.contents){
         if(obj.ofKind(AdultMalePenis)){
                 oCock = obj;
         }
      }
      return oCock;
  }
;

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
 + class: Female                   +
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
class Female: Thing
  is_A_Girl = true
  isHim = nil
  isHer = true
  isShe = true
  getVagina(){
      local oVag = nil;
      foreach(local obj in self.contents){ // gActor.contents){
         if(obj.ofKind(AdultFemaleVagina)){
                 // "Vag. found! ";
                 oVag = obj;
         }
      }
      return oVag;
  }
  /* classes must override
   * When AudreyGirl hasSexWith gDobj == Male, this
   * routine is called and it should usually check to
   * see if permission is granted and so on. If the Male
   * isn't willing, it should usually fail.
   */
  boyRequestsSex(oWho){
       "She\'s not interested in you. ";       
  }
  /*
   *  This is when the Female NPC requests it of the boy.
   */
  fuckBoy(oWho){ 
       // override
       if(!oWho.ofKind(Male)){
             "That\'s not a guy. ";
             exit;
       }
       // request
       oWho.girlRequestsSex(self);
  }

  /*
   *  NPC "courtship" functions. 
   *  
   *  We use some of the following for Male NPCs to court (or get to know)
   *  the player when the player is Female. 
   */

  /*
   *  This is when a guy hits on the Female at a bar or something.
   *  oWho = the Male hitting on the girl
   *  hitString = the witty saying he uses
   *  
   *  It is then up to the girl to react to this in a yes or no type
   *  manner. Classes can override.
   *
   *  Returns 'y' for positive or yes reaction 
   *  Returns 'n' for negative or no reaction  
   */
  boyHitsOnYou(oWho,hitString){
               if(self != gPlayerChar) return nil; // NPC classes may override
               say(hitString);
               local iDone = 0;
               local s0 = '';
               do{
                  "<br><font color=yellow>You have just been hit on by a guy!</font>
                   <br>What is your reaction (yes = positive, no = negative): ";
                  s0 = inputManager.getInputLine(nil, nil);
                  s0 = s0.toLower();
                  if(
                     (s0 == 'y') ||
                     (s0 == 'yes') ||
                     (s0 == 'n') ||
                     (s0 == 'no') ||
                     (s0 == 'positive') ||
                     (s0 == 'negative')
                    ){ 
                       iDone++;
                  }else{
                       "<br>Please enter yes or no (positive or negative) for your reaction to 
                       his hit on you: ";
                  } 
                  "\n";
               }while(iDone==0);
               "<.p> ";
               if(s0=='y' || s0=='yes' || s0 == 'positive') return 'y';
               return 'n';
  }
  /*
   *  This is when an NPC alerts a Female of something or says something 
   *  that she might give a positive or negative reaction to. Like being "hit" on, only
   *  less specific. Like if an NPC warns her not to talk to so-and-so, in which case
   *  a negative reaction might spur a "mind your own business" type reply, otherwise
   *  a positive reaction could create a thankful reply instead. 
   *
   *  oWho = the NPC (male or not) telling the girl something
   *  alertString = whatever he is alertring the girl
   *  
   *  It is then up to the girl to react to this in a yes or no type
   *  manner. Classes can override.
   *
   *  Returns 'y' for positive or yes reaction 
   *  Returns 'n' for negative or no reaction  
   */
  npcAlertsYou(oWho,alertString){
               if(self != gPlayerChar) return nil; // NPC classes may override
               say(alertString);
               local iDone = 0;
               local s0 = '';
               do{
                  "<br>What is your reaction (yes = positive, no = negative): ";
                  s0 = inputManager.getInputLine(nil, nil);
                  s0 = s0.toLower();
                  if(
                     (s0 == 'y') ||
                     (s0 == 'yes') ||
                     (s0 == 'n') ||
                     (s0 == 'no') ||
                     (s0 == 'positive') ||
                     (s0 == 'negative')
                    ){ 
                       iDone++;
                  }else{
                       "<br>Please enter yes or no (positive or negative) for your reaction to 
                       the NPCs statement: ";
                  } 
                  "\n";
               }while(iDone==0);
               "<.p> ";
               if(s0=='y' || s0=='yes' || s0 == 'positive') return 'y';
               return 'n';
  }

  getYesNoReply(oWho,alertString){
               if(self != gPlayerChar) return nil; // NPC classes may override
               say(alertString);
               local iDone = 0;
               local s0 = '';
               do{
                  "<br>(y/n): ";
                  s0 = inputManager.getInputLine(nil, nil);
                  s0 = s0.toLower();
                  if(
                     (s0 == 'y') ||
                     (s0 == 'yes') ||
                     (s0 == 'n') ||
                     (s0 == 'no')
                    ){ 
                       iDone++;
                  }else{
                       "<br>Please answer yes or no (y or n): ";
                  } 
                  "\n";
               }while(iDone==0);
               "<.p> ";
               if(s0=='y' || s0=='yes' || s0 == 'positive') return 'y';
               return 'n';
  }
  /*
   *  This is when the NPC asks the player a question, like "what is your favorite color?" and
   *  the player is allowed to send back a reply. We'll send back a gLiteral type reply string.
   *
   */
  npcAsksYouLiteral(oWho,questionString){
               if(self != gPlayerChar) return nil; // NPC classes may override
               say(questionString);
               "<br>Please type your reply: ";
               local s0 = inputManager.getInputLine(nil, nil);
               s0 = s0.toLower();
               "<.p> ";
               return s0;
  }


  npcAsksYouOneWordReply(oWho,questionString){
               if(self != gPlayerChar) return nil; // NPC classes may override
               say(questionString);
               local iDone = 0;
               local s0 = '';
               local tokList = nil;
               do{
                  "<br>Please type a one word response: ";
                  s0 = inputManager.getInputLine(nil, nil);
                  // s0 = s0.toLower();
                  tokList = Tokenizer.tokenize(s0);
                  // "<br> length of tokens: <<tokList.length>> 
                  // <br> first element: <<tokList[1][1]>> ";
                  if(
                     (tokList.length == 1)
                    ){ 
                       iDone++;
                  }else{
                       "<br>Please enter a one word response: ";
                  } 
                  "\n";
               }while(iDone==0);
               "<.p> ";
               return tokList[1][1];
  }


;

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
 + class: LittleGirl               +
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
class LittleGirl: Female
  is_A_Little_Girl = 1
  bulk = 3 // little girls aren't that bulky if carried by grown-ups
  weight = 5
  dobjFor(Take)
  { 
       verify()
       { 
                 inherited();
                 if (self == gActor)
                        illogicalSelf('You can not take yourself. ');
       }
       check()
       { 
            if(gActor.pcAge < 10)
            {
                 "She\'s too heavy for you to lift and take with you. ";
            }
       }      
    }
  isListed = true
  isListedInContents = true
  isListedInInventory = true
  isHeldBy(actor) { return isDirectlyIn(actor); }
  meetsObjHeld(actor) { return isDirectlyIn(actor); }
  okayDropMsg = '{You/he} set{s} {the dobj/him} gently back down. ' // 'Dropped. ' // {The/she}
  notifyMoveInto(newCont) {
      if(newCont.ofKind(Actor)){
           local oSelf = self;
           local actor = gActor;
           gMessageParams(actor,newCont,oSelf);// this sets variables for use with msg params
           // note the "\^" below is used to capitalize the next first letter encountered...
           local oWho = (gActor == gPlayerChar) ? 'you' : gActor.name;
           local s0 = '\^' + oWho + '{subj actor} take{s} {the oSelf/him}. ';
           say(s0);
      }else if((gPlayerChar == self) && (gActor.ofKind(Actor)) && (gActor != gPlayerChar)){
           //  "*** Another Actor is placing YOU in a new floor/location/container!!! *** ";
           local oSelf = self;
           local actor = gActor;
           gMessageParams(actor,newCont,oSelf);// this sets variables for use with msg params
           // note the "\^" below is used to capitalize the next first letter encountered...
           local oTheName = (gActor.theName != nil) ? gActor.theName : gActor.name;
           local oWho = (gActor == gPlayerChar) ? 'you' : oTheName;
           local s0 = '\^' + oWho + '{subj actor} carefully set{s} {the oSelf/him} down. ';
           say(s0);
      }
  }
  dobjFor(Drop)
    {
        preCond = [objHeld]
        verify()
        {
            /* the object must be held by the actor, at least indirectly */
            if (isIn(gActor))
            {
                /* 
                 *   it's being held, so dropping it makes sense; verify
                 *   transfer from the current container hierarchy to the
                 *   new one 
                 */
                verifyMoveTo(gActor.getDropDestination(self, nil));
            }
            else
            {
                /* it's not being held, so this is simply not logical */
                illogicalAlready(&notCarryingMsg);
            }
        }

        action()
        {
            /* send the object to the actor's drop destination */
            gActor.getDropDestination(self, nil)
                .receiveDrop(self, dropTypeDrop);
        }
    }


  dobjFor(ShowTo){
        preCond = [objHeld]
        verify()
        {
            /* it's more likely that we want to show something held */
            if (isHeldBy(gActor))
            {
                /* I'm being held - use the default logical ranking */
            }
            else if (isIn(gActor))
            {
                /* 
                 *   the actor isn't hold me, but I am in the actor's
                 *   inventory, so reduce the likelihood only slightly 
                 */
                logicalRank(80, 'not held');
            }
            else
            {
                /* 
                 *   the actor isn't even carrying me, so reduce our
                 *   likelihood even more 
                 */
                logicalRank(70, 'not carried');
            }
        }
        check()
        {
            /*
             *   The direct object must be visible to the indirect object
             *   in order for the indirect object to be shown the direct
             *   object. 
             */
            if (!gIobj.canSee(self))
            {
                reportFailure(&actorCannotSeeMsg, gIobj, self);
                exit;
            }

            /*
             *   The actor performing the showing must also be visible to
             *   the indirect object, otherwise the actor wouldn't be able
             *   to attract the indirect object's attention to do the
             *   showing.  
             */
            if (!gIobj.canSee(gActor))
            {
                reportFailure(&actorCannotSeeMsg, gIobj, gActor);
                exit;
            }
        }
    }
    iobjFor(ShowTo)
    {
        verify() { illogical(&cannotShowToMsg); }
    }
    dobjFor(Examine)
    {
        preCond = [objVisible]
        verify()
        {
            /* give slight preference to an object being held */
            if (!isIn(gActor))
                logicalRank(80, 'not held');
        }
        action()
        {
            /* 
             *   call our mainExamine method from the current actor's point
             *   of view 
             */
            fromPOV(gActor, gActor, &mainExamine);
        }
    }
   // cannotTakeMsg = &cannotTakePersonMsg
  cannotMoveMsg = &cannotMovePersonMsg
  cannotPutMsg = &cannotPutPersonMsg
  cannotTasteActorMsg = &cannotTastePersonMsg
;

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
 + class: ComplexHumanPlayer                                     +
 +                                                               +
 + NOTE: by making CromexxHuman also part of the                 +
 + SexualPromptDaemon class, the daemon starts                   +
 + up automatically AND can *know* the parent                    +
 + object by simply referring to "self."                         +
 + So you could simply also just modify the                      +
 + "sexualPromptDaemon()" method directly in                     +
 + this class to do what you want. Otherwise                     +
 + if we handled it as a dynamic object variable                 +
 + then the pointer lacks a lexicalParent as the                 +
 + daemon just resides in memory.                                +
 + We could also over-ride method "sexualPromptDaemon()"         +
 + by placing an over-ride class before class CromexxHuman       +
 + below in our definition. For example                          +
 + class FemaleSexualPromptDaemon (or maybe we'll call it just   +
 + FemaleSexDrive).                                              +
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
class CromexxHumanPlayer: CromexxHuman
  // globalParamName = 'me' // for use with {sub me} or {sub horace} etc
  baseVocabWords = nil // use these instead of vocabWords please...
  name = 'Quill'  
  // override if you wish...
  // don't be running this code unless we're a grown woman
  
;

/* 
 * Class: SexualPromptDaemon
 *
 * We eliminated alot of the more complex code from this.
 * The daemon still runs on each CromexxHuman but we have 
 * dumped the use of BasicSoul class, and SoulJar class and
 * gone with a more simpler approach.
 * 
 * This is the "brain" of every player character & NPC's sexual activity.
 * Anything that happens to a body part in relation to anything important 
 * in sexual stimulation (including foreplay) is going to be signaled through
 * here and cause meter adjustments and possible further reporting back to
 * the sender and receiver. 
 *
 * Note that we'll try our best to communicate to the body's "soul" object 
 * as often as is necessary in order to keep that object well informed.  
 * What this may do, for example, is cause the soul to have a sender body
 * (and sex) preference, as well as a receiver body (and sex) preference.
 * So for example if blondes really do have more fun then the soul will 
 * gravitate towards wanting to be a blonde based on the build-up of information
 * and experience piped through this daemon ("brain"). The interesting thing
 * about this is that if the NPC or player were stuck on another planet somewhere
 * where you had no other choice but either masturbation or sex with the aliens,
 * that sexual preference could eventually mutate and adapt from a prior one.
 * If left un-checked you could put an NPC in a room full of trolls and find
 * that the NPC and trolls are having sex. Not likely due to imprinted standards
 * but certainly possible if there is no other choice and random chance is at work.
 * We should probably have various types of souls to allow for unwillingness to
 * change or outright refusal, as well as souls that are a little more open minded.
 *
 * See also: PreinitObject
 * See also: InitObject
 * The InitObject class invokes this object's "execute()" method on start up...
 * Note that because "execute()" is called automatically on game start up, that
 * the sex prompt daemon is started up "automatically" via a call to
 * self.startMySexualPromptDaemon. 
 * Note that "InitObject" only has the "execute()" method called as the game
 * compiles during start up. No text will EVER be seen within a call to that
 * method during initialization. And also restarting the game *may* not make
 * a subsequent call to this method (will have to test to make sure if necessary). 
 *
 * Here is how the fake neural net works:
 *
 * 0. Someone stimulates a body part by carrying out an action (i.e. "rub nipples" for example)
 * 
 * 1. BodyPart relays to sex-prompt-daemon
 *      self.location.notifyMySexualPromptDaemon(relayValue,oReceiverPoV,oSenderPoV);// method in class SoulJar
 * 
 * 2. SexualPromptDaemon asks the SoulJar (the owner) 
 *    to notify its soul and waits for a reply
 *       Sex-prompt-daemon sends this:
 *         local whatNow = owner.notifySoul(value,owner,sender);
 *       SoulJar relays it with this:
 *         return oSoul.signalResponseRequested(value,owner,sender);
 *       BasicSoul replies on if it liked it or whatever with this:
 *         true  (or 0 or 117, 124, etc.)
 *
 * 3. Sex-Prompt-Daemon takes the "whatNow" value from step 2 and...
 *     if value == 1 
 *         tellSenderWeLikedIt(value,owner,sender)
 *     if value == -1
 *         tellSenderToStop(value,owner,sender)
 *     if value == 0 we just do nothing
 * 
 * 4. in each "tellSenderWeLikedIt" or "tellSenderToStop" we build
 *    up a list of values based on the "value" sent to us, and we
 *    would send back that info to the player: 
 *         self.saySomethingPoV(oPlayerPoV,oSenderPoV,oReceiverPoV,s1,s2,s3,s4,s5);
 *
 * Note that in the above steps we have really not implemented too much
 * complexity as the BasicSoul class (for now anyway) always returns true,
 * approving/liking the action. If we want the soul to have a preference
 * we can later over-ride or extend the BasicSoul class and create a new
 * AdvancedSoul class or something. 
 *
 * In other words: for each action, we only care about the code in the sex-prompt-daemon
 * and the actual body part object.
 *
 */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
 + class: SexualPromptDaemon       +
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
class SexualPromptDaemon: InitObject {
  isSexualPromptDaemonActive = nil
  mySexualPromptDaemonRunning = nil
  mySexualPromptDaemonTurnCounter = 0
  /* We can add in some more counters and flags
   * that could be stored on the receiver
   * but for faster reference and better
   * virtual reality programming, we'll emulate
   * that this daemon is actually like a
   * brain and stores the information right here.
   *
   * This is our main database of mostly useless counters.
   */  
   // *** add flags here if desired *** 
   // ***
   // ***
  execute(){ "*******we are starting a sexual prompt daemon on initialization...****\n";
             "*******this text should NEVER be seen on initialization*****************\n";
             self.startMySexualPromptDaemon();
           }
  /*
   *  Called by the "tellSenderWeLikedIt" and 
   *  our "tellSenderToStop" routines.
   *  Basically you build 5 string values of
   *  differing perspectives s1-s5, and send that
   *  along with your PoV actor objects to this
   *  routine and a report is generated based on
   *  the current PoV observation.
   *
   *  oPlayerPoV = player character
   *  oSenderPoV = sender actor of the action
   *  oReceiverPoV = receiver actor of the action
   *
   *  s1 = self action where the player is the sender and the receiver
   *  s2 = self action where an NPC is the sender and the receiver and being observed by the player
   *  s3 = non-self action where player is the sender and taking action on NPC who is the receiver
   *  s4 = non-self action where sender and receiver are two NPCs being observed taking action on each other by the player
   *  s5 = non-self action where NPC is the sender and taking action upon the player who is the receiver
   */
  saySomethingPoV(oPlayerPoV,oSenderPoV,oReceiverPoV,s1,s2,s3,s4,s5){
           /* if player is not even here then exit */
           if(oPlayerPoV.location != oReceiverPoV.location) exit;  
           /* if anything is nil then exit */
           if((oPlayerPoV == nil) || (oSenderPoV==nil) || (oReceiverPoV==nil) || 
              (s1==nil) || (s2==nil) || (s3==nil) || (s4==nil) || (s5==nil)) exit;
           /* self stimulus */
           if(oSenderPoV == oReceiverPoV){
              /* self stimulus from player PoV */
              if(oSenderPoV == oPlayerPoV) say(s1);
              /* self stimuls from NPC PoV */
              if(oSenderPoV != oPlayerPoV) say(s2);
          }else{
              /* else non-self stimulus */
              /* ...player rubbing NPC */
              if(oSenderPoV == oPlayerPoV) say(s3);
              /* ...NPC is rubbing another NPC */
              if((oSenderPoV != oPlayerPoV) && (oReceiverPoV != oPlayerPoV)) say(s4);
              /* ...NPC is rubbing the PC */
              if((oSenderPoV != oPlayerPoV) && (oReceiverPoV==oPlayerPoV)) say(s5);
          }
  }   
  
  startMySexualPromptDaemon(){
       // abort if we're not old enough to be doing this...
       if(self.lexicalParent != nil){
          if(self.lexicalParent.ofKind(CromexxHuman)){
             if(self.lexicalParent.is_A_Little_Girl == true) exit;  
          }
       }
       //if(self.parent != nil){
       //   if(self.parent.ofKind(CromexxHuman)){
       //      if(self.parent.is_A_Little_Girl == true) exit;
       //   }
       //}
       if(self.mySexualPromptDaemonRunning != true){
            /* start daemon */
            new PromptDaemon(self,&sexualPromptDaemon);// there are other ways to initialize this but this calls self & a method in self
            /* set that the daemon is running (so we can keep track easy) */
            self.mySexualPromptDaemonRunning = true;
       }
       // make sure we are active
       self.isSexualPromptDaemonActive = true;
  }
  stopMySexualPromptDaemon(){
          // eventManager.events_; // Schedulable.allSchedulables;
          foreach(local obj in eventManager.events_){
                // if our obj_ is this "someObj" object, then remove the event/agent/daemon
                if(obj.obj_ == self){
                     obj.removeEvent();// actually removes the event/agent/daemon
                     self.mySexualPromptDaemonRunning = nil;
                     /* "isActive = nil" is optional. We picked up this flag idea from ditch day drifter
                      *  This variable is used only in our "someObj" object, not part of 
                      *  the Event class (as far as I know), and is used as an emergency backup
                      *  check in case the agent/daemon is still running or fires off one last time.
                      *  (i.e. a "server hiccup" type prevention)
                      */ 
                     self.isSexualPromptDaemonActive = nil;
                }
          }
   }
  sexualPromptDaemon(){
       // if it was de-activated, then exit the daemon
       if(self.isSexualPromptDaemonActive == true){
           if(self.is_A_Little_Girl != true){
                // do something only if active...
         //      "This is the sexual prompt daemon running. How kinky!\n ";
                mySexualPromptDaemonTurnCounter++;
         //      "This is the <<self.mySexualPromptDaemonTurnCounter>> turn it 
         //       is running for character: <<self.name>> ...\n"; 
           }           
       }
  }
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
 + class: CromexxHuman             +
 + note: class Person can NOT be   +
 + taken, but class Actor can.     +
 + In TADS class Person represents +
 + your basic human actor object.  +
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
class CromexxHuman: Hidden, Person, SexualPromptDaemon 
    discovered = true // added 6/6/2019 by Cleo Kraft. If this is nil then it's hidden. We can use this for "transformations" to hide the old body with
    hide(){
        discovered = nil;
    }
    bulkCapacity = 10000
    maxSingleBulk = 10
    weightCapacity = 10000
  /* we would not normally worry about vocabWords 
   * but in the case of a body swap we need to 
   * modify these a bit...
   */
  baseVocabWords = nil
  /*
   * Note: by adding in 'body' to the final return below, 
   * if a player does an 'examine body' it will ask
   * "which body do you mean, the Memdroid or you?"
   * if the MemDroid was in the same room as you.
   */
  /*
   * NOTE: WARNING!!! The code below added a bug to the game
   *   where an 'examine it' would ALWAYS return back a reference
   *   to the player character and/or all the other actors in the room.
   *   So you could never follow-up on a command. We'll not mess with
   *   vocabWords directly.
   */
 // vocabWords {
 //       local myBase = (self.baseVocabWords != nil) ? (self.baseVocabWords + '/') : '';
 //       local myTemp = (self.name != nil) ? ('/' + self.name) : '';
 //       if(self == libGlobal.playerChar){
 //          /* NOTE: in most cases the PARSER will determine what me/self/myself means...
 //           *  Un-remming the following line to replace the next will cause trouble
 //           *  for the parser determining who an "examine me" command refers to after
 //           *  a body swap. So to eliminate this just refrain from using 'me/self/myself'
 //           *  in your vocabWords.
 //           */
 //          // return myBase + 'me/self/myself/body' + myTemp; //  + self.name;  // (gActor==self) ? (self.name + '/binklebo/me/self/myself/body') : self.name
 //          return myBase + 'body' + myTemp; //  + self.name;  // (gActor==self) ? (self.name + '/binklebo/me/self/myself/body') : self.name
 //       }else{
 //          return myBase + 'body' + myTemp; //** see note above
 //       }
 // }
  /*
   * Object holder variable: firstPlayerMeetingNPCObject
   *
   * Manually set to me, etc. when NPC first meets and converses with player.
   * This is so that if the player meets the NPC when in girl-form or something
   * that the NPC takes note of it and optionally later on if they meet again when
   * the player is male again or something and reveals sex change happened, the 
   * npc can somehow take note of what "original" form the player FIRST appeared
   * to be. So for example, if the player meets the NPC as a girl, then later as a
   * boy, the NPC will probably think the player started out as a natural born girl,
   * which could affect certain dialogue. 
   */
  firstPlayerMeetingNPCObject = nil 
  firstPlayerMeetingNPCGender = nil // 'male' or 'female' ...use gPlayerChar.getSexMF() to set
  getSexMF(){ if(self.is_A_Girl) return 'female';
              return 'male';
            }
  getSexManWomanChildLG(){
              if(gameMain.is_a_little_girl) return 'little girl';// gameMain always overrides
              if(gameMain.is_a_girl) return 'woman'; // gameMain always overrides
              
              if(self.is_A_Little_Girl) return 'little girl';
              if(self.pcAge < 13) return 'little boy';
              if(self.pcAge < 20){
                 if(self.is_A_Girl) return 'teenage girl';
                 return 'teenage boy';
              }
              if(self.is_A_Girl) return 'woman';
              return 'man';
  }
  firstPersonDesc {                
                // don't report if human. this is already implied by default
                local oRace = (self.pcRace == 'human') ? ' ' : (' ' + self.pcRace + ' ');
                "You are <<self.pcAge>> year old<<oRace>><<self.getSexManWomanChildLG>>. Your 
                 height is <<self.pcHeight>> and you have <<self.pcEyes>> eyes and
                 <<self.pcHair>> hair. ";
                if(gameMain.is_a_zombie != nil){
                        "You are a zombie. ";
                }
                if(self.nudeCheck !=0){
                   "You are nude. <br>";
                }else{
                   // ** TO DO: Add in clothes listing here ** 
                }
   }// end firstPersonDesc...
   thirdPersonDesc = "You see nothing unusual. "
   desc {   if(libGlobal.playerChar == self){
                return self.firstPersonDesc;
            }else{
                return self.thirdPersonDesc;
            }
        }      
   /* Note: start the sex prompt daemon by
    * calling self.mySexPromptDaemon.startMySexualPromptDaemon();
    */
   myTestObj : object {
        desc = "This is the 'inner' - enclosing: <<lexicalParent.desc>> "
   }
   // mySexPromptDaemon = static new SexualPromptDaemon() // or static new SexualPromptDaemon(self) // works!

  
   /*
    * Note: if you don't re-define "execute()" below you'll get
    * an "unknown exception" (i.e. crash) at start up. 
    */
   //mySexPromptDaemon : SexualPromptDaemon {
  //      desc = "Hi ho - enclosing: <<lexicalParent.desc>> "
  //      execute(){ "do nothing...\n"; }
  // }
   is_A_Little_Girl = nil // nil or true 
   is_A_Girl = nil // nil or true
   bindingStrength = 0 // this magically "binds" you to this current body if it is 100%
   percentGirlified = 0 // only really useful on TF machines - natural born girls should NEVER have this value set
   pcRace = 'human' // 'human', 'elf', 'dwarf', etc.
   pcAge = 18 // default
   pcHeight = '6\' 0\"'
   pcHair = 'brown' // default
   pcEyes = 'blue' // default  
   /* statlist is a vector of RPG stat values
    * STR, DEX, AGI, STA, WIS, INT... can add more later but that's a start
    */
   statList = [12,12,12,12,12,12]
   isSleeping = nil // nil or true if sleeping
   lostTally = 0 // counter. if lostTally > lostThresh[iCurLostThresh] we'll "help" the lost player somehow
   isLost = (lostTally > 0) ? 1 : 0
   lostThresh = [3,5,7,9]  // array of high end lost threshhold - we rotate this each time we "help" a lost player
   iCurLostThresh = 1
   diedInTheDark = 0  // start room wizard (?) may use this to summon & "save" you
   diedFromSharks = 0 // start room wizard (?) may use this to summon & "save" you
   // also in crom_mod.t
   goToSleep(){
        /* simply report that we can't sleep now */
        mainReport(&cannotSleepMsg);
        // you *could* toggle isSleeping here
        // isSleeping = true
   }   
   // also in crom_mod.t
   dobjFor(HaveSexWith){
      preCond = [touchObj]
      verify() { 
          if(gActor.is_A_Little_Girl)            
            illogical('Even if it were possible, which it\'s not, you are just a little girl
             and shouldn\'t even be thinking about such things. ');
         // by default this action is illogical
         illogical('You\'d better not. It\'s unsanitary and you don\'t even have your 
            raincoat and rubbers. ');         
      }      
    }
    dobjFor(PlayWith) remapTo(HaveSexWith,self)
   //  {
   //   preCond = [touchObj]
   //   verify() {
   //       if(me.is_A_Little_Girl)            
   //         illogical('Even if it were possible, which it\'s not, you are just a little girl
   //          and shouldn\'t even be thinking about such things. ');
   //       illogical('You shouldn\'t play with yourself. Especially not without your clown suit. ');
   //  }
   // }  
    dobjFor(Rub){
       preCond = [touchObj]
       verify(){ }
       action(){
          /* show our "feel" description */
          fromPOV(gActor, gActor, &basicExamineFeel);
          // fromPOV(gActor, gActor, &mainExamine);
       }
    }   
    // NOTE: the following null commands prevent 
    //       game crash by things such as "put me in bed", etc.     
    dobjFor(PutIn){
           verify(){ exit; }
           check(){ }
           action(){ }
    }
    dobjFor(PutOn){
           verify(){ exit; }
           check(){ }
           action(){ }
    }
    dobjFor(PutUnder){
           verify(){ exit; }
           check(){ }
           action(){ }
    }
    dobjFor(PutBehind){
           verify(){ exit; }
           check(){ }
           action(){ }
    }
    dobjFor(GetIn){
           verify(){ exit; }
           check(){ }
           action(){ }
    }
    dobjFor(GetOn){
           verify(){ exit; }
           check(){ }
           action(){ }
    }
   // dobjFor(Examine){
   //      verify(){ logicalRank(2,'eliminate the x it disambig problem');
   //          inherited;
   //      } 
   //      check(){ inherited; }
   //      action(){ inherited; }
   //
   // 
   // }
   // dobjFor(Examine){
   //     preCond = [objVisible]
   //     verify() { inherited; }
   //     action() {
   //         if(gActor==gPlayerChar){
   //              "...calling EXAMINE as gActor == gPlayerChar...";
   //              fromPOV(gPlayerChar,gPlayerChar,&mainExamine);
   //         }else{
   //             // this fixes a body swap PoV reporting bug
   //              "...calling EXAMINE as just gActor (!= gPlayerChar)... 
   //               where gameMain.currCromPlayerChar == <<gameMain.currCromPlayerChar.name>> ";
   //
   //              fromPOV(gameMain.currCromPlayerChar,gameMain.currCromPlayerChar,&mainExamine);
   //             // fromPOV(gActor, gActor, &mainExamine);
   //         }
   //     }
   // }
   //  mainExamine() {
   //     /* perform the basic 'examine' action */
   //     basicExamine();
//
//        /* 
//         *   listen to and smell the object, but only show a message if we
//         *   have an explicitly associated Noise/Odor object 
//         */
//        basicExamineListen(nil);
//        basicExamineSmell(nil);
//        
//        /* show special descriptions for any contents */
//        examineSpecialContents();
//    }
    //dobjFor(Examine){
    //       preCond = [objVisible]
    //       verify(){ 
    //            if(self == libGlobal.playerChar) logicalRank(80,'somewhat more likely than out of body');
    //            if(self != libGlobal.playerChar) logicalRank(5,'somewhat less likely');
    //            inherited;
    //       }
    //       check(){ inherited; }
    //       action(){ if(self == libGlobal.playerChar){
    //                    inherited;
    //                 }else{
    //                    inherited;
    //                 }
    //       }
    //}
    /* modified "Thing" in file crom_mod.t
     * to handle basic TellTo command and verb rule.
     * "TellTo" is for giving orders to this actor.
     */
    dobjFor(TellTo){ 
          verify() {} 
              preCond = [canTalkToObj] 
              action() { 
                    local tokList = Tokenizer.tokenize(gLiteral); 
                    /* you probably want to translate 'you' into 'me' 
                     * likewise 'himself' or 'herself' into 'yourself' 
                     * in any token 
                     */ 
                    if(tokList.indexWhich({x: x[1] is in ('you', 'himself', 'herself')})) {  
                       local lst = []; 
                       foreach(local tok in tokList) { 
                             if(tok[1] == 'you') { 
                                tok[1] = 'me'; 
                                tok[3] = 'me'; 
                             } 
                             if(tok[1] is in ('himself', 'herself')) { 
                                tok[1] = 'yourself'; 
                                tok[3] = 'yourself'; 
                             }        
                             lst += [tok];   
                      } 
                      tokList = lst;  
                   } 
                   executeCommand(self, gActor, tokList, true); 
              }// end action()...
  }// end dobjFor(TellTo)...
 makeProper{
    if(isProperName == nil && properName != nil) {
      isProperName = true;
      name = properName;      
      /* Method 1: */
      local tokList = Tokenizer.tokenize(properName);
      for (local i = 1, local cnt = tokList.length() ; i <= cnt ; ++i) {
        if(i < cnt)
          cmdDict.addWord(self, getTokVal(tokList[i]), &adjective);
        cmdDict.addWord(self, getTokVal(tokList[i]), &noun);
      }
       
      /* Simpler Alternative: this doesn't add forenames as both nouns and
       * adjectives, but as adjectives only with the final name as a noun: 
       */
       //     initializeVocabWith(properName);
    }
  }// end makeProper...
  toplessCheck{
       // checks to see if you are topless (i.e. exposing breasts if you're a girl)
       local isCovered = 0;
       isCovered = isCovered + clothingLevelCheck(4); // swimsuit 1-piece
       isCovered = isCovered + clothingLevelCheck(5); // bra
       isCovered = isCovered + clothingLevelCheck(6); // t-shirt (undershirt)
       isCovered = isCovered + clothingLevelCheck(7); // shirt/blouse
       isCovered = isCovered + clothingLevelCheck(8); // coat
       isCovered = isCovered + clothingLevelCheck(12); // dress (full gown)
       isCovered = isCovered + clothingLevelCheck(22); // body stocking (full body stocking)       
       return ((isCovered == 0) ? 1 : 0); 
  }
  // mainly for checking if you can have sex with current clothes on.
  // For example a skirt or short dress is acceptable IF you're not wearing panties 
  // or stockings underneith. Otherwise those would block having sex.
  bottomlessAccessCheck{
       // checks to see if you are not wearing anything covering your... ahem...
       local isCovered = 0;
       isCovered = isCovered + clothingLevelCheck(3); // underpants/panties
       isCovered = isCovered + clothingLevelCheck(4); // swimsuit (1-piece)
       isCovered = isCovered + clothingLevelCheck(9); // pants/shorts
       isCovered = isCovered + clothingLevelCheck(12); // dress (i.e. evening gown)
       isCovered = isCovered + clothingLevelCheck(22); // body stocking
       isCovered = isCovered + clothingLevelCheck(23); // regular stockings
       return ((isCovered == 0) ? 1 : 0); 
  }
  // Almost the same as bottomlessAccessCheck only builds in a panty check.
  // You'd need to lift your panties a bit out for a quick peek or whatever. 
  // So... if you are NOT wearing a swimsuit, pants/shorts, dress, body stocking,
  // or regular stockings but ARE wearing panties, this routine will return true,
  // else it will always return 0 (or false)
  bottomlessAccessWithPantyLiftCheck{
       // checks to see if you are not wearing anything covering your... ahem...
       local isCovered = 0;
       local isWearingPanties = clothingLevelCheck(3);// underpants/panties       
       isCovered = isCovered + clothingLevelCheck(4); // swimsuit (1-piece)
       isCovered = isCovered + clothingLevelCheck(9); // pants/shorts
       isCovered = isCovered + clothingLevelCheck(12); // dress (i.e. evening gown)
       isCovered = isCovered + clothingLevelCheck(22); // body stocking
       isCovered = isCovered + clothingLevelCheck(23); // regular stockings       
       return (((isCovered == 0) && (isWearingPanties!=0)) ? 1 : 0); 
  }
  skirtCheck {
       local isWearing = 0;
       isWearing = isWearing + clothingLevelCheck(11); // skirt
       return ((isWearing != 0) ? 1 : 0); 
  }
  dressCheck {
       local isWearing = 0;
       isWearing = isWearing + clothingLevelCheck(12); // dress (evening gown)       
       return ((isWearing != 0) ? 1 : 0); 
  }
  slipCheck {
       local isWearing = 0;
       isWearing = isWearing + clothingLevelCheck(10); // slip
       return ((isWearing != 0) ? 1 : 0); 
  }
  pantiesCheck {
       local isWearing = 0;
       isWearing = isWearing + clothingLevelCheck(3); // panties
       return ((isWearing != 0) ? 1 : 0);
  }
  // does not take into consideration jewelry or hair pins, etc. as exception 
  justWearingPantiesCheck {
      // checks to see if the pc/npc is wearing clothing or not and returns true or nil
      local clothingTally = 0;
      local failComparison = 0;
      // local isWearing = clothingLevelCheck(3);// panties
      if(self.contents == nil) return 0;// if you're carrying nothing, you're nude, so return 0 or false
      foreach(local obj in self.contents){
           if(obj.ofKind(CromexxClothing)){               
               if(obj.clothLevel != nil){
                  if(obj.isWornBy(self)){
                        clothingTally++;
                        if(obj.clothLevel != 3) (failComparison = 1);                  
                  }
               }
           }       
      }   
      if(failComparison == 1) return 0;// failed - some other type of clothing was worn
      /*
       * If the clothing tally is just 1 item
       * and we passed the fail comparison check,
       * then this 1 item must be our panties.
       * So therefor we're just wearing panties.
       */
      local myReturner = ((clothingTally == 1) ? 1 : 0);
      return myReturner; // nil; // (clothingTally == 0);
  }
  // A more restrictive version of "bottomlessAccessCheck."
  // This one accounts for line of sight type obstructions,
  // such as wearing a skirt, slip, or dress, or even full length
  // fur coat.
  bottomlessCheck{ 
       local isCovered = 0;
       isCovered = isCovered + clothingLevelCheck(3); // underpants/panties
       isCovered = isCovered + clothingLevelCheck(4); // swimsuit (1-piece)
       isCovered = isCovered + clothingLevelCheck(8); // fur coat 
       isCovered = isCovered + clothingLevelCheck(9); // pants/shorts
       isCovered = isCovered + clothingLevelCheck(10); // slip
       isCovered = isCovered + clothingLevelCheck(11); // skirt
       isCovered = isCovered + clothingLevelCheck(12); // dress (i.e. evening gown)
       isCovered = isCovered + clothingLevelCheck(22); // body stocking
       isCovered = isCovered + clothingLevelCheck(23); // regular stockings
       return ((isCovered == 0) ? 1 : 0); 
  }
  nudeCheck {
      // checks to see if the pc/npc is wearing clothing or not and returns true or nil
      local clothingTally = 0;
      if(self.contents == nil) return 1;// if you're carrying nothing, you're nude, so return 1 or true
      foreach(local obj in self.contents){
           if(obj.ofKind(CromexxClothing)){
               if(obj.isWornBy(self)) clothingTally++;
           }       
      }   
      local myReturner = (clothingTally == 0) ? 1 : 0;// 1 == true, 0 == false or nil
      return myReturner; // nil; // (clothingTally == 0);
  }
  //
  // Returns true if you are wearing a clothing item of the myInteger value
  clothingLevelCheck(myInteger){
      local clothingTally = 0;
      if (self.contents == nil) return 0; // if nothing here then return 0, skipping loop
      foreach(local obj in self.contents){
           if(obj.ofKind(CromexxClothing)){
               if((obj.isWornBy(self)) &&
                  (obj.clothLevel != nil)){
                      if(obj.clothLevel == myInteger) clothingTally++;
               }
           }           
      }
      local myReturner = (clothingTally > 0) ? 1 : 0;
      return myReturner; 
  }
  clothingLevelWornItemReturner(myInteger){
      // local clothingTally = 0;
      local x = 0;
      if(self.contents != nil){         
         if(self.contents.length > 0){
            x = self.contents.length;            
            do{
              if(self.contents[x].isWorn()){
                 if(self.contents[x].isWornBy(self)){
                   if(self.contents[x].clothLevel != nil){
                     if(gActor.contents[x].clothLevel == myInteger){
                       return gActor.contents[x].name;
                       // x = 0;
                     }
                   }
                 }
              }
              x--;
            }while(x > 0);
         }
      }  
      // local myReturner = (clothingTally > 0) ? true : nil;
      return nil; //  myReturner; // nil; // (clothingTally == 0);
  }
  bareFootCheck {
     local myXReturner = (clothingLevelCheck(1) ||
        clothingLevelCheck(2) ||
        clothingLevelCheck(23) ||
        clothingLevelCheck(22)) ? nil : true;
        return myXReturner;
  }  
  mainFootCover {
       // shoes/flats
       if(clothingLevelCheck(1)){
          return 'a pair of ' + clothingLevelWornItemReturner(1);
       }
       // socks
       if(clothingLevelCheck(2)){
          return 'some ' + clothingLevelWornItemReturner(2);
       }
       // stockings
       if(clothingLevelCheck(23)){
          return 'some ' + clothingLevelWornItemReturner(23);
       }
       // body stocking
       if(clothingLevelCheck(22)){
          return 'a ' + clothingLevelWornItemReturner(22);
       }
       return nil;
  }
  mainOutfit {
       // swimsuit?
       if(clothingLevelCheck(4)){
          return 'a ' + clothingLevelWornItemReturner(4);
       }
       // skirt?
       if(clothingLevelCheck(11)){
          return 'a ' + clothingLevelWornItemReturner(11);
       }
       // dress?
       if(clothingLevelCheck(12)){
          return 'a ' + clothingLevelWornItemReturner(12);
       }
       // pants/shorts?
       if(clothingLevelCheck(9)){
          return 'some ' + clothingLevelWornItemReturner(9);
       }
       // panties? 
       if(clothingLevelCheck(3)){
          return 'a pair of ' + clothingLevelWornItemReturner(3);
       }
     return nil;
  }      
;

class AdultFemaleLegs: FemaleBodyPart
   name = 'legs'
   isPlural = true
   vocabWords = '(left) (right) leg/legs/knee/knees/calf/calfs/calves/thigh/thighs/shin/shins/ankle/ankles'
   // desc = "{You/he} see{s} nothing unusual about {it me/him}. " 
   desc {
           /*
            * According to the walkthrough, you have to set a local
            * variable and pass that to the "gMessageParams" function
            * and that changes the direct object in your string {} stuff.
            * So don't pass the real object name. Set it to a local var and
            * pass that instead.
            */
           local myobj = self;           
           // gMessageParams(myobj);// this simply is calling --> gAction.setMessageParam()
           local myobj2 = gActor; // tiffanyMeadows;
           gMessageParams(myobj,myobj2);// you can send more than one variable!
           /*
            * See: file:///d:/sw/games/tads/t3msg.htm
            *
            * if myobj == self... {that myobj/him} returns "those"
            * if myobj == me..... {that myobj/him} returns "you"
            * if myobj2 == tiffanyMeadows  
            *    ....and myobj == self
            *    ....and tiffany does an "x legs" command...  
            *    ....and the string is:  "{A myobj2/she} examine{s} {that myobj/him} <<self.name>> for a moment. ";
            *    ....then the result is: "A Tiffany examines those legs for a moment."
            *
            * if same values as above but this as string: "{itself myobj2} examine{s} {that myobj/him} <<self.name>> for a moment. ";
            *    ....then the result is: "herself examines those legs for a moment."
            *
            * if same values as above but this as string: "{that/he myobj2} examine{s} {that myobj/him} <<self.name>> for a moment. "
            *    ....then the result is: "she examines those legs for a moment."
            *
            * if myobj == self .... and myobj2 == gActor
            *
            */
           //"{A myobj2/she} examine{s} {that myobj/him} <<self.name>> for a moment. ";// returns "those" if 
           //"{that myobj/him} examine{s} {that myobj/him} <<self.name>> for a moment. ";// returns "those" if 
           // ___pre-defined object selectors___
           // actor - the actor performing the command
           // dobj  - the direct object of the command
           // iobj  - the indirect object of the command
           gMessageParams(myobj,myobj2); // gMessageParams(actor,dobj,iobj,myobj,myobj2);
           /*
            * when you do an 'x legs' command...
            * ....and the string is: "{A actor/she} looks around and around... ";
            * ....the result is: "You looks around and around... "
            * ....but when tiffany does the 'x legs' command...
            * ....the result is: "A Tiffany looks around and around... "
            */
           local oWho = (gActor == gPlayerChar) ? 'you' : gActor.name;
           // \^ <-- this string pattern will capitalize the next first letter encountered in the string...
           "\^<<oWho>> {subj actor} look{s} around and around at {that myobj/him} <<self.name>> but no
            matter what there\'s got to be something better to do. ";
   }
;

class AdultFemaleArms: FemaleBodyPart
   name = 'arms'
   isPlural = true
   vocabWords = '(left) (right) arm*arms'
;

class AdultFemaleNipples: FemaleBodyPart
   name = 'nipples'
   isPlural = true
   vocabWords = '(left) (right) (dark) (brown) (brownish) (pink) (big) (puffy) (sensitive) nipple*nipples'
;

class AdultFemaleSkin: FemaleBodyPart
   name = 'skin'
   vocabWords = '(white) (tan) skin'
   firstPersonDesc = "You see nothing unusual about your skin. "
   thirdPersonDesc = "You see nothing unusual. "
;

class AdultFemaleShoulders: FemaleBodyPart
   name = 'shoulders'
   vocabWords = '(white) (tan) shoulder*shoulders' 
   isPlural = true   
;

class AdultFemaleTorso: FemaleBodyPart
   name = 'torso'
   vocabWords = '(white) (tan) torso'   
;

class AdultFemaleBellybutton: FemaleBodyPart
   name = 'bellybutton'
   vocabWords = '(white) (tan) (tiny) (small) (belly) button'  
;

class AdultFemaleHips: FemaleBodyPart
   name = 'hips'
   vocabWords = '(white) (tan) (narrow) (slender) hip'  
   isPlural = true
;

class AdultFemaleWaist: FemaleBodyPart
   name = 'waist'
   vocabWords = '(white) (tan) (narrow) (slender) waist'  
;

class AdultFemaleToes: FemaleBodyPart
   name = 'toes'
   vocabWords = '(white) (tan) (pink) toe'
   isPlural = true
;

class AdultFemaleMouth: FemaleBodyPart
   name = 'mouth'
   vocabWords = 'lips/gums/teeth/tongue'
;




class AdultFemaleBlondeHair: FemaleBodyPart
   name = 'blonde hair'
   vocabWords = '(light) (strawberry) (yellow) (wavy) (curly) (straight) (long) (short) hair'
   disambigName = 'pretty blonde hair'
   hairDesc = 'You have long blonde hair. '
   desc = "<<hairDesc>>"
   dobjFor(BrushWith){
       verify(){ logicalRank(110,'likely'); }
       check(){ }
       action(){
           if(gActor.location == basementDressingRoom){
                 if(dressingRoomHairbrush.hasUsed == true){
                    "You\'ve already done your hair. You don\'t need to fuss with it anymore right now. ";
                    exit;
                 }
                 dressingRoomHairbrush.hasUsed = true;
                 "You use the hairbrush, brushing your long blonde hair. The tangles come right out without much fuss and though
                  you really don\'t know what you\'re doing and never brushed hair this long on your head before you eventually
                  get it to a point where it looks at least presentable. You set the brush back down on the dressing table. You won\'t
                 need it anymore for now. ";
                 dressingRoomHairbrush.hasUsed = true;
           }else if(gActor.location == yourVillaInner){
                 "You don\'t see any hair brush for that. ";
           }else{
                 "You can\'t do that here. ";
           }
       }
   }
   dobjFor(Brush) {
       verify(){ logicalRank(110,'likely'); }
       check(){ }
       action(){
           if(gActor.location == basementDressingRoom){
                 if(dressingRoomHairbrush.hasUsed == true){
                    "You\'ve already done your hair. You don\'t need to fuss with it anymore right now. ";
                    exit;
                 }
                 dressingRoomHairbrush.hasUsed = true;
                 "You use the hairbrush, brushing your long blonde hair. The tangles come right out without much fuss and though
                  you really don\'t know what you\'re doing and never brushed hair this long on your head before you eventually
                  get it to a point where it looks at least presentable. You set the brush back down on the dressing table. You won\'t
                 need it anymore for now. ";
           }else if(gActor.location == yourVillaInner){
                 "You don\'t see any hair brush for that. ";
           }else{
                 "You can\'t do that here. ";
           }
       }
   }
;

class AdultFemaleBrownHair: FemaleBodyPart
   name = 'hair'
   disambigName = 'pretty brown hair'
   vocabWords = '(dark) (brunette) (wavy) (curly) (straight) (long) (short) hair'
;

class AdultFemaleRedHair: FemaleBodyPart
   name = 'hair'
   disambigName = 'pretty red hair'
   vocabWords = '(firey) (firy) (firie) (bright) (dark) (red) (wavy) (curly) (straight) (long) (short) hair'
;

class AdultFemaleBlackHair: FemaleBodyPart
   name = 'hair'
   disambigName = 'pretty black hair'
   vocabWords = '(dark) (black) (wavy) (curly) (straight) (long) (short) hair'
;

class AdultFemaleEyeLashes:FemaleBodyPart
   name = 'eye lashes'
   vocabWords = '(left) (right) (eye) lash/lashes/eyelash*eyelashes'
   isPlural = true
;

class AdultFemaleEyeBrows:FemaleBodyPart
   name = 'eyebrows'
   vocabWords = '(left) (right) (eye) brow/brows/eyebrow*eyebrows'
   isPlural = true
;

class AdultFemaleBrownEyes:FemaleBodyPart
   name = 'brown eyes'
   vocabwords = '(left) (right) (brown) eye*eyes'
   isPlural = true
;

class AdultFemaleBlueEyes:FemaleBodyPart
   name = 'blue eyes'
   vocabWords = '(left) (right) (lightblue) (light) (hazel) (skyblue) (sky) (blue) (blue) eye*eyes'
   isPlural = true
;

class AdultFemaleEars:FemaleBodyPart
   name = 'ears'
   vocabWords = '(left) (right) (pink) (tan) (white) ear*ears'
   isPlural = true
;

class AdultFemaleHead:FemaleBodyPart
   desc = "<<headDesc>>"
   headDesc = 'You have a pretty woman\'s face. '
   name = 'head'
   vocabWords = '(pink) (tan) (white) face/head'  
;

class AdultFemaleHands:FemaleBodyPart
   name = 'hands'
   vocabWords = '(left) (right) (pink) (tan) (white) hand*hands'  
   isPlural = true
;

class AdultFemaleFingers:FemaleBodyPart
   name = 'fingers'
   vocabWords = '(middle) (pinky) (index) (pointer) (ring) thumb/thumbs/finger*fingers'
   isPlural = true
;

class AdultFemaleFeet:FemaleBodyPart
   name = 'feet'   
   vocabWords = '(left) (right) (pink) (tan) (white) ankle heel foot*feet'  
   isPlural = true
;

class AdultFemaleNose: FemaleBodyPart
   name = 'nose'
   vocabWords = 'snout/nostril/nostrils/nose'
;

class AdultFemaleFingerNails: FemaleBodyPart
   name = 'finger nails'
   vocabWords = '(finger) nail/nails/fingernail*fingernails'
   isPlural = true
   dobjFor(Examine){
              preCond = [objVisible] 
              verify(){                 
                 logicalRank(40,'not likely as compared to construction nails');
                 inherited;
              }
              check(){ inherited; }
              action(){ inherited; }
  }   
;

class AdultFemaleToeNails: FemaleBodyPart
   name = 'toe nails'
   vocabWords = '(toe) nail/nails/toenail*toenails'
   isPlural = true
   dobjFor(Examine){
              preCond = [objVisible] 
              verify(){                 
                 logicalRank(30,'not as likely as finger nails or construction nails');
                 inherited;
              }
              check(){ inherited; }
              action(){ inherited; }
   }  
;

class AdultMalePenis: BodyPart, VaginalInsertionDevice
   name = 'penis'  
   // isHim, isHer, isIt... see: en_us.t
   isHim = nil // tads library thing
   isHer = nil // tads library thing
   isIt {
        /* by default, we're an 'it' if we're not a 'him' or a 'her' */
        return !(isHim || isHer);
    }
   theName = 'the penis'
   vocabWords = 'penis/dick/shaft/rod/dong/dingdong/weiner/weenie/weeny/cock'
   permissionToPlayWith = nil
   dobjFor(PutIn){
          verify(){ 
              illogical('That is not necessary. If you wish to have
                     sex with someone just try \"have sex with\" and the
                     name of who you want to have sex with, and if the action
                     is possible I will prompt you through your options. ');
          }
   }   
   iobjFor(PutIn){
          verify(){
              if((gActor == gPlayerChar) && (self.location == gPlayerChar))
                      illogical('You\'re not a girl you know. You shouldn\'t be trying
                                 to cram things into {that myobj/him}. ');
              illogical('You can\'t put anything in the penis. ');
          }
   }
   dobjFor(PlayWith) remapTo(HaveSexWith,self.location)
   dobjFor(Rub) remapTo(HaveSexWith,self.location)
   dobjFor(Feel) remapTo(HaveSexWith,self.location)  
   dobjFor(Taste) remapTo(HaveSexWith,self.location)
   dobjFor(Lick) remapTo(HaveSexWith,self.location)   
   dobjFor(Examine) {
          verify(){ illogical('That\'s not something you should be doing. At least not yet. ');
          }
   }
;

class AdultFemaleBreasts: FemaleBodyPart
 name = 'breasts'
 vocabWords = 'chest/boobs/boobies/boobys/knockers/jugs/juggs/tits/titties/tittys/tit/breast*breasts'  
 permissionToPlayWith = nil  
 isPlural = true
 feelDesc = 'They feel wonderful in your hands. Not too big or small but just perfect. '  
 dobjFor(Examine){
       preCond = [objVisible] 
       verify(){ inherited; }
       check(){ 
                      local isTotallyTopless = self.location.toplessCheck;
                      // if the player is NOT here at all don't show anything
                      if(libGlobal.playerChar.location != self.location.location){
                            // *** don't show anything, just exit. the NPC's must be up to some funny business
                            exit;
                      }
                      /* child proof - class AdultFemaleBreasts should not be located on a little girl.
                       * This just makes extra sure the programmer does not accidentally use the wrong
                       * class object someplace. For example, an age regression should account for
                       * entirely different default body part descriptions, etc. So if the programmer
                       * somehow forgot to do that, we need to catch it.
                       */                  
                      if(self.location.is_A_Little_Girl == 1){ 
                            say('This isn\'t that kind of game. ');
                            self.moveInto(nil);// now get rid of it so it doesn't happen again
                            exit;
                      }    
                      // if it's a little girl trying to carry out this action on someone else...
                      if(gActor.is_A_Little_Girl == 1){
                            say('Children shouldn\'t be even thinking such things. ');
                            exit;
                      }
                      // if we are NOT the owner of the object, can we clearly see it? 
                      if((self.location != gActor) && (isTotallyTopless == 0)){
                            say('She has ample bosoms but for a really good look you\'d have to
                                 convince her somehow to remove some clothing. ');
                            exit;                        
                      }
                      // if we ARE the owner, can we clearly see it?
                      if((self.location == gActor) && (isTotallyTopless == 0)){
                            say('Your breasts look pretty but you\'ll have to remove some clothing 
                                 to really get a good look at them. ');
                            exit;
                      }
       }// end Examine check()...
       action(){ inherited; }
 }// end Examine...  
;


//testDong: AdultMalePenis
//  location = me
//;

class VaginalInsertionDevice: PlugAttachable, Thing
  
;
  
class AdultFemaleVagina: FemaleBodyPart, RestrictedContainer
    name = 'vagina'
    // vocabWords = (self.femWords + ' (nice) (soft) (smooth) vagina/pussy/cunt/clit/clitorous/slit/crack/crotch/groin/gonads/genitals/genital')
    vocabWords = '(nice) (soft) (smooth) vagina/pussy/cunt/clit/clitorous/slit/crack/crotch/groin/gonads/genitals/genital'
    hairColor = 'blonde'
    theName = 'the vagina'
    isProperName = nil
    properName = nil
    isShaved = true
    isWet = nil
    lubricationLevel = 0  // 1 = a little, 2 = average, 3+ = gushing
    validContents = []
    // sex counters for tracking purposes
    soloSexCount = 0
    sexWithMenCount = 0
    cockHistory = [] // array of male sex organs that have been put inside 
    // baby tracker
    pregnant = (self.babyInside != nil) // if true then this woman is pregnant
    babyInside = nil // an Actor object that will grow into our baby if non-nil
    birthCount = 0 // how many times did we have a baby?    
    permissionToPlayWith = nil
    // see: class RestrictedContainer in file: objects.t 
    canPutIn(obj) {
          // if we don't have permission and are not the PC 
          // then we always return nil by default
          //if((self.permissionToPlayWith == nil) &&
          //   (libGlobal.playerChar != self.location)) return nil;
          if(obj.ofKind(VaginalInsertionDevice)) return true;
          if(obj.ofKind(AdultMalePenis)) return true;
          // else if not of this type we'll allow for override
          // in the case of something put in the validContents list...
          return (validContents.indexOf(obj) != nil); 
    }
    dobjFor(Fondle) remapTo(HaveSexWith,self.location)
    dobjFor(PlayWith) remapTo(HaveSexWith,self.location)
    dobjFor(Rub) remapTo(HaveSexWith,self.location)
    dobjFor(Feel) remapTo(HaveSexWith,self.location)
    dobjFor(PutIn){
          verify(){                         
             if((gActor == gPlayerChar) && (self.location == gPlayerChar)){
                  illogical('You\'re not going to be putting your vagina <i>into</i>
                      anything. The physics might permit the reverse however. ');
             }             
             illogical('That is physically impossible. You might be able to put things
                        <i>into</i> the vagina however. ');
          }
    }
    iobjFor(PutIn){   
          verify(){                 
              if((gActor == gPlayerChar) && (self.location == gPlayerChar)){
                 local s1 = 'That is not necessary. If you wish to play with ';
                 s1 = s1 + 'yourself just try \"play with myself\" and I will ';
                 s1 = s1 + 'prompt you through masturbation, if it is possible right now. '; 
                 illogical(s1);
              }
              local s0 = 'That is not necessary. If you wish to have sex with her ';
              s0 = s0 + 'just try \"have sex with ' + self.location.name + '\" and I ';
              s0 = s0 + 'will prompt you through sex, if sex is possible with her right now. ';            
              illogical(s0);
          }// end verify
    }
    // if you pass the checks below you may see the longDesc...
    nudeDesc = 'It seems to be just an ordinary slit. If you\'ll pardon the pun, 
                most girls come with one of these. '
    dobjFor(ListenTo){
          preCond = [objVisible]
          verify(){ 
               illogical('If you do that we both must be going mad. I don\'t know what you 
                          expect to hear. Even if you rigged up a sonar array to it 
                          you probably wouldn\'t hear anything too interesting. Then 
                          again why would you go to the trouble? '); 
          }
    }      
    /*
     * A bit more complex than other routines... but well worth it.
     */
    dobjFor(Examine){
          preCond = [objVisible] // touchObj]
          verify(){ inherited; } 
          check(){ 
                      local isEasilyAccessable = self.location.bottomlessAccessCheck;// less restrictive (just care about access to the vagina - i.e. lift a skirt, etc.)
                      local isTotallyBottomless = self.location.bottomlessCheck;// very restrictive - must not be wearing anything at all over us, even a skirt or dress
                      local isNude = self.location.nudeCheck;  
                      local isPantyLiftOkayForViewAnyway = self.location.bottomlessAccessWithPantyLiftCheck;                                          
                      local isWearingSlip = self.location.slipCheck;
                      local isWearingDress = self.location.dressCheck;
                      local isWearingSkirt = self.location.skirtCheck;                      
                      local isJustWearingPanties = self.location.justWearingPantiesCheck;
                      local oPlayerPoV = gPlayerChar;// or--> libGlobal.playerChar
                      local oSenderPoV = gActor;// Note: do not confuse with gIssuingActor (or libGlobal.curIssuingActor)
                      local oReceiverPoV = self.location;
                      local tempJunk = (oPlayerPoV == oReceiverPoV) ? 'your' : (oReceiverPoV.name + '\'\s'); 
                      // if the player is NOT here at all don't show anything
                      if(libGlobal.playerChar.location != self.location.location){
                            // *** don't show anything, just exit. the NPC's must be up to some funny business
                            exit;
                      }
                      /* child proof - class AdultFemaleVagina should not be located on a little girl.
                       * This just makes extra sure the programmer does not accidentally use the wrong
                       * class object someplace. For example, an age regression should account for
                       * entirely different default body part descriptions, etc. So if the programmer
                       * somehow forgot to do that, we need to catch it.
                       */                  
                      if(self.location.is_A_Little_Girl == 1){ 
                            say('This isn\'t that kind of game. ');
                            self.moveInto(nil);// now get rid of it so it doesn't happen again
                            exit;
                      }    
                      // if it's a little girl trying to carry out this action on someone else...
                      if(gActor.is_A_Little_Girl == 1){
                            say('Children shouldn\'t be even thinking such things. ');
                            exit;
                      }
                      // if we are NOT the owner of the object, can we clearly see it? 
                      if(self.location != gActor){ 
                         if(isTotallyBottomless == 0){
                            say('She has some clothing blocking the view to that. ');
                            exit;
                         }
                      }
                      /* if we ARE the owner we can we see it one of these ways anyway:
                       * isEasilyAccessable, isTotallyBottomless, isPantyLiftOkayForViewAnyway, isNude
                       * 
                       */
                      local iOverride = ((self.location == gActor) &&
                            ((isEasilyAccessable==1) || (isTotallyBottomless==1) || 
                            (isPantyLiftOkayForViewAnyway==1) || (isNude==1))) ? 1 : 0;
                      /* Are we the owner and NOT totally bottomless for an easy view?
                       * and if so, do we also fail the override check?
                       */
                      if(((self.location == gActor) && (isTotallyBottomless == 0)) &&
                          (iOverride == 0)){                           
                          local s1 = 'You need to remove some of your clothing to see that clearly.\n\n ';
                          local s2 = (oSenderPoV.name + ' glances at her crotch and mutters something to 
                                      herself about needing to remove her clothes to get a better look. ');
                          local s3 = ('You try to examine ' + tempJunk + ' vagina but she\'s wearing some 
                                       clothing over it so you can\'t see.\n\n ');
                          local s4 = (oSenderPoV.name + ' sneakily tries to examine ' + tempJunk + ' crotch and
                                       mutters something about ' + tempJunk + ' not undressed enough. ');
                          local s5 = (oSenderPoV.name + ' sneakily tries to examine ' + tempJunk + ' crotch but
                                       your clothes are blocking the view. '); 
                          // Now say it in the correct PoV
                          saySomethingPoV(oPlayerPoV,oSenderPoV,oReceiverPoV,s1,s2,s3,s4,s5);
                          exit;  
                      }
                      // Are we NOT totally bottomless for an easy view?
                      // and if so, do we PASS the override check?
                      // If that is the case we avoid the normal examine description
                      // and do a skirt, dress, and/or panty lift to see the object,
                      // and also take into consideration the PoV.
                      if((isTotallyBottomless == 0) && (iOverride == 1)){
                          // we'll try and build a correct PoV report right here...
                          // first we need to set some local objects for string building
                          local oWho = (gActor == gPlayerChar) ? 'you' : gActor.name;// Tiffany or you
                          local oS = (gActor == gPlayerChar) ? '' : 's';// shows an 's' if not the pc
                          local oYourHer = (gActor == gPlayerChar) ? 'your' : 'her';// shows 'your' if pc, or 'her' if not                          
                          local oYouAreSheIs = (gActor == gPlayerChar) ? 'you\'re' : 'she is';
                          local oYouShe = (gActor == gPlayerChar) ? 'you' : 'she';
                          local oAreIs = (gActor == gPlayerChar) ? 'are' : 'is';
                          local oAndSeesToSee = (gActor == gPlayerChar) ? 'and see' : 'to see';
                          local oEs = (gActor == gPlayerChar) ? '' : 'es';// shows an 'es' if not the pc (ex: smooth vs. smoothes) 
                          local iLiftedDress = 0;
                          local iLiftedSkirt = 0;
                          local iLiftedSlip = 0;
                          local iLiftedPanties = 0;   
                          //local iSetPantiesBack = 0;    
                          // local iSetSlipBack = 0;
                          local iSetSkirtBack = 0;
                          local iSetDressBack = 0;                                         
                          local s1 = '';
                          // easy access to us by lifting dress or skirt for example                   
                          if(isEasilyAccessable == 1){
                              if(isWearingSlip == 1){
                                 s1 = '\^' + oWho + ' daintily lift' + oS + ' up ' + oYourHer + ' slip';
                                 iLiftedSlip = 1;
                                 if(isWearingDress == 1){  
                                        s1 = s1 + ' and dress';
                                        iLiftedDress = 1;
                                 }
                                 if(isWearingSkirt == 1){ 
                                        s1 = s1 + ' and skirt';
                                        iLiftedSkirt = 1;
                                 }
                              }else{
                                 if(isWearingDress == 1){
                                      s1 = '\^' + oWho + ' daintily lift' + oS + ' up ' + oYourHer + ' dress';
                                      iLiftedDress = 1;
                                 }
                                 if(isWearingSkirt == 1){
                                      s1 = '\^' + oWho + ' daintily lift' + oS + ' up ' + oYourHer + ' skirt';
                                      iLiftedSkirt = 1;
                                 }
                              }
                          }
                          // nothing covering us, at least not there 
                          if(isTotallyBottomless == 1){
                              s1 = 'As ' + oYouAreSheIs + ' not wearing anything over it ' + oYouShe + ' take' + oS + ' a good look';
                          }
                          // totally nude
                          if(isNude == 1){
                              s1 = 'As ' + oWho + ' ' + oAreIs + ' completely nude ' + oYouShe + ' take' + oS + ' a good long look';
                          }
                          // if all else fails perhaps a panty lift will work  
                          if(isPantyLiftOkayForViewAnyway == 1){
                              if(isWearingSlip == 1){
                                 s1 = '\^' + oWho + ' daintily lift' + oS + ' up ' + oYourHer + ' slip';
                                 iLiftedSlip=1;
                                 if(isWearingDress == 1){ 
                                       s1 = s1 + ' and dress';
                                       iLiftedDress = 1;
                                 }
                                 if(isWearingSkirt == 1){
                                       s1 = s1 + ' and skirt';
                                       iLiftedSkirt = 1;
                                 }
                              }else{
                                 if(isWearingDress == 1){
                                       s1 = 'You daintily lift up your dress';
                                       iLiftedDress=1;
                                 }
                                 if(isWearingSkirt == 1){
                                       s1 = 'You daintily lift up your skirt';
                                       iLiftedSkirt = 1;
                                 }
                              }
                              s1 = s1 + ' and with both thumbs ' + oYouShe + ' lift' + oS + ' ' + oYourHer + ' panties out a bit';
                              iLiftedPanties = 1;
                          }
                          // or were we ONLY wearing panties?
                          if(isJustWearingPanties== 1){
                              s1 = '\^' + oWho + ' take' + oS + ' both ' + oYourHer + ' thumbs and use' + oS + ' them to lift ' + oYourHer + ' panties out a bit';
                              iLiftedPanties = 1;
                          }
                          if(s1 != ''){
                              s1 = s1 + ' ' + oAndSeesToSee;//s1 = s1 + ' and see' + oS;
                          }else{
                              s1 = '\^' + oWho + ' see' + oS;
                          }
                          if(self.isShaved==true){
                              s1 = s1 + ' ' + oYourHer + ' smooth, sexy';
                          }else{
                              s1 = s1 + ' a small triangular patch of ' + self.hairColor + ' hair above ' + oYourHer + ' incredible';                            
                          }
                          s1 = s1 + ' vagina. ';
                          // say it now..
                          say('\n<.p>' + s1);
                          // if we are the owner, also show our description
                          if(gPlayerChar == gActor){
                              say(self.nudeDesc);
                          }
                          // now right the clothes if they were moved...
                          s1 = '';
                          s1 = 'After a moment of reflection ' + oYouShe + ' sigh' + oS + ' peacefully and';                          
                          if(iLiftedPanties == 1){
                              s1 = s1 + ' remove' + oS + ' ' + oYourHer + ' thumbs from the corners of ';
                              s1 = s1 + oYourHer + ' panties and set' + oS + ' them back in place again';                                                            
                              // also have a slip? 
                              if(iLiftedSlip == 1){
                                 s1 = s1 + ' along with ' + oYourHer + ' slip';                                 
                                 if((iLiftedDress==1) && (iLiftedSkirt==0)){
                                     s1 = s1 + 'and dress';                                     
                                     iSetDressBack = 1;
                                 }
                                 if((iLiftedDress==0) && (iLiftedSkirt==1)){
                                     s1 = s1 + ' and skirt';
                                     iSetSkirtBack = 1;
                                 }
                                 if((iLiftedDress==1) && (iSetDressBack == 0) && (iSetSkirtBack==0) && (iLiftedSkirt==1)){
                                     s1 = s1 + ', dress, and skirt';
                                     iSetDressBack = 1;
                                     iSetSkirtBack = 1;
                                 }                                 
                              }
                              // set back dress?
                              if((iSetDressBack==0) && (iLiftedDress==1)){
                                 s1 = s1 + ' along with ' + oYourHer + ' pretty dress';
                                 iSetDressBack = 1;
                                 if((iSetSkirtBack==0) && (iLiftedSkirt==1)){
                                     s1 = s1 + ' and skirt';
                                     iSetSkirtBack = 1;
                                 }
                              }
                              // set back skirt?
                              if((iSetSkirtBack==0) && (iLiftedSkirt==1)){
                                 s1 = s1 + ' along with ' + oYourHer + ' skirt';
                                 iSetSkirtBack=1;                                  
                              }
                              s1 = s1 + ' and smooth' + oEs + ' ' + oYourHer + ' hands down along ' + oYourHer + ' hips. ';
                              s1 = s1 + '\^' + oYouShe + ' pat' + oS + ' ' + oYourHer + ' tummy with a mischievous grin';
                          }else{
                              if((iLiftedDress==1) || (iLiftedSkirt==1) || (iLiftedSlip==1)){
                                 s1 = s1 + ' right' + oS + ' ' + oYourHer + ' clothes back in place and smooth' + oEs;
                                 s1 = s1 + ' ' + oYourHer + ' hands down along ' + oYourHer + ' hips. ';
                              }else{
                                 // must have been nude or bottomless
                                 s1 = ' yawn' + oS;
                              }
                          }
                          s1 = s1 + '. ';
                          say(s1);
                          exit;                           
                      }// end of our override "sneek peek" routine
                      // ** one last check                           
                      if((self.location != gActor) &&
                               (isTotallyBottomless == 0)){
                                say('You would need to remove some clothing to see that clearly.');
                                exit;
                      }                         
          }// end check()...
          // action(){ inherited; }
          action(){
          "<.p> ";
          /* 
           *  We'll manually figure out PoV this way...
           *  
           *  oPlayerPoV = gPlayerChar  .... this is always the player character
           *  oSenderPoV = gActor       .... this is always the actor who issued this command
           *                                 and can be a NPC like the memDroid for example.
           *  oReceiverPoV = self.location ..this is the owner of our body part being acted upon. 
           *
           */          
            local oPlayerPoV = gPlayerChar;// or--> libGlobal.playerChar
            local oSenderPoV = gActor;// Note: do not confuse with gIssuingActor (or libGlobal.curIssuingActor)
            local oReceiverPoV = self.location;
            /* more strings */
            local tempJunk = (oPlayerPoV == oReceiverPoV) ? 'your' : (oReceiverPoV.name + '\'\s'); 
            /*
             *  s1 = self action where the player is the sender and the receiver
             *  s2 = self action where an NPC is the sender and the receiver and being observed by the player
             *  s3 = non-self action where player is the sender and taking action on NPC who is the receiver
             *  s4 = non-self action where sender and receiver are two NPCs being observed taking action on each other by the player
             *  s5 = non-self action where NPC is the sender and taking action upon the player who is the receiver
             *             
             */
            local s1 = 'Okay...\n\n ';//  + self.firstPersonDesc;
            local s2 = (oSenderPoV.name + ' is closely examining her crotch. ');
            local s3 = ('You examine ' + tempJunk + ' vagina...\n\n ');//  + self.thirdPersonDesc);
            local s4 = (oSenderPoV.name + ' is examining ' + tempJunk + ' vagina. ');
            local s5 = (oSenderPoV.name + ' examines ' + tempJunk + ' vagina. ');
            // Now say it in the correct PoV
            saySomethingPoV(oPlayerPoV,oSenderPoV,oReceiverPoV,s1,s2,s3,s4,s5);
           // **** A BIT OF A REPEAT OF THE ABOVE ROUTINE *****
           // ---- we will use some of the same logic but return first or third person desc if avail
           /* if player is not even here then exit */
           if(oPlayerPoV.location != oReceiverPoV.location) exit;  
           /* if anything is nil then exit */
           if((oPlayerPoV == nil) || (oSenderPoV==nil) || (oReceiverPoV==nil) || 
              (s1==nil) || (s2==nil) || (s3==nil) || (s4==nil) || (s5==nil)) exit;
           /* self stimulus */
           if(oSenderPoV == oReceiverPoV){
              /* self stimulus from player PoV */
              if(oSenderPoV == oPlayerPoV) say(self.nudeDesc); // self.firstPersonDesc;// say(s1);            
           }else{
              /* else must be in third person */
              /* ...player rubbing NPC */
              if(oSenderPoV == oPlayerPoV) say(self.nudeDesc); // probably unreachable???? // self.thirdPersonDesc;// say(s3);
           }          
            //  self.desc;
          }
    }   
; 

body_Legs_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) legs/knees/knee/thigh/thighs/calf/calves/ankle/ankles'
  name = 'girls legs'
  isPlural = true
  desc = (location == me) ? "You've got small hairless legs. Nothing too out of the ordinary here for a little girl like yourself. "
         : "Small hairless legs. "
;
body_Left_Leg_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) left leg'
  name = 'girls left leg'
  desc = (location == gPlayerChar) ? "You've got small hairless legs. Nothing too out of the ordinary here for a little girl like yourself. "
         : "Small hairless legs. "
;
body_Right_Leg_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) right leg'
  name = 'girls right leg'  
  desc = (location == gPlayerChar) ? "You've got small hairless legs. Nothing too out of the ordinary here for a little girl like yourself. "
         : "Small hairless legs. "
;
body_Arms_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) arms/elbow/elbows/biceps/bicep/forearm/forearms'
  name = 'girls arms'
  isPlural = true
  desc = (location == gPlayerChar) ? "You've got small almost completely hairless arms. What hair exists is light and barely noticable. "
         : "Small hairless arms. "
;
body_Right_Arm_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) right arm'
  name = 'girls right arm'  
  desc = (location == gPlayerChar) ? "You've got small almost completely hairless arms. What hair exists is light and barely noticable. "
         : "Small hairless arms. "
;
body_Left_Arm_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) left arm'
  name = 'girls left arm'  
  desc = (location == gPlayerChar) ? "You've got small almost completely hairless arms. What hair exists is light and barely noticable. "
         : "Small hairless arms. "
;
body_Feet_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) feet/toes/heel/heels'
  name = 'girls feet'
  isPlural = true
  desc = (location == gPlayerChar) ? "You've got small hairless feet. "
         : "Small hairless feet. "
;
body_Right_Foot_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) right foot'
  name = 'girls right foot'  
  desc = (location == gPlayerChar) ? "You've got small hairless feet. "
         : "Small hairless feet. "
;
body_Left_Foot_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) left foot'
  name = 'girls left foot'  
  desc = (location == gPlayerChar) ? "You've got small hairless feet. "
         : "Small hairless feet. "
;
body_Hands_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) hands/finger/fingers/wrist/wrists/palm/palms'
  name = 'girls hands'
  isPlural = true
  desc = (location == gPlayerChar) ? "You've got small hairless hands. "
         : "Small hairless hands. "
;
body_Right_Hand_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) right hand'
  name = 'girls right hand'  
  desc = (location == gPlayerChar) ? "You've got small hairless hands. "
         : "Small hairless hands. "
;
body_Left_Hand_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) left hand'
  name = 'girls left hand'  
  desc = (location == gPlayerChar) ? "You've got small hairless hands. "
         : "Small hairless hands. "
;
body_Chest_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) chest/breast/breasts/nipple/nipples/hooters/mammaries/mammary'
  name = 'girls chest'
  isPlural = true
  desc = (location == gPlayerChar) ? "It's a flat chest, but what were you expecting? You're just a little girl. "
         : "Small flat, hairless chest. "
;
body_Waist_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) waist'
  name = 'girls waist'
  isPlural = true
  desc = (location == gPlayerChar) ? "An ordinary slim waist. "
         : "An ordinary slim waist. "
;
body_Hips_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) hips/hip/butt/buttocks/rump/fanny/rear'
  name = 'girls hips'
  isPlural = true
  desc = (location == gPlayerChar) ? "Your hips and rear are plain enough for someone your age. "
         : "It appears ordinary enough. "
;
body_Right_Hip_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) right hip'
  name = 'girls right hip'
  desc = (location == gPlayerChar) ? "Your hips and rear are plain enough for someone your age. "
         : "It appears ordinary enough. "
;
body_Left_Hip_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) left hip'
  name = 'girls left hip'
  desc = (location == gPlayerChar) ? "Your hips and rear are plain enough for someone your age. "
         : "It appears ordinary enough. "
;
body_Neck_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) neck'
  name = 'girls neck'
  desc = (location == gPlayerChar) ? "Your neck is smooth and slender. "
         : "It appears ordinary enough. "
;
body_Shoulders_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) shoulders'
  name = 'girls shoulders'
  isPlural = true
  desc = (location == gPlayerChar) ? "Your shoulders are plainly those of a little girl. "
         : "It appears ordinary enough. "
;
body_Right_Shoulder_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) right shoulder'
  name = 'girls right shoulder'
  desc = (location == gPlayerChar) ? "Your shoulders are plainly those of a little girl. "
         : "It appears ordinary enough. "
;
body_Left_Shoulder_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) left shoulder'
  name = 'girls left shoulder'
  desc = (location == gPlayerChar) ? "Your shoulders are plainly those of a little girl. "
         : "It appears ordinary enough. "
;
body_Vagina_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) vagina/pussy/cunt/slit/crotch'
  name = 'girls vagina'
  isPlural = true
  counter = 0
  desc { 
         if(location == gPlayerChar){
            counter++;
            myList2.doScript();             
         }else{
            "You shouldn't be trying to look at that. ";
         }
       }
  myList2: StopEventList {
          ['Naughty girl! Shouldn\'t be looking down there! ',
           'You see nothing unusual about it. You\'re female after all. ',
           'Look, I already told you, there\'s nothing unusual about it. ',
           'Naughty girl! Why are you trying to look there for? This isn\'t that type of game! ',
           'You just don\'t quit, do you? ',
           'Well, everyone needs a hobby. ',
           'Look, if you don\'t stop bugging me about this I\'m going to report you to the 
              adventurers union for unfair parser pestering. ',
           'I warned you. Stop asking me about your vagina. ',
           'Okay, since you seem to be fascinated by it, I\'ll tell you what. I\'m giving you 
              a special command if that\'ll make you happy. It\'s the Binkle command. Just 
              say the word Binkle and see what happens. ',
           'You\'ve asked this ' + body_Vagina_LG.counter + ' times already! '
          ]

  }
  dobjFor(Feel){
          precond = [objHeld]
          verify(){ illogicalNow('You are too young to be messing around like that. ', 50); }
          check(){ }
          action(){ }
  }
  dobjFor(PlayWith) remapTo(Feel,body_Vagina_LG)
  dobjFor(Rub) remapTo(Feel,body_Vagina_LG)
;
body_Head_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) head/face'
  name = 'girls head'  
  desc = (location == gPlayerChar) ? "If you had a mirror handy you could see that better. You get the impression that you have a cute little girl's face. "
         : "She's got a pretty little girl's face. "
;
body_Eyes_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) eyes'
  name = 'girls eyes'  
  isPlural = true
  desc = (location == gPlayerChar) ? "If you had a mirror handy you could see that better. You get the impression that you have a cute little girl's face. "
         : "She's got pretty little girl's eyes. They're <<colorDesc>>. "
;
body_Right_Eye_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) right eye'
  name = 'girls right eye'  
  colorDesc = me.pcEyes // 'blue'
  desc = (location == gPlayerChar) ? "If you had a mirror handy you could see that better. You get the impression that you have a cute little girl's face. "
         : "She's got pretty little girl's eyes. They're <<colorDesc>>. "
;
body_Left_Eye_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) left eye'
  name = 'girls left eye' 
  colorDesc = me.pcEyes // 'blue' 
  desc = (location == gPlayerChar) ? "If you had a mirror handy you could see that better. You get the impression that you have a cute little girl's face. "
         : "She's got pretty little girl's eyes. They're blue. "
;
body_Mouth_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) mouth/lips/lip/tongue/teeth'
  name = 'girls mouth'
  colorDesc = 'pink. '// me.pcLipstick // 'pink' // refers to lip/lipstick color of the mouth
  desc = (location == gPlayerChar) ? "If you had a mirror handy you could see that better. You get the impression that you have a cute little girl's face. "
         : "She's got a pretty little girl's mouth. Her lips are <<colorDesc>>. "
;
body_Nose_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) nose/nostrils/nostril'
  name = 'girls nose'  
  desc = (location == gPlayerChar) ? "If you had a mirror handy you could see that better. You get the impression that you have a cute little girl's face. "
         : "She's got a pretty little girl's nose. "
;
body_Eyebrows_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) (eye) eyebrows/brow/brows'
  name = 'girls eyebrows'  
  isPlural = true
  colorDesc = me.pcHair
  desc = (location == gPlayerChar) ? "If you had a mirror handy you could see that better. You get the impression that you have a cute little girl's face. "
         : "She's got pretty little girl's eyebrows. "
;
body_Eyelashes_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) (eye) eyelashes/lash/lashes'
  name = 'girls eyelashes'  
  isPlural = true
  desc = (location == gPlayerChar) ? "If you had a mirror handy you could see that better. You get the impression that you have a cute little girl's face. "
         : "She's got pretty little girl's eyelashes. "
;
body_Ears_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) (eye) ears'
  name = 'girls ears'  
  isPlural = true
  desc = (location == gPlayerChar) ? "If you had a mirror handy you could see that better. You get the impression that you have a cute little girl's face. "
         : "She's got pretty little girl's ears. "
;
body_Right_Ear_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) (eye) right ear'
  name = 'girls right ear'  
  desc = (location == gPlayerChar) ? "If you had a mirror handy you could see that better. You get the impression that you have a cute little girl's face. "
         : "She's got pretty little girl's ears. "
;
body_Left_Ear_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) (eye) left ear'
  name = 'girls left ear'  
  desc = (location == gPlayerChar) ? "If you had a mirror handy you could see that better. You get the impression that you have a cute little girl's face. "
         : "She's got pretty little girl's ears. "
;
body_Head_Hair_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) (eye) hair'
  name = 'girls hair'  
  colorDesc = 'blonde'
  desc = (location == gPlayerChar) ? "If you had a mirror handy you could see that better. You get the impression that you have a cute little girl's face. You have <<colorDesc>> hair. "
         : "She's got pretty little girl's hair. It's <<colorDesc>>. "
  dobjFor(Examine){
         verify(){ logicalRank(150,'most likely means hair on head and not body'); }
  }
;
body_Body_LG: FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) (eye) body'
  name = 'girls body'
  desc = (location == gPlayerChar) ? "You have a pretty little girl's body. "
         : "A pretty little girl's body. "
  dobjFor(Examine){
         verify(){ logicalRank(100,'most likely means body'); }
  }
;
body_Body_Hair_LG : FemaleBodyPart
  vocabWords = '(cute) (little) (girl) (girls) (girl\'s) (eye) body hair'
  name = 'girls body hair'
  colorDesc = 'blonde'  
  desc = (location == gPlayerChar) ? "It's practically nonexistant. Your body is mostly smooth and hairless. "
         : "It's practically nonexistant. "
  dobjFor(Examine){
         verify(){ logicalRank(40,'most likely means hair on head and not body'); }
  }
;






defaultSkin:BodyPart
   name = 'skin'
   vocabWords = 'skin/flesh/'
   firstPersonDesc = "You see nothing unusual about your skin. "
   thirdPersonDesc = "You see nothing unusual. "
;

defaultLegs:BodyPart
   name = 'legs'
   vocabWords = '(left) (right) leg/legs/knee/knees/calf/calfs/calves/thigh/thighs/shin/shins/ankle/ankles/'
   firstPersonDesc = "You see nothing unusual about your legs. "
   thirdPersonDesc = "You see nothing unusual. "
   isPlural=true
;

defaultArms:BodyPart
   name = 'arms'
   vocabWords = '(left) (right) arm/arms/'
   firstPersonDesc = "You see nothing unusual about your arms. "
   thirdPersonDesc = "You see nothing unusual. "
   isPlural=true
;

defaultFeet:BodyPart
   name = 'feet'
   vocabWords = '(left) (right) foot/feet/'
   firstPersonDesc = "You see nothing unusual about your feet. "
   thirdPersonDesc = "You see nothing unusual. "
   isPlural=true
;

defaultHands: BodyPart
   name = 'hands'
   vocabWords = '(left) (right) hand/hands/'
   firstPersonDesc = "You see nothing unusual about your hands. "
   thirdPersonDesc = "You see nothing unusual. "
   isPlural=true
;

defaultHead:BodyPart
   name = 'head'
   vocabWords = 'head/face/'
   firstPersonDesc = "You notice nothing unusual about your head. "
   thirdPersonDesc = "You see nothing unusual about it. "
;

defaultEars:BodyPart
   name = 'ears'
   vocabWords = '(left) (right) ear/ears/'
   firstPersonDesc = "You notice nothing unusual about your ears. "
   thirdPersonDesc = "You see nothing unusual. "
   isPlural = true
;

defaultEyes:BodyPart
   name = 'eyes'
   vocabWords = '(left) (right) eye/eyes/'
   firstPersonDesc = "You notice nothing unusual about your eyes. "
   thirdPersonDesc = "You see nothing unusual. "
   isPlural = true
;

defaultEyeLashes:BodyPart
   name = 'eye lashes'
   vocabWords = '(left) (right) eye eyes lash/lashes/eyelash/eyelashes/'
   firstPersonDesc = "You notice nothing unusual about your eyelashes. "
   thirdPersonDesc = "You see nothing unusual. "
   isPlural = true
;

defaultEyeBrows:BodyPart
   name = 'eye brows'
   vocabWords = '(left) (right) eye eyes brow/brows/eyebrow/eyebrows/'
   firstPersonDesc = "You notice nothing unusual about your eyebrows. "
   thirdPersonDesc = "You see nothing unusual. "
   isPlural = true
;

defaultHair:BodyPart
   name = 'hair'
   vocabWords = 'hair/'
   firstPersonDesc = "You notice nothing unusual about your hair. "
   thirdPersonDesc = "You see nothing unusual. "
;

defaultMouth:BodyPart
   name = 'mouth'
   vocabWords = 'lips/gums/teeth/tongue/mouth/'
   firstPersonDesc = "You notice nothing unusual about that. "
   thirdPersonDesc = "You see nothing unusual. "
;

defaultNose:BodyPart
   name = 'nose'
   vocabWords = 'nose/snout/nostril/nostrils/'
   firstPersonDesc = "You notice nothing unusual about your nose. "
   thirdPersonDesc = "You see nothing unusual. "
;

defaultFingers:BodyPart
   name = 'fingers'
   vocabWords = '(middle) (pinky) (index) (pointer) (ring) finger/fingers/thumb/thumbs/'
   firstPersonDesc = "You notice nothing unusual about your fingers. "
   thirdPersonDesc = "You see nothing unusual. "
   isPlural = true
;


defaultToes:BodyPart
   name = 'toes'
   vocabWords = '(middle) (pinky) (index) (pointer) (ring) (little) (big) toe/toes/piggy/piggies/piggys/'
   firstPersonDesc = "You notice nothing unusual about your toes. "
   thirdPersonDesc = "You see nothing unusual. "
   isPlural = true
;

defaultFingerNails:BodyPart
   name = 'finger nails'
   vocabWords = '(finger) nail/nails/fingernails/'
   firstPersonDesc = "You notice nothing unusual about your fingernails. "
   thirdPersonDesc = "You see nothing unusual. "
   isPlural = true
   dobjFor(Examine){
              preCond = [objVisible] 
              verify(){                 
                 logicalRank(40,'not likely as compared to construction nails');
                 inherited;
              }
              check(){ inherited; }
              action(){ inherited; }
  }   
;

defaultToeNails:BodyPart
   name = 'toe nails'
   vocabWords = '(toe) nail/nails/toenails/'
   firstPersonDesc = "You notice nothing unusual about your toe nails. "
   thirdPersonDesc = "You see nothing unusual. "
   isPlural = true
   dobjFor(Examine){
              preCond = [objVisible] 
              verify(){                 
                 logicalRank(30,'not as likely as finger nails or construction nails');
                 inherited;
              }
              check(){ inherited; }
              action(){ inherited; }
   }  
;


defaultWaist:BodyPart
   name = 'waist'
   vocabWords = 'waist/'
   firstPersonDesc = "You notice nothing unusual about your waist. "
   thirdPersonDesc = "You see nothing unusual. "
;

defaultHips:BodyPart
   name = 'hips'
   vocabWords = 'hip/hips/'
   firstPersonDesc = "You notice nothing unusual about your hips. "
   thirdPersonDesc = "You see nothing unusual. "
   isPlural = true
;

defaultBellybutton:BodyPart
   name = 'bellybutton'
   vocabWords = '(belly) bellybutton/button/'
   firstPersonDesc = "You notice nothing unusual about your bellybutton. "
   thirdPersonDesc = "You see nothing unusual. "
;

defaultTorso:BodyPart
   name = 'stomach'
   vocabWords = 'stomach/torso/tummy/belly/'
   firstPersonDesc = "You notice nothing unusual about that. "
   thirdPersonDesc = "You see nothing unusual. "
;

defaultShoulders:BodyPart
   name = 'shoulders'
   vocabWords = '(left) (right) shoulder/shoulders/'
   firstPersonDesc = "You notice nothing unusual about your shoulders. "
   thirdPersonDesc = "You see nothing unusual. "
   isPlural = true
;

defaultChest:BodyPart
   name = 'chest'
   vocabWords = 'chest/breast/breasts/boobs/tits/nipples/'
   firstPersonDesc = "You notice nothing unusual about your chest. "
   thirdPersonDesc = "You see nothing unusual. "
   isPlural = true
;

/*
 * Class: BasicClothingPile
 * This is like the ClothingWornGroup object only
 * used exclusively for clothes dropped in a room
 * or on a table in a room, etc. 
 * 
 * We'll extend this to RoomClothingPile for
 * a planned way of managing 'get clothes', etc. 
 * when some clothes are on the floor of a room
 * and/or vs. clothes on the player. The way this
 * will work is when clothes are dropped on the floor,
 * if a RoomClothingPile does not exist for the room,
 * a RoomClothingPile object will be dynamically created.
 * Then if the last item of clothing from the floor is
 * picked up, the RoomClothingPile object will be deleted.
 * 
 */
class BasicClothingPile: ClothingWornGroup
  name = 'clothes' 
  vocabWords = 'clothing clothes pile'
;

/*
 * Class: ClothingOutfit
 * 
 * A tag-along object used to manage entire outfits
 * comprised of different clothing items. Such as
 * a maid's uniform for example which might contain
 * a dress, stockings, shoes, and a maid's hat. 
 * 
 * Remember to put the setting "collectiveGroup = <ClothingOutfitObjName>"
 * in each clothing item that you want a part of this
 * collective group. Also you need to add those items
 * to this group's "myCromOutfitList" so the group can
 * properly manage "take outfit", "wear outfit", etc.
 *
 * A "location" value should never normally be required.
 * This allows the parser to determine the vocabWords 
 * in a more global context than just in one room location.
 * And some of the preconditions are handled automatically
 * this way as well.
 *   
 */
// NOTE that we did NOT define a location for
// this collective group, so it can be queried from
// anywhere!
// NOTE that because it can be queried from anywhere
// that you should override the "Examine" routine to
// display the "desc" tag only if the full outfit is
// here.
class ClothingOutfit: CollectiveGroup, SecretFixture 
  vocabWords = '(generic) outfit/outift/clothes/bongobit' // 'outift' is for dysleis programisr
  name = 'generic outfit'
  desc = "The generic outfit consists of a bunch of different clothes. "
  /*
   * The "owner" value is normally nil in Tads, but you can set it
   * manually so that it's always "owned" by an actor even if that
   * actor is not carrying it. Aside from "ClothingOutfit" class,
   * this idea could be used for, say, a magic ring owned by Ian Banten,
   * and if the player said "get Banten's ring" even though "banten" was
   * not listed in the vocabWords and Banten might not even be there at all
   * in the room or even the game, it'll allow an implied reference.
   * In the case of "ClothingOutfit" we want to be able to say "x my clothes"
   * and get a good match to this object. Or even "x Quill's clothes" and
   * have it match dispite the vocabWords list.
   *
   * In this case, ClothingOutfit has no "location" value but we still
   * would like to know who own's the object. So we would set "owner=me"...
   * 
   * NOTE: VERY IMPORTANT! For a ClothingOutfit object, on the setup
   * please set "owner = <actorObject>" (NOT a string! but the actual
   * Actor or Person class object). We'll try doing this on all of our
   * default starting outfits for our actors. (i.e. Maid's clothes,
   * Butler's clothes, Gardeners clothes, etc.) And note that if you
   * do that you do not have to put the owner's name up in the vocabWords
   * list. That's the whole point of this, for disambiguation checks and
   * to automatically have the parser know who this object belongs to.
   * Where this *may* backfire is if TADS is picky about who can own this
   * object. If Quill tries to get the Maid's clothes, even if she's not
   * wearing them, it may trail back through the CollectiveGroup list and 
   * fail the attempt.
   */
  owner = nil

  // NOTE: "myCromOutfitList" is something you have to manually set
  //        as well as in each object in this list, that object
  //        should have a pointer back to this CollectiveGroup 
  //        by using "collectiveGroup = <thisCollectiveGroupObjName>"
  // myCromOutfitList = [maidsShoes,maidsDress,maidsStockings]
  myCromOutfitList = [] 
  // we'll attempt to sort the clothes by the
  // order they need to be worn
  sortCromexxClothingWearOrder(lst){
     if(lst==nil) return nil;
     local vReturner = new List();
     local vTemp = lst;// temp list that gets eaten down to nothing
     // iOrder represents clothLevel value order from underwear to full body suit
     // local iOrder = [3,5,4,7,23,2,10,11,9,6,7,12,1,8,13,14,20,21,18,16,17,15,19,22];
     local iOrder = [3,23,5,4,7,2,10,11,9,6,7,12,1,8,13,14,20,21,18,16,17,15,19,22];// moved 23, stockings...
     foreach(local x in iOrder){
         foreach(local obj in vTemp){
           if(obj.clothLevel == x){
              vReturner += obj;// add to new list
              vTemp -= obj;// subtract from temp list
           }
         }
     }
     // if anything was left over we'll add it now
     if(vTemp.length > 0){
        foreach(local obj in vTemp){
           vReturner += obj;
        }
     }
     return vReturner;
  }
  // we'll attempt to sort the clothes by the
  // order they need to be removed
  sortCromexxClothingRemoveOrder(lst){
     if(lst==nil) return nil;
     local vReturner = new List();
     local vTemp = lst;// temp list that gets eaten down to nothing
     // iOrder represents clothLevel value order from full body suit to underwear
     // local iOrder = [22,19,15,17,16,18,21,20,14,13,8,1,12,7,6,9,11,10,2,23,7,4,5,3];
     local iOrder = [22,19,15,17,16,18,21,20,14,13,8,1,12,7,6,9,11,10,2,7,4,5,23,3];// moved 23 (stockings..)
     foreach(local x in iOrder){
         foreach(local obj in vTemp){
           if(obj.clothLevel == x){
              vReturner += obj;// add to new list
              vTemp -= obj;// subtract from temp list
           }
         }
     }
     // if anything was left over we'll add it now
     if(vTemp.length > 0){
        foreach(local obj in vTemp){
           vReturner += obj;
        }
     }
     return vReturner;
  }
  // these old list routines were for passing CromexxClothing items to them & getting back a list
  getClothingList(owhat){
              if(owhat == nil) return nil;
              local vList = new List();
              if(owhat.location == nil) return nil;
              if(owhat.location.contents == nil) return nil;
              foreach(local obj in owhat.location.contents){
                    if(obj.ofKind(CromexxClothing))
                       vList += obj;
              }
              return vList;
  }
  getClothingWornList(owhat){
              if(owhat == nil) return nil;
              local vList = new List();
              if(owhat.location == nil) return nil;
              if(owhat.location.contents == nil) return nil;
              foreach(local obj in owhat.location.contents){
                    if((obj.ofKind(CromexxClothing)) &&
                       (obj.isWorn == true))
                       vList += obj;
              }
              return vList;
  } 
  getClothingHeldList(owhat){
           if(owhat == nil) return nil;
           local vList = new List();
              if(owhat.location == nil) return nil;
              if(owhat.location.contents == nil) return nil;
              foreach(local obj in owhat.location.contents){
                    if((obj.ofKind(CromexxClothing)) &&
                       (obj.isWorn != true))
                       vList += obj;
              }
              return vList;   
  }  
  isCollectiveAction(action, whichObj) { 
         /* we handle 'Examine' and 'Take' etc... */ 
         if (action.ofKind(ExamineAction) || action.ofKind(TakeAction) ||
             action.ofKind(WearAction) || action.ofKind(RemoveAction) || 
             action.ofKind(DoffAction) || action.ofKind(DropAction))
             return true; 
  
         /* it's not one of ours */ 
         return nil; 
  } 
  // NOTE: we needed to set "preCond=[]" here 
  // because the default, if not specified, is
  // that we must have the item(s) in our posession.
  // What this does is make "Drop" act like "Take"...
  // Since that was bad, we'll set preCond=[] and 
  // handle everything in the check() routine
  dobjFor(Drop){
        preCond=[]
        verify(){ 
                   
        }
        check() {
              local myList = new List();// see list.t
              myList = self.getVisibleIndividuals(gActor.visibleInfoTable());
              // if no objects
              if(myList.length == 0){ 
                 "You don\'t see that here.\n "; 
                 exit;
              }
              // is the gActor already NOT in posession of the full outfit?
              local iTally = 0;
              foreach(obj in myList){ if(!obj.isIn(gActor)) iTally++; }
              if(myList.length == iTally){
                // report back only if player & exit either way
                if(gActor == gPlayerChar){
                     local s0 = 'You do not even have ';
                     local obj2 = self;
                     gMessageParams(obj2);// set "obj2" for use in our string params
                     s0 = s0 + '{subj obj2}{the/he}. ';// this should return the correct object name "the maid's outfit"
                     say(s0); 
                }
                exit;
              }              
              // at this point we'll just try dropping what we have...
              foreach(obj in myList){
                     if(obj.name != nil) "<b>drop <<obj.name>>:</b> ";
                     newActorAction(gActor,Drop,obj);
                     "<.p>";
              }         
        }
        action(){ }
  }
  dobjFor(Doff) remapTo(Remove,self)
  dobjFor(Remove){
        verify(){ }
        check(){ 
              local myList = new List();// see list.t
              myList = self.getVisibleIndividuals(gActor.visibleInfoTable());
              // if no objects
              if(myList.length == 0){ 
                 "You don\'t see that here.\n "; 
                 exit;
              }              
              // is gActor NOT wearing the outfit already
              local iTally = 0;
              foreach(obj in myList){ if(obj.wornBy == gActor) iTally++; }
              if(iTally == 0){
                // report back only if player & exit either way
                if(gActor == gPlayerChar){
                     local s0 = 'How can you? You are not even wearing ';
                     local obj2 = self;
                     gMessageParams(obj2);// set "obj2" for use in our string params
                     s0 = s0 + '{subj obj2}{the/he}. ';// this should return the correct object name "the maid's outfit"
                     say(s0); 
                }
                exit;
              } 
              // else... let's try removing what we have
              // let's first sort in a logical remove order...
              myList = self.sortCromexxClothingRemoveOrder(myList);
              foreach(obj in myList){
                     if(obj.name != nil) "<b>remove <<obj.name>>:</b> ";
                     newActorAction(gActor,Remove,obj);
                     "<.p>";
              }     
              exit; 
        }
        action(){ }
  }
  dobjFor(Wear){
        verify(){ }
        check(){ 
              local myList = new List();// see list.t
              myList = self.getVisibleIndividuals(gActor.visibleInfoTable());
              // if no objects
              if(myList.length == 0){ 
                 "You don\'t see that here.\n "; 
                 exit;
              }              
              // is gActor wearing the FULL outfit already? (note - we tally off the full list)
              if(self.myCromOutfitList == nil) exit;
              local iCompp = self.myCromOutfitList.length;
              if(iCompp==0) exit;
              local iTallyy=0;         
              foreach(local obj in self.myCromOutfitList){ 
                 if(obj.isWornBy(gActor)) iTallyy++;
              }
              if(iTallyy == iCompp){
                  if(gActor==gPlayerChar){                     
                     local oobj2 = self;
                     gMessageParams(oobj2);// set "obj2" for use in our string params
                     local s9 = 'You are already wearing {subj oobj2}{the/he}. ';
                     say(s9);
                  }
                  exit;
              }             
              //local iTally = 0;
              //foreach(obj in myList){ if(obj.isWornBy(gActor)) iTally++; }
              //if(iTally == myList.length){
              //  // report back only if player & exit either way
              //  if(gActor == gPlayerChar){
              //       local s0 = 'You are already wearing ';
              //       local obj2 = self;
              //       gMessageParams(obj2);// set "obj2" for use in our string params
              //       s0 = s0 + '{subj obj2}{the/he}. ';// this should return the correct object name "the maid's outfit"
              //       say(s0); 
              //  }
              //  exit;
              //} 
              // not wearing it or not wearing all of it...
              // ...is someone else wearing the outfit already??
              local iTally = 0;
              local myFullList = self.myCromOutfitList;              
              if(myFullList.length > 0){
                 foreach(obj in myFullList){
                    if((obj.wornBy != nil) && (!obj.isWornBy(gActor))) iTally++;
                 }   
              }
              // completely worn by someone else (may be more than 1 other person too)
              if(iTally == self.myCromOutfitList.length){
                     local s4 = 'Someone else is wearing ';
                     local obj3 = self;
                     gMessageParams(obj3);// set "obj2" for use in our string params
                     s4 = s4 + '{subj obj3}{the/he}. ';// this should return the correct object name "the maid's outfit"
                     say(s4); 
                     exit;     
              }
              // ...if we are wearing any other clothes we must remove them first
              local myWornList = new List();
              foreach(local obj in gActor.contents){
                    if(obj.isWornBy(gActor)) myWornList += obj;
              }
              // set a flag so later we can see if we screwed up and are naked
              local iHadClothes = (myWornList.length > 0);
              if(iHadClothes){
                 // if(gActor==gPlayerChar) "(first removing what you are wearing...)\n ";// ** don't need it with "tryImplicitAction" below
                 myWornList = self.sortCromexxClothingRemoveOrder(myWornList);
                 foreach(obj in myWornList){
                     tryImplicitAction(Remove,obj);// with this you don't need the extra reporting lines
                     //if(obj.name != nil) "<b>remove <<obj.name>>:</b> ";// ** tryImplicitAction was better!
                     // newActorAction(gActor,Remove,obj);// ** tryImplicitAction was better!
                     //"<.p>";                     
                 }
              }
              // not wearing it or not wearing all of it so try what we can see...
              // first let's sort to a logical wear order...
              myList = self.sortCromexxClothingWearOrder(myList);//sortCromexxClothingRemoveOrder(lst)
              foreach(obj in myList){
                     tryImplicitAction(Wear,obj);
                     //if(obj.name != nil) "<b>wear <<obj.name>>:</b> ";// ** tryImplicitAction was better!
                     //newActorAction(gActor,Wear,obj);// ** tryImplicitAction was better!                     
                     //"<.p>";// ** tryImplicitAction was better!
              }  
              // now let's see if we're naked (this could happen if someone else was wearing the outfit)
              myWornList = [];// reset worn list to rebuild it...
              foreach(local obj in gActor.contents){
                    if(obj.isWornBy(gActor)) myWornList += obj;
              }
              if((myWornList.length == 0) && (iHadClothes)){ 
                    "\nWell I don\'t know what you\'ve done wrong but now you\'re buck naked. ";
                    exit;
              } 
              // do we now have the full outfit on the gActor? if so report it
              if(self.myCromOutfitList == nil) exit;
              local iComp = self.myCromOutfitList.length;
              if(iComp==0) exit;
              iTally=0;         
              foreach(local obj in self.myCromOutfitList){ 
                 if(obj.isWornBy(gActor)) iTally++;
              }
              if(iTally == iComp){
                  if(gActor==gPlayerChar){                     
                     local oobj2 = self;
                     gMessageParams(oobj2);// set "obj2" for use in our string params
                     local s9 = 'You are now wearing {subj oobj2}{the/he}. ';
                     say(s9);
                  }
                  exit;
              }
              if(iTally < iComp){
                 if(gActor==gPlayerChar){                     
                     local oobj2 = self;
                     gMessageParams(oobj2);// set "obj2" for use in our string params
                     local s9 = 'Well, you\'re wearing what you could anyway of {subj oobj2}{the/he}. ';
                     say(s9);
                  }
                  exit;
              }
              exit;          
        }
        action() { } 
  }
  dobjFor(Take){
        verify(){ }
        check(){ 
            local myList = new List();// see list.t
            myList = self.getVisibleIndividuals(gActor.visibleInfoTable());
            // if no objects of the collective group are at the gActor's location this may fail...            
            if(myList.length==0){
                 "You don\'t see that here.\n ";// probably in a dark room if the objects are there
                 exit;
            } 
            if(myList.length < self.myCromOutfitList.length){
                 // we'll try and wear what we can...
                 "Some items from that outfit are not here but we\'ll try and take what we can...\n ";
                 foreach(obj in myList){
                     if(obj.name != nil) "<b>take <<obj.name>>:</b> ";
                     newActorAction(gActor,Take,obj);// nestedActorAction(gActor,Remove,obj);
                     // nestedActorAction(gActor,Take,obj);
                     "<.p>";
                 }
            }  
            // outfit items are all here
            // is gActor holding them already
            local iTally = 0;
            foreach(obj in myList){ if(obj.isIn(gActor)) iTally++; }
            if(iTally == myList.length){
                // report back only if player & exit either way
                if(gActor == gPlayerChar) "You already have it. ";
                exit;
            }            
            foreach(obj in myList){
                     if(obj.name != nil) "<b>take <<obj.name>>:</b> ";
                     newActorAction(gActor,Take,obj);
                     "<.p>";
            }
            exit;            
        }
        action(){ }
  }
  dobjFor(Examine){
        verify(){ }
        check() { 
              if(gActor != gPlayerChar) exit; // only players should be able to call up this list...
              local myList = new List();   
              /* This builds the list of our collective group's 
               * visible objects in gActor's location           
               */
              myList = self.getVisibleIndividuals(gActor.visibleInfoTable());
              // Note: normally "Examine" will fail if no objects of
              // the collective group are at the gActor's location
              // so the following code may never execute...
              if(myList.length == 0){
                  "You see no outfit here. \n";
                   exit;    
              }
              if(myList.length < self.myCromOutfitList.length){
                  "Well, the full outfit isn\'t even here. Though you do see ";                   
                   // *** manual way without using "Lister" class in List.t  ***
                   local oWho = '';                   
                   local s0 = '';// main string
                   local s1 = '';// worn or held or on the ground
                   local iCount=0;
                   local obj2 = nil; // for gMessageParams...
                   foreach(obj in myList){
                       s0 = '';
                       gMessageParams(obj);// set "obj" for use in our string params
                       s0 = s0 + '{subj obj}{a/he}';// this should return the correct object name in a list, including plural or "a"/"the" before it (otherwise use obj.name)            
                       /*
                        * This next routine is really cool. It will display
                        * "in the oaken dresser" or "on the ground", etc. 
                        * as a default drop description.
                        * 
                        * If we used "obj2 = obj.location.getDropDestination(obj.location,nil)"
                        * then it would return "(in the roadside)" for an object within, say,
                        * an oaken dresser. But if we use:
                        *    obj2 = obj.location.getNominalDropDestination  
                        * ... this gives us an accurate description of where this object is at.
                        */
                       if(obj.location.getNominalDropDestination != nil){
                                  obj2 = obj.location.getNominalDropDestination;  
                                  gMessageParams(obj,obj2);// set "obj2" for use in our string params
                                  s1 = ' ({subj obj2}{on}';// returns "on the ground" !!! works!!!
                                  // Old way is --> s1 = ' (on the ' + obj.location.getNominalDropDestination.name; 
                       }                       
                       /*
                        *  If we are a CromexxHuman we will 
                        *  over-write the above drop description with something else.
                        *  Otherwise the default will report "(in you)" or "(in Tiffany)"
                        *  and that doesn't seem to read as nice as "worn by" or "held by"...
                        */
                       if(obj.location.ofKind(CromexxHuman)){
                          oWho = (obj.location == gPlayerChar) ? 'you' : (obj.location.name);
                          s1 = ' (held by ';
                          // if(obj.isWornBy(obj.location)) s1 = ' (worn by ';
                          if(obj.wornBy != nil){
                             s1 = ' (worn by ';
                          }
                          s1 = s1 + oWho;                          
                       }
                       s1 = s1 + ')';
                       iCount++;                       
                       if(myList.length == iCount) s1 = s1 + '. ';
                       if((myList.length > 1) &&
                          (iCount < myList.length)){
                          if(iCount == (myList.length-1)){
                               s1 = s1 + ' and ';
                          }else{
                               s1 = s1 + ', ';
                          }
                       }
                       say(s0 + s1);                         
                   }
                  exit;                  
              }// end if(myList.length < self.myCromOutfitList.length)...
              //** if our list is full we made it this far and can go right to "action()"...
        }
        action(){ inherited; }
  }
;





/* *** A FOOTNOTE OBJECT! 
 * Use in a string of text like so:  " <<myMMMFootnoteClothesError.noteRef>> ";
 */
myMMMFootnoteClothesError: Footnote "Ah the limitations of the parser. Well friend,
                  it may be that there really are clothes here after all even if
                  it is not obvious. That doesn\'t mean there are clothes or that there
                  are clothes for which you can take, remove, wear or drop, it just
                  means that in such a vague reference it is likely that I do not
                  understand what you are trying to do. Clothing collection 
                  references are rather vague sometimes and I need more exact details 
                  on which clothing items you wish to take, remove, wear, or drop. 
                  I can not easily determine what you mean by referring to \"clothes\"
                  in the context of the clothes you have on you, which is
                  going to always be the default if no clothes are found
                  in a room or no clothes are found logically matching the command. ";


/* 
 * See file: this CollectiveGroup type object 
 * handles bulk clothing routines like: "get clothes", 
 *   "examine clothes", "drop clothes", "wear clothes
 * To use simply add an object onto your Actor/CromexxHuman class object
 * like so:    + tifClothes: ClothingWornGroup; 
 *
 * It may be possible to use this class for piles of clothes
 * on the floor or laundry piles, etc. Or clothes in a clothes
 * drawer. However it would be best if this class were extended
 * for that and the "clothes" collection moved to nil after 
 * a "get clothes" command was issued by the player. Or else
 * tag along the clothing collective group somehow, for example
 * a school girl's uniform could be a collective group consisting
 * of shoes, socks, skirt, and sailor girl's top and cap. Then
 * the properName could be "sailor girl outfit" and if you wear it,
 * you wear the whole deal. Same with removal. 
 */
class ClothingWornGroup: CollectiveGroup, SecretFixture 'clothing/clothes/outfit' 'clothes'
   "*** nothing should ever be seen here *** "
  properName = self.name
  isProperName = true
  isPlural = true  
  disambigName {
                  local tempName = 'the' + ((self.name != nil) ? self.name : 'body part');
                  if(self.name == nil) return tempName;
                  if(self.location == nil) return tempName;                
                  if(self.location.name == nil) return tempName;                    
                  if(self.myOwnerPosessiveName == '') return tempName;
                  if(self.location.ofKind(Person) != true) return tempName;
                  return (self.myOwnerPosessiveName + ' ' + self.name);
  }
  // Example: returns Tiffany's or else 'the' if no owner
  myOwnerPosessiveName {
                  local oS = '\'s';
                  if(self.name == nil) return '';
                  if(self.location == nil) return '';
                  if(self.location.name == nil) return '';
                  if(self.location.ofKind(Person) != true) return '';
                  if(self.location.name.endsWith('s')) oS = '\'';                     
                  if(self.location == gPlayerChar) return 'your';
                  local myOwner = (self.location.name + oS);
                  return myOwner;
  }
  // "you are" or "Tiffany is"
  myOwnerPosessiveYourIsName {
                  //local oS = '\'s';
                  if(self.name == nil) return '';
                  if(self.location == nil) return '';
                  if(self.location.name == nil) return '';
                  if(self.location.ofKind(Person) != true) return '';
                  //if(self.location.name.endsWith('s')) oS = '\'';                     
                  if(self.location == gPlayerChar) return 'you are';
                  local myOwner = (self.location.name + ' is');// + ' ' + self.name
                  return myOwner;
   }
   dobjFor(Take){              
            verify(){ 
                      if(self.location==nil) dangerous;
                      // can't or shouldn't take what we may already have
                      if((gActor == gPlayerChar) && (self.location == gPlayerChar)) nonObvious;
                      if(self.location.ofKind(CromexxHuman)){          
                          if(self.location.nudeCheck==1){
                              nonObvious;                               
                          }else{
                              if(self.location == gPlayerChar) logicalRank(150,'very likely'); 
                          }                                                                                    
                      }
                      if((self.location.ofKind(Room)) || 
                         (self.location.ofKind(OutdoorRoom)))
                           logicalRank(75,'somewhat less logical'); 
                      if((self.location != gActor) && 
                         (self.location.ofKind(CromexxHuman)) &&
                         (self.location != gPlayerChar)
                         ){
                          if(self.location.nudeCheck != 1){
                               illogical('You probably shouldn\'t go around trying
                                  to take other people\'s clothes off them without their
                                  permission. ');
                          }else{
                               local myObj = self.location.name;  
                               local s1 = '\^' + myObj + ' is nude. ';
                               illogical(s1);
                          }
                      } 
                      // our "nonObvious" check above will catch this before it happens
                      // and select another actor's clothing collection instead BUT...
                      // ...if you are in a room by yourself then the stuff below is triggered.
                      if((gActor == gPlayerChar) && (self.location == gPlayerChar)){                     
                             if(self.location.nudeCheck == 1){
                                  illogicalSelf('I do not see any clothes to take. For that matter I don\'t
                                     even see any on you. ' + 
                                     myMMMFootnoteClothesError.noteRef); 
                             }else{
                                   illogicalSelf('I do not see any clothes to take. ' + 
                                     myMMMFootnoteClothesError.noteRef); 
                             }
                     }
            }
            check(){
                  local myList = self.getClothingList();  
                  local s0 = 'You are carrying no clothes to...um... take. That probably sounds illogical but maybe so was the action. ';
                  local myObj = self.location.name;  
                  local s1 = '\^' + myObj + ' has none. ';                  
                  if(self.areClothesHere(myList,s0,s1)!= true) exit;                  
            }
            action(){
                  local myList = self.getClothingList();
                  foreach(local obj in myList){
                     if(obj.name != nil) "<b>take <<obj.name>>:</b> ";
                     newActorAction(gActor,Take,obj);
                     "<.p>";
                  }                  
            }
   }
   dobjFor(Wear){
           verify(){
                      if(self.location==nil) dangerous;
                      if(self.location.ofKind(CromexxHuman)){
                          logicalRank(30,'unlikely match');
                      }
                      if(self.location == gPlayerChar)
                           logicalRank(150,'very likely');
                      if((self.location.ofKind(Room)) || 
                         (self.location.ofKind(OutdoorRoom)))
                           logicalRank(75,'somewhat less logical'); 
                      if((self.location != gActor) && 
                         (self.location.ofKind(CromexxHuman)) &&
                         (self.location != gPlayerChar)
                         ){
                          if(self.location.nudeCheck != 1){
                               illogical('You probably shouldn\'t go around trying
                                  to wear other people\'s clothes without their
                                  permission. ');
                          }else{
                               local myObj = self.location.name;  
                               local s1 = '\^' + myObj + ' is nude. ';
                               illogical(s1);
                          }
                      }    
           }
           check(){
                 local myList = self.getClothingHeldList();  
                 //local myList = getClothingList();// we'll just consider all worn & unworn clothes for this
                 local s0 = 'You are have no clothes in your hands for wearing. '; 
                 // local myObj = self.location.name;                   
                 local s1 = '\^' + self.myOwnerPosessiveYourIsName + ' holding no clothes for wearing. ';
                 if(self.areClothesHere(myList,s0,s1)!= true) exit;                   
                 // do we have any clothes                 
           }
           action(){
                 local myList = self.getClothingHeldList();                
                 foreach(local obj in myList){                    
                     if(obj.name != nil) "<b>wear <<obj.name>>:</b> ";
                     // nestedActorAction(gActor,Remove,obj);
                     newActorAction(gActor,Wear,obj);// "newActorAction" displays back text for "Remove", "nested" doesn't
                     "<.p>";
                 }                       
            }  
   }
   dobjFor(Remove){
           verify(){ 
                      if(self.location==nil) dangerous;
                      if(self.location == gPlayerChar)
                           logicalRank(150,'very likely');
                      if(self.location.ofKind(CromexxHuman)){
                          logicalRank(75,'likely match');
                      }
                      if((self.location.ofKind(Room)) || 
                         (self.location.ofKind(OutdoorRoom)))
                           logicalRank(30,'somewhat less logical'); 
                      if((self.location != gActor) && 
                         (self.location.ofKind(CromexxHuman)) &&
                         (self.location != gPlayerChar)
                         ){
                          illogical('You probably shouldn\'t go around trying
                                  to remove other people\'s clothes without their
                                  permission. ');
                      }                   
            }
            check(){ 
                 local myList = self.getClothingWornList();  
                 local s0 = 'You have no clothes on you for removing. ';
                 local myObj = self.location.name;  
                 local s1 = '\^' + myObj + ' has no clothes handy for removing. ';
                 if(self.areClothesHere(myList,s0,s1)!= true) exit;                  
            }
            action(){
                 local myList = self.getClothingWornList();
                 foreach(local obj in myList){
                     if(obj.name != nil) "<b>remove <<obj.name>>:</b> ";
                     // nestedActorAction(gActor,Remove,obj);
                     newActorAction(gActor,Remove,obj);// "newActorAction" displays back text for "Remove", "nested" doesn't
                     "<.p>";
                 }      
            }      
   }   
   dobjFor(Drop){
            verify(){ 
                      if(self.location==nil) dangerous;
                      if(self.location == gPlayerChar)
                           logicalRank(150,'very likely');
                      if(self.location.ofKind(CromexxHuman)){
                          // are we naked?
                          if(self.location.nudeCheck == 1){
                                  illogical('\^' + self.myOwnerPosessiveYourIsName + ' already naked. ');
                          }
                          logicalRank(75,'likely match if not nude');
                      }
                      if((self.location.ofKind(Room)) || 
                         (self.location.ofKind(OutdoorRoom)))
                           logicalRank(30,'somewhat less logical');                      
                    
            }
            check(){ 
                 local myList = self.getClothingList();  
                 local s0 = 'You have no clothes on you for dropping. ';
                 local myObj = self.location.name;  
                 local s1 = '\^' + myObj + ' has no clothes. ';
                 if(self.areClothesHere(myList,s0,s1)!= true) exit;                  
            }
            action(){
                 local myList = self.getClothingList();
                 foreach(local obj in myList){
                     if(obj.name != nil) "<b>drop <<obj.name>>:</b> ";
                     newActorAction(gActor,Drop,obj);
                     "<.p>";
                 }      
            }      
   }   
   getClothingHeldList(){
           local vList = new List();
              if(self.location == nil) return nil;
              if(self.location.contents == nil) return nil;
              foreach(local obj in self.location.contents){
                    if((obj.ofKind(CromexxClothing)) &&
                       (obj.isWorn != true))
                       vList += obj;
              }
              return vList;   
   }
   getClothingWornList(){
              local vList = new List();
              if(self.location == nil) return nil;
              if(self.location.contents == nil) return nil;
              foreach(local obj in self.location.contents){
                    if((obj.ofKind(CromexxClothing)) &&
                       (obj.isWorn == true))
                       vList += obj;
              }
              return vList;
   }
   getClothingList(){
              local vList = new List();
              if(self.location == nil) return nil;
              if(self.location.contents == nil) return nil;
              foreach(local obj in self.location.contents){
                    if(obj.ofKind(CromexxClothing))
                       vList += obj;
              }
              return vList;
   }   
   areClothesHere(lst,errorself,errorthird){              
              // a simple pass or fail routine for use in the "check()" areas
              if((lst.length == 0) && (self.location == gPlayerChar)){
                    say(errorself);// "You are naked. " or "There are no clothes here for dropping";
                    return nil;
              }
              if((lst.length == 0) && (self.location != gPlayerChar)){
                    if(self.location.name == nil){ 
                        "I see no clothes here. ";
                        return nil;
                    }                    
                    if((self.location.ofKind(Room)) || (self.location.ofKind(OutdoorRoom))){
                          "I see no clothes here. ";
                    }else{                              
                         say(errorthird);// "\^<<myObj>> isn\'t wearing any clothes. ";
                    }
                    return nil;
             }
             return true;       
   }
   dobjFor(Examine){
            verify(){ 
                    if(self.location.ofKind(CromexxHuman) != true)
                          illogical('Please be more specific about 
                                     which clothing item you wish to examine. ');
            }
            check(){ 
                    local myList = self.getClothingList(); 
                    local s0 = 'You are naked. ';
                    local myObj = self.location.name;  
                    local s1 = '\^' + myObj + ' isn\'t wearing any clothes. ';
                    if(self.areClothesHere(myList,s0,s1)!= true) exit;                    
            }
            action(){
                    local myList = self.getClothingList();
                    local oWho = self.myOwnerPosessiveYourIsName;
                    local s0 = '\^' + oWho + ' wearing ';                   
                    say(s0);
                    local myWearingLister = new WearingLister();// see List.t     
                    /* 
                     *  WearingLister.showListAll(list,options,indent) where:
                     *
                     *  list = the List object you are passing to the routine for listing
                     *  options = ListContents (comma seperated), ListTall (semicolon seperated)
                     *  indent = only for ListLong (long lists), if 0 then no indentation
                     */               
                    myWearingLister.showListAll(myList,ListContents,0);
                    exit;
            }
   }   
;

class FemaleBodyPart: BodyPart
   name = 'body part'
   isPlural = nil
   // Example: returns Tiffany's or else 'the' if no owner
   myOwnerPosessiveName {
                  local oS = '\'s';
                  if(self.name == nil) return '';
                  if(self.location == nil) return '';
                  if(self.location.name == nil) return '';
                  if(self.location.ofKind(Person) != true) return '';
                  if(self.location.name.endsWith('s')) oS = '\'';                     
                  if(self.location == gPlayerChar) return 'your';
                  local myOwner = (self.location.name + oS);// + ' ' + self.name
                  return myOwner;
   }
   disambigName {
                  local tempName = 'the' + ((self.name != nil) ? self.name : 'body part');
                  if(self.name == nil) return tempName;
                  if(self.location == nil) return tempName;                
                  if(self.location.name == nil) return tempName;                    
                  if(self.myOwnerPosessiveName == '') return tempName;
                  if(self.location.ofKind(Person) != true) return tempName;
                  return (self.myOwnerPosessiveName + ' ' + self.name);
   }
   baseVocabwords = ''
   vocabWords = (self.femWords + 
                ((self.myOwnerPosessiveName == 'your') ? ' (your) ' : ' ') + 
                 self.baseVocabwords + 
                 (((self.myOwnerPosessiveName != '') && (self.myOwnerPosessiveName != 'your')) ? (self.myOwnerPosessiveName + '/') : '') + 
                 ((self.name != nil) ? self.name : ''))
   firstPersonDesc = (self.isPlural == true) ?
                     "You notice nothing unusual about your pair of pretty <<self.name>>. " : 
                     "You notice nothing unusual about your pretty <<self.name>>. "
   thirdPersonDesc = (self.isPlural == true) ? 
                     "Looks like an ordinary pair of pretty female <<self.name>>. " :
                     "Looks like an ordinary pretty female <<self.name>>. "
   desc = getFirstOrThird()  
   getFirstOrThird(){
           if(libGlobal.playerChar == self.location) return self.firstPersonDesc;
           return self.thirdPersonDesc;          
   }
;



/*
 * Note: The KEY to this is each BodyPart object MUST have
 * the "location" variable defined somehow. Otherwise
 * in some cases an "examine my skin" may return "you do not
 * seem to have such a thing." But if you put location = me,
 * then an appropriate description is handled. 
 * 
 * Also note: This is a "Decoration" type object so that
 * the "remove all" command does not list this object as 
 * an obvious thing for removal. It's a "Fixture" object
 * to show that it can not ever be removed, and lastly
 * it is a "Component" object to show that it is a part of
 * the Actor/Person where this BodyPart is located.
 */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
 + class: BodyPart                 +
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
class BodyPart: Decoration, Component, Fixture, Thing
// Another Tads game used just "Component" class for things like this
// class BodyPart: Component
  name = 'body part'
  properName = self.name
  isProperName = true
  // Example: returns Tiffany's or else '' if no owner or 'your' if you are the owner
  myOwnerPosessiveName {
                  local oS = '\'s';
                  if(self.name == nil) return '';
                  if(self.location == nil) return '';
                  if(self.location.name == nil) return '';
                  if(self.location.ofKind(Person) != true) return '';
                  if(self.location.name.endsWith('s')) oS = '\'';                     
                  if(self.location == gPlayerChar) return 'your';
                  local myOwner = (self.location.name + oS);// + ' ' + self.name
                  return myOwner;
  }
  disambigName {
                  local tempName = 'the' + ((self.name != nil) ? self.name : 'body part');
                  if(self.name == nil) return tempName;
                  if(self.location == nil) return tempName;                
                  if(self.location.name == nil) return tempName;                    
                  if(self.myOwnerPosessiveName == '') return tempName;
                  if(self.location.ofKind(Person) != true) return tempName;
                  return (self.myOwnerPosessiveName + ' ' + self.name);
  }
  baseVocabwords = ''
  vocabWords =  (((self.myOwnerPosessiveName == 'your') ? ' (your) ' : '') + 
                self.baseVocabwords + 
                (((self.myOwnerPosessiveName != '') && (self.myOwnerPosessiveName != 'your')) ? (self.myOwnerPosessiveName + '/') : '') + 
                ((self.name != nil) ? self.name : ''))
  isBodyPart = true  
  isIt = true
  bulk = 0 // very important that this takes up no space...
  firstPersonDesc = "You see nothing unusual about your body part. "
  thirdPersonDesc = "You see nothing unusual about it. "  
  femWords = '(incredible) (incredibly) (amazing) (female) (girl) (girl\'s) (woman) (woman\'s) (slim)
              (thin) (shapely) (goddess) (godess) (soft) (pretty) (smooth) (milky) 
              (white) (caucasian) (pale) (nice) (hairless) (sexy) (beautiful) (lovely)
              (loveable) (lovable) (gorgeous) (hairless) (adult) (mature) (young)' 
  isBodyPartOf(obj) {
                if(obj != nil){
                   if((obj.ofKind(CromexxHuman)) || (obj == gActor)){
                      if(obj.contents.length == 0) return nil;
                      if(obj.contents.indexOf(self) == nil) return nil;
                      if(obj.contents.indexOf(self) > 0) return true;  // Ex: me.contents.indexOf(defaultHips)                       
                   }
                }
                return nil;                      
  }  
  getFirstOrThird(){
           if(libGlobal.playerChar == self.location) return self.firstPersonDesc;
           return self.thirdPersonDesc;          
  }
  desc = getFirstOrThird()  
  no_drop = true // true if no drop item
  no_drop_message = "You can not drop that. "
  is_not_removable = true
  is_not_removable_message = "You can not remove that. "
  /*
   *  An old routine we made up to do our own PoV 
   *  checking and reporting.
   *
   *  Basically you build 5 string values of
   *  differing perspectives s1-s5, and send that
   *  along with your PoV actor objects to this
   *  routine and a report is generated based on
   *  the current PoV observation.
   *
   *  oPlayerPoV = player character
   *  oSenderPoV = sender actor of the action
   *  oReceiverPoV = receiver actor of the action
   *
   *  s1 = self action where the player is the sender and the receiver
   *  s2 = self action where an NPC is the sender and the receiver and being observed by the player
   *  s3 = non-self action where player is the sender and taking action on NPC who is the receiver
   *  s4 = non-self action where sender and receiver are two NPCs being observed taking action on each other by the player
   *  s5 = non-self action where NPC is the sender and taking action upon the player who is the receiver
   */
  saySomethingPoV(oPlayerPoV,oSenderPoV,oReceiverPoV,s1,s2,s3,s4,s5){
           /* if player is not even here then exit */
           if(oPlayerPoV.location != oReceiverPoV.location) exit;  
           /* if anything is nil then exit */
           if((oPlayerPoV == nil) || (oSenderPoV==nil) || (oReceiverPoV==nil) || 
              (s1==nil) || (s2==nil) || (s3==nil) || (s4==nil) || (s5==nil)) exit;
           /* self stimulus */
           if(oSenderPoV == oReceiverPoV){
              /* self stimulus from player PoV */
              if(oSenderPoV == oPlayerPoV) say(s1);
              /* self stimuls from NPC PoV */
              if(oSenderPoV != oPlayerPoV) say(s2);
          }else{
              /* else non-self stimulus */
              /* ...player rubbing NPC */
              if(oSenderPoV == oPlayerPoV) say(s3);
              /* ...NPC is rubbing another NPC */
              if((oSenderPoV != oPlayerPoV) && (oReceiverPoV != oPlayerPoV)) say(s4);
              /* ...NPC is rubbing the PC */
              if((oSenderPoV != oPlayerPoV) && (oReceiverPoV==oPlayerPoV)) say(s5);
          }
  }   
  dobjFor(Remove){      
       verify(){  
            // not a very obvious command at all
            nonObvious;
            if((self.location == libGlobal.playerChar) && 
               (libGlobal.curIssuingActor == libGlobal.playerChar)){
                    illogical('You can not remove what is a part of you. '); 
            }else{
                    local s0 = self.isPlural ? 'those' : 'that';
                    illogical('You can not remove ' + s0 + '.');
            }              
       }  
            
  }
  dobjFor(Doff) asDobjFor(Remove)
  dobjFor(Drop) asDobjFor(Remove) 
  dobjFor(Examine){
              preCond = [objVisible] 
              verify(){                 
                 logicalRank(50,'fairly likely to be examined but female body parts have higher ranking');
                 inherited;
              }
              check(){ inherited; 
                    gActor.setPronounObj(self);
              }
              action(){ inherited; }
  }  
  dobjFor(Rub){
              preCond = [touchObj]
              verify(){
                 if(gIssuingActor.is_A_Little_Girl==true){
                      if(self.location == gIssuingActor){
                             illogical('Unless you were taking a bath or something you probably
                             do not need to do that. In fact, rubbing body parts
                             seems like maybe a grown up thing to do. So maybe try that 
                             again when you\'re older. ');
                      }else{
                             illogical('Um... Sorry. Hands off, little one. ');
                      }
                 }
                 local s0 = 'I am going to take a wild guess here that you are trying
                             to rub body parts in order to stimulate sex. You do not
                             need to do that. To make this easy I will prompt you with 
                             options during sex. To begin sex just try the command 
                             \"have sex with\" and the name of who you have in mind. ';
                 if(gameMain.is_a_little_girl){
                    s0 = 'You feel nothing out of the ordinary. ';
                 }
                 illogicalNow(s0);
              }
  }
  dobjFor(Feel){
              preCond = [touchObj]
              verify(){
                 if(gIssuingActor.is_A_Little_Girl==true){
                      if(self.location == gIssuingActor){
                             illogical('Unless you were taking a bath or something you probably
                             do not need to do that. In fact, feeling body parts
                             seems like maybe a grown up thing to do. So maybe try that 
                             again when you\'re older. ');
                      }else{
                             illogical('Um... Sorry. Hands off, little one. ');
                      }
                 }
                 local s0 = 'I am going to take a wild guess here that you are trying
                             to feel body parts in order to stimulate sex. You do not
                             need to do that. To make this easy I will prompt you with 
                             options during sex. To begin sex just try the command 
                             \"have sex with\" and the name of who you have in mind. ';
                 if(gameMain.is_a_little_girl){
                    s0 = 'You feel nothing out of the ordinary. ';
                 }
                 illogicalNow(s0);
              }
  }  
  dobjFor(Taste){
              preCond = [touchObj]
              verify(){
                 if(gIssuingActor.is_A_Little_Girl==true){
                      if(self.location == gIssuingActor){
                             illogical('That\'s not for tasting. Even if you\'re the little
                             daughter of the Oonga Oonga tribe of cannibals I doubt your
                             parents would approve of inbetween meal snacks of this kind.
                             Also if you really want to lose weight you should probably just
                             go on a diet instead of eating yourself to death. ');
                      }else{
                             illogical('Um... Sorry. Hands off you little cannibal you. ');
                      }
                 }
                 if(self.location == gIssuingActor){
                       illogical('You should probably just go on a diet instead of trying
                                  to eat yourself to death. ');
                 }else{
                       illogical('Sorry, no. For one thing you\'d probably need permission
                                  and for another I don\'t think you have your proper 
                                  cannibal-style knife and fork set with you. ');
                 }
              }
  }  
  dobjFor(Eat){
              preCond = [touchObj]
              verify(){
                 if(gIssuingActor.is_A_Little_Girl==true){
                      if(self.location == gIssuingActor){
                             illogical('That\'s not for eating. Even if you\'re the little
                             daughter of the Oonga Oonga tribe of cannibals I doubt your
                             parents would approve of inbetween meal snacks of this kind.
                             Also if you really want to lose weight you should probably just
                             go on a diet instead of eating yourself to death. ');
                      }else{
                             illogical('Um... Sorry. Hands off you little cannibal you. ');
                      }
                 }
                 if(self.location == gIssuingActor){
                       illogical('You should probably just go on a diet instead of trying
                                  to eat yourself to death. ');
                 }else{
                       illogical('Sorry, no. For one thing you\'d probably need permission
                                  and for another I don\'t think you have your proper 
                                  cannibal-style knife and fork set with you. ');
                 }
              }
  } 
  dobjFor(Burn){
              preCond = [touchObj]
              verify(){
                 if(gIssuingActor.is_A_Little_Girl==true){
                      if(self.location == gIssuingActor){
                             illogical('Sorry, no. Little girls should not try setting their 
                             bodies on fire. If your parents found out what you were up to 
                             you\'d probably be grounded until you\'re an old maid. ');
                      }else{
                             illogical('Sorry honey but it isn\'t nice for little girls to
                             go around trying to set other people\'s body parts on fire. ');
                      }
                 }
                 if(self.location == gIssuingActor){
                       illogical('I don\'t think so. Call me stupid but what would setting 
                             yourself on fire really accomplish anyway? ');
                 }else{
                       illogical('Are you on a witch hunt or something? You just can\'t go around
                             trying to set other people\'s body parts on fire. ');
                 }
              }
  } 
 dobjFor(Clean){
              preCond = [touchObj]
              verify(){
                 if(gIssuingActor.is_A_Little_Girl==true){
                      if(self.location == gIssuingActor){
                             illogical('That\'s not important right now. You may have to wait until 
                             bath time. ');
                      }else{
                             illogical('You should let other people take care cleaning themselves. ');
                      }
                 }
                 if(self.location == gIssuingActor){
                       illogical('That is not especially important right now. ');
                 }else{
                       illogical('You should let other people take care of cleaning themselves. ');
                 }
              }
  } 
  dobjFor(Kiss){
              preCond = [touchObj]
              verify(){
                 if(gIssuingActor.is_A_Little_Girl==true){
                      if(self.location == gIssuingActor){
                             illogical('As your spirit guardian I\'m just not going to 
                             allow it. Little girls should practice kissing their dollies, not 
                             themselves. ');
                      }else{
                             illogical('I realize as a little girl you may feel like giving
                             everyone kisses but specifying a body part isn\'t really necessary.
                             If you\'d like to kiss someone anyway, just try \"kiss\" and the person\'s 
                             name of who you\'d like to kiss. ');
                      }
                 }
                 if(self.location == gIssuingActor){
                       illogical('I know you are probably deeply in love with yourself at this point
                             or you wouldn\'t try something like that but it\'s really more appropriate
                             and useful to kiss somebody else instead. ');
                 }else{
                       illogical('Sorry. No. I\'ll give you credit for trying though but really now,
                             as your spirit guide I feel I owe it to you to explain a few things here
                             so you are not wasting your time issuing unlikely handled commands. 
                             If you are trying to kiss somebody just try \"kiss\" and the person\'s
                             name of who you would like to kiss. If you are trying to go beyond that
                             and initiate foreplay of some kind it\'s going to be rather simple. I will
                             prompt you with options during sex and you get to select them from a list.
                             If you wish to have sex with someone you just try \"have sex with\" and
                             the name of the person you wish to have sex with and if the action is 
                             possible then I will prompt you through it. ');
                 }
              }
  } 
  dobjFor(HaveSexWith){
              preCond = [touchObj]
              verify(){
                 if(gIssuingActor.is_A_Little_Girl==true){
                      if(self.location == gIssuingActor){
                             illogical('My, my, my! Little girls shouldn\'t have such dirty thoughts! ');
                      }else{
                             illogical('Little girls shouldn\'t even be thinking of such things. ');
                      }
                 }
                 illogical('Sorry. No. I\'ll give you credit for trying though but really now,
                             as your spirit guide I feel I owe it to you to explain a few things here
                             so you are not wasting your time issuing unlikely handled commands. 
                             If you are trying to have sex with somebody just try \"have sex with\" and 
                             the person\'s name of who you would like to have sex with. If you are 
                             trying to go beyond that and initiate foreplay of some kind it\'s going 
                             to be rather simple. I will prompt you with options during sex and you 
                             get to select them from a list. ');
              }
  } 
  dobjFor(PlayWith){
              preCond = [touchObj]
              verify(){
                 if(gIssuingActor.is_A_Little_Girl==true){
                      if(self.location == gIssuingActor){
                             illogical('Little girls should be playing with dolls, not themselves. ');
                      }else{
                             illogical('Little girls shouldn\'t even be thinking of such things. ');
                      }
                 }
                 illogical('Sorry. No. I\'ll give you credit for trying though but really now,
                             as your spirit guide I feel I owe it to you to explain a few things here
                             so you are not wasting your time issuing unlikely handled commands. 
                             If you are trying to have sex with somebody just try \"have sex with\" and 
                             the person\'s name of who you would like to have sex with. If you are 
                             trying to go beyond that and initiate foreplay of some kind it\'s going 
                             to be rather simple. I will prompt you with options during sex and you 
                             get to select them from a list. ');
              }
  } 

; 
