#charset "utf-8"
#include <adv3.h>
#include <cs_cz.h>
//potřebuji také #include "SimpleAttachable.t" - zde ve zdrojovém souboru se ale includují jen soubory .h, toto přidávám ve WB nebo ručně uvedením v souboru MakeFile

/* Exoter, předělávka původní hry ze ZX Spectra do systému TADS. Vytvořil Luděk Šťastný s vydatnou pomocí autora báječné textové hry Základna na Asteroidu Gaspodou.*/

versionInfo: GameID
    IFID = '558c20af-6559-477a-9f98-b7b4274cd304'
    name = 'Exoter'
    byline = 'od Luďka Šťastného'
    htmlByline = 'od autora <a href="mailto:ludek.stastny@gmail.com">
                  Luděk Šťastný</a>'
    version = '1'
    authorEmail = 'Luděk Šťastný <ludek.stastny@gmail.com>'
    desc = 'Právě hrajete textovou hru Exoter, přesněji řečeno její co nejvěrnější předělávku ze skvělého počítače ZX Spectrum a jeho klonů.'
    htmlDesc = 'Právě hrajete textovou hru Exoter, přesněji řečeno její co nejvěrnější předělávku ze skvělého počítače ZX Spectrum a jeho klonů.'
;

// Každá definice objektu včetně versionInfo musí končit středníkem.

gameMain: GameMainDef
// Hráč je definován jako 'me'.
    initialPlayerChar = me
    showIntro()
    {
        "Vítejte v konverzační hře Exoter, přesněji řečeno v její co nejvěrnější předělávce ze skvělého počítače ZX Spectrum a Didaktik Gama.\b";
    }
    showGoodbye()
    {
        "<.p>Děkuji za hraní tého konverzační hry.\b";
    }
;

me: Actor
    pcDesc = "Jsi uvězněn v hradu Exoter. Tvým úkolem je dostat se co nejrychleji ven. "
    /* the initial location
       - ještě přidám mužský rod mé postavy*/
    location = kobka
    gender = 1
;

// definuji první místnost včetně popisu a východů z místnosti pro parser i hráče
kobka: Room 'Kobka' 'do kobky'
"Jsi v malé kamenné kobce. Je tu cítit mrtvolný zápach. Světlo sem proniká z jediného stropního otvoru, ve kterém je mříž. \bNemůžeš jít nikam. "
{
    north : NoTravelMessage {"Nemůžeš jít nikam!. "}
    east : NoTravelMessage {"Nemůžeš jít nikam!. "}
    south : NoTravelMessage {"Nemůžeš jít nikam!. "}
    west : NoTravelMessage {"Nemůžeš jít nikam!. "}
    up : TravelMessage 
    {  ->chodba
            "Vzniklým otvorem prolézáš nahoru ven z kobky. "
            canTravelerPass(traveler) {return mriz.isOpen; }
        explainTravelBarrier(traveler) { "Skrz mříž se neprotáhneš. "; } 
    } 
    down : NoTravelMessage {"Nemůžeš jít nikam!. "}
}

// definuji první objekt, se kterým lze manipulovat. Mříž lze přeříznot pilníkem, ale nikoliv otevřít a zavřít plus horní TravelMessage doplňuje text
+ mriz : PreferredDobj, IndirectLockable, Door 'mříž' 'mříž' *3
      "Železná mříž je Tvůj jediný způsob jak poznat, je-li venku den či noc. " 

      dobjFor(Open) { verify { illogical (cannotOpenMsg); } }
      dobjFor(Close) { verify { illogical(cannotCloseMsg); } }
      cannotOpenMsg = 'Mříž nedokážeš otevřít. '
      cannotCloseMsg = 'Mříž nedokážeš zavřít. '

// definuji předmět, kterým lze mříž přeříznout
      canBeCutBy = [pilnik]

// definuji akci, co s objektem mříž může hráč provádět, toto naleznu v TADS Library
// pomocí objektu Achievement a metody objektu awardPointsOnce() přidávám za úspěšně provedenou akci hráčí 1 bod skóre
	  dobjFor(CutWith)
		{
			verify()
				{
					if(isOpen) illogicalNow('Mříž už byla přepilována.' );
				}
		check()
				{
					if(canBeCutBy.indexOf(gIobj) == nil)
					failCheck('Mříž nemůžeš přeříznout {that iobj/him}. ');
				}
					action()
				{
					"Podařilo se Ti přepilovat mříž. "; 
                    achievement.awardPointsOnce();
					isOpen = true;
				}
		}

      achievement: Achievement { +1 "přepilování mříže" }

      gcName = 'mříže, mříži, mříž, mříži, mříží'
      gcVocab = 'mříže/mříži/mříž'
; 

+ mrtvola : RestrictedContainer, Heavy 'mrtvola' 'mrtvola' *3
 "Je v pokročilém stádiu rozkladu. "

     isListed = true
     gcName = 'mrtvoly, mrtvole, mrtvolu, mrtvole, mrtvolou'
     gcVocab = 'mrtvoly/mrtvole/mrtvolu'

// definuji akci koukni se do objektu,rozdílné od klasického prozkoumej
            dobjFor(LookIn)
	 {
		action()
		{
			if(pilnik.moved)
			{
				"Na mrtvole jsi neobjevil už nic zajímavého. ";
				exit
				;
			}
//				pilnik.moveInto(self);
				pilnik.discover();
            			"Bližší pohled na mrtvolu odhalil pilník schovaný v záhybech polorozpadlých šatů! ";
	  }
        }
;

// pilník ve výchozím stavu není vidět, až po kouknutí se do mrtvoly
++ pilnik : Hidden 'pilník' 'pilník' *2
       "Je šikovně upraven pro přepilování mříží. "

// velmi důležité definice přímého a nepřímého objektu - dobjFor a iobjFor. Zde lze pomocí pilníku přeříznout mříž.
	iobjFor(CutWith)
		{
			verify() { }
		}

       gcName = 'pilníku, pilníku, pilník, pilníku, pilníkem'
       gcVocab = 'pilníku/pilníkem/pilník'
;

// jednotlivé místnosti budu oddělovat tímto komentářem složeným ze znaků /

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

chodba: Room 'Chodba' 'do chodby'
    "Stojíš na kamenné dlažbě středověké chodby. Nízká klenba Ti rozhodně nedodává pocit jistoty. \bMůžeš jít na východ, na jih, dolů.
    \nNevidíš nic zvláštního. "
    east = chodba_s_pochodni
    south = chodba_se_zebrikem
    down = mrizInside
;

// průchozí mříž definuji stejně jako mříž z druhé strany
+ mrizInside : IndirectLockable, Door -> mriz 'mříž' 'mříž' *3

      dobjFor(Open) { verify { illogical (cannotOpenMsg); } }
      dobjFor(Close) { verify { illogical(cannotCloseMsg); } }
      cannotOpenMsg = 'Mříž nedokážeš otevřít. '
      cannotCloseMsg = 'Mříž nedokážeš zavřít. '

      gcName = 'mříže, mříži, mříž, mříži, mříží'
      gcVocab = 'mříže/mříži/mříž'
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

chodba_se_zebrikem: Room 'Chodba' 'do chodby'
    "Jsi v chodbě. Je tu žebřík vedoucí někam nahoru. \bMůžeš jít na sever, na jih, nahoru. "
    north = chodba
    south = chodba_se_zeleznymi_dvermi
    up = ve_vyklenku
;

// využívám objekt schodiště
+ zebrik: StairwayUp, CustomImmovable 'žebřík' 'žebřík' *2
    "Dřevěný žebřík vede kamsi nahoru. "

    cannotTakeMsg = 'Žebřík je příliš těžký na přenášení v úzkých chodbách. '
    cannotMoveMsg = 'Žebřík je příliš těžký na přenášení v úzkých chodbách. '
    cannotPutMsg = 'Pohnout se žebříkem opravdu nepůjde. '

    gcName = 'žebříku, žebříku, žebřík, žebříku, žebříkem'
    gcVocab = 'žebříku/žebříkem'
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

chodba_se_zeleznymi_dvermi: Room 'Chodba' 'do chodby'
     "Stojíš v chodbě. Na jihu jsou masivní železné dveře. \bMůžeš jít na sever. "
     north = chodba_se_zebrikem
     south = dvere_chodba_se_zeleznymi_dvermi
;

// definuji dveře, vždy je nutno popsat obě jejich strany, v tomto případě dvere_chodba_se_zeleznymi_dvermi a dvere_zatuchla_komurka 
+ dvere_chodba_se_zeleznymi_dvermi : LockableWithKey, Door 'dveře' 'dveře' *3
     "Masivní železné dveře. " 

     isPlural = true
     keyList = [svazek_klicu]

     gcName = 'dveří, dveřím, dveře, dveřích, dveřmi'
     gcVocab = 'dveří/dveřím/dveřích/dveřmi'
; 


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

zatuchla_komurka: Room 'Zatuchlá komůrka' 'do zatuchlé komůrky'
    "Nacházíš se v malé zatuchlé komůrce. Na severu jsou vidět masivní železné dveře. 
    \bMůžeš jít na sever. "
    north = dvere_zatuchla_komurka
;

// definice druhé strany dveří
+ dvere_zatuchla_komurka : LockableWithKey, Door -> dvere_chodba_se_zeleznymi_dvermi 'dveře' 'dveře' *3
     "Masivní železné dveře. " 

     isPlural = true
     keyList = [svazek_klicu]

     gcName = 'dveří, dveřím, dveře, dveřích, dveřmi'
     gcVocab = 'dveří/dveřím/dveřích/dveřmi'
;

+ prvni_drahokam : Thing 'první drahokam' 'první drahokam' *2
      "Je nádherný. "

      gcName = 'prvního drahokamu, prvnímu drahokamu, první drahokam, prvním drahokamu, prvním drahokamem'
      gcVocab = 'prvnímu prvním drahokamu/drahokamem*drahokamy'
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

ve_vyklenku: Room 'Ve výklenku' 'do výkenku'
    "Jsi v malé komůrce, ihned jsi si všimnul malého výklenku ve zdi. \bMůžeš jít dolů. "
    down = chodba_se_zebrikem
;

// na výklenek je možné si i stoupnout
+ maly_vyklenek : CustomFixture, Platform 'malý výklenek' 'malý výklenek' *2
    "I když je malý, není možné jej v menší místnosti přehlédnout. "

    cannotTakeMsg = 'Výklenek opravdu nelze vzít. '
    cannotMoveMsg = 'Výklenek opravdu nikam nepřeneseš. '
    cannotPutMsg = 'Pohnout s výklenkem asi nepůjde. '

// tyto vlastnosti definují jako předložky a pád použít např. při stoupnutí si na výklenek
    objInPrep = 'v'
    objIntoPrep = 'do'
    objIntoCase = 2
    objOutOfPrep = 'z'

    gcName = 'malého výklenku, malému výklenku, malý výklenek, malému výklenku, malým výklenkem'
    gcVocab = 'malému malým výklenku/výklenkem'
;

+ sekera : Thing 'sekera/sekerou/sekeru' 'sekera' *3
      "Je docela obyčejná. "

       gcName = 'sekeru, sekeře, sekeru, sekeře, sekerou'
       gcVocab = 'sekery/sekeře/sekeru'

// definice přímého objektu, kterým lze zaútočit nebo něco přeříznout
    	iobjFor(AttackWith)
    	{
        	verify() { }
    	}

	    iobjFor(CutWith)
		{
			verify() { }
		}
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

chodba_s_pochodni: Room 'Chodba' 'do chodby'
    "Jsi v chodbě. \bMůžeš jít na východ, na západ. "
    east = chodba_se_strazcem
    west = chodba
;

// objekt, který může hořet a vydávat světlo, v této hře je nutno dodržet přesnou hierarchii přímých a nepřímých objektů pochodeň, křesadlo a kupka sena, aby nevznikl problém se zapálení čeho/čím
+ pochoden : FireSource, Candle 'pochodeň/pochodně/pochodni/pochodní' 'pochodeň' *3
    desc()
    {
        if(isLit)
             "Příjemně praská a vydává hodně světla. ";
        else
            "Kdyby se Ti jí podařilo zapálit, jistě by vydávala hodně světla. ";
    }

// pochodeň v této hře nikdy nezhasne
    getFuelLevel() { return nil; }
    brightnessOn = 2
    
    iobjFor(BurnWith)
    {
        preCond = [objHeld, objBurning]
        verify()
        {
            /* don't allow using me to light myself */
            if (gDobj == self)
                illogicalNow(&cannotBurnDobjWithMsg);
            nonObvious;
         }
    }
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

chodba_se_strazcem: Room 'Chodba' 'do chodby'
    "Jsi v chodbě. <<if strazce.curState != strazceDeadState>>Vidíš strážce, naštěstí je k Tobě obrácen zády\b<<end>>\bMůžeš jít na východ, na západ. "

// bariéra, která hráče nepustí dále, dokud strážce nezemře
    east : TravelMessage
    		{  ->konec_chodby
           	"Opatrně procházíš kolem mrtvého strážce dál na východ . "
                canTravelerPass(traveler) {return strazce.curState == strazceDeadState; }
        		explainTravelBarrier(traveler) 
			{ "Strážce se na tebe se strašlivým řevem vrhl a celkem snadno ukončil tvůj život. "; finishGameMsg(ftDeath, [finishOptionUndo] );}
}
    west = chodba_s_pochodni
;

// definice první NPC postavy ve hře s využitím akcí
+ strazce: OutOfReach, UntakeableActor, RestrictedContainer 'stráž/strážce/strážný/strážného' 'strážce' *1
     
      gcName = 'strážce, strážci, strážce, strážci, strážcem'
      gcVocab = 'strážci/strážci/strážcem'

	allowAttack = true

    dobjFor(Attack)
    {
        check()
        {
            failCheck('Zaútočit na strážce holýma rukama není dobrý nápad. ');
        }
    }

    dobjFor(AttackWith)
    {
        check()
        {
            if (gIobj != sekera)
                failCheck('To bude chtít jinou zbraň. ');
        }
              
  		action()
        {
			 strazce.moveIntoForTravel(chodba_se_strazcem);

             "Jediným mocným úderem se ti podařilo poslat strážce do věčných lovišť. Přezka jeho opasku se při pádu uvolnila a na zem dopadly dva předměty, které už jistě potřebovat nebude. ";
             setCurState(strazceDeadState);
             kresadlo.moveInto(location); 
             svazek_klicu.moveInto(location); 
             achievement.awardPointsOnce();
// lze využít 	 moveIntoForTravel(nil); - v takovém případě zmizí z místnosti
        }
    }

achievement: Achievement { +1 "zabití strážce" }

canObjReachSelf(obj) { return curState != strazceDeadState; }
canObjReachContents(obj) { return curState != strazceDeadState; }
cannotReachFromOutsideMsg(dest) { return 'Nepřipadá Ti vhodné dotýkat se mrtvoly!'; }
;

// definice různéch stavů postavy strážce
++ strazceGuardState: HermitActorState
    noResponse = "Chystá se zabít tě. "
    stateDesc = "Chystá se zabít tě. "
    isInitState = true
;

++ strazceDeadState: HermitActorState
noResponse = "Je mrtvý a nic už neslyší. "
specialDesc = "Strážce leží mrtvý na podlaze. "
stateDesc = "Strážce je mrtvý. "
;

//  strazce.makePosture(sitting); - zajímavý příklad ze Základny, pokud potřebuji, aby si strážce sednul, viz. actorCommander.t

// křesadlo je preferovaný přímý objekt k zapálení něčeho, jen ne sebe sama
++ kresadlo: PreferredIobj, Thing 'křesadlo/křesadla/křesadlu/křesadlem' 'křesadlo' *4
    "Snad by se s ním dal rozdělat oheň. "
    iobjFor(BurnWith)
    {
        preCond = [objHeld]
        verify()
        {
            /* don't allow using me to light myself */
            if (gDobj == self)
                illogicalNow(&cannotBurnDobjWithMsg);
            nonObvious;
         }
    }

       gcName = 'křesadlo, křesadlu, křesadlo, křesadlu, křesadlem'
       gcVocab = 'křesadlu/křesadlem/křesadlo'
;

++ svazek_klicu : Key 'svazek svazkem/klíčů/klíče/klíči/' 'svazek' *2
     "Je to pět rezatých klíčů na provázku. "

     gcName = 'svazek klíčů, svazku klíčů, svazek klíčů, svazku klíčů, svazkem klíčů'
     gcVocab = 'svazku svazkem svazek klíčů/klíčů/klíčů'
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

konec_chodby: Room 'Konec chodby' 'do konce chodby'
    "Jsi na konci chodby. Vidíš dveře. \bMůžeš jít na východ, na západ. "
    east = dvere_konec_chodby
    west = chodba_se_strazcem
;

+ dvere_konec_chodby : LockableWithKey, Door 'dveře' 'dveře' *3
      "Dveře uzavírající tuto část chodby. " 

      isPlural = true
      keyList = [svazek_klicu]

      gcName = 'dveří, dveřím, dveře, dveřích, dveřmi'
      gcVocab = 'dveří/dveřím/dveřích/dveřmi'
; 

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

sz_nadvori: Room 'Severozápadní část nádvoří' 'do severozápadní části nádvoří'
    "Jsi na nádvoří. Na západě jsou dveře vedoucí do kamenné chodby. \bMůžeš jít na východ, na jih, na západ. "
    east = sv_nadvori
    south = jz_nadvori
    west = dvere_sz_nadvori
;

+ dvere_sz_nadvori : Lockable, Door -> dvere_konec_chodby 'dveře' 'dveře' *3
      "Dveře uzavírající tuto část chodby. " 

      isPlural = true
      keyList = [svazek_klicu]

      gcName = 'dveří, dveřím, dveře, dveřích, dveřmi'
      gcVocab = 'dveří/dveřím/dveřích/dveřmi'
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

jz_nadvori: Room 'Jihozápadní část nádvoří' 'do jihozápadní části nádvoří'
    "Stojíš na nádvoří. \bMůžeš jít na sever, na východ, na jih, dolů. "
    north = sz_nadvori
    east = jv_nadvori
    south = brana_do_hradu

// v akci se studní a s lanem využívám třídu SimpleAttachable, zde definice možnosti sešplhat do studny
    down : TravelMessage 
    		{  ->ve_studni
            	"Sešplhal jsi dolů za pomoci přivázaného lana. "
		  canTravelerPass(traveler) {return provaz.isAttachedTo(studna); } //zde musí být isAttachedTo
          explainTravelBarrier(traveler) 
			  { "Studna je moc hluboká na to, abys do ní skočil jen tak. "; }
    }
;

// pokud má hra přivázané lano nechat na místě, je nutno provaz místo Attachable definovat jako NearbyAttachable

+ studna : SimpleAttachable, Container, Heavy 'studna' 'studna' *3
    "Hluboká studna, nyní však již zcela vyschlá. "
	specialDesc = "Je tu stará kamenná studna. "

	canAttachTo(obj) {return obj == provaz;}
	handleAttach (other)
		{
			"Provaz jsi spustil dolů. ";
            achievement.awardPointsOnce();
		}

//	getNearbyAttachmentLocs(other)
//		{
//			return [location, self, 0];
//		}
    achievement: Achievement { +1 "přivázání lana ke studni" }
	minorAttachmentItems = [provaz]

	gcName = 'studny, studni, studnu, studni, studnou'
	gcVocab = 'studny/studni/studnu/studnou'
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

ve_studni: DarkRoom 'Ve studni' 'do studny'
    "Jsi na dně studny. Je tu vlhko. \bMůžeš jít nahoru. "
    up = jz_nadvori
;

+ druhy_drahokam : Thing 'druhý drahokam' 'druhý drahokam' *2
      "Je určitě hezčí, než první drahokam. "

      gcName = 'druhého drahokamu, druhému drahokamu, druhý drahokam, druhém drahokamu, druhým drahokamem'
      gcVocab = 'druhému druhým drahokamu/drahokamem*drahokamy'
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

brana_do_hradu: Room 'Brána do hradu' 'do hradní brány'
      "Stojíš u obrovské brány v jižním výběžku nádvoří. \bMůžeš jít na sever, na jih. "
      north = jz_nadvori
      south : TravelMessage
              {  ->vitezstvi
              "Procházíš branou na jih. "
                canTravelerPass(traveler) {return prvni_drahokam.isIn(traveler)&&druhy_drahokam.isIn(traveler)&&treti_drahokam.isIn(traveler)&&ctvrty_drahokam.isIn(traveler); }
        		explainTravelBarrier(traveler) { "Brána je zavřená. "; }
}
;

// hráč s branou nesmí nikterak manipulovat
+ brana : CustomImmovable 'brána' 'brána' *3
    "Je zašlá a zrezivělá, není na ní příjemný pohled. "

    cannotTakeMsg = 'Bránu opravdu nelze vzít. '
    cannotMoveMsg = 'Bránu opravdu nikam nepřeneseš. '
    cannotPutMsg = 'Pohnout s branou asi nepůjde. '
    cannotOpenMsg = 'Brána je zavřená, nevidíš žádnou možnost, jak jí otevřít. '

    gcName = 'brány, bráně, bránu, bráně, bránou'
    gcVocab = 'brány/bráně/bránu/bránou'
;

vitezstvi: Room 'Vítězství' 'Vítězství'
     
    	desc()
    		{
                 finishGameMsg('Díky všem čtyřem drahokamům unikáš z hradu. Gratuluji šťastnému vítězi.', [finishOptionFullScore]);

// ukončení hry bez zobrazení skóre - finishGameMsg('Díky všem čtyřem drahokamům unikáš z hradu. Gratuluji šťastnému vítězi.', []);
       	 	}
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

jv_nadvori: Room 'Jihovýchodní část nádvoří' 'do jihovýchodní části nádvoří'
    "Jsi v jihovýchodným rohu nádvoří. Jsou tu schody vedoucí do budovy, která je na východě. \bMůžeš jít na sever, na západ, nahoru. "
    north = sv_nadvori
    west = jz_nadvori
    up = knihovna
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

sv_nadvori: Room 'Severovýchodní část nádvoří' 'do severovýchodní části nádvoří'
    "Stojíš v tmavém koutě nádvoří. Na severu se do výšky několika metrů tyčí kamenná věž. \bMůžeš jít na jih, na západ. "
    south = jv_nadvori
    west = sz_nadvori
;

// preferovaný nepřímý objekt, který mohu zapálit křesadlem i hořící pochodní
+ kupka_sena : PreferredDobj, RestrictedContainer, Immovable 'kupka sena/seno' 'kupka sena/seno' *3
      "Je dobře proschlá, jistě by dobře hořela. "

      cannotTakeMsg = 'Kupku sena nedokážeš vzít. '
      cannotMoveMsg = 'Kupku sena opravdu nikam nepřeneseš. '
      cannotPutMsg = 'Pohnout se senem nepůjde, to by Tě příliš zdrželo. '
      isListed = true
      specialDesc = "Veliká hromada sena parádně voní. "
//    preferredIobj = pochoden

    dobjFor(BurnWith)
    {
        verify() {}
        check()
        {
            if (!pochoden.isIn(me)&&(!pochoden.isLit) || !kresadlo.isIn(me))
                    failCheck('Seno sám od sebe nezapálíš. ');
        }
        action()
        {
            "Zapálil jsi seno. Bylo tak dobře proschlé, že za několik sekund zbyla jen docela malá hromádka popela. A vida, objevila se pověstná jehla. ";
            kupka_sena.moveInto(nil);
            jehla.discover();
            achievement.awardPointsOnce();
         }
    }

            achievement: Achievement { +1 "zapálení kupky sena" }

      gcName = 'kupka sena, kupce sena, kupku sena, kupce sena, kupkou sena'
      gcVocab = 'kupce kupkou kupku sena/sena/sena'
;

+ jehla : Hidden 'jehla' 'jehla' *3
       "Je velmi ostrá. "

       gcName = 'jehly, jehle, jehlu, jehle, jehlou'
       gcVocab = 'jehly/jehle/jehlu/jehlou'
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

knihovna: Room 'Knihovna' 'do knihovny'
    "Jsi v místnosti, která vypadá jako knihovna po průjezdu parního válce. V západní části místnosti jsou schody vedoucí dolů na nádvoří. \bMůžeš jít na východ, dolů. "
    east = kruhova_mistnost
    down = jv_nadvori
;

+ ohorely_papir : Thing 'ohořelý papír' 'ohořelý papír' *2
      "Je na něm čitelných jen několik slov - ... a ven se dostane jen ten, kdo má čtyři magické diamanty... "

      gcName = 'ohořelého papíru, ohořelému papíru, ohořelý papír, ohořelém papíru, ohořelým papírem'
      gcVocab = 'ohořelému ohořelým papíru/papírem'
;

// preferovaný nepřímý objekt, lze jej rozbít sekerou a objeví se nové objekty kapalina a nepotřebné střepy
+ sklenena_koule : PreferredDobj, CustomImmovable 'skleněná koule/koule' 'skleněná koule/koule' *3
      "Koule je pevně upevněna v železné obruči. Je na ní lebka se skříženými drápy a uvnitř je nějaká kapalina. "

      cannotTakeMsg = 'Kouli nedokážeš vzít. '
      cannotMoveMsg = 'Kouli opravdu nikam nepřeneseš. '
      cannotPutMsg = 'Pohnout s koulí asi nepůjde. '
      cannotBreakMsg = 'Kouli holýma rukama nerozbiješ. '
      isListed = true

    dobjFor(Attack)
    {
        verify() { }
        action() { mainReport('Kouli holýma rukama nerozbiješ. '); }
    }

    dobjFor(Break)
    {
        verify() { }
        action() { mainReport('Kouli holýma rukama nerozbiješ. '); }
    }

    dobjFor(AttackWith)
    {
        check()
        {
            if (gIobj != sekera)
                failCheck('Tím kouli nerozbiješ. ');
        }
        action()
        {
            "Rozbil jsi skleněnou kouli sekerou, kapalina vytekla na zem a všude kolem jsou rozházené střepy. ";
            sklenena_koule.moveInto(nil);
            kaluz.discover();
            strepy.discover();
            achievement.awardPointsOnce();
         }
    }

            achievement: Achievement { +1 "rozbití skleněné koule" }

// definice příkazů "zaútoč na" a rozbij, zde nefunguje tak jak potřebuji, proto metody Attack, Break a AttackWith definuji samostatně
//    dobjFor(AttackWith) asDobjFor(Break)

      gcName = 'skleněnou kouli, skleněné kouli, skleněnou kouli, skleněné kouli, skleněnou koulí'
      gcVocab = 'skleněné skleněnou skleněná kouli/koulí/koule'
;

+ kaluz : Hidden, Immovable, RestrictedContainer 'kaluž/louže/kapalina' 'kaluž' *3
      "Páchne po hořkých mandlích. "

      cannotTakeMsg = 'Kaluž nedokážeš vzít. '
      cannotMoveMsg = 'Kaluž opravdu nikam nepřeneseš. '
      cannotPutMsg = 'Pohnout s kaluží asi nepůjde. '
      isListed = true
      specialDesc = "Temná louže je rozteklá po podlaze. "

  canPutIn(obj) { return obj.ofKind(jehla); }

// akce polož něco do něčeho, objekt jehla po namočení zmizí a nový otrávená jehla zůstane v kaluži, hráč jí musí sebrat
    iobjFor(PutIn)
    {
        verify() {}
        check()
        {
            if (jehla.isHeldBy(me))
            "Jehla se namočila v kaluži, úplně se Ti zachvěly ruce, když jsi si uvědomil, co to může znamenat. ";
         }
        action()
        {
            jehla.moveInto(nil);
            otravena_jehla.discover();
            achievement.awardPointsOnce();
         }
    }

            achievement: Achievement { +1 "otrávení jehly" }

      gcName = 'kaluže, kaluži, kaluž, kaluži, kaluží'
      gcVocab = 'kaluže/kaluži/kaluž/kaluží/louže/louži/louže/louži/kapaliny/kapalinu/kapalina/kapalině'
;

// preferovaný přímý objekt definovaný jako zbraň, kterou potřebuji na zneškodnění draka
+ otravena_jehla : PreferredIobj, Hidden 'otrávená jehla' 'otrávená jehla' *3
       "Je velmi ostrá a nyní také jedovatá. "

       isListed = true

    	iobjFor(AttackWith)
    	{
        	verify() { }
    	}

       gcName = 'otrávené jehly, otrávené jehle, otrávenou jehlu, otrávené jehle, otrávenou jehlou'
       gcVocab = 'otrávené otrávené otrávenou otrávenou jehly/jehle/jehlu/jehlou'
;

// definuji hlášení, které hráče informuje o nemožnosti jejich sebrání/přenešení/přesunutí
+ strepy : Hidden, Immovable 'střepy' 'střepy' *3
      "Je jich tak moc a jsou tak malé, že je není možné sesbírat. "

      cannotTakeMsg = 'Střepy nedokážeš sesbírat. '
      cannotMoveMsg = 'Střepy opravdu nikam nepřeneseš. '
      cannotPutMsg = 'Pohnout se střepy nepůjde, pořezal by ses. '
      isListed = true
      specialDesc = "Střepy se válí všude kolem. "

      gcName = 'střepy, střepům, střepy, střepům, střepy'
      gcVocab = 'střepy/střepy/střepy'
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

kruhova_mistnost: Room 'Kruhová místnost' 'do kruhové místnosti'
    "Stojíš v malé kruhové místnosti. Na severu jsou schody vedoucí nahoru do věže, na východě schody vedoucí do podzemí. Z jihu je cítit sirný zápach. \bMůžeš jít na východ, na jih, na západ, nahoru. "
    east = vrchol_schodiste
    south = mistnost_s_drakem
    west = knihovna
    up = mala_mistnost_vez
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

mistnost_s_drakem: Room 'Místnost se spícím drakem' 'do místnosti se spícím drakem'
    "Stojíš v rozhlehlé místnosti. Je tu velmi cítit sirný zápach. Na jihu je výklenek ve zdi. \bMůžeš jít na sever, na jih. "
    north = kruhova_mistnost
    south : TravelMessage 
    		{  ->vyklenek
           	"Opatrně procházíš kolem mrtvého draka dál na jih. "
                canTravelerPass(traveler) {return spici_drak.curState == spici_drakDeadState; }
        		explainTravelBarrier(traveler) 
			{ "Drak se probudil, překvapeně se na tebe podíval, pak se však pokusil polaskat tě svým horkým dechem. Potom ohořelé tělo znechuceně odstrčil a znovu usnul. "; finishGameMsg(ftDeath, [finishOptionUndo] );}
}
;

// NPC definovaná jako mimo dosah hráče a nesebratelná
+ spici_drak : OutOfReach, UntakeableActor 'spící drak' 'spící drak' *1
      "Má pět hlav a dlouhý ocas. "

   
      gcName = 'spící drak, spícímu drakovi, spící drak, spícímu drakovi, spícím drakem'
      gcVocab = 'spícímu spícím spícího drakovi/drakem/draka'

      allowAttack = true

// akce podobné jako u NPC strážce
    dobjFor(Attack)
    {
        check()
        {
            failCheck('Probudit draka a ještě s holýma rukama není dobrý nápad. ');
        }
    }

    dobjFor(AttackWith)
    {
        check()
        {
            if (gIobj != otravena_jehla)
                failCheck('To bude chtít jinou zbraň. ');
        }
              
  		action()
        {
			 spici_drak.moveIntoForTravel(mistnost_s_drakem);

             "Píchl jsi draka jehlou. Drak překvapeně otevřel oči, pak sebou však několikrát škubnul a bylo po něm. ";
             setCurState(spici_drakDeadState);
             achievement.awardPointsOnce();
        }
    }

             achievement: Achievement { +1 "zabit draka" }

canObjReachSelf(obj) { return curState != spici_drakDeadState; }
canObjReachContents(obj) { return curState != spici_drakDeadState; }
cannotReachFromOutsideMsg(dest) { return 'Nepřipadá Ti vhodné dotýkat se dračí mrtvoly!'; }
;

++ spici_drakGuardState: HermitActorState
    noResponse = "Pokud ho probudíš, se zlou se potážeš. "
    stateDesc = "Pokud ho probudíš, se zlou se potážeš. "
    isInitState = true
;

++ spici_drakDeadState: HermitActorState
noResponse = "Je mrtvý a už se nehýbe. "
specialDesc = "Drak leží mrtvý na podlaze. "
stateDesc = "Drak je mrtvý. "
;

// dračí hlavy jsou součástí živého i mrtvého draka definované jako Component, díky čemuž není možné je sebrat, ale jen uříznout
++ draci_hlavy : PreferredDobj, Component 'dračí dračími/hlavy/hlavu/hlavami/hlavou' 'hlavy' *3
     "Jsou obrovské a nahánějí Ti hrůzu. "

     isPlural = true
     gcName = 'dračí hlavy, dračím hlavám, dračí hlavy, dračím hlavám, dračíma hlavama'
     gcVocab = 'dračím dračíma dračí hlavám/hlavama/hlavy'

// po uříznutí hlav musí z důvodu správného popisu objektu spící drak i s komponentou dračí hlavy zmizet a ojeví se objekty nové
    dobjFor(CutWith)
    {
        preCond = []
        		verify() {}

				check()
				{
                        if (gIobj != sekera)
                        failCheck('To bude chtít něco jiného. ');

				        if (spici_drak.curState != spici_drakDeadState)
                        failCheck('I když drak spí, tohle by ho určitě probudilo. ');
                }

                action()    

                {
                        "Odsekl jsi dračí hlavy od těla. ";
                        spici_drak.moveInto(nil);
                        draci_hlavy.moveInto(nil);
                        drak_bez_hlavy.discover();
                        useknute_draci_hlavy.discover();
                        achievement.awardPointsOnce();
                }
    }

                        achievement: Achievement { +1 "useknutí dračích hlav" }
;

// zde již pouze jediné plus, je to objekt na úrovni spícího draka, který se objeví po odseknutí hlav
// draka bez hlavy lze definovat také jako Heavy a poté není nutné vypisovat cannotXXXMsg
+ drak_bez_hlavy : Hidden, Immovable 'bezhlavý drak' 'mrtvý drak' *1
     "Obrovská hora dračího těla leží bezvládně na zemi bez hlav. "
      cannotTakeMsg = 'Mrtvý drak je i bez hlav nesmírně těžký. '
      cannotMoveMsg = 'Mrtvého draka i bez hlav opravdu nikam nepřeneseš. '
      cannotPutMsg = 'Pohnout s mrtvolou draka nepůjde, ani když je bez hlav. '
      isListed = true

     gcName = 'bezhlavý drak, bezhlavému drakovi, bezhlavého draka, bezhlavému drakovi, bezhlavým drakem'
     gcVocab = 'bezhlavému bezhlavým bezhlavého mrtvému mrtvým mrtvého drakovi/drakem/draka' 
;

// ty lze náslendě podat drakovi, nejedná se tedy o zbraň
+ useknute_draci_hlavy : Hidden, Thing 'useknuté useknutými dračí dračími/hlavy/hlavami/' 'useknuté hlavy' *3
     "Dokud byly živé, vypadaly hrozivě. "

     isPlural = true
     gcName = 'useknuté dračí hlavy, useknutým dračím hlavám, useknuté dračí hlavy, useknutým dračím hlavám, useknutýma dračíma hlavama'
     gcVocab = 'useknutým dračím useknutýma dračíma useknuté dračí hlavám/hlavama/hlavy'
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

vyklenek: Room 'Výklenek' 'do výklenku'
    "Jsi u malého výklenku. \bMůžeš jít na sever. "
    north = mistnost_s_drakem
;

+ treti_drahokam : Thing 'třetí drahokam' 'třetí drahokam' *2
     "Je stejně krásný jako první a druhý drahokam dohromady. "

     gcName = 'třetího drahokamu, třetímu drahokamu, třetí drahokam, třetím drahokamu, třetím drahokamem'
     gcVocab = 'třetímu třetím drahokamu/drahokamem*drahokamy'
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

vrchol_schodiste: Room 'Vrchol schodiště' 'na vrchol schodiště'
    "Stojíš na vrcholu schodiště vedoucího kamsi do podzemí. \bMůžeš jít na západ, dolů. "
    west = kruhova_mistnost
    down = podzemi
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

podzemi: Room 'Podzemí' 'do podzemí'
    "Jsi v podzemí. Je tu spousta ohlodaných kostí, hlavně lidských. \bMůžeš jít na východ, nahoru. "
    east : TravelMessage 
    		{  ->konec_podzemni_chodby
           	"Opatrně procházíš kolem mrtvého psa dál na východ . "
                canTravelerPass(traveler) {return pes.curState == pesDeadState; } //lze i {return !pes.location; }
        		explainTravelBarrier(traveler) 
			{ "Pes se na tebe lačně vrhnul a za několik okamžiků tvé kosti obohatily už tak velkou podzemní sbírku. "; finishGameMsg(ftDeath, [finishOptionUndo] );}
}
    up = vrchol_schodiste
;

// NPC postava, na kterou nelze zaútočit
+ pes : OutOfReach, UntakeableActor 'obrovský pes' 'obrovský pes' *1
      "Vidíš mu na očích, že kromě lidského masa k smrti miluje dračí hlavy. "
     
      gcName = 'obrovský pes, obrovskému psovi, obrovský pes, obrovském psovi, obrovským psem'
      gcVocab = 'obrovskému obrovským obrovského psovi/psem/psa'

      allowAttack = nil

canObjReachSelf(obj) { return curState != pesDeadState; }
canObjReachContents(obj) { return curState != pesDeadState; }
cannotReachFromOutsideMsg(dest) { return 'Nepřipadá Ti vhodné dotýkat se psí mrtvoly!'; }
;

++ pesGuardState: ActorState
    stateDesc = "Vrčí na Tebe a viditelně Tě nechce pustit dál. "
    isInitState = true
;

// pokud potřebuji definovat možnot podání otrávených hlav psovi, musím využít konverzační témata, v tomto případě definuji příkaz dej něco
+++ GiveTopic 
     matchObj = useknute_draci_hlavy
	 topicResponse()
	 {
		"Pes se lačně vrhl na otrávené dračí hlavy. Na jeho předsmrtnou agónii nebyl pěkný pohled. ";
		draci_hlavy.moveInto(nil);
        pes.setCurState(pesDeadState);
        pes.moveInto(nil);
        mrtvola_psa.discover();
        achievement.awardPointsOnce();
	 }

        achievement: Achievement { +1 "zabití psa" }
;

// na jiné předměty, než otrávené dračí hlavy potřebuji, aby pes nereagoval, zase využiji konverzační témata
+++ DefaultAnyTopic
    "<.p>Pes nereaguje. "

    deferToEntry(entry) { return !entry.ofKind(DefaultTopic); }
;

++ pesDeadState: HermitActorState
noResponse = "Je mrtvý a už se nehýbe. "
specialDesc = "Pes leží mrtvý na podlaze. "
stateDesc = "Pes je mrtvý. "
;

+ mrtvola_psa : Hidden, Immovable 'mrtvola psa' 'mrtvola psa' *1
     "Obrovské tělo mrtvého psa leží bezvládně na zemi. "

      cannotTakeMsg = 'Mrtvý pes je nesmírně těžký. '
      cannotMoveMsg = 'Mrtvého psa opravdu nikam nepřeneseš. '
      cannotPutMsg = 'Pohnout s mrtvolou psa nepůjde. '
      isListed = true

     gcName = 'mrtvola psa, mrtvole psa, mrtvolu psa, mrtvole psa, mrtvolou psa'
     gcVocab = 'mrtvole mrtvolou mrtvolu psa/psa/psa'
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

konec_podzemni_chodby: Room 'Konec podzemní chodby' 'na konec podzemní chodby'
    "Jsi na konci podzemní chodby. \bMůžeš jít na západ. "
    west = podzemi
;

+ ctvrty_drahokam : Thing 'čtvrtý drahokam' 'čtvrtý drahokam' *2
     "Je ze všech čtyř drahokamů nejkrásnější. "

     gcName = 'čtvrtého drahokamu, čtvrtému drahokamu, čtvrtý drahokam, čtvrtém drahokamu, čtvrtým drahokamem'
     gcVocab = 'čtvrtému čtvrtým drahokamu/drahokamem*drahokamy'
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

mala_mistnost_vez: Room 'Malá místnost na vrcholu věže' 'do malé místnosti na vrcholu věže'
    "Jsi v malé místnosti na vrcholu věže. V severní stěně je kruhový otvor, kterým se dá prolézt jen jedním směrem. \bMůžeš jít na sever, dolů. "
    north = mistnost_vrchol_vez
    down = kruhova_mistnost
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

mistnost_vrchol_vez: Room 'Místnost na vrcholu věže' 'do místnosti na vrcholu věže'
    "Jsi v místnosti na vrcholu věže. \bMůžeš jít na západ. "
    west = druha_mistnost_vrchol_vez
;

// příklad nedůležitého obektu, který hráč nemůže nikde využít
+ vaza : Thing 'váza' 'váza' *3
      "Je docela hezká. "

      gcName = 'vázu, váze, vázu, váze, vázou'
      gcVocab = 'vázy/váze/vázu'
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

druha_mistnost_vrchol_vez: Room 'Druhá místnost na vrcholu věže' 'do druhé místnosti na vrcholu věže'
    "Jsi v místnosti na vrcholu věže. \bMůžeš jít na východ, dolů. "
    east = mistnost_vrchol_vez
    down : TravelMessage 
    		{  ->sv_nadvori
           	"Spadl jsi přímo doprostřed kupky sena, která ideálně ztlumila tvůj pád. "
                canTravelerPass(traveler) {return kupka_sena.isIn(sv_nadvori); }
        		explainTravelBarrier(traveler) 
			{ "Zabil jsi se pádem z výšky. "; finishGameMsg(ftDeath, [finishOptionUndo] );}
    }
;

+ truhla : Container, Heavy 'truhla' 'truhla' *3
      "Vypadá sice bytelně, víko jí však chybí. "

      cannotTakeMsg = 'Truhla je příliš těžká. '
      cannotMoveMsg = 'Truhlu opravdu nikam nepřeneseš. '
      cannotPutMsg = 'Pohnout s truhlou asi nepůjde. '
      cannotOpenMsg = 'Truhlu nelze otevřít, je bez víka. '
      cannotCloseMsg = 'Truhlu nelze zavřít, je bez víka. '

      isListed = true
      gcName = 'truhlu, truhle, truhlu, truhle, truhlou'
      gcVocab = 'truhly/truhle/truhlu'
;

// zde využívám třídu SimpleAttachable, pokud je provaz definován jako Attachable, stále "jde" se mnou i po přivázání
++ provaz : SimpleAttachable, Hidden 'provaz/lano' 'provaz' *2
       "Je ho pořádný kus a jistě se bude hodit na nepřístupných místech. "

       changeGender = 'lan:4'
       gcName = 'provaz, provazu, provaz, provazu, provazem'
       gcVocab = 'provazu/provazu/provaz/lanu/lanu/lano'
;

// definice nových slov do slovníku hry, které by hráč mohl zkoušet
VerbRule(privaz)
    ('přivaž' | 'přivázat') dobjList
    ('k' | 'ke' | 'na' | 'do') singleIobj
    : AttachToAction
    askIobjResponseProd = atSingleNoun
    verbPhrase
    {
            return 'přivázat/přivazuj{eš}/přivázal{a} (co) (k čemu)';
    }
;

VerbRule(privaz_k_cemu)
    [badness 500] ('přivaž' | 'přivázat') dobjList
    : AttachToAction
    verbPhrase
    {
            return 'přivázat/přivazuj{eš}/přivázal{a} (co) (k čemu)';
    }
    construct()
    {
        /* set up the empty indirect object phrase */
        iobjMatch = new EmptyNounPhraseProd();
        iobjMatch.responseProd = atSingleNoun;
    }
;

VerbRule(odvaz)
    ('odvaž' | 'odvázat') dobjList
    ('od' | 'z' | 'ze') singleIobj
    : DetachFromAction
    askIobjResponseProd = atSingleNoun
    verbPhrase
    {
            return 'odvázat/odvazuj{eš}/odvázal{a} (co) (od čeho)';
    }
;

VerbRule(odvaz_od_ceho)
    [badness 500] ('odvaž' | 'odvázat') dobjList
    : DetachFromAction
    verbPhrase
    {
            return 'odvázat/odvazuj{eš}/odvázal{a} (co) (od čeho)';
    }
    construct()
    {
        /* set up the empty indirect object phrase */
        iobjMatch = new EmptyNounPhraseProd();
        iobjMatch.responseProd = atSingleNoun;
    }
;

VerbRule(namoc)
    [badness 500] ('namoč' | 'namočit') dobjList
    : PutInAction
    verbPhrase = 'namočit/namáč{íš}/namočil{a} (co) (do čeho)'
    construct()
    {
        /* set up the empty indirect object phrase */
        iobjMatch = new EmptyNounPhraseProd();
        iobjMatch.responseProd = toSingleNoun;
    }
;

VerbRule(namoc_do)
    ('namoč' | 'namočit')
    dobjList 'do' singleIobj
    | ('namoč' | 'namočit')
    'do' singleIobj dobjList
    : PutInAction
    verbPhrase = 'namočit/namáč{íš}/namočil{a} (co) (do čeho)'
    askIobjResponseProd = toSingleNoun
;

VerbRule(namoc_v)
    ('namoč' | 'namočit')
    dobjList 'v' singleIobj
    | ('namoč' | 'namočit')
    'v' singleIobj dobjList
    : PutInAction
    verbPhrase = 'namočit/namáč{íš}/namočil{a} (co) (v čem)'
    askIobjResponseProd = toSingleNoun
;

VerbRule(rozbij_cim)
    ('rozbij' | 'rozbít') singleDobj singleIobj
    : AttackWithAction
    verbPhrase = 'rozbít/rozbíj{íš}/rozbil{a} (co) (čím)'
    isPrepositionalPhrasing = nil
    omitIobjInDobjQuery = true
    askDobjResponseProd = singleNoun
    askIobjResponseProd = singleNoun
;

VerbRule(pichni_koho)
    ('píchni' | 'píchnout') singleDobj singleIobj
     : AttackWithAction
    verbPhrase = 'píchnout/pích{áš}/píchnul{a} (koho) (čím)'
    askDobjResponseProd = onSingleNoun
    askIobjResponseProd = singleNoun
;

VerbRule(usekni_co)
    ('usekni' | 'useknout') singleDobj singleIobj
     : CutWithAction
    verbPhrase = 'useknout/usekáv{áš}/usekl{a} (co) (čím)'
    askDobjResponseProd = onSingleNoun
    askIobjResponseProd = singleNoun
;

VerbRule(prepiluj)
    [badness 500] ('přepiluj' | 'přepilovat') singleDobj
    : CutWithAction
    verbPhrase = 'přepilovat/piluj{eš}/přepiloval{a} (co) (čím)'
    construct()
    {
        /* set up the empty indirect object phrase */
        iobjMatch = new EmptyNounPhraseProd();
        iobjMatch.responseProd = singleNoun;
    }
;

VerbRule(prepiluj_s)
    ('přepiluj' | 'přepilovat') singleDobj singleIobj
    : CutWithAction
    verbPhrase = 'přepilovat/piluj{eš}/přepiloval{a} (co) (čím)'
    askDobjResponseProd = singleNoun

    askIobjResponseProd = singleNoun
;

VerbRule(upiluj)
    [badness 500] ('upiluj' | 'upilovat') singleDobj
    : CutWithAction
    verbPhrase = 'upilovat/piluj{eš}/upiloval{a} (co) (čím)'
    construct()
    {
        /* set up the empty indirect object phrase */
        iobjMatch = new EmptyNounPhraseProd();
        iobjMatch.responseProd = singleNoun;
    }
;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// do hry mohu zaintegrovat nápovědu, vzhledem k délce ale není nutná



