#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>
#include <SquareCircle.h>

/* pig.t - implementation of the pig in SquareCircle */

pig : UntakeableActor 'large pink pig/animal/hog/swine' 'pig'
   @westField
  "It's a large pink animal, and quite good-looking as pigs go. "
  isHim = true
  isIt = true
  afterPushTravel(destination)
  {
    curState.afterPushTravel(destination);
  }
  uselessToAttackMsg = 'Somewhere in your brain stirs a recollection that
   you always found mindless cruelty to animals to be something not only
   deeply distasteful but absurdly irrational. '
  cannotKissActorMsg = 'The pig would find that distasteful even if you don\'t. ' 
  cannotEatMsg = 'To do that you\'d first have to slaughter it, butcher it,
   and cook it, and quite frankly, you\'re far too squeamish for the first two
   operations and have nothing to hand to accomplish the third. '
  cannotScrewMsg = 'You dirty old sod! ' 
  tasteDesc = "You can't do that without eating him, or at least biting him, which
   a live pig isn't going to take at all kindly to. "
  specialDescOrder = 11
  iobjFor(ThrowTo)
  {
    verify()
    {
      if(getOutermostRoom != gActor.getOutermostRoom)
        illogicalNow('The pig is too far away.' );
    }    
  }
  throwTargetCatch(obj, path)
     {
       /* take the object */
       obj.moveInto(location);
 
         /* generate the default message if we successfully took the object */
       if (obj.isDirectlyIn(location))
       {
         gMessageParams(obj);
         "{The obj/he} land{s} just in front of the pig's snout. ";
       }
     }

  afterAction()
  {
    inherited;
    if(gActionIs(Yell))
      "The pig takes not the least bit of notice; perhaps he\'s grown used
       to hearing idiots <<gVerbName>>. ";
  }
;

+ SimpleNoise
  desc =  "Oink! Oink! "
;

+ SimpleOdor
  desc = "Hm. Fresh farmyard smell. Not exactly smoked ham -- rather
   a different sort of pungency! "
;

+ GiveShowTopic @sandwich
   topicResponse()
   {
    "As the pig sniffs the sandwich you recall guiltily that it is, after all, 
     a <i>ham</i> sandwich and you stop to wonder if pigs are cannibals. 
     It occurs to you that encouraging cannibalism amongst pigs might be
     a <i>bad idea</i> -- it could give rise to mad pig disease or something --
     so you quickly snatch the sandwich back out of the pig's reach. ";
//     sandwich.moveInto(nil);
   }
;

+ DefaultCommandTopic
  "Either he's too pig ignorant to understand you, or he's just being pig obstinate. Either
  way, he ignores you. "
;

+ DefaultGiveShowTopic
  "He seems totally uninterested -- perhaps he doesn't consider {it dobj/him} edible. "
;

+ DefaultAnyTopic
 "Since he never learned English and you never learned Porkish, the possibilities
  for mutual communication are somewhat limited. "
;

+ pigFeeding : ActorState
  isInitState = true
  specialDesc = "A large pig is sniffing round the trough, looking for something to eat. "
  stateDesc = "It's sniffing round the trough. "
  distantSpecialDesc = (specialDesc)
  remoteSpecialDesc(pov) { distantSpecialDesc; } 
  beforeAction()
  {
    if(gActionIs(Take) && gDobj.isIn(trough) && gDobj is in (hat, boots))
    {
      "The pig squeals at you furiously, tugging {the dobj/him} from your grasp and
       dropping {it dobj/him} back in the trough<.reveal pig-guard>. He seems
       obsessed with anything that even <i>might</i> be food. ";
      exit; 
    }
  }
  afterPushTravel(destination)
  {
    "The pig trots along behind the trough. ";
    getActor.moveIntoForTravel(destination);
  }
  afterAction()
  {
    if(pig.canTouch(acorns) && !acorns.isIn(gPlayerChar))
    {
      "The pig gives the acorns a curious sniff, and then starts munching them. ";
      acorns.moveInto(nil);
      getActor.setCurState(pigMunching);
    }
    if(pig.canTouch(sandwich) && !sandwich.isIn(gPlayerChar))
    {
//      "Before you can complete the thought, <q>I wonder if pigs have any
//       conscientious objection to cannibalism,</q> the hungry pig has gobbled
//       the sandwich whole. ";
//       sandwich.moveInto(nil);
		"You start to wonder whether pigs are cannibals, and decide it might be
		 as well not to put it to the test -- you don't want to introduce mad pig
		 disease into the food chain!
		 So just as the pig starts sniffing the sandwich you quickly snatch it up. ";
		 sandwich.moveInto(gPlayerChar);
    }
  }
;

++ GiveShowTopic @acorns
  topicResponse
  {
    acorns.moveInto(nil);
    "The pig eagerly takes the acorns from your outstretched arm and starts munching
     them. ";
    getActor.setCurState(pigMunching); 
  }
;

+ pigMunching : HermitActorState, EventList
  specialDesc = "The large pig is busily chewing the acorns. "
  stateDesc = "He's eating something. "
  noResponse = "He's too busily eating to take any notice. "
  eventList = ['The pig chews eagerly. ', 'The pig seems to be enjoying the acorns. ',
    'The pig seems to be coming near the end of his meal. ',
   new function {
     "The pig licks his snout then turns his attention back to the trough. ";
     if(!pig.isIn(trough.location))
     {
        "The pig goes off in search of its trough. ";
        pig.moveIntoForTravel(trough.location);
        pig.setCurState(pigArriving);
     }
     else
         pig.setCurState(pigFeeding);
     acorns.moveInto(acorns.newLocation);
     acorns.moved = nil;
   }
   ]  
   activateState(actor, oldState) { 
     inherited(actor, oldState);
     curScriptState = 1;
   }

; 

+ pigArriving : ActorState, EventList
  specialDesc = "The pig is looking for its trough. "
  stateDesc = "He's looking for his trough. "
  eventList = [
    new function()
    {
      "The pig trots up in search of his trough. ";
      pig.setCurState(pigFeeding);
    }
  ]
;

+ AgendaItem
  isReady = pig.canSee(gPlayerChar) && blueCoveralls.wornBy == gPlayerChar
  initiallyActive = true
  invokeItem
  {
    isDone = true;
    "The pig temporarily turns his attention to you, sniffing at your coveralls, just
     for a moment, before deciding that they're far less interesting than his trough.
     You're heartily glad he's only a pig -- a human being would have
     taken a much more worrying interest in your attire. ";
  }
;