#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>
#include <SquareCircle.h>

// SquareHints.t (File for hints system)

Hint template 'hintText'  [referencedGoals]? ;

topHintMenu: TopHintMenu 'Hints';

+ Goal 'Oh no! Not a hunger puzzle!'
 [ 'No, you can rest absolutely assured, there\'s <i>no</i> hunger puzzle in this game. 
    The reference to starvation in the note is purely to set
   the scene and to tell you something about the mentality of your captors -- 
   there\'s no actual time limit or turn limit within which food must be found and consumed. ',
   
   'And no need to eat anything at all at any point in the game
    (though you can find something edible and eat it if you want to -- it\'s simply
     a matter of taste). '
  ]
   openWhenDescribed = note
   closeWhenTrue = (equator.linesDrawn > 3)
;

+ Goal 'How can anyone draw a square circle? It\'s impossible!'
   ['Think carefully about the definitions of <q>square</q> and <q>circle</q> -- particularly
     about those offered in the geometry textbook in your cell. ',
    'It is, of course, impossible to draw a square
     circle on a plane surface -- but no one said you had to. ',
    'You don\'t need to use complicated syntax: the job can be done with
     commands in the form DRAW X ON Y. ', 
    'Are you being too Euclidean? ', 
    'Try looking at the definition of sphere in the green book. ',
    'You need to find something spherical to draw on. ',
    'How is a straight line defined? ',
    'What is the shortest distance between two points on the surface of a sphere?',
    'Look up the definition of great circle in the green book. ',
    'An angle of 180 degrees still counts as an angle. ',
    'Four equal lines each at 180 degrees to each other forming a closed figure
     could be both a square and a circle -- on the surface of a sphere. ',
    'Have you found a sphere you can draw on anywhere? ',
    'Have you examined it, to see what\'s on it already? ',
    'The shortest distance between two straight lines on the surface of a
     sphere is a great circle. ',
    'On a globe, the obvious great circles are the equator and the meridians. ',
     spoilerWarning,
    'In the circle room to the east of the Vestibule you\'ll find a globe: draw
     four lines on its equator (then show the globe to the guardian). ',
    'To do this, type DRAW LINE ON EQUATOR four times. '     
    ]
   openWhenDescribed = note
   openWhenSeen = vestibule
   closeWhenTrue = (equator.linesDrawn > 3)
;

+ penGoal : Goal 'Where can I get a pen to draw with?'
  [
    'How thoroughly have you searched the cell? ',
    'Is there anywhere a pen could be concealed? ',
    'What sort of place might you expect a pen to be put in?',
    'If a pen is used to draw with then you could call it a ......',
    'If a pen is used to draw with then you could call it a d.....',
    'If a pen is used to draw with then you could call it a dra...',
    'If a pen is used to draw with then you could call it a draw-er (bad pun!).',
    'How thoroughly have you searched the desk? ',
    drawerHint
  ]
  openWhenDescribed = note
  openWhenRevealed = 'need-pen' 
  closeWhenSeen = pen
;

++ drawerHint : Hint 'Look in the desk drawer'
  [drawerGoal]
;

+ drawerGoal: Goal 'How can I open the desk drawer?'
  [ 'Clearly you need a key -- where is a key explicitly mentioned in this cell? ',
    'What must you do to a book in order to read it?', 
    'What happens when you simply try to read the red book? ',
    'If you only read the first few pages, what might you be missing? ',
    'What do you do to a book you\'re about to read, after
     picking it up?', 
    'What might you try to see what\'s in the middle of the book? ',
     spoilerWarning, 
    'Open the red book'    
  ]
  openWhenRevealed = 'DeskTried'
  closeWhenSeen = brassKey
;

+ Goal 'How do I get out of the cell?'
  [ 'Have you tried opening the door?', 'If you have, you\'ll have found it\'s locked. ',
    'So you\'ll need to find a key that unlocks it. ', 'But perhaps you should
    concentrate on some other tasks first. ', 'Such as getting the desk drawer open.' ]
  closeWhenTrue = (pen.moved || tinBox.seen)  
  openWhenTrue = true
;

+ Goal 'How do I get out of the cell?'
  ['Where did the pen go when you dropped it? Does that suggest somewhere else to look?',
   'What do you sleep on?', spoilerWarning, 'Look under the bed.' ]
  openWhenTrue = (pen.moved)
  closeWhenSeen = tinBox
;

+ Goal 'How do I get out of the cell?'
  ['What did you find under the bed?', 'Have you opened it yet?',
   'Have you found a key anywhere?', 'Have you looked in the desk?',
   'Could the same key unlock more than one thing?',
   spoilerWarning, 'Use the small brass key to unlock the tin box.' ]
  openWhenSeen = tinBox
  closeWhenSeen = ironKey
;


+ Goal 'I can\'t see anything in the room to the east of the Vestibule -- what do I do?'
  ['Bring a light source with you -- where have you seen one?', 
    'What provides light in the square room?', 
    lightCubeHint, 
    spoilerWarning, 
    'Push the desk into the square room, stand on
    it, and take the light cube, which you can then carry into the circle room. '
  ]  
  closeWhenTrue = (lightCube.moved)
  openWhenRevealed = 'CircleRoom'
;

++ lightCubeHint : Hint 'Might there be some way of getting the light cube?'
   [lightCubeGoal]
;

+ lightCubeGoal : Goal
  'I can\'t reach the light cube -- how do I take it?'
  ['What would normally enable you to reach something high up?',
   'Try standing on something. ', 'If there\'s nothing in the Square Room you
    can stand on, you obviously need to get something from somewhere else. ',
    'What objects
     substantial enough to stand on have you come across?',
    'What other light sources
     have you seen, and what could you stand on to reach them? ',
   'If the thing you want to stand on is too heavy, try pushing it where you want
    it. ', spoilerWarning,
   'Push the desk from the cell into the Square Room (PUSH DESK N followed by 
    PUSH DESK E)' ]
  openWhenRevealed = 'CubeOutOfReach'  
  closeWhenTrue = (lightCube.moved)
;

+ Goal 'The prison guardian has made off with the pen; how do I get it back? '
  ['You can\'t, but you don\'t need to; you\'re finished with it.']
  openWhenTrue = (pen.isIn(nil))
  closeWhenTrue = (isDone)
  displaySubItem(idx, lastBeforeInput, eol)
  { 
    inherited(idx, lastBeforeInput, eol);
    isDone = true;
  }
  isDone = nil
;


+ Goal 
  'How do I get through the blue door with the electrified handle? '
  ['Use one of two approaches: insulate yourself from the shock or turn off the power. ',
   'What have you come across that might be an insulator? Alternatively, where else
    have come across an electric output?',
   'If you\'re standing on an insulator you won\'t get a shock; or you can try putting
    something in a light socket to short-circuit the power.',
    spoilerWarning,
    rubberHint
   ]
  closeWhenRevealed = 'blue door open'
  openWhenRevealed = 'electrified handle'
;

++ rubberHint : Hint
   'Either stand on the square rubber sheet before opening the blue door, or unscrew 
    the silver disc from the glass-topped table in the circular room, push the desk
    back into the cell, remove the light bulb from its socket and put the silver disc
    in its place (make sure you have the light cube with you if you do otherwise
    you\'ll be stuck in the dark).'
    [disableAlarmGoal ]
;

+ disableAlarmGoal : Goal
  'How do I stop the alarm ringing when I open the blue door? '
  [
    'Have you examined the blue door? ',
    'Is there something else nearby? ',
    'How carefully have you searched the courtyard? ',
    'What is situated opposite the blue door in the courtyard? ',
    'How closely have examined it (the object opposite the blue door)? ',
    'If you haven\'t already done so, take a closer look at the bush. ',
    'What lies behind the blue panel? ',    
    bushGoal,
    spoilerWarning,
    'Use the tool you find under the bush to unscrew the blue panel, then
     open it, then flip the switch to turn the alarm off. '    
  ]
  openWhenTrue = (rubberSheet.isDirectlyIn(courtyard) && gPlayerChar.isIn(rubberSheet))
  closeWhenRevealed = 'blue door open'
;

++ bushHint : Hint 'Have you looked under the bush yet?'
  [bushGoal]
;

+ bushGoal: Goal 'I can\'t get at the metallic object in the bush. '
  [
    'Where does the object appear to be in relation to the bush? ',
    'What might you do to dislodge it? ',
    'What might happen to it then? ',
    'Where might you look for it then? ',
     spoilerWarning,
    'Shake the bush, then look under the bush. '
    
  ]  
  openWhenDescribed = bush
  closeWhenTrue = (file.discovered)
;

+ Goal 'I can\'t open the gate from the small yard into the field. '
 [
   'If you can\'t find a way to unlock it (and there is a way) you could try getting over
    it. ',
   'You have already found a key that can be made to unlock the gate, you just have to
     do something to it; alternatively, find something to stand on to help you over the gate. ',
   spoilerWarning,
   'Rub the iron key with the metal implement you found under the bush in the 
    courtyard. Once filed, the key will unlock the gate. '   
 ]
  closeWhenSeen = field
  openWhenRevealed = 'GateTried'
;

+ Goal 'The desk leg keeps getting stuck in the pothole'
  [
    'What would make the leg ride over the hole? ',
    'What could you put in the hole to stop the leg getting trapped in it? ',
    'What\'s piled up just to the east of the hole? ',
    'Have you found a sandwich yet? ',
    'What was it in?',
    spoilerWarning,
    'You can use a box to convey sand to the hole, or you can put a small
     sand-filled box in the hole. '
  ]
  openWhenTrue = (alley.east.travelBarrier.explained)
  closeWhenTrue = (gPlayerChar.hasSeen(field) || desk.isIn(smallYard))
;

+ Goal 'Okay, so I\'m out of the prison -- what happens now?'
  [
    'Well, the first priority is not to get caught again. ',
     clothesHint,
    'You want to explore away from a heavily populated area. ',
    'Exploring the forest would probably be a good start. '
  ]
  openWhenSeen = field
  closeWhenSeen = hermit
;

++ clothesHint : Hint
   'The prison coveralls mark you out as an escaped prisoner. '
   [clothesGoal]
;

+ Goal 'Can I get back over the gate into the prison?'
  [
    'Yes, you can. ',
    'You can get back over the gate much the same way you got over it in the first place. ',
    'Once again, you need to find something to stand on. ',
    'There\'s something suitable not far away. ',
    'But you\'ll need to push it over to the gate before standing on it. ',
    'You can hardly ask the pig what to do, but he might be interested in something
     that could help. ',
    spoilerWarning,
    'Push the trough north, then stand on it, then climb over the gate. '
    
  ]
  openWhenTrue = (field.seen && !fieldGate.hasBeenOpened && trough.seen)
  closeWhenTrue = (fieldGate.hasBeenOpened || gRevealed('gate-climbed-again'))
;



+ Goal 'How do I get the hat and boots?'
  [
    'You\'ll need to distract the pig. ',
    'Maybe if you give the pig something to eat, he\'ll lose interest in the hat. ',
    'Where might you find something the pig likes to eat? ',
    'Look in the forest. ',
    'Look for something lying around in the forest. ',
    'Something not obviously fit for human consumption. ',
    'Something recently fallen off a tree. ',
    'This pig likes acorns. '    
  ]
   openWhenSeen = hat
   closeWhenMoved = hat
;

+ clothesGoal: Goal 'How do I get a change of clothes?'
  [
    'Find someone friendly. ',
    'Who lives in the forest? ',
    'What does he keep under his table? ',
    'Have you tried asking him? ',
    'You\'ll need to find somewhere private to change. ',
    'Some parts of the forest are fairly secluded. '
  ]
  openWhenSeen = road
  closeWhenTrue = (oldClothes.isWornBy(gPlayerChar))
;

+ Goal 'So what am I meant to be doing now?'
  [
    'Is there anything else you could ask {the hermit/him} that might
     shed light on what\'s going on? ',
    'Have you explored the forest area thoroughly? ',
    'Where might you look next to find some answers? ',
    'Now that you\'ve changed your clothes, have you tried finding out
     where the road (that runs along the west side of the field) goes? ',
    'What\'s at the end of it (as far east as you can go along it)? ',
    'Might it be worth while taking a look inside the Department of
     Applied Rationality?'    
  ]
  openWhenTrue  = (oldClothes.isWornBy(gPlayerChar))
  closeWhenSeen = receptionist
;



+ Goal 'The scrap of paper keeps getting blown away when I try to take it. '
   [
     'You won\'t be able to take it with your bare hands. ',
     'What kind of thing might you be able to scoop it up in? ',
     'Where might you find a net?',
     'What could you attach to the net to make a handle?',
     'How thoroughly have you explored the forest? ',
     'Go southeast from the clearing with the hermit\'s hut, then go south. ',
     'What did you find in the river?',
     'Take the net.',
     'Go north from the river bank to the small seclude clearing, then go east. ',
     'What do you find then?',
     'Could you use that broken-off stick for something?',
     'What\'s missing from the net?',
     spoilerWarning,
     'Try attaching the stick to the net. ',
     'Then go back to the hillside and TAKE SCRAP WITH NET. '
   ]
   openWhenRevealed = 'scrap-blown'
   closeWhenMoved = paperScrap
;

+ Goal 'Is there any way of finding out what the writing on the scrap of
  paper originally said? '
  [
    'Perhaps you could try showing it to someone. ',
    'Who might be helpful?',
    'Have you tried showing it to {the hermit/him}?',
    'Were you fully convinced by his suggestion?',
    'Even if he got it wrong, he may have jogged your memory a bit.',
    'Try looking at the scrap of paper again. ',
    'It\'s also worth showing it to {the hermit/him} more than once. '
  ]
  openWhenRevealed = 'scrappy-text'
  closeWhenTrue = paperScrap.isIn(nil)
  closeWhenRevealed = 'blanks-filled' 
;

+ Goal 'How do I find out who I am and what happened to me?'
  [
    'Try to get as much information as you come from {the hermit/him}. ',
    'And follow his advice. ',
    'Start by searching the forest and its immediate environs. ',
    'You have managed to retrieve that scrap of paper from the hillside,
     haven\'t you?',
    'Does it mention a name?',
    'Have you got {the hermit/him} to tell you anything about the person
     named on the scrap of paper?',
    'Where does this person work?',
    'Perhaps it would be a good idea to pay that place a visit. ',
    'Once you\'ve got yourself a change of clothes you can explore where the
     road to the west of the field goes. ',
    'Follow that road to the north, and then round the bend to the east...',
    '... and as far east as you can go. ',
    'When you\'ve done that, what\'s to the north of you?',
    'Try going inside the Department of Applied Rationality. ',
    'Then talk to {the receptionist/her} until a couple of things happen. ',
    'You might most usefully ask her about herself. ',
    'What did a couple of people do while you were chatting with {the receptionist/her}? ',
    'What has just been put in the tray on her desk? ',
    'You need to get hold of those envelopes somehow. ',
    'And then take a very good look at their contents. '  
  ]
  openWhenRevealed = 'id-quest'
  closeWhenDescribed = pandraPicture
;


+ Goal 'What am I meant to be doing now?'
 [
   'Have you tried talking to the receptionist? ',
   'Find out what interests her. ',
   'Keep talking to her until something happens. '
 ]
 openWhenSeen = receptionist
 closeWhenSeen = whiteEnvelope
;

+ Goal 'What am I meant to be doing now?'
 [
   'Has something been delivered recently (in the reception area)? ',
   'Have you looked at it or them? ',
   'Might they be important? ',
   'Would it be worth trying to find out what\'s inside? ',
    spoilerWarning,
   'Have you tried taking the two envelopes (white and brown) recently
    dropped into the wire tray on the receptionist\'s desk? '
 ]
 openWhenSeen = whiteEnvelope
 closeWhenTrue = (brownEnvelope.moved || whiteEnvelope.moved
   || gRevealed('snatch-envelope'))
;


+ Goal 'How do I take the envelopes from the tray on {the receptionist/she}\'s desk? '
  [
    'You\'ll need to distract {the receptionist/her} somehow. ',
    'If you talk with her you might find out what she\'s interested in. ',
    'What have you seen that she might like? ',
    'What have you read that might interest her? ',
    'What reading matter was in your cell? ',
    spoilerWarning,
    'Give {the receptionist/her} the blue book. '
  ]
  openWhenRevealed = 'snatch-envelope'
  closeWhenTrue = (brownEnvelope.moved || whiteEnvelope.moved)
;

+ Goal 'How do I smuggle the envelopes out of the reception area?'
  [
    'You\'ll have to make sure no one sees you leaving with them. ',
    'Or, to put it another way, you\'ll have to make sure no one can
      see you carrying them when you leave. ',
    'So, you\'ll have to hide them somehow. ',
    'How can you conceal something you\'re carrying? ',
    'What could you put them in? ',
    'Could something wearable also be a container? ',
    'What might conceal its contents when worn? ',
    spoilerWarning,
    'Put them under you hat. '    
  ]
  openWhenTrue = (brownEnvelope.moved || whiteEnvelope.moved)
  closeWhenDescribed = document
;

+ Goal 'The guardian is blocking the road and I want to get past. '
 [
   'Don\'t go near him -- you\'ll have to find another way of dealing with him. ',
   'You\'ll have to find some way of making him move. ',
   enlistHint,   
   alarmHint 
 ]
 openWhenRevealed = 'guard-watch'
 closeWhenRevealed = 'guard-moved'
;

++ enlistHint: Hint { 'Have you tried enlisting help? ' [enlistHelpGoal] }

++ alarmHint: Hint { 'Can you think of something that might alarm him enough to distract him? ' 
     [alarmGoal] }  

+ enlistHelpGoal : Goal 'How can I enlist help with distracting the guardian? '
  [
    'Who is most likely to help you? ',
    'When did you last talk to {the hermit/him}? ',
    'Have you told {the hermit/him} about the guardian? ',
    'Have you given {the hermit/him} any motive to want to help you?',
    'What attitude does {the hermit/he} have towards the New Enlightenment? ',
    'What could you show him to convince him that you might be able to change things? ',
    'Has {the hermit/he} seen the material you stole from the reception area?',
    spoilerWarning,
    'Show the document (about Pandra) from the envelope to {the hermit/him}, then
     tell him about the guardian'
  ]
  closeWhenTrue = (!guardian.isIn(prisonRoad))
;

+ alarmGoal : Goal 'Is there some way I can distract the guardian myself? '
 [
   'Is there an alarm somewhere that might distract him? ',
   'How would the guardian have summoned help while he was still guarding you? ',
   'How carefully have you searched the area where the guardian was sitting? ',
   spoilerWarning,
   'You can go back into the prison complex
    and set off the alarm by pushing the red button behind the panel in the corridor. 
    At that point, get out (via the blue door from the courtyard) as fast as you can. '
   
 ]
 closeWhenTrue = (!guardian.isIn(prisonRoad))
;

+ Goal 'How can I get the Pandra document published? '
  [
     'Have you found another envelope? ',  
     greenHint,    
    'What would happen to a document placed in the white envelope
      along with the green covering letter? ',
    'By what method was the Pandra document delivered? ',
    'What happened when the press release was delivered? ',
    'Could someone be back shortly to deliver more documents? ',
    'Where might you put documents where they\'d be likely to be delivered? ',
    'Put the green sheet of paper and the Pandra document in the white envelope,
     and then put the white envelope somewhere where it\'ll be delivered. ',
    'What\'s parked outside the Department of Rationality? ',
    'How closely have you examined the bike? ',
    'What about the pouch?',
    spoilerWarning,
    'After putting the correct documents into the white envelope, put the
     envelope into the pouch on the motorbike. '   
  ]
  openWhenRevealed = 'pandra-document'
;

++ greenHint : Hint
   'What was in the white envelope? '
   [whiteEnvelopeGoal]
;

+ whiteEnvelopeGoal : Goal 'What\'s this about a white envelope? '
  [
    'You did stay to see the white envelope delivered too, didn\'t you?',
    'If not, you\'d better go back for it. ',
    'It\'s in the same place you found the brown one. ',
    'And you can get it just the same way. '
  ]
  closeWhenMoved = whiteEnvelope
;

+ Goal 'What do I need to give {the hermit/him}? '
 [
   'Something that will interest the guardian ',
   'Would the guardian be interested in information about an escaped prisoner?',
   'Or how about some written evidence of the plot that got you arrested in the first place?',
   'Have you found anything that expresses hostility to the New Enlightenment? ',
   'Where did two plotters meet? ',
   'What did you find on the hillside? ',
   spoilerWarning,
   'Give the guardian the scrap of paper you should have found on the hillside;
    alternatively, if you still have them, you could give him your blue coveralls. '
 ]
 openWhenRevealed = 'hermit-ideas'
 closeWhenTrue = !guardian.isIn(prisonRoad);


+ Goal 'The brass key isn\'t where I expected to find it. '
 [
   'You need to look somewhere you haven\'t looked before. ',
   'Where were you when you woke up?',
   'What were you lying on?',
   'Other than the bed, that is. ',
   'Where do folks who don\'t trust banks traditionally keep their cash?',
   'What\'s under the mattress?',
    spoilerWarning,
   'LOOK UNDER THE MATTRESS'
 ]
 openWhenTrue = brassKey.isIn(mattress)
 closeWhenTrue = brassKey.discovered
;

+ Goal 'The iron key isn\'t where I expected to find it. '
 [
   'You need to look somewhere you haven\'t looked before. ',
   'Where were you when you woke up?',
   'What were you lying on?',
   'Other than the bed, that is. ',
   'Where do folks who don\'t trust banks traditionally keep their cash?',
   'What\'s under the mattress?',
    spoilerWarning,
   'LOOK UNDER THE MATTRESS'
 ]
 openWhenTrue = ironKey.isIn(mattress)
 closeWhenTrue = ironKey.discovered
;

+ Goal 'I\'m locked in the cell again -- is there a way out?'
 [
   'Yes, there is. ',
   'It\'s much the same as before...',
   '...except that some things may be hidden in different places. ',
   'If you\'re still stuck, read the hint referring to a key. '
 ]
 openWhenRevealed = 'back-in-cell' 
 closeWhenTrue = !cellDoor.isLocked
;


+ Goal 'I drew a square circle but I was rearrested when I tried to leave -- what
  do I do now? '
 [ 
   'Was trying to walk out through the main gate perhaps a bit too obvious?',
   'Could there be another way out of the courtyard?',
   'What\'s on the far side of the courtyard from the bush?'
 ]
 openWhenRevealed = 'back-in-cell'
 closeWhenRevealed = 'blue door open' 
;



+ Goal 'How do I find the combination to the padlock?'
 [
   'Have you read the note on the chair? ',
   'Have you read both sides of it? ',
   'To see both sides of the note, you obviously need to be holding it. ',
   'What might the significance of the circle on the note be? ',
   'What in the vicinity is described as being circular?',
   'What might be the point of the square on the note? ',
   'Does it suggest any mathematical operation to you? ',
   'More specifically, does it suggest an arithmetical operation? ',
   'How do you square a number?',
   spoilerWarning,
   'The combination is the square of the three numbers written on the note,
    i.e. 25 81 36. Turn the dial to each of these numbers in turn and the
    padlock will open. '
 ]
 openWhenRevealed = 'padlock'
 closeWhenRevealed = 'padlock-open'
;

+ Goal 'Is there a way to get past the checkpoint (pole) barrier?'
  [
    'No; it\'s simply a boundary of the map and there\'s no need for you to 
    get past it to complete the game. '
  ]
 openWhenRevealed = 'checkpoint'
;


spoilerWarning : Hint
  'SPOILER WARNING: The next hint contains full instructions. '
;