/*
** GndBus.t is the bus station and surrounding environs.
**
** Copyright (c) 1999, Stephen Granade. All rights reserved.
*/

#pragma C+

bus_station: busRm, turnCountRoom
    sdesc = "Bus Station"
    ldesc = "Your feet click on the tile floor as you shift around,
	     waiting. You could sit&mdash;there are a couple of worn
	     chairs scattered around, but they all look really
	     uncomfortable. The ticket counter and the board with
	     the bus schedules on it are on the north side of the room,
	     opposite the exit. "
    firstseen = {
	notify(jeanieMe, &playWithTicket, 2);
    }
    exits = 'north and south'
    north = bus_station_counter_room
    south = outside_station
    out = outside_station
    // After the player's been here for a while, if the bus hasn't
    // arrived, summon it.
    updateCounter = {
	self.turnCounter++;
	if (self.turnCounter == 10)
	    outside_station.summon_bus;
    }
;

modify theFloor
    adjective = 'tile'
    ldesc = {
	if (actorObject().location == bus_station ||
	    actorObject().location == bus_station_counter_room)
	    "The tiles used to be white and blue, but they've faded until
	     they're just about all gray. ";
	else pass ldesc;
    }
;

worn_chairs: fixeditem
    isThem = true
    noun = 'chair' 'chairs'
    adjective = 'worn' 'plastic'
    location = bus_station
    sdesc = "worn chairs"
    ldesc = "Their plastic is all brittle and cracked. "
    verDoBoard(actor) = (self.verDoSiton(actor))
    verDoLieon(actor) = (self.verDoSiton(actor))
    verDoSiton(actor) = {
	"As uncomfortable as they look? No thanks. ";
    }
;

distant_ticket_counter: distantItem
    noun = 'counter'
    adjective = 'ticket'
    location = bus_station
    sdesc = "ticket counter"
    ldesc = "The counter's to the north. "
;

bus_station_counter_room: busRm
    sdesc = "Bus Station, at the counter"
    ldesc = "The ticket counter is more like a cage, with the guy
	     giving tickets sitting behind bars. There's barely
	     enough room in there for him and his chair. On
	     the wall beside the counter is a big board listing
	     arrivals and departures. The rest of the station is to
	     the south. "
    noexit = { "The station's to the south. "; return nil; }
    exits = 'south'
    south = {
	local changeFlag = (change.location == ticket_counter),
	      ticketFlag = (ticket.location == ticket_counter);
	if (changeFlag || ticketFlag) {
	    "<q>Take your stuff,</q> the ticket guy mumbles. Blushing,
	     you grab your ";
	    if (changeFlag) {
		change.moveInto(jeanieMe);
		"change";
		if (ticketFlag) {
		    " and ticket";
		    ticket.moveInto(jeanieMe);
		}
	    }
	    else {
		"ticket";
		ticket.moveInto(jeanieMe);
	    }
	    ".\b";
	}
	return bus_station;
    }
    southeast = (self.south)
    southwest = (self.south)
    out = bus_station
    nrmLkAround(verbosity) =        // lookAround without location status
    {
        local l, cur, i, tot;

        if (verbosity) {
            self.dispBeginLdesc;
            self.ldesc;
            self.dispEndLdesc;

            l = self.contents;
            tot = length(l);
            i = 1;
            while (i <= tot) {
                cur = l[i];
                if (cur.isfixed)
                    cur.heredesc;
                i++;
            }
        }

        self.dispParagraph;
        if (itemcnt(self.contents)) {
            "You see "; listcont(self); " here. ";
        }
        listcontcont(self); "\n";

        l = self.contents;
        tot = length(l);
        i = 1;
        while (i <= tot) {
            cur = l[i];
            if (cur.isactor && cur.isListed) {
                if (cur != parserGetMe()) {
                    self.dispParagraph;
                    cur.actorDesc;
                }
            }
            i++;
        }
        "\n";
    }
;

ticket: item
    noun = 'ticket' 'cardboard'
    adjective = 'bus'
    location = ticket_counter
    sdesc = "bus ticket"
    ldesc = "You almost can't believe you just bought it. <q>Los
	     Angeles,</q> it says, as if you could forget. "
    verDoRead(actor) = {}
    doRead(actor) = { "<q>Los Angeles</q> is printed on it. "; }
;

change: item
    noun = 'money' 'change'
    location = ticket_counter
    sdesc = "change"
    adesc = "some change"
    ldesc = "There's not much left of the money you gave the ticket guy,
	     but every little bit counts. "
    verDoCount(actor) = {
	"It looks like the right amount. ";
    }
;

ticket_guy: Actor
    isHim = true
    isListed = nil
    noun = 'guy' 'man' 'person'
    adjective = 'ticket'
    location = bus_station_counter_room
    sdesc = "ticket guy"
    ldesc = "He looks bored. Really, really bored. He looks more
	     bored than you think you've ever felt. "
    dobjGen(a, v, i, p) = {
	if (v.touch) {
	    "You can't reach him through the bars. ";
	    exit;
	}
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
    verIoGiveTo(actor) = {
	"He doesn't even look up at you. Jerk. ";
    }
;

ticket_guy_chair: fixeditem
    noun = 'chair'
    adjective = 'his'
    location = bus_station_counter_room
    sdesc = "chair"
    ldesc = "Judging from how swaybacked it looks, the guy giving out the
	     tickets doesn't leave it much. "
    dobjGen(a, v, i, p) = {
	if (v.touch) {
	    "You can't reach the chair. ";
	    exit;
	}
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

ticket_counter: surface, fixeditem
    noun = 'counter' 'cage' 'bar' 'bars'
    adjective = 'ticket'
    location = bus_station_counter_room
    sdesc = "ticket counter"
    ldesc = {
	"Bars run the length of the counter. There's a small space that's
	 free of them where the guy behind the counter puts the tickets. ";
	if (itemcnt(self.contents))
	    "In that space is <<listcont(self)>>. ";
    }
;

schedule_board: floatingItem, fixeditem
    noun = 'board' 'schedule' 'chalkboard' 'blackboard'
    adjective = 'big' 'bus'
    location = {
	local loc = parserGetMe().location;

	if (loc == bus_station || loc == bus_station_counter_room)
	    return loc;
	return nil;
    }
    sdesc = "bus schedule"
    ldesc = "The chalkboard lists a bunch of buses, but the only one
	     you really care about is the one coming from New York
	     and going to Los Angeles. "
    verDoClean(actor) = { "Better not. "; }
    verDoRead(actor) = {}
    doRead(actor) = (self.ldesc)
;

outside_station: twodescroom, busRm
    seenBusDoorsOpen = nil        // Has Jeanie seen the bus's doors open?
    steppedOffBus = nil           // Did Jeanie just step off the bus?
    sdesc = "Outside the Station"
    j_ldesc1 = {
	"It's gotten chillier since you got here. ";
	if (bus_object.isIn(self))
	    "Good thing that bus is here already. ";
	else "Hopefully that bus'll be here soon. ";
	"There's only one car in the parking lot, and not a lot of
	 traffic on the road. ";
    }
    j_ldesc = "Yellow light from the street lamps makes the parking lot
	       and bus stop look weird. Old Church Road, running in front
	       of the bus station, is pretty much empty. The station's
	       behind you to the north. "
    enterRoom(actor) = {
	inherited.enterRoom(actor);
	if (bus_object.location == self && !self.seenBusDoorsOpen) {
	    "\bThe bus's doors swing open. ";
	    notify(self, &dismiss_bus, 8);
	    self.seenBusDoorsOpen = true;
	}
	else if (self.steppedOffBus) {
	    "\bYou step back from the bus. ";
	    self.bus_goes_away;
	}
    }
    firstseen = {
	notify(self, &summon_bus, 5);
    }
    summon_bus = {
	// First see if the bus is already here
	if (bus_object.isIn(self))
	    return;
	if (jeanieMe.location == bus_station_counter_room) {
	    notify(self, &summon_bus, 1);
	    return;
	}
	if (jeanieMe.location == bus_station)
	    "\bYou see a bus pull up outside and idle. ";
	else {
	    "\bYou hear the bus's engine some time before you see
	     it. It comes crawling down Old Church Road and pulls
	     into the lot in front of you. Its doors open. ";
	    notify(self, &dismiss_bus, 8);
	    self.seenBusDoorsOpen = true;
	}
	bus_object.moveInto(self);
	fake_bus_object.moveInto(bus_station);
    }
    dismiss_bus = {
	"\bThe bus driver shrugs. ";
	self.bus_goes_away;
    }
    // One function to describe the bus leaving
    bus_goes_away = {
	"The doors hiss shut and the bus jerks into life, lumbering
	 towards the road and away from the station. You watch the
	 bus windows slide past you, blank with reflected light. The
	 red taillights grow smaller and smaller and smaller until
	 they're gone.

	 \bYou shrug your bag onto your shoulder. It's a fair walk
	 back to the house. ";
	die();
    }
    exits = {
	"north";
	if (bus_object.isIn(self))
	    " and in";
    }
    noexit = { "If you wander too far you might miss your bus. "; return nil; }
    north = {
	if (bus_object.location == self) {
	    "You step back from the bus. ";
	    self.bus_goes_away;
	}
	return bus_station;
    }
    south = {
	if (bus_object.location == self) {
	    "You hang back for a moment, then finally climb up in the
	     bus.\b";
	    unnotify(self, &dismiss_bus);
	    return bus;
	}
	return self.noexit;
    }
    in = {
	if (bus_object.location == self)
	    return (self.south);
	return (self.north);
    }
;

parking_lot: decoration
    noun = 'lot' 'park'
    adjective = 'parking' 'car'
    location = outside_station
    sdesc = "parking lot"
    ldesc = "The parking lot's just about empty, except for one car. "
    takedesc = "Whatever. "
;

bus_stop: decoration
    noun = 'stop' 'island'
    adjective = 'bus' 'concrete'
    location = outside_station
    sdesc = "bus stop"
    ldesc = "It's not much of a bus stop, really. It's just a concrete
	     island where buses have dropped a lot of oil and grease. "
;

oil_and_grease: decoration
    noun = 'grease' 'oil'
    location = outside_station
    sdesc = "oil and grease"
    ldesc = "Nasty. You'd think Greyhound would have better buses. "
;

single_car: fixeditem
    noun = 'car' 'pinto'
    adjective = 'one' 'single' 'parked'
    location = outside_station
    sdesc = "car"
    ldesc = "It's a beat-up old Pinto. "
    takedesc = "Like that's going to happen. "
    verDoLookin(actor) = "It's pretty dirty. "
    verDoOpen(actor) = {
	"It's locked, and if you do break in, you'll have the cops
	 after you whether you stay or go. ";
    }
    verDoClose(actor) = "The car's already closed. "
    verDoSearch(actor) = {
	"It's closed and locked. ";
    }
    verDoHit(actor) = {
	"You do that and, assuming you do go through with it and
	 take off for LA, the cops'll be after you, too. ";
    }
    doSynonym('Hit') = 'Break' 'Kick'
    verDoEnter(actor) = "The car's locked. "
    doSynonym('Enter') = 'Board'
;

street_lamps: fixeditem
    isThem = true
    noun = 'lamp' 'lamps'
    adjective = 'street'
    location = outside_station
    sdesc = "street lamps"
    ldesc = "They're dotted around the parking lot and bus stop. "
    takedesc = "Whatever. "
;

yellow_light: fixeditem
    noun = 'light'
    adjective = 'yellow'
    location = outside_station
    sdesc = "yellow light"
    ldesc = "It spills down around you from those street lamps. "
    dobjGen(a, v, i, p) = {
	if (v.touch) {
	    "How're you gonna do that? ";
	    exit;
	}
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

old_church_road: fixeditem
    noun = 'road'
    adjective = 'old' 'church'
    location = outside_station
    sdesc = "Old Church Road"
    adesc = (self.sdesc)
    thedesc = (self.sdesc)
    ldesc = "Old Church Road runs east and west in front of the bus station.
	     A ways down the street is the Methodist church that the road
	     got its name from, though you can't see it from here. "
    takedesc = "Whatever. "
    verDoFollow(actor) = { "You're waiting for a bus. Remember?"; }
;

methodist_church: fixeditem
    noun = 'church'
    adjective = 'methodist'
    location = outside_station
    sdesc = "Methodist church"
    ldesc = "You can't see it from here, but what you remember is that
	     it's gone all gray and the wood on it's swelled up. "
    dobjGen(a, v, i, p) = {
	if (v != inspectVerb) {
	    "You can't even see it from here. ";
	    exit;
	}
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

bus_station_object: fixeditem
    noun = 'station'
    adjective = 'bus'
    location = outside_station
    sdesc = "bus station"
    ldesc = "It's behind you, to the north. "
    verDoEnter(actor) = {}
    doEnter(actor) = {
	local dest;

	dest = outside_station.north;
	if (dest != nil)
	    actor.travelTo(dest);
    }
;

// This is the bus object which shows up "inside" the bus station
fake_bus_object: distantItem
    noun = 'bus'
    adjective = 'greyhound' 'grayhound'
    sdesc = "Greyhound bus"
    ldesc = "It looks like the bus to LA. "
;

bus_object: fixeditem
    noun = 'bus'
    adjective = 'greyhound' 'grayhound'
    sdesc = "Greyhound bus"
    ldesc = "The bus is belching smoke and shaking as it idles. Its door
	     is open, and the bus driver is staring at you. The sign over
	     its windshield reads <q>Los Angeles</q>. "
    heredesc = "A bus is idling in front of the station. "
    doRead -> bus_sign
    verDoEnter(actor) = {}
    doEnter(actor) = {
	actor.travelTo(outside_station.south);
    }
    doSynonym('Enter') = 'Board'
;

bus_sign: decoration
    noun = 'sign'
    adjective = 'bus'
    location = bus_object
    sdesc = "bus sign"
    ldesc = "The sign reads <q>Los Angeles</q>. "
    verDoRead(actor) = {}
    doRead(actor) = { self.ldesc; }
;

fake_bus_driver: distantItem
    noun = 'driver' 'man'
    adjective = 'bus'
    location = bus_object
    sdesc = "bus driver"
    ldesc = "As tired as he looks, he must've been driving a while. "
    itisdesc = "he's"
    verDoTalkto(actor) = {
	"There's no way he can hear you over the idling bus. ";
    }
;

bus: busRm
    jeanieJustTalked = nil   // Did Jeanie just talk to bus driver?
    doorsOpen = true
    ejectCounter = 1
    sdesc = "Inside the Bus"
    ldesc = "The bus is empty except for you and the bus driver, but
	     it still smells like old people and cigarettes. At least
	     you have your pick of seats. "
    firstseen = {
	"\bThe bus driver looks at you. <q>Staying or going?</q>\ he
	 asks, his hand out for your ticket. You think about mom putting
	 a roast in the oven. ";
	notify(self, &eject_jeanie, 3);
    }
    time_to_go = {
	"\b<q>I said, grab a seat! We gotta move,</q> the bus driver
	 tells you. ";
	bus_seats.doSiton(jeanieMe);
    }
    clearJustTalkedFlag = { self.jeanieJustTalked = true; }
    eject_jeanie = {
	if (ticket.isIn(bus_driver))
	    return;
	switch (self.ejectCounter) {
	  case 1:
	    if (self.jeanieJustTalked)
		"The driver holds his hand out again for your ticket. ";
	    else "\b<q>You gonna give me that ticket or what?</q>
		  the bus driver asks you. You look at him, then
		  away. ";
	    notify(self, &eject_jeanie, 2);
	    break;
	  case 2:
	    "\b<q>Okay, look, miss, I gotta go now. Are you coming?</q> ";
	    notify(self, &eject_jeanie, 2);
	    break;
	  case 3:
	    "\b<q>I can't wait any more. You gotta get off.</q> He
	     gently moves you down the steps and out the bus.\b";
	    outside_station.steppedOffBus = true;
	    jeanieMe.travelTo(outside_station);
	}
	self.ejectCounter++;
    }
    exits = 'north'
    north = {
	if (self.doorsOpen) {
	    outside_station.steppedOffBus = true;
	    return outside_station;
	}
	"The doors to the bus are closed. ";
	return nil;
    }
    south = (self.north)
    east = (self.north)
    west = (self.north)
    out = (self.north)
;

bus_driver: Actor
    isHim = true
    noun = 'driver' 'man'
    adjective = 'bus'
    location = bus
    sdesc = "bus driver"
    ldesc = {
	if (ticket.location == self)
	    "He's blinking sleepily at the road, getting ready for the
	     next leg of his trip. ";
	else "He's looking at you, waiting for your ticket. ";
    }
    actorDesc = {
	if (ticket.location == self)
	    "The bus driver's checking his mirrors and gauges. ";
	else "The bus driver is looking at you, waiting. ";
    }
    verIoGiveTo(actor) = {
	if (ticket.location == self)
	    "<q>The ticket'll be plenty enough, thanks.</q> ";
    }
    ioGiveTo(actor, dobj) = {
	if (dobj != ticket)
	    "The bus driver rolls his eyes. <q>This ain't a swap meet.</q> ";
	else {
	    ticket.moveInto(self);
	    "<q>Now we're cooking with Crisco.</q> He takes the
	     ticket from you and swings shut the doors. <q>Grab a
	     seat.</q> ";
	    bus.doorsOpen = nil;
	    notify(bus, &time_to_go, 2);
	}
    }
    ioSynonym('GiveTo') = 'ShowTo'
    verGrab(obj) = {
	// Bus driver only ever has ticket
	"<q>Look, miss, you don't get your ticket back. That's not
	 how it works.</q> He continues getting the bus ready to leave. ";
    }
;

bus_seats: chairitem
    isThem = true
    noun = 'seat' 'seats'
    adjective = 'blue' 'off-blue'
    location = bus
    sdesc = "seats"
    ldesc = {
	"They're an odd off-blue color. ";
	if (itemcnt(self.contents))
	    "On one of them is <<listcont(self)>>. ";
    }
    verDoSiton(actor) = {
	if (ticket.location != bus_driver)
	    "The bus driver stops you. <q>Not unless you got a
	     ticket.</q> ";
    }
    doSiton(actor) = {
	"You pick a seat at random and flop into it. ";
	if (flowerdy_bag.isIn(actor))
	    "The flowerdy bag goes over the seat; your head goes
	     against the headrest. ";
	else "You put your head against the headrest with a sigh. ";
	"\bThe bus moves with a jerk, the brakes squealing as the
	 driver coaxes the bus out of the station and onto the
	 road. You close your eyes, letting the glow of street
	 lights play over you, light then dark, light then dark. One
	 last glance at the houses slipping past, fading away into
	 the night, before you close your eyes and try to sleep. ";
	die();
    }
    doSynonym('Siton') = 'Take'
;
