#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "AHA.h"

/* 
 *   crow.t 
 
     The code for the crow NPC encountered at the top of Skull Mountain
 */

crow : Person 'large ugly black carrion crow/bird/raven' 'carrion crow' 
    @skullMountain
    "It's a large ugly black bird -- large even for a crow. "
    isHim = true 
    isIt = true
    throwTargetHitWith(projectile, path)
    {
        "<q>Stone the crows!</q> squawks the crow as he dodges your missile,
        <q>What did I do to deserve that? Show some manners, for pity's
        sake!</q> <.reveal talking-crow>";
        
        projectile.moveInto(location);
    }
    beforeAction()
    {
        if(gActionIs(Take) && gDobj==bonePile)
        {
            "The crow pecks at your hand, driving you away from his bones. ";
            exit;
        }
        inherited;
    }
    afterAction()
    {
        if(gActionIn(PutOn, AttachTo) && gDobj.ofKind(Word) 
           && gIobj is in (titulus, centralCross))
            "<.p>The crow flutters over to inspect the new opening, pokes his
            beak inside, but then evidently deciding against investigating any
            futher, returns to his pile of bones. ";
    }
    beforeTravel(traveler, connector)
    {
        if(traveler.contents.length > 0 && connector == crossHole)
        {
            "Something prevents your fitting through the hole.\b
            <q>That's a grave down there!</q> the crow squawks at you, <q>you
            can't take anything with you to the grave!</q> ";
            exit;
        }
        else
            inherited(traveler, connector);
        
    }
    uselessToAttackMsg = 'He could easily avoid your clumsy blows by flying out
        of range, and that beak looks like it could do you some serious
        damage. '
    cannotKissActorMsg = 'He\'s not your type: his beak and your lips just
        wouldn\'t work together. '
    cannotTakeMsg = 'The carrion crow easily evades your attempts to catch
        him. '
    hugResponse = "Sure -- hug a crow -- great idea. Get real! "
    cannotEatMsg = 'You\'d have to kill him first, and then cook him, but you
        can\'t even catch him. Besides, when you think about what <i>he\'s</i>
        been eating, the idea of ingesting him loses any remote appeal it might
        otherwise have had. '
    
;

+ InConversationState
    specialDesc = "The crow is perched on top of the pile of bones, looking at
        you with his head cocked to one side. "
;

++ ConversationReadyState
    isInitState = true
    specialDesc = "A large black carrion crow is pecking away at the pile
        of bones. "
;

+++ HelloTopic, StopEventList
    [ '<q>Excuse me, Mr Crow,</q> you begin.<.p>
    <q>Who ever heard of a talking crow?</q> the crow squawks back, <q>But
    since I <i>am</i> talking, what did you want?</q><.reveal talking-crow>',
        '<q>Hello again,</q> you say.\b
        <q>Oh, it\'s you again!</q> cries the crow, <q>Come to crow again? Get
        it? Crow? Haw! Haw! Haw!</q>',
        '<q>Hi there!</q> you greet the crow.\b
        <q>Hi yourself!</q> he replies. '
    ]
;

+++ ImpByeTopic
    "The crow resumes pecking at the pile of bones. "
;

+++ ByeTopic
    "<q>Well, cheerio then!</q> you say.\b
    In reply, the crow merely squawks, and returns to his pile of bones. "
;

++ AskTopic, StopEventList @crow
    [
        '<q>What are you doing here?</q> you ask him.\b
        <q>Picking at bones. What does it look like?</q> he replies. ',
        
        '<q>How long have you been here?</q> you wonder.\b
        <q>As long as they have,</q> he replies, indicating the three crosses
        with a sweep of his starboard wing. ' 
    ]
;

++ AskAboutForTopic, StopEventList @bonePile
    [
        '<q>What are those bones doing there?</q> you inquire.\b
        <q>What a to-do, what a to-do!</q> croaks the crow, <q>Three crosses
        and only two sets of bones!</q>',
        
        '<q>Can I take a closer look at those bones?</q> you ask.\b
        <q>You can take a <i>look</i>, just as long as you don\'t try to take
        the bones!</q> the crow tells you. '    
    ]
;

++ AskTopic, StopEventList @wordPile
    [
        '<q>What on earth are these words doing here?</q> you wonder.<.p>
        <q>Well,</q> he replies, <q>I\'m only an illiterate bird-brain who\'s
        not meant to understand these things, but it seems to me that there\'s
        two places round here where there\'s a word where you might expect to
        find one, and one place where there\'s not, so it might be a good idea
        to try putting the right word in the right place.</q>',
        
        '<q>But how did these words get among the bones?</q> you ask.<.p>
        <q>Perhaps they came from a similar place,</q> he suggests.',
        
        '<q>So you want me to put one of these words somewhere?</q><.p>
        <q>Well, it would kind of make things right,</q> the crow opines,
        <q>and since I don\'t really understand these things, I reckon you\'ll
        have to do it.</q>',
        
        '<q>But which word should I choose?</q> you want to know.<.p>
        <q>Whichever seems the most appropriate,</q> the crow replies, <q>I\'m
        only a poor bird-brain who doesn\'t understand these things, so the
        choice is up to you.</q>'        
    ]
    
;

++ AskTopic, StopEventList @centralCross
    [
        '<q>What are these crosses doing here?</q> you ask.\b
        <q>They were used to crucify criminals,</q> the crow tells you.<.reveal
        criminals> ',
        
        '<q>Who was crucified on these crosses?</q> you want to know.\b
        In reply the crow flaps his wings and flies over to the southernmost
        cross. He pecks at its titulus and remarks, <q>Well, if you can read,
        which is more than I can, you can see what was crucified
        <i>here</i>.</q> He then flies over to the northernmost cross where he
        repeats the same procedure, pecking at the titulus and squawking,
        <q>And you can see what was crucified <i>here</i>.</q> Finally, he
        flaps his way over to the central cross, taps on its titulus, and
        remarks, <q>But what was crucified <i>here</i>? That\'s the
        question!</q>\b
        This done, the crow returns to his pile of bones. ',
        
        '<q>So you don\'t know who died on that central cross?</q> you ask.\b
        <q>Who -- or what?</q> squawks the crow, <q>Maybe it\'s for you to
        decide!</q>' 
    ]
;

++ AskTellGiveShowTopic @largeStone
    "<q>What's this?</q> you ask, pointing to the stone.\b
    <q>Well, I know I'm only a bird-brain,</q> replies the crow, cocking his
    head to one side, <q>but I'd say it was a stone.</q> "
;

++ AskTellTopic @tCriminals
    "<q>What sort of criminals were crucified here?</q> you ask.\b
    <q>Ones sentenced to death, I suppose,</q> the crow replies, <q>What would
    I care? They taste just as good whatever their crime was!</q> "
    isActive = gRevealed('criminals')
;

++ AskTellTopic @gPlayerChar
    "You tell the crow about your adventures in hell; in response he flaps his
    wings in a gesture that might signify sympathy, understanding, annoyance,
    amusement or simply boredom -- you never were that good at interpreting
    crow body-language. "
;


++ AskTopic @tHell
    "<q>What do you know about hell?</q> you ask.\b
    <q>Hell is other crows,</q> the crow opines. "
;

++ AskTopic, StopEventList @tGod
    [
        '<q>What do you know about God?</q> you inquire.\b
        <q>Only that He created crows in His own image,</q> the crow
        replies. ',
        
        '<q>Do you really think God is like a crow?</q> you ask.\b
        <q>It stands to reason,</q> the crow replies promptly, <q>God is the
        Being than which nothing greater can be conceived -- that can only mean
        a great crow!</q>',
        
        '<q>What else can you tell me about God?</q> you ask.\b   
        <q>I\'ve already told you all I know,</q> the crow assures you. '  
    ]
;


++ AskTopic @tHistoricalJesus
    "<q>Was Jesus crucified here?</q> you want to know.\b
    <q>Do you think I care about the <i>names</i> of these long-dead
    criminals?</q> the crow replies, <q>They were only humans, after
    all!</q><.reveal criminals>"
;

++ AskTopic @tHeaven
    "<q>Is there a heaven?</q> you ask.\b
    <q>This is heaven!</q> the crow declares stoutly, <q>Dead felons to eat and
    no other crows to share them with!</q>"
;

++ AskTopic, StopEventList [felicity, blondeWoman]
    [
        '<q>I don\'t suppose you\'ve seen a pretty blonde woman called Felicity
        Hope round these parts recently, have you?</q> you ask hopefully.\b
        <q>Pretty?</q> croaks the crow, <q>blonde? All you humans look alike to
        me! Hell\'s teeth -- you mostly all <i>taste</i> alike! What would I
        want with a tasty blonde except to peck her eyes out and feast on her
        flesh? Nah -- in any case you\'re the first living human I\'ve seen
        here in centuries!</q>',
        
        'It seems the crow has no useful information to give you on Felicity,
        and you don\'t want to hear him talk about pecking her eyes out
        again. '
    ] 
;

++ SemiDefaultAskTopic, ShuffledEventList
    eventList = 
    [
        {: "<q>What can you tell me about <<gTopicText>>?</q> you ask.\b
            In reply, the crow squawks some incomprehensible reply in
            bird-speak. "},   
        
        'Your question about ' + gTopicText + ' apparently gets the bird into
            something of a flap -- at least, that\'s what he does with his
            wings, and that\'s the only reply you get. ',
        
        '<q>I was wondering about ' + gTopicText + ',</q> you say.\b
            <q>No -- you were just wondering whether I\'m too much of a
            bird-brain to have an opinion on such matters,</q> the crow
            grumbles, <q>Well, I have no intention of giving you the
            satisfaction of finding out!</q>',
        
        '<q>I\'d like your opinion on ' + gTopicText + ',</q> you announce.\b
            The crow cocks his head to one side, stretches his port wing, and then
            launches into a series of rapid squawks that would no doubt be entirely
            comprehensible to another crow. '    
    ]
;

++ DefaultAskTellTopic, ShuffledEventList
    [
        
        '<q>Now what about...?</q> you begin.\b
        <q>Questions, questions, always questions!</q> squawks the crow, <q>Why
        must humans always ask so many questions? I\'m sure it can\'t be
        healthy!</q>',     
            
        'The crow ponders your question for a while, and then apparently
        forgets to answer, returning to his bone pile. ', 
        
        '<q>What...?</q> you start.\b
        <q>Can\'t you see I\'m busy?</q> the crow complains, picking at his
        pile of bones. <q>I don\'t have all day to talk, you know!</q>',
        
        '<q>Can you explain...</q> you begin\b
        <q>Explain? Explain!</q> squawks the crow, suddenly becoming highly
        agitated, <q>You want an explanation from me? You know what my old Dad
        said? Never apologize, never explain!</q> ',
        
        '<q>I\'d like to know...</q> you start to say.\b
        <q>Like to know? Like to know?</q> the crow interrupts, <q>Do I look
        like an educator? This black stuff I\'m wearing isn\'t some academic
        gown, you know, it\'s just my feathers!</q>'  
        
    ]     
;

++ DefaultGiveShowTopic
    "<q>That's no use to me!</q> squawks the crow. "
;

++ DefaultAskForTopic
    "<q>What do you take me for?</q> cries the crow, <q>I never give anyone
    anything! I'm a <i>crow</i> for goodness's sake, not a benevolent
    society!</q>"
;

++ CommandTopic @TopicActionBase
    "It probably doesn't make much sense to tell him to do that. "
    isConversational = nil
;

++ DefaultTCommandTopic
    "<q>Excuse me, Mr Crow, would you <<cmdPhrase>>, please?</q> you ask.\b
    <q>Certainly not!</q> croaks the crow. "
;

