//
// Librera de Visual SINTAC
//
// v2.02 (21.04.2000)
//
// NOTA: este mdulo no debera modificarse directamente. Mirar el mdulo "Usuario".
//

// --------------------------------------------------------
// devuelve el nombre completo (nombre+adjetivo)
// --------------------------------------------------------
Sub NombreCompleto(nombre,adjetivo)
    Declare(txt)

    txt:=nombre
    If adjetivo<>"" Then
        txt:=txt + " " + adjetivo
    EndIf

Return txt

// --------------------------------------------------------
// devuelve el nombre de un objeto (nombre+adjetivo)
// --------------------------------------------------------
Sub NombreObj(obj)

Return NombreCompleto(OBJ[obj].Nombre,OBJ[obj].Adjetivo)

// --------------------------------------------------------
// devuelve el nombre de un PSI (nombre+adjetivo)
// --------------------------------------------------------
Sub NombrePSI(psi)

Return NombreCompleto(PSI[psi].Nombre,PSI[psi].Adjetivo)

// --------------------------------------------------------
// comprueba si un objeto est presente
// --------------------------------------------------------
Sub EstaPresenteObj(obj)
    Declare(ret)

    ret:=FALSE

    If ((OBJ[obj].Contenedor=PSI[PSIJugador].Localidad) | (PSI[PSIJugador].Contiene(obj))) & Not(OBJ[obj].Invisible) Then
        ret:=TRUE
    Endif

Return ret

// --------------------------------------------------------
// comprueba si un PSI est presente
// --------------------------------------------------------
Sub EstaPresentePSI(psi)
    Declare(ret)

    ret:=FALSE

    If (PSI[psi].Localidad=PSI[PSIJugador].Localidad) & Not(PSI[psi].Invisible) Then
        ret:=TRUE
    Endif

Return ret

// --------------------------------------------------------
// devuelve la terminacin 'O' si el objeto/PSI es masculino
// y 'A' si es femenino
// tambin tiene en cuenta el nmero, si es singular o plural
// recibe:
//      'psi' TRUE si se refiere a un PSI, FALSE si a un objeto
//      'nombre' nombre del PSI u objeto al que nos referimos
// --------------------------------------------------------
Sub TMF(psi,nombre)
    Declare(term)

    term:=""
    If psi Then
        Select PSI[nombre].Femenino
            Case TRUE
                term:="a"
            Case FALSE
                term:="o"
        EndSelect
    Else
        Select OBJ[nombre].Femenino
            Case TRUE
                term:="a"
            Case FALSE
                term:="o"
        EndSelect
        If OBJ[nombre].Plural Then
            term:=term + "s"
        EndIf
    EndIf

Return term

// --------------------------------------------------------
// devuelve la terminacin verbal 'N' si el objeto/PSI es plural
// recibe:
//      'psi' TRUE si se refiere a un PSI, FALSE si a un objeto
//      'nombre' nombre del PSI u objeto al que nos referimos
// --------------------------------------------------------
Sub TMFV(psi,nombre)
    Declare(term)

    term:=""
    If psi Then
        If PSI[nombre].Plural Then
            term:="n"
        EndIf
    Else
        If OBJ[nombre].Plural Then
            term:="n"
        EndIf
    EndIf

Return term

// --------------------------------------------------------
// devuelve el artculo correspondiente a un objeto segn su nmero y gnero
// el parmetro 'tipo' indica qu artculo devuelve:
//  0   UN, UNA, UNOS, UNAS
//  1   EL, LA, LOS, LAS
// --------------------------------------------------------
Sub Articulo(obj,tipo)
    Declare(art)

    art:=""
    Select OBJ[obj].Femenino
        Case TRUE
            If OBJ[obj].Plural Then
                If tipo=0 Then
                    art:="unas"
                Else
                    art:="las"
                EndIf
            Else
                If tipo=0 Then
                    art:="una"
                Else
                    art:="la"
                EndIf
            EndIf
        Case FALSE
            If OBJ[obj].Plural Then
                If tipo=0 Then
                    art:="unos"
                Else
                    art:="los"
                EndIf
            Else
                If tipo=0 Then
                    art:="un"
                Else
                    art:="el"
                EndIf
            EndIf
    EndSelect

Return art + " "

// --------------------------------------------------------
// devuelve la descripcin de un objeto que ser un artculo
// seguido de la descripcin corta o del nombre+adjetivo
// si es un objeto de escenario
// --------------------------------------------------------
Sub DescObj(obj)
    Declare(desc)

    If OBJ[obj].Escenario Then
        desc:=Articulo(obj,1) + Lcase(NombreObj(obj))
    Else
        desc:=Articulo(obj,1) + OBJ[obj].DescCorta
    EndIf

Return desc

// --------------------------------------------------------
// devuelve el artculo correspondiente a un PSI segn su nmero y gnero
// --------------------------------------------------------
Sub ArticuloPSI(psi)
    Declare(art)

    art:=""
    If PSI[psi].Femenino Then
        art:="la"
    Else
        art:="le"
    EndIf
    If PSI[psi].Plural Then
        art:=art + "s"
    EndIf

Return art

// --------------------------------------------------------
// da formato e imprime los dilogos de los PSIs
// recibe:
//      'txt_psi' lo que dice el PSI
//      'txt' texto adicional que se imprimir justo detrs
//      de lo que dice el PSI (si se pasa cadena vaca se ignora)
// --------------------------------------------------------
Sub HablaPSI(txt_psi,txt)

    Print(CR + dialogo_psi1 + txt_psi + dialogo_psi2 + tipo_letra + color_letra)
    If txt<>"" Then
        Print(" " + txt)
    EndIf
    Print(CR)
    
Return

// --------------------------------------------------------
// pinta el grfico de una localidad, si le pasamos cadena vaca borra la zona de grficos
// --------------------------------------------------------
Sub GraficoLocalidad(loc)

    If Not(hay_graficos) Then
        Return
    EndIf

    If loc="" Then
        ScreenCls(pant_grf)
    Else
        ScreenImg(pant_grf,LOC[loc].Grafico)
    EndIf

Return

// --------------------------------------------------------
// toca el sonido de una localidad, si le pasamos cadena vaca borra la zona de grficos
// --------------------------------------------------------
Sub SonidoLocalidad(loc)
    Declare(sonido_loc)

    If Not(hay_sonido) Then
        Return
    EndIf

    If loc<>"" Then
        If LOC[loc].Sonido<>"" Then
            sonido_loc:=LoadWav(LOC[loc].Sonido)
            PlayWav(sonido_loc,0,0)
            UnloadWav(sonido_loc)
        EndIf
    EndIf

Return

// --------------------------------------------------------
// espera a que se pulse una tecla
// --------------------------------------------------------
Sub PulsaTecla()

    Print(CR + tipo_letra + "\[N]Pulsa una tecla.\[N]" + CR)
    Pause()

Return

// --------------------------------------------------------
// mueve los PSIs
// este procedimiento usa las siguientes propiedades del PSI:
//
//  MOV_RUTA:    puede tomar los siguientes valores
//               - SEGUIR si se desea que el PSI siga al jugador
//               - un array de verbos de movimiento que describen la ruta
//                 del PSI
//  MOV_PASO:    contiene el ndice del array del siguiente paso de la ruta
//               debera inicializarse a 1
//  MOV_REPETIR: si es 1 el PSI repetir la ruta desde el principio
//               cuando se llegue al final de la misma, para ello
//               se debera definir una ruta circular, es decir, que
//               acabe en la misma localidad donde se inici
//               si es 0 el PSI se parar cuando complete la ruta
// --------------------------------------------------------
Sub PSI_Mueve()
    Declare(i)
    Declare(ruta)
    Declare(long_ruta)
    Declare(paso)
    Declare(mov)
    Declare(movido)
    Declare(loc_ant)

    For i:=0 To NumPSI-1
        // saltamos el PSI del jugador
        If i<>PSIJugador Then
            movido:=FALSE
            loc_ant:=PSI[i].Localidad
            ruta:=PSI[i].Mov_Ruta
            If ruta<>"" Then
                If UCase(ruta)="SEGUIR" Then
                    If PSI[i].Localidad<>PSI[PSIJugador].Localidad Then
                        PSI[i].Localidad:=PSI[PSIJugador].Localidad
                        movido:=TRUE
                    EndIf
                Else
                    long_ruta:=ArrayLen(ruta)
                    paso:=PSI[i].Mov_Paso
                    // por si acaso
                    If paso<1 Then
                        paso:=1
                    EndIf
                    // si el PSI tiene definida una ruta
                    If (paso<=long_ruta) & (long_ruta>0) Then
                        mov:=ArrayItem(ruta,paso)
                        movido:=PSI[i].Mover(mov)
                        If movido Then    
                            // siguiente paso en la ruta
                            If paso<=long_ruta Then
                                paso:=paso+1
                            Else
                                If PSI[i].Mov_Repetir Then
                                    // si ha llegado al final de la ruta vuelve al principio
                                    paso:=1
                                EndIf
                            EndIf
                        EndIf
                    EndIf
                    PSI[i].Mov_Paso:=paso
                EndIf
        
                If movido Then
                    // notificamos al jugador
                    If PSI[PSIJugador].Localidad=loc_ant Then
                        Print(PSI[i].DescCorta + " " + DirPSI(mov) + "." + CR)
                    Else
                        If PSI[PSIJugador].Localidad=PSI[i].Localidad Then
                            Print(PSI[i].DescCorta + " viene." + CR)
                        EndIf
                    EndIf
                EndIf
            EndIf
        EndIf
    Next

Return

// --------------------------------------------------------
// devuelve el texto correspondiente a la direccin de movimiento de un PSI
// --------------------------------------------------------
Sub DirPSI(mov)
    Declare(txt)

    Select Ucase(mov)
        Case "N"
            txt:="va hacia el norte"
        Case "S"
            txt:="va hacia el sur"
        Case "E"
            txt:="va hacia el este"
        Case "O"
            txt:="va hacia el oeste"
        Case "NE"
            txt:="va hacia el noreste"
        Case "NO"
            txt:="va hacia el noroeste"
        Case "SE"
            txt:="va hacia el sureste"
        Case "SO"
            txt:="va hacia el suroeste"
        Case "ARR"
            txt:="sube"
        Case "ABJ"
            txt:="baja"
        Case "ENT"
            txt:="entra"
        Case "SAL"
            txt:="sale"
        Case *
            txt:="se va"
    EndSelect

Return txt

// --------------------------------------------------------
// procedimiento principal
// --------------------------------------------------------
Sub Principal()
    Declare(comando)

    ScreenCls(0)
    USR_Copyright()
    USR_Inicio()

    USR_MusicaFondo()
    DescripcionLocalidad()

    // bucle principal, se encarga de recoger el
    // comando tecleado y procesarlo
    While TRUE
        // lnea de estado
        Screen(pant_info)
        ScreenCls(pant_info)
        If PSI[PSIJugador].Localidad<>"" Then
            Print(tipo_letra_info + "\[N]  " + LOC[PSI[PSIJugador].Localidad].DescCorta + "\[N]")
        EndIf
        USR_LineaEstado()
        Screen(0)

        Print()
        comando:=Input(prompt)
        comando:=Trim(RemoveAc(comando))
        If comando<>"" Then
            ProcesaComando(comando)
            PSI_Mueve()
            turnos:=turnos+1
        EndIf
    Loop

Return

// --------------------------------------------------------
// mueve al jugador en la direccin indicada
// --------------------------------------------------------
Sub MueveJugador()
    Declare(cardinales)
    Declare(txtmov)

    // este array lo definimos para presentar el mensaje correcto si no puede moverse
    // debe contener los verbos de movimiento cardinales (NORTE,SUR,ESTE...) en MAYUSCULAS
    // "No puedes ir hacia el ..." si la palabra de movimiento est en el array
    // "No puedes ..." en otro caso
    cardinales:=Array("NORTE","SUR","ESTE","OESTE","NORESTE","NOROESTE","SURESTE","SUROESTE")

    If InArray(cardinales,ParseVerbo)<>0 Then
        txtmov:="ir hacia el \[C]" + ParseVerbo + "\[C]"
    Else
        txtmov:="\[C]" + ParseVerbo + "\[C]"
    EndIf

    // llamamos a rutina mover de usuario
    If Not(USR_MueveJugador(ParseVerbo)) Then
        Return
    EndIf

    If PSI[PSIJugador].Mover(ParseVerbo) Then
        DescripcionLocalidad()
    Else
        If LOC[PSI[PSIJugador].Localidad].Abierta(ParseVerbo) Then
            Print("No puedes " + txtmov + "." + CR)
        Else
            Print("No puedes " + txtmov + ". Algo te bloquea el paso." + CR)
        EndIf
    EndIf

Return

// --------------------------------------------------------
// describe la localidad actual del jugador
// --------------------------------------------------------
Sub DescripcionLocalidad()
    Declare(locjugador)
    Declare(objetos)
    Declare(numobjetos)
    Declare(psis)
    Declare(numpsis)
    Declare(obj)
    Declare(conexiones)
    Declare(numconexiones)
    Declare(lista)
    Declare(objs_escenario)
    Declare(c)
    Declare(i)

    // indicador de si en la localidad hay o no objetos de escenarios para
    // ajustar los textos de la descripcin
    objs_escenario:=FALSE
    
    locjugador:=PSI[PSIJugador].Localidad
    If locjugador<>"" Then
        SonidoLocalidad(locjugador)

        // comprobamos si la localidad est a oscuras (no est iluminada y no es exterior)
        If Not(LOC[locjugador].Iluminada) & Not(LOC[locjugador].Exterior) Then
            // en caso de que est a oscuras comprobamos si hay una fuente de luz encendida, 
            // bien en la localidad o bien la lleva el jugador encima
            objetos:=Search("*","Luz=1,Encendido=1",0)
            // si no hay fuentes de luz, borramos el grfico, imprimimos el mensaje correspondiente y salimos
            If ArrayLen(objetos)=0 Then
                GraficoLocalidad("")
                Print(CR + "Todo est muy oscuro." + CR)
                Return
            EndIf
        EndIf

        GraficoLocalidad(locjugador)
        Print(LOC[locjugador].DescLarga)

        // objetos que hay en la localidad
        objetos:=LOC[locjugador].Objetos()
        numobjetos:=ArrayLen(objetos)
        If numobjetos>0 Then
            // construimos la lista de objetos separados por comas (,)
            lista:=""
            For i:=1 To numobjetos
                obj:=ArrayItem(objetos,i)
                // si es un objeto de escenario lo incluye
                // en la descripcin de la localidad
                If (OBJ[obj].Escenario) & Not(OBJ[obj].Invisible) Then
                    If Not(objs_escenario) Then
                        // entre el texto de la localidad y los objetos
                        // de escenario, hacemos una salto de lnea
                        Print(CR)
                        objs_escenario:=TRUE
                    EndIf
                    Print(OBJ[obj].DescCorta + ". ")
                Else
                    // slo lo incluye si est visible
                    If Not(OBJ[obj].Invisible) Then
                        c:=Articulo(obj,0) + OBJ[obj].DescCorta
                        lista:=ArrayInsert(lista,ArrayLen(lista)+1,c)
                    EndIf
                EndIf
            Next
            If ArrayLen(lista)>0 Then
                If objs_escenario Then
                    // hacemos un salto de lnea si hay objetos de escenario
                    Print(CR)
                    // indicamos que ya se ha hecho el salto de lnea
                    objs_escenario:=FALSE
                EndIf
                Print(CR + "\[N]Tambin ves:\[N] " + ArrayFormat(lista,", "," y ",".","") + CR)
            EndIf
        EndIf

        // PSIs
        psis:=LOC[locjugador].PSIs()
        numpsis:=ArrayLen(psis)
        If numpsis>0 Then
            lista:=""
            For i:=1 To numpsis
                obj:=ArrayItem(psis,i)
                If Not(PSI[obj].Invisible) Then
                    c:=PSI[obj].DescCorta
                    lista:=ArrayInsert(lista,ArrayLen(lista)+1,c)
                EndIf
            Next
            If objs_escenario Then
                // hacemos un salto de lnea si hay objetos de escenario
                Print(CR)
                // indicamos que ya se ha hecho el salto de lnea
                objs_escenario:=FALSE
            EndIf
            Print(CR + "\[N]Aqu est:\[N] " + ArrayFormat(lista,", "," y ",".","") + CR)
        EndIf       

        // conexiones
        conexiones:=LOC[locjugador].Conexiones()
        numconexiones:=ArrayLen(conexiones)/2
        If numconexiones>0 Then
            If objs_escenario Then
                // hacemos un salto de lnea si hay objetos de escenario
                Print(CR)
                // indicamos que ya se ha hecho el salto de lnea
                objs_escenario:=FALSE
            EndIf
            Print(CR + "\[N]Salidas: \[N]")
            lista:=""
            For i:=1 To numconexiones
                c:=LCase(ArrayItem(conexiones,(i*2)-1))
                lista:=ArrayInsert(lista,ArrayLen(lista)+1,c)
            Next
            Print(ArrayFormat(lista,", "," y ",".","") + CR)
        EndIf
    EndIf

    // si hay objetos de escenario, hacemos un salto de lnea
    // si todava no lo hemos hecho
    If objs_escenario Then
        Print(CR)
    EndIf

Return

// --------------------------------------------------------
// procesa el comando tecleado
// --------------------------------------------------------
Sub ProcesaComando(comando)
    Declare(opc)
    Declare(frase)
    Declare(fichero)

    // limpiamos el verbo que hubiese
    ParseVerbo:=""

    While TRUE
        frase:=Parse(comando)

        // acciones anteriores a que se procese el comando del jugador
        USR_Ant()

        If Not(USR_Respuesta()) Then
            If EsVerboMov Then
                MueveJugador()
            Else
                Select ParseVerbo
                    Case "TURNOS"
                        Print("Turnos: " + turnos + CR)
                        turnos:=turnos-1
                    Case "FIN"
                        opc:=Input("Ests seguro de querer salir? ")
                        If Ucase(Left(opc,1))="S" Then
                            Abandonar()
                        EndIf
                    Case "MIRAR"
                        // si teclea slo MIRAR hace una descripcin de la localidad
                        // si no ejecuta un EXAMINAR
                        If ParseNombre1="" Then
                            ScreenCls(ScreenAct)
                            DescripcionLocalidad()
                        Else
                            Examinar()
                        EndIf
                    Case "EXAMINAR"
                        Examinar()
                    Case "INVENTARIO"
                        Inventario(PSIJugador,0)
                    Case "GUARDAR"
                        fichero:=Input("Nombre del fichero: ")
                        fichero:=Trim(fichero)
                        If fichero<>"" Then
                            If Save(RutaDat + "\\" + fichero) Then
                                Print("El estado del juego ha sido guardado." + CR)
                            Else
                                Print("Error al guardar el estado del juego." + CR)
                            EndIf
                        EndIf
                        turnos:=turnos-1
                    Case "CARGAR"
                        fichero:=Input("Nombre del fichero: ")
                        fichero:=Trim(fichero)
                        If fichero<>"" Then
                            If Load(RutaDat + "\\" + fichero) Then
                                Print("Recuperada la posicin guardada. Pulsa una tecla." + CR)
                                Pause()
                                ScreenCls(ScreenAct)
                                DescripcionLocalidad()
                            Else
                                Print("Error al recuperar la posicin guardada." + CR)
                            EndIf
                        EndIf
                        turnos:=turnos-1
                    Case "COGER"
                        Coger()
                    Case "DEJAR"
                        Dejar()
                    Case "METER"
                        Meter()
                    Case "SACAR"
                        Sacar()
                    Case "ABRIR"
                        Abrir()
                    Case "CERRAR"
                        Cerrar()
                    Case "PONER"
                        Poner()
                    Case "QUITAR"
                        Quitar()
                    Case "ENCENDER"
                        Encender()
                    Case "APAGAR"
                        Apagar()
                    Case "AYUDAR"
                        USR_Ayuda()
                        turnos:=turnos-1
                    Case "ESPERAR"
                        If Not(USR_Esperar()) Then
                            Print("El tiempo pasa inexorablemente..." + CR)
                        EndIf
                    Case "LANZAR"
                        If Not(USR_Lanzar()) Then
                            // el tratamiento por defecto de lanzar es dejar el objeto
                            Dejar()
                        EndIf
                    Case "GOLPEAR"
                        Golpear()
                    Case "ATAR"
                        Atar()
                    Case "DESATAR"
                        Desatar()
                    Case "SABOREAR"
                        Saborear()
                    Case "OLER"
                        Oler()
                    Case "TOCAR"
                        Tocar()
                    Case "ESCUCHAR"
                        Escuchar()
                    Case "CORTAR"
                        Cortar()
                    Case "MOVER"
                        Mover()
                    Case "MATAR"
                        Matar()
                    Case "BEBER"
                        Beber()
                    Case "COMER"
                        Comer()
                    Case "SALTAR"
                        Saltar()
                    Case "GRITAR"
                        Gritar()
                    Case "CANTAR"
                        Cantar()
                    Case "BESAR"
                        Besar()
                    Case "DORMIR"
                        Dormir()
                    Case "DECIR"
                        Decir()
                    Case "DAR"
                        Dar()
                    Case *
                        If comando<>"" Then
                            Print("No entiendo qu quieres decir con \[C]" + comando + "\[C]." + CR)
                        EndIf
                EndSelect
            EndIf
        EndIf

        // acciones posteriores a que se procese el comando del jugador
        USR_Post()

        // salimos si no haba ms para analizar
        If frase="" Then
            Return
        Else
            comando:=frase
        EndIf
    Loop

Return

// --------------------------------------------------------
// finaliza
// --------------------------------------------------------
Sub Abandonar()
    Declare(opc)
    Declare(sonido)

    // paramos la msica de fondo y tocamos sonido de finalizar
    If hay_sonido Then
        UnloadSong(musica_fondo)
        sonido:=LoadWav("#1")
        PlayWav(sonido,12000,64)
    EndIf

    opc:=Input("Otra partida? ")
    If Ucase(Left(opc,1))="N" Then
        Print(CR + "Adios..." + CR)
        Pause()
        If hay_sonido Then
            UnloadWav(sonido)
        EndIf
        Exit
    Else
        If hay_sonido Then
            UnloadWav(sonido)
        EndIf
        Restart
    EndIf

Return

// --------------------------------------------------------
// examinar
// --------------------------------------------------------
Sub Examinar()
    Declare(obj)
    Declare(lista)
    Declare(tipo)
    Declare(lista_desc)
    Declare(i)

    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("Qu quieres examinar?" + CR)
        Return
    EndIf

    If USR_Examinar() Then
        Return
    EndIf

    // buscamos los objetos y PSIs que estn presentes (y visibles) que coincidan con el objeto
    // que se pretende examinar (es decir: el jugador puede haber tecleado EX LLAVE y haber
    // dos o ms llaves presentes)
    lista:=Search(obj,"",0)
    // si no encontramos objetos, probamos con PSIs
    If ArrayLen(lista)=0 Then
        lista:=Search(obj,"",3)
    EndIf

    Select ArrayLen(lista)
        Case 0
            Print("Eso no est por aqu." + CR)
            Return
        Case 1
            // si hemos encontrado slo uno lo cogemos
            obj:=ArrayItem(lista,1)
        Case *
            // si hemos encontrado ms de uno debe especificar cul quiere
            Print("Qu " + LCase(obj) + " quieres examinar?" + CR)
            Return
    EndSelect

    tipo:=TypeOf(obj)
    Select tipo
        // objeto
        Case 2
            // si hemos llegado aqu, el objeto est visible y en la localidad del jugador
            // o lo lleva el jugador encima
            If OBJ[obj].DescLarga="" Then
                Print("Es " + Articulo(obj,1) + OBJ[obj].DescCorta + " como otr" + TMF(FALSE,obj) + " cualquier" + TMF(FALSE,obj) + "." + USR_ExaminarDetalles(FALSE,obj))
            Else
                Print(OBJ[obj].DescLarga + USR_ExaminarDetalles(FALSE,obj))
            EndIf

            // si es un contenedor imprimimos la lista de objetos que tiene, si est abierto
            If OBJ[obj].EsContenedor Then
                If OBJ[obj].Abierto Then
                    Print(" Est" + TMFV(FALSE,obj) + " abiert" + TMF(FALSE,obj) + ".")
                    lista:=OBJ[obj].Objetos
                    If ArrayLen(lista)>0 Then
                        // lista con las descripciones de objetos dentro del contenedor
                        lista_desc:=""
                        For i:=1 To ArrayLen(lista)
                            lista_desc:=ArrayInsert(lista_desc,i,Articulo(ArrayItem(lista,i),0) + OBJ[ArrayItem(lista,i)].DescCorta)
                        Next
                        Print(" Dentro hay " + ArrayFormat(lista_desc,", "," y ",".","nada."))
                    EndIf
                Else
                    Print(" Est" + TMFV(FALSE,obj) + " cerrad" + TMF(FALSE,obj) + ".")
                EndIf
            Else
                // si tiene tapa imprime si est abierto o cerrado
                If OBJ[obj].TieneTapa Then
                    If OBJ[obj].Abierto Then
                        Print(" Est" + TMFV(FALSE,obj) + " abiert" + TMF(FALSE,obj) + ".")
                    Else
                        Print(" Est" + TMFV(FALSE,obj) + " cerrad" + TMF(FALSE,obj) + ".")
                    EndIf
                EndIf
                // si es una fuente de luz imprime si est encendida o apagada
                If OBJ[obj].Luz Then
                    If OBJ[obj].Encendido Then
                        Print(" Est" + TMFV(FALSE,obj) + " encendid" + TMF(FALSE,obj) + ".")
                    Else
                        Print(" Est" + TMFV(FALSE,obj) + " apagad" + TMF(FALSE,obj) + ".")
                    EndIf
                EndIf
            EndIf
            Print()
        // PSI
        Case 3
            // si hemos llegado aqu, el PSI est visible y en la localidad del jugador
            If PSI[obj].DescLarga="" Then
                Print("No tiene nada especial." + USR_ExaminarDetalles(TRUE,obj))
            Else
                Print(PSI[obj].DescLarga + USR_ExaminarDetalles(TRUE,obj))
            EndIf
            // si est muerto...
            If PSI[obj].Muerto Then
                Print(" Est muert" + TMF(TRUE,obj) + ".")
            EndIf
            Inventario(obj,1)
            Print()
        Case *
            Print("No tiene nada de especial." + CR)
    EndSelect

Return

// --------------------------------------------------------
// muestra el inventario de un PSI
// recibe:
//      'psi' nombre del PSI del que queremos el inventario
//      'formato' formato para imprimir el inventario:
//          0: inventario del jugador
//          1: inventario de un PSI
// --------------------------------------------------------
Sub Inventario(psi,formato)
    Declare(objetos)
    Declare(numobjetos)
    Declare(listaobjs)
    Declare(obj)
    Declare(c)
    Declare(i)

    objetos:=PSI[psi].Objetos()
    numobjetos:=ArrayLen(objetos)
    If numobjetos>0 Then
        // construimos la lista de objetos
        listaobjs:=""
        For i:=1 To numobjetos
            obj:=ArrayItem(objetos,i)
            // slo incluimos los objetos visibles
            If Not(OBJ[obj].Invisible) Then
                c:=Articulo(obj,0) + OBJ[obj].DescCorta
                If (OBJ[obj].Prenda) & (OBJ[obj].Puesto) Then
                    c:=c + " (puest" + TMF(FALSE,obj) + ")"
                EndIf
                If ArrayLen(listaobjs)=0 Then
                    listaobjs:=Array(c)
                Else
                    listaobjs:=ArrayInsert(listaobjs,ArrayLen(listaobjs)+1,c)
                EndIf
            EndIf
        Next
    EndIf

    Select formato
        Case 0
            // este formato se usa para el inventario normal del jugador
            // imprimimos el inventario, sustituyendo la coma final por un punto (.)
            If ArrayLen(listaobjs)>=1 Then
                Print("\[N]Llevas:\[N] " + ArrayFormat(listaobjs,", "," y ",".","") + CR)
            Else
                Print("No llevas nada." + CR)
            EndIf
        Case 1
            // este formato se usa para el inventario de los PSIs que examinamos
            // imprimimos el inventario, sustituyendo la coma final por un punto (.)
            If ArrayLen(listaobjs)>=1 Then
                Print(" Lleva " + ArrayFormat(listaobjs,", "," y ",".",""))
            EndIf
    EndSelect

Return

// --------------------------------------------------------
// coger
// --------------------------------------------------------
Sub Coger()
    Declare(i)
    Declare(obj)
    Declare(lista)
    Declare(psi)
    Declare(todo)
    Declare(cogidos)

    psi:=FALSE
    // comprobamos si quiere coger TODO (suponemos que se refiere a todos los objetos, no a PSIs)
    If ParseNombre1="TODO" Then
        lista:=Search("*","",1)
        todo:=TRUE
    Else
        obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
        If obj="" Then
            Print("Qu quieres coger?" + CR)
            Return
        EndIf
        // buscamos los objetos que estn en la localidad (y visibles) que coincidan con el objeto
        // que se pretende coger (es decir: el jugador puede haber tecleado COGER LLAVE y haber
        // dos o ms llaves presentes)
        lista:=Search(obj,"",1)
        todo:=FALSE
    EndIf
    // si no hemos encontrado objetos, probamos con PSIs
    If ArrayLen(lista)<1 Then
        lista:=Search(obj,"",3)
        psi:=TRUE
    EndIf

    If psi Then
        Select ArrayLen(lista)
            Case 0
                Print("No est por aqu." + CR)
            Case 1
                // si hemos encontrado slo uno lo cogemos
                obj:=ArrayItem(lista,1)
                If Not(USR_Coger(TRUE,obj)) Then
                    Print(PSI[obj].DescCorta + " no deja que " + ArticuloPSI(obj) + " cojas en brazos." + CR)
                EndIf            
            Case *
                Print("A qu " + obj + " quieres coger?" + CR)
        EndSelect
    Else
        Select ArrayLen(lista)
            Case 0
                If Not(todo) Then
                    Print("Eso no est por aqu." + CR)
                Else
                    Print("No hay nada que puedas coger." + CR)
                EndIf
                Return
            Case 1
                // si hemos encontrado slo uno lo cogemos
                obj:=ArrayItem(lista,1)
                If Not(USR_Coger(FALSE,obj)) Then
                    // los objetos de escenario no se pueden coger
                    If OBJ[obj].Escenario Then
                        Print("No puedes coger " + DescObj(obj) + "." + CR)
                    Else
                        If PSI[PSIJugador].Coger(obj) Then
                            Print("Has cogido " + DescObj(obj) + "." + CR)
                        Else
                            Print("No puedes coger " + DescObj(obj) + "." + CR)
                        EndIf
                    EndIf
                EndIf
            Case *
                // si hemos encontrado ms de uno y no estamos intentando coger TODO
                // debe especificar cul quiere coger
                If Not(todo) Then
                    Print("Qu " + LCase(obj) + " quieres coger?" + CR)
                    Return
                Else
                    // intentamos coger todos los objetos
                    // llevamos la cuenta de los que hemos podido coger para imprimir un mensaje al final
                    cogidos:=""
                    For i:=1 To ArrayLen(lista)
                        obj:=ArrayItem(lista,i)
                        If Not(USR_Coger(FALSE,obj)) Then
                            // los objetos de escenario no se pueden coger
                            If Not(OBJ[obj].Escenario) Then
                                If PSI[PSIJugador].Coger(obj) Then
                                    cogidos:=ArrayInsert(cogidos,ArrayLen(cogidos)+1,DescObj(obj))
                                EndIf
                            EndIf
                        EndIf
                    Next
    
                    // mostramos un mensaje con los objetos que ha podido coger
                    If ArrayLen(cogidos)=0 Then
                        Print("No hay nada que puedas coger." + CR)
                    Else
                        Print("Has cogido " + ArrayFormat(cogidos,", "," y ",".","") + CR)
                    EndIf
                EndIf
        EndSelect
    EndIf

Return

// --------------------------------------------------------
// dejar
// --------------------------------------------------------
Sub Dejar()
    Declare(i)
    Declare(obj)
    Declare(lista)
    Declare(todo)
    Declare(dejados)
    Declare(psi)

    psi:=FALSE
    // comprobamos si quiere dejar TODO
    If ParseNombre1="TODO" Then
        lista:=Search("*","",2)
        todo:=TRUE
    Else
        obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
        If obj="" Then
            Print("Qu quieres dejar?" + CR)
            Return
        EndIf
        // buscamos los objetos que lleva el jugador (y visibles) que coincidan con el objeto
        // que se pretende dejar (es decir: el jugador puede haber tecleado DEJAR LLAVE y haber
        // dos o ms llaves presentes)
        lista:=Search(obj,"",2)
        todo:=FALSE
    EndIf

    Select ArrayLen(lista)
        Case 0
            If Not(todo) Then
                Print("No tienes eso." + CR)
            Else
                Print("No llevas nada que puedas dejar." + CR)
            EndIf
            Return
        Case 1
            // si hemos encontrado slo uno lo dejamos
            obj:=ArrayItem(lista,1)
            If Not(USR_Dejar(obj)) Then
                If PSI[PSIJugador].Dejar(obj) Then
                    If OBJ[obj].Puesto Then
                        Print("Primero te lo quitas. ")
                        OBJ[obj].Puesto:=FALSE
                    Endif
                    Print("Has dejado " + DescObj(obj) + "." + CR)
                Else
                    Print("No puedes dejar " + DescObj(obj) + "." + CR)
                EndIf
            EndIf
        Case *
            If Not(todo) Then
                // si hemos encontrado ms de uno debe especificar cul quiere dejar
                Print("Qu " + LCase(obj) + " quieres dejar?" + CR)
                Return
            Else
                // intentamos dejar todos los objetos
                // llevamos la cuenta de los que hemos podido dejar para imprimir un mensaje al final
                dejados:=""
                For i:=1 To ArrayLen(lista)
                    obj:=ArrayItem(lista,i)
                    If Not(USR_Dejar(obj)) Then
                        If PSI[PSIJugador].Dejar(obj) Then
                            If OBJ[obj].Puesto Then
                                OBJ[obj].Puesto:=FALSE
                            Endif
                            dejados:=ArrayInsert(dejados,ArrayLen(dejados)+1,DescObj(obj))
                        EndIf
                    EndIf
                Next

                // mostramos un mensaje con los objetos que ha podido dejar
                If ArrayLen(dejados)=0 Then
                    Print("No puedes dejar nada." + CR)
                Else
                    Print("Has dejado " + ArrayFormat(dejados,", "," y ",".","") + CR)
                EndIf
            EndIf
    EndSelect

Return

// --------------------------------------------------------
// meter en un contenedor
// --------------------------------------------------------
Sub Meter()
    Declare(i)
    Declare(obj)
    Declare(lista)
    Declare(todo)
    Declare(obj_contenedor)
    Declare(lista_contenedores)
    Declare(metidos)

    // comprobamos si quiere meter TODO
    If ParseNombre1="TODO" Then
        lista:=Search("*","",2)
        todo:=TRUE
    Else
        obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
        If obj="" Then
            Print("Qu quieres meter?" + CR)
            Return
        EndIf
        // buscamos los objetos que lleva el jugador (y visibles) que coincidan con el objeto
        // que se pretende meter (es decir: el jugador puede haber tecleado METER LLAVE EN BOLSA
        // y haber dos o ms llaves presentes)
        lista:=Search(obj,"",2)
        todo:=FALSE
    EndIf

    // dnde quiere meterlo
    obj_contenedor:=NombreCompleto(ParseNombre2,ParseAdjetivo2)
    If obj_contenedor="" Then
        Print("Dnde quieres meterlo?" + CR)
        Return
    EndIf

    // miramos si esta el objeto contenedor
    lista_contenedores:=Search(obj_contenedor,"EsContenedor=1",0)
    Select ArrayLen(lista_contenedores)
        Case 0
            Print("No puedes meter nada ah." + CR)
            Return
        Case 1
            obj_contenedor:=ArrayItem(lista_contenedores,1)
        Case *
            Print("En cul " + Lcase(obj_contenedor) + " quieres meterlo?" + CR)
            Return
    EndSelect

    // miramos si el contenedor est cerrado
    If Not(OBJ[obj_contenedor].Abierto) Then
        Print("No puedes meter nada en " + DescObj(obj_contenedor) + ". Est" + TMFV(FALSE,obj) + " cerrad" + TMF(FALSE,obj_contenedor) + "." + CR)
        Return
    EndIf

    Select ArrayLen(lista)
        Case 0
            If Not(todo) Then
                Print("No tienes eso." + CR)
            Else
                Print("No llevas nada que puedas meter en " + DescObj(obj_contenedor) + "." + CR)
            EndIf
            Return
        Case 1
            // si hemos encontrado slo uno lo metemos
            obj:=ArrayItem(lista,1)

            // comprobamos si es el propio contenedor
            If obj=obj_contenedor Then
                Print("No seas bruto!" + CR)
                Return
            EndIf
    
            If Not(USR_Meter(obj,obj_contenedor)) Then
                If OBJ[obj].Meter(obj_contenedor) Then
                    Print("Has metido " + DescObj(obj) + " en " + DescObj(obj_contenedor) + "." + CR)
                Else
                    Print("No puedes meter " + DescObj(obj) + " en " + DescObj(obj_contenedor) + "." + CR)
                EndIf
            EndIf
        Case *
            If Not(todo) Then
                // si hemos encontrado ms de uno debe especificar cul quiere meter
                Print("Qu " + LCase(obj) + " quieres meter?" + CR)
                Return
            Else
                // intentamos meter todos los objetos
                // llevamos la cuenta de los que hemos podido meter para imprimir
                // un mensaje al final
                metidos:=""
                For i:=1 To ArrayLen(lista)
                    obj:=ArrayItem(lista,i)
                    // nos saltamos el propio contenedor
                    If obj<>obj_contenedor Then
                        If Not(USR_Meter(obj,obj_contenedor)) Then
                            If OBJ[obj].Meter(obj_contenedor) Then
                                metidos:=ArrayInsert(metidos,ArrayLen(metidos)+1,DescObj(obj))
                            EndIf
                        EndIf
                    EndIf
                Next

                // mostramos un mensaje con los objetos que ha podido meter
                If ArrayLen(metidos)=0 Then
                    Print("No puedes meter nada en " + DescObj(obj_contenedor) + "." + CR)
                Else
                    Print("Has metido " + ArrayFormat(metidos,", "," y ","","") + " en " + DescObj(obj_contenedor) + "." + CR)
                EndIf
            EndIf
    EndSelect

Return

// --------------------------------------------------------
// sacar de un contenedor
// --------------------------------------------------------
Sub Sacar()
    Declare(i)
    Declare(obj)
    Declare(lista)
    Declare(todo)
    Declare(obj_contenedor)
    Declare(lista_contenedores)
    Declare(sacados)

    // de dnde quiere sacarlo
    obj_contenedor:=NombreCompleto(ParseNombre2,ParseAdjetivo2)
    If obj_contenedor="" Then
        Print("De dnde quieres sacar cosas?" + CR)
        Return
    EndIf

    // miramos si hay algn objeto contenedor
    lista_contenedores:=Search(obj_contenedor,"EsContenedor=1",0)
    Select ArrayLen(lista_contenedores)
        Case 0
            Print("No puedes sacar nada de ah." + CR)
            Return
        Case 1
            obj_contenedor:=ArrayItem(lista_contenedores,1)
        Case *
            Print("De cul " + Lcase(obj_contenedor) + " quieres sacarlo?" + CR)
            Return
    EndSelect

    // miramos si el contenedor est cerrado
    If Not(OBJ[obj_contenedor].Abierto) Then
        Print("No puedes sacar nada de " + DescObj(obj_contenedor) + ". Est" + TMFV(FALSE,obj) + " cerrad" + TMF(FALSE,obj_contenedor) + "." + CR)
        Return
    EndIf

    // comprobamos si quiere sacar TODO
    If ParseNombre1="TODO" Then
        lista:=Search("*","Contenedor=" + NombreObj(obj_contenedor),9)
        todo:=TRUE
    Else
        obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
        If obj="" Then
            Print("Qu quieres sacar?" + CR)
            Return
        EndIf
        // buscamos los objetos que hay en el contenedor (y visibles) que coincidan con el objeto
        // que se pretende sacar (es decir: el jugador puede haber tecleado SACAR LLAVE DE BOLSA
        // y haber dos o ms llaves en el contenedor)
        lista:=Search(obj,"Contenedor=" + NombreObj(obj_contenedor),9)
        todo:=FALSE
    EndIf

    Select ArrayLen(lista)
        Case 0
            If Not(todo) Then
                Print("Eso no est en " + DescObj(obj_contenedor) + "." + CR)
            Else
                Print("No hay nada que puedas sacar de " + DescObj(obj_contenedor) + "." + CR)
            EndIf
            Return
        Case 1
            // si hemos encontrado slo uno, lo sacamos
            obj:=ArrayItem(lista,1)

            If Not(USR_Sacar(obj,obj_contenedor)) Then
                OBJ[obj].TipoContenedor:=2
                OBJ[obj].Contenedor:=NombrePSI(PSIJugador)
                Print("Has sacado " + DescObj(obj) + " de " + DescObj(obj_contenedor) + "." + CR)
            EndIf
        Case *
            If Not(todo) Then
                // si hemos encontrado ms de uno debe especificar cul quiere sacar
                Print("Qu " + LCase(obj) + " quieres sacar?" + CR)
                Return
            Else
                // intentamos sacar todos los objetos
                // llevamos la cuenta de los que hemos podido sacar para imprimir
                // un mensaje al final
                sacados:=""
                For i:=1 To ArrayLen(lista)
                    obj:=ArrayItem(lista,i)
                    If Not(USR_Sacar(obj,obj_contenedor)) Then
                        OBJ[obj].TipoContenedor:=2
                        OBJ[obj].Contenedor:=NombrePSI(PSIJugador)
                        sacados:=ArrayInsert(sacados,ArrayLen(sacados)+1,DescObj(obj))
                    EndIf
                Next

                // mostramos un mensaje con los objetos que ha podido sacar
                If ArrayLen(sacados)=0 Then
                    Print("No puedes sacar nada de " + DescObj(obj_contenedor) + "." + CR)
                Else
                    Print("Has sacado " + ArrayFormat(sacados,", "," y ","","") + " de " + DescObj(obj_contenedor) + "." + CR)
                EndIf
            EndIf
    EndSelect

Return

// --------------------------------------------------------
// abrir objeto
// --------------------------------------------------------
Sub Abrir()
    Declare(obj)
    Declare(lista)

    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("Qu quieres abrir?." + CR)
        Return
    EndIf

    // buscamos el objeto que queremos abrir
    lista:=Search(obj,"",0)
    Select ArrayLen(lista)
        Case 0
            If Not(USR_Abrir(obj)) Then
                Print("Eso no se puede abrir." + CR)
            EndIf
            Return
        Case 1
            obj:=ArrayItem(lista,1)
        Case *
            Print("Qu " + Lcase(obj) + " quieres abrir?" + CR)
            Return
    EndSelect

    If Not(USR_Abrir(obj)) Then
        // slo se pueden abrir objetos con tapa
        If OBJ[obj].TieneTapa Then
            If OBJ[obj].Abierto Then
                Print("Ya est" + TMFV(FALSE,obj) + " abiert" + TMF(FALSE,obj) + " ")
            Else
                OBJ[obj].Abierto:=TRUE
                Print("Has abierto ")
            EndIf        
        Else
            Print("No puedes abrir ")
        EndIf

        Print(DescObj(obj) + "." + CR)
    EndIf

Return

// --------------------------------------------------------
// cerrar objeto con tapa
// --------------------------------------------------------
Sub Cerrar()
    Declare(obj)
    Declare(lista)

    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("Qu quieres cerrar?." + CR)
        Return
    EndIf

    // buscamos el objeto que queremos cerrar
    lista:=Search(obj,"",0)
    Select ArrayLen(lista)
        Case 0
            If Not(USR_Cerrar(obj)) Then
                Print("Eso no se puede cerrar." + CR)
            EndIf
            Return
        Case 1
            obj:=ArrayItem(lista,1)
        Case *
            Print("Qu " + Lcase(obj) + " quieres cerrar?" + CR)
            Return
    EndSelect

    If Not(USR_Cerrar(obj)) Then
        // slo se pueden cerrar objetos con tapa
        If OBJ[obj].TieneTapa Then
            If OBJ[obj].Abierto Then
                OBJ[obj].Abierto:=FALSE
                Print("Has cerrado ")
            Else
                Print("Ya est" + TMFV(FALSE,obj) + " cerrad" + TMF(FALSE,obj) + " ")
            EndIf        
        Else
            Print("No puedes cerrar ")
        EndIf
    
        Print(DescObj(obj) + "." + CR)
    EndIf

Return

// --------------------------------------------------------
// ponerse una prenda
// --------------------------------------------------------
Sub Poner()
    Declare(i)
    Declare(obj)
    Declare(lista)
    Declare(todo)
    Declare(puestos)

    If ParseNombre1="TODO" Then
        lista:=Search("*","Prenda=1",2)
        todo:=TRUE
    Else
        obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
        If obj="" Then
            Print("Qu quieres ponerte?." + CR)
            Return
        EndIf
        // buscamos el objeto que queremos ponernos (lo debe tener cogido)
        lista:=Search(obj,"Prenda=1",2)
        todo:=FALSE
    EndIf

    Select ArrayLen(lista)
        Case 0
            Print("No tienes eso." + CR)
            Return
        Case 1
            obj:=ArrayItem(lista,1)
            If Not(USR_Poner(obj)) Then
                // comprobamos si llevamos puesto el objeto
                If OBJ[obj].Puesto Then
                    Print("Ya tienes puest" + TMF(FALSE,obj) + " " + DescObj(obj) + "." + CR)
                Else
                    OBJ[obj].Puesto:=TRUE
                    Print("Te has puesto " + DescObj(obj) + "." + CR)
                EndIf
            EndIf
        Case *
            If Not(todo) Then
                Print("Qu " + Lcase(obj) + " quieres ponerte?" + CR)
                Return
            Else
                // intentamos ponernos todos los objetos
                // llevamos la cuenta de los que nos hemos podido poner
                // para imprimir un mensaje al final
                puestos:=""
                For i:=1 To ArrayLen(lista)
                    obj:=ArrayItem(lista,i)
                    If Not(USR_Poner(obj)) Then   
                        // slo nos podemos poner prendas que no tengamos puestas
                        If Not(OBJ[obj].Puesto) Then
                            OBJ[obj].Puesto:=TRUE
                            puestos:=ArrayInsert(puestos,ArrayLen(puestos)+1,DescObj(obj))
                        EndIf
                    EndIf
                Next

                // mostramos un mensaje con los objetos que hemos podido ponernos
                If ArrayLen(puestos)=0 Then
                    Print("No hay nada que puedas ponerte." + CR)
                Else
                    Print("Te has puesto " + ArrayFormat(puestos,", "," y ",".","") + CR)
                EndIf
            EndIf
    EndSelect

Return

// --------------------------------------------------------
// quitarse una prenda
// --------------------------------------------------------
Sub Quitar()
    Declare(i)
    Declare(obj)
    Declare(lista)
    Declare(todo)
    Declare(quitados)

    If ParseNombre1="TODO" Then
        lista:=Search("*","Prenda=1",2)
        todo:=TRUE
    Else
        obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
        If obj="" Then
            Print("Qu quieres quitarte?." + CR)
            Return
        EndIf
        // buscamos el objeto que queremos quitarnos (lo debe tener puesto)
        lista:=Search(obj,"Prenda=1",2)
        todo:=FALSE
    EndIf

    Select ArrayLen(lista)
        Case 0
            Print("No llevas eso puesto." + CR)
            Return
        Case 1
            obj:=ArrayItem(lista,1)
            If Not(USR_Quitar(obj)) Then
                // comprobamos si llevamos puesto el objeto
                If OBJ[obj].Puesto Then
                    OBJ[obj].Puesto:=FALSE
                    Print("Te has quitado " + DescObj(obj) + "." + CR)                
                Else
                    Print("Ya tienes quitad" + TMF(FALSE,obj) + " " + DescObj(obj) + "." + CR)
                EndIf
            EndIf
        Case *
            If Not(todo) Then
                Print("Qu " + Lcase(obj) + " quieres quitarte?" + CR)
                Return
            Else
                // intentamos quitarnos todos los objetos
                // llevamos la cuenta de los que nos hemos podido quitar
                // para imprimir un mensaje al final
                quitados:=""
                For i:=1 To ArrayLen(lista)
                    obj:=ArrayItem(lista,i)
                    If Not(USR_Quitar(obj)) Then   
                        // slo nos podemos quitar prendas que tengamos puestas
                        If OBJ[obj].Puesto Then
                            OBJ[obj].Puesto:=FALSE
                            quitados:=ArrayInsert(quitados,ArrayLen(quitados)+1,DescObj(obj))
                        EndIf
                    EndIf
                Next

                // mostramos un mensaje con los objetos que hemos podido quitarnos
                If ArrayLen(quitados)=0 Then
                    Print("No llevas nada que puedas quitarte." + CR)
                Else
                    Print("Te has quitado " + ArrayFormat(quitados,", "," y ",".","") + CR)
                EndIf
            EndIf
    EndSelect

Return

// --------------------------------------------------------
// encender una fuente de luz
// --------------------------------------------------------
Sub Encender()
    Declare(obj)
    Declare(lista)

    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("Qu quieres encender?." + CR)
        Return
    EndIf

    // buscamos el objeto que queremos encender (debe estar presente o cogido y ser fuente de luz)
    lista:=Search(obj,"Luz=1",0)

    Select ArrayLen(lista)
        Case 0
            If Not(USR_Encender(obj)) Then
                Print("No parece que puedas encender eso." + CR)
            EndIf
            Return
        Case 1
            obj:=ArrayItem(lista,1)
            // comprobamos si el objeto est encendido
            If OBJ[obj].Encendido Then
                Print("Ya est" + TMFV(FALSE,obj) + " encendid" + TMF(FALSE,obj) + " " + DescObj(obj) + "." + CR)
            Else
                Print("Has encendido " + DescObj(obj) + "." + CR)                
                OBJ[obj].Encendido:=TRUE
            EndIf
        Case *
            Print("Qu " + Lcase(obj) + " quieres encender?" + CR)
    EndSelect

Return

// --------------------------------------------------------
// apagar una fuente de luz
// --------------------------------------------------------
Sub Apagar()
    Declare(obj)
    Declare(lista)

    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("Qu quieres apagar?." + CR)
        Return
    EndIf

    // buscamos el objeto que queremos apagar (debe estar presente o cogido y ser fuente de luz)
    lista:=Search(obj,"Luz=1",0)

    Select ArrayLen(lista)
        Case 0
            If Not(USR_Apagar(obj)) Then
                Print("Cmo vas a apagar eso?" + CR)
            EndIf
            Return
        Case 1
            obj:=ArrayItem(lista,1)
            // comprobamos si el objeto est encendido
            If OBJ[obj].Encendido Then
                Print("Has apagado " + DescObj(obj) + "." + CR)                
                OBJ[obj].Encendido:=FALSE
            Else
                Print("Ya est" + TMFV(FALSE,obj) + " apagad" + TMF(FALSE,obj) + " " + DescObj(obj) + "." + CR)
            EndIf
        Case *
            Print("Qu " + Lcase(obj) + " quieres apagar?" + CR)
    EndSelect

Return

// --------------------------------------------------------
// saborear
//
// la propiedad SABOR del objeto o PSI determina el texto
// que se imprimir, si esta propiedad est en blanco se
// imprimir un texto estndar
// --------------------------------------------------------
Sub Saborear()
    Declare(obj)
    Declare(lista)
    Declare(psi)

    psi:=FALSE
    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("Qu quieres saborear o chupar?." + CR)
        Return
    EndIf

    // buscamos el objeto que queremos saborear (debe estar presente)
    lista:=Search(obj,"",0)
    // si no encontramos el objeto probamos con un PSI
    If ArrayLen(lista)<1 Then
        lista:=Search(obj,"",3)
        psi:=TRUE
    EndIf

    If psi Then
        Select ArrayLen(lista)
            Case 0
                If Not(USR_Saborear(TRUE,obj)) Then
                    Print("Puaggg... qu asco!" + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Saborear(TRUE,obj)) Then
                    // si tiene texto de SABOR imprimimos ese, sino imprimimos un mensaje estndar
                    If Len(Trim(PSI[obj].Sabor))>0 Then
                        Print(PSI[obj].Sabor + CR)                
                    Else
                        Print("Parece que a " + PSI[obj].DescCorta + " no le gusta que le peguen lametones." + CR)
                    EndIf
                EndIf
            Case *
                Print("A qu " + Lcase(obj) + " quieres lamer?" + CR)
        EndSelect
    Else
        Select ArrayLen(lista)
            Case 0
                If Not(USR_Saborear(FALSE,obj)) Then
                    Print("Puaggg... qu asco!" + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Saborear(FALSE,obj)) Then
                    // si tiene texto de SABOR imprimimos ese, sino imprimimos un mensaje estndar
                    If Len(Trim(OBJ[obj].Sabor))>0 Then
                        Print(OBJ[obj].Sabor + CR)
                    Else
                        Print("Parece que " + DescObj(obj) + " es" + TMFV(FALSE,obj) + " bastante insipid" + TMF(FALSE,obj) + "." + CR)
                    EndIf
                EndIf
            Case *
                Print("Qu " + Lcase(obj) + " quieres saborear o chupar?" + CR)
        EndSelect
    EndIf

Return

// --------------------------------------------------------
// oler
//
// la propiedad OLOR del objeto o PSI determina el texto
// que se imprimir, si esta propiedad est en blanco se
// imprimir un texto estndar
// --------------------------------------------------------
Sub Oler()
    Declare(obj)
    Declare(lista)
    Declare(psi)

    psi:=FALSE
    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("Qu quieres oler?." + CR)
        Return
    EndIf

    // buscamos el objeto que queremos oler (debe estar presente)
    lista:=Search(obj,"",0)
    // si no encontramos el objeto probamos con un PSI
    If ArrayLen(lista)<1 Then
        lista:=Search(obj,"",3)
        psi:=TRUE
    EndIf

    If psi Then
        Select ArrayLen(lista)
            Case 0
                If Not(USR_Oler(TRUE,obj)) Then
                    Print("No hueles nada particular." + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Oler(TRUE,obj)) Then
                    // si tiene texto de OLOR imprimimos ese, sino imprimimos un mensaje estndar
                    If Len(Trim(PSI[obj].Olor))>0 Then
                        Print(PSI[obj].Olor + CR)                
                    Else
                        Print("Parece que a " + PSI[obj].DescCorta + " no le gusta que le huelan." + CR)
                    EndIf
                EndIf
            Case *
                Print("A qu " + Lcase(obj) + " quieres oler?" + CR)
        EndSelect
    Else
        Select ArrayLen(lista)
            Case 0
                If Not(USR_Oler(FALSE,obj)) Then
                    Print("No hueles nada particular." + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Oler(FALSE,obj)) Then
                    // si tiene texto de OLOR imprimimos ese, sino imprimimos un mensaje estndar
                    If Len(Trim(OBJ[obj].Olor))>0 Then
                        Print(OBJ[obj].Olor + CR)                
                    Else
                        Print("Parece que " + DescObj(obj) + " no despide olores apreciables por tu olfato." + CR)
                    EndIf
                EndIf
            Case *
                Print("Qu " + Lcase(obj) + " quieres oler?" + CR)
        EndSelect
    EndIf

Return

// --------------------------------------------------------
// escuchar
//
// escucha el sonido de una localidad, objeto o PSI,
// se usa la propiedad ESCUCHA para determinar el texto a imprimir
// si se deja en blanco se imprimir un texto estndar
// --------------------------------------------------------
Sub Escuchar()
    Declare(obj)
    Declare(lista)
    Declare(psi)

    psi:=FALSE
    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        // escucha el sonido de la localidad
        // si tiene texto ESCUCHA imprime ese, sino imprime un texto estndar
        If Len(Trim(LOC[PSI[PSIJugador].Localidad].Escucha))>0 Then
            Print(LOC[PSI[PSIJugador].Localidad].Escucha + CR)
        Else
            Print("Todo est en silencio." + CR)
        EndIf
        Return
    EndIf

    // buscamos el objeto que queremos escuchar (debe estar presente)
    lista:=Search(obj,"",0)
    // si no encontramos el objeto probamos con un PSI
    If ArrayLen(lista)<1 Then
        lista:=Search(obj,"",3)
        psi:=TRUE
    EndIf

    If psi Then
        Select ArrayLen(lista)
            Case 0
                // escucha el sonido de la localidad
                // si tiene texto ESCUCHA imprime ese, sino imprime un texto estndar
                If Len(Trim(LOC[PSI[PSIJugador].Localidad].Escucha))>0 Then
                    Print(LOC[PSI[PSIJugador].Localidad].Escucha + CR)
                Else
                    Print("Todo est en silencio." + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Escuchar(TRUE,obj)) Then
                    // si tiene texto ESCUCHA imprime ese, sino imprime un texto estndar
                    If Len(Trim(PSI[obj].Escucha))>0 Then
                        Print(PSI[obj].Escucha + CR)
                    Else
                        Print(PSI[obj].Desccorta + " est en silencio." + CR)
                    EndIf
                EndIf
            Case *
                Print("Qu " + Lcase(obj) + " quieres escuchar?" + CR)
        EndSelect
    Else
        Select ArrayLen(lista)
            Case 0
                // escucha el sonido de la localidad
                // si tiene texto ESCUCHA imprime ese, sino imprime un texto estndar
                If Len(Trim(LOC[PSI[PSIJugador].Localidad].Escucha))>0 Then
                    Print(LOC[PSI[PSIJugador].Localidad].Escucha + CR)
                Else
                    Print("Todo est en silencio." + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Escuchar(FALSE,obj)) Then
                    // si tiene texto ESCUCHA imprime ese, sino imprime un texto estndar
                    If Len(Trim(OBJ[obj].Escucha))>0 Then
                        Print(OBJ[obj].Escucha + CR)
                    Else
                        Print("Te acercas a " + DescObj(obj) + " pero no oyes nada." + CR)
                    EndIf
                EndIf
            Case *
                Print("Qu " + Lcase(obj) + " quieres escuchar?" + CR)
        EndSelect
    EndIf

Return

// --------------------------------------------------------
// tocar
//
// la propiedad TACTO del objeto o PSI determina el texto
// que se imprimir, si esta propiedad est en blanco se
// imprimir un texto estndar
// --------------------------------------------------------
Sub Tocar()
    Declare(obj)
    Declare(lista)
    Declare(psi)

    psi:=FALSE
    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("Qu quieres tocar?." + CR)
        Return
    EndIf

    // buscamos el objeto que queremos tocar (debe estar presente)
    lista:=Search(obj,"",0)
    // si no encontramos el objeto probamos con un PSI
    If ArrayLen(lista)<1 Then
        lista:=Search(obj,"",3)
        psi:=TRUE
    EndIf

    If psi Then
        Select ArrayLen(lista)
            Case 0
                If Not(USR_Tocar(TRUE,obj)) Then
                    Print("No notas nada especial." + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Tocar(TRUE,obj)) Then
                    // si tiene texto de TACTO imprimimos ese, sino imprimimos un mensaje estndar
                    If Len(Trim(PSI[obj].Tacto))>0 Then
                        Print(PSI[obj].Tacto + CR)                
                    Else
                        Print("Parece que a " + PSI[obj].DescCorta + " no le gusta que le toquen." + CR)
                    EndIf
                EndIf
            Case *
                Print("A qu " + Lcase(obj) + " quieres tocar?" + CR)
        EndSelect
    Else
        Select ArrayLen(lista)
            Case 0
                If Not(USR_Tocar(FALSE,obj)) Then
                    Print("No notas nada especial." + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Tocar(FALSE,obj)) Then
                    // si tiene texto de TACTO imprimimos ese, sino imprimimos un mensaje estndar
                    If Len(Trim(OBJ[obj].Tacto))>0 Then
                        Print(OBJ[obj].Tacto + CR)                
                    Else
                        Print("Tocas " + DescObj(obj) + " pero no notas nada fuera de lo normal." + CR)
                    EndIf
                EndIf
            Case *
                Print("Qu " + Lcase(obj) + " quieres tocar?" + CR)
        EndSelect
    EndIf

Return

// --------------------------------------------------------
// golpear
// --------------------------------------------------------
Sub Golpear()
    Declare(obj)
    Declare(lista)
    Declare(psi)

    psi:=FALSE
    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("Qu quieres golpear?." + CR)
        Return
    EndIf

    // buscamos el objeto que queremos golpear (debe estar presente)
    lista:=Search(obj,"",0)
    // si no encontramos el objeto probamos con un PSI
    If ArrayLen(lista)<1 Then
        lista:=Search(obj,"",3)
        psi:=TRUE
    EndIf

    If psi Then
        Select ArrayLen(lista)
            Case 0
                If Not(USR_Golpear(TRUE,obj)) Then
                    Print("Por qu quieres golpear eso?. No parece buena idea." + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Golpear(TRUE,obj)) Then
                    Print("Intentas dar un buen golpe a " + PSI[obj].DescCorta + ", pero te esquiva sin mucha dificultad." + CR)
                EndIf
            Case *
                Print("A qu " + Lcase(obj) + " quieres golpear?" + CR)
        EndSelect
    Else
        Select ArrayLen(lista)
            Case 0
                If Not(USR_Golpear(FALSE,obj)) Then
                    Print("Por qu quieres golpear eso?. No parece buena idea." + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Golpear(FALSE,obj)) Then
                    Print("Golpeas con fuerza " + DescObj(obj) + " pero parece resistir." + CR)
                EndIf
            Case *
                Print("Qu " + Lcase(obj) + " quieres golpear?" + CR)
        EndSelect
    EndIf

Return

// --------------------------------------------------------
// cortar
// --------------------------------------------------------
Sub Cortar()
    Declare(obj)
    Declare(lista)
    Declare(psi)

    psi:=FALSE
    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("Qu quieres cortar?." + CR)
        Return
    EndIf

    // buscamos el objeto que queremos cortar (debe estar presente)
    lista:=Search(obj,"",0)
    // si no encontramos el objeto probamos con un PSI
    If ArrayLen(lista)<1 Then
        lista:=Search(obj,"",3)
        psi:=TRUE
    EndIf

    If psi Then
        Select ArrayLen(lista)
            Case 0
                If Not(USR_Cortar(TRUE,obj)) Then
                    Print("No puedes cortar eso." + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Cortar(TRUE,obj)) Then
                    Print("Quiz no sea buena idea cortar a " + PSI[obj].Desccorta + "." + CR)
                EndIf
            Case *
                Print("A qu " + Lcase(obj) + " quieres cortar?" + CR)
        EndSelect
    Else
        Select ArrayLen(lista)
            Case 0
                If Not(USR_Cortar(FALSE,obj)) Then
                    Print("No puedes cortar eso." + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Cortar(FALSE,obj)) Then
                    Print("No puedes cortar o rasgar " + DescObj(obj) + ", quiz carezcas de herramientas adecuadas." + CR)
                EndIf
            Case *
                Print("Qu " + Lcase(obj) + " quieres cortar?" + CR)
        EndSelect
    EndIf

Return

// --------------------------------------------------------
// atar
// --------------------------------------------------------
Sub Atar()
    Declare(obj)
    Declare(lista)
    Declare(psi)

    psi:=FALSE
    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("Qu quieres atar?." + CR)
        Return
    EndIf

    // buscamos el objeto que queremos atar (debe estar presente)
    lista:=Search(obj,"",0)
    // si no encontramos el objeto probamos con un PSI
    If ArrayLen(lista)<1 Then
        lista:=Search(obj,"",3)
        psi:=TRUE
    EndIf

    If psi Then
        Select ArrayLen(lista)
            Case 0
                If Not(USR_Atar(TRUE,obj)) Then
                    Print("No puedes atar eso." + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Atar(TRUE,obj)) Then
                    Print("No tienes nada con lo que puedas atar a " + PSI[obj].Desccorta + "." + CR)
                EndIf
            Case *
                Print("A qu " + Lcase(obj) + " quieres atar?" + CR)
        EndSelect
    Else
        Select ArrayLen(lista)
            Case 0
                If Not(USR_Atar(FALSE,obj)) Then
                    Print("No puedes atar eso." + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Atar(FALSE,obj)) Then                
                    Print("No tienes nada para atar " + DescObj(obj) + "." + CR)
                EndIf
            Case *
                Print("Qu " + Lcase(obj) + " quieres atar?" + CR)
        EndSelect
    EndIf

Return

// --------------------------------------------------------
// desatar
// --------------------------------------------------------
Sub Desatar()
    Declare(obj)
    Declare(lista)
    Declare(psi)

    psi:=FALSE
    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("Qu quieres desatar?." + CR)
        Return
    EndIf

    // buscamos el objeto que queremos desatar (debe estar presente)
    lista:=Search(obj,"",0)
    // si no encontramos el objeto probamos con un PSI
    If ArrayLen(lista)<1 Then
        lista:=Search(obj,"",3)
        psi:=TRUE
    EndIf

    If psi Then
        Select ArrayLen(lista)
            Case 0
                If Not(USR_Desatar(TRUE,obj)) Then
                    Print("Eso no est atado." + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Desatar(TRUE,obj)) Then
                    Print(PSI[obj].Desccorta + " no est" + TMFV(TRUE,obj) + " atad" + TMF(TRUE,obj) + "." + CR)
                EndIf
            Case *
                Print("A qu " + Lcase(obj) + " quieres desatar?" + CR)
        EndSelect
    Else
        Select ArrayLen(lista)
            Case 0
                If Not(USR_Desatar(FALSE,obj)) Then
                    Print("Eso no est atado." + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Desatar(FALSE,obj)) Then
                    Print("No puedes desatar " + DescObj(obj) + ", no est" + TMFV(FALSE,obj) + " atad" + TMF(FALSE,obj) + "." + CR)
                EndIf
            Case *
                Print("Qu " + Lcase(obj) + " quieres desatar?" + CR)
        EndSelect
    EndIf

Return

// --------------------------------------------------------
// mover
// --------------------------------------------------------
Sub Mover()
    Declare(obj)
    Declare(lista)
    Declare(psi)

    psi:=FALSE
    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("Qu quieres mover?." + CR)
        Return
    EndIf

    // buscamos el objeto que queremos mover (debe estar presente)
    lista:=Search(obj,"",0)
    // si no encontramos el objeto probamos con un PSI
    If ArrayLen(lista)<1 Then
        lista:=Search(obj,"",3)
        psi:=TRUE
    EndIf

    If psi Then
        Select ArrayLen(lista)
            Case 0
                If Not(USR_Mover(TRUE,obj)) Then
                    Print("Est firmemente sujeto." + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Mover(TRUE,obj)) Then
                    Print("No puedes mover a " + PSI[obj].Desccorta + "." + CR)
                EndIf
            Case *
                Print("A qu " + Lcase(obj) + " quieres mover?" + CR)
        EndSelect
    Else
        Select ArrayLen(lista)
            Case 0
                If Not(USR_Mover(FALSE,obj)) Then
                    Print("Est firmemente sujeto." + CR)
                EndIf
                Return
            Case 1
                obj:=ArrayItem(lista,1)
                If Not(USR_Mover(FALSE,obj)) Then
                    Print("No puedes mover " + DescObj(obj) + "." + CR)
                EndIf
            Case *
                Print("Qu " + Lcase(obj) + " quieres mover?" + CR)
        EndSelect
    EndIf

Return

// --------------------------------------------------------
// matar a PSI
// --------------------------------------------------------
Sub Matar()
    Declare(obj)
    Declare(lista)

    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("A quin quieres matar?." + CR)
        Return
    EndIf

    lista:=Search(obj,"",3)

    Select ArrayLen(lista)
        Case 0
            If Not(USR_Matar(obj)) Then
                Print("A quin?." + CR)
            EndIf
            Return
        Case 1
            obj:=ArrayItem(lista,1)
            If Not(USR_Matar(obj)) Then
                Print("Debers calmar tus ansias asesinas y planificar mejor el asesinato de " + PSI[obj].DescCorta + "." + CR)
            EndIf
        Case *
            Print("A qu " + obj + " quieres matar?" + CR)
    EndSelect

Return

// --------------------------------------------------------
// beber
// --------------------------------------------------------
Sub Beber()
    Declare(obj)
    Declare(lista)

    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("Qu quieres beber?." + CR)
        Return
    EndIf

    lista:=Search(obj,"",1)

    Select ArrayLen(lista)
        Case 0
            If Not(USR_Beber(obj)) Then
                Print("No puedes beberte eso." + CR)
            EndIf
            Return
        Case 1
            obj:=ArrayItem(lista,1)
            If Not(USR_Beber(obj)) Then
                Print("No puedes beberte " + DescObj(obj) + "." + CR)
            EndIf
        Case *
            Print("Qu " + obj + " quieres beberte?" + CR)
    EndSelect

Return

// --------------------------------------------------------
// comer
// --------------------------------------------------------
Sub Comer()
    Declare(obj)
    Declare(lista)

    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("Qu quieres comer?." + CR)
        Return
    EndIf

    lista:=Search(obj,"",1)

    Select ArrayLen(lista)
        Case 0
            If Not(USR_Comer(obj)) Then
                Print("No puedes comerte eso." + CR)
            EndIf
            Return
        Case 1
            obj:=ArrayItem(lista,1)
            If Not(USR_Comer(obj)) Then
                Print("No puedes comerte " + DescObj(obj) + "." + CR)
            EndIf
        Case *
            Print("Qu " + obj + " quieres comerte?" + CR)
    EndSelect

Return

// --------------------------------------------------------
// saltar
// --------------------------------------------------------
Sub Saltar()

    If Not(USR_Saltar()) Then
        Print("Saltas." + CR)
    EndIf

Return

// --------------------------------------------------------
// gritar
// --------------------------------------------------------
Sub Gritar()

    If Not(USR_Gritar()) Then
        Print("Gritas, pero nadie te escucha." + CR)
    EndIf

Return

// --------------------------------------------------------
// cantar
// --------------------------------------------------------
Sub Cantar()

    If Not(USR_Cantar()) Then
        Print("Unos curiosos sonidos salen de tu boca, un amago por entonar una cancin. Mejor te dedicas a otra cosa." + CR)
    EndIf

Return

// --------------------------------------------------------
// besar
// --------------------------------------------------------
Sub Besar()
    Declare(obj)
    Declare(lista)

    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        Print("A qu o quien quieres besar?." + CR)
        Return
    EndIf
    lista:=Search(obj,"",3)

    Select ArrayLen(lista)
        Case 0
            Print("No parece buena idea dar un beso a eso." + CR)
            Return
        Case 1
            obj:=ArrayItem(lista,1)
            If Not(USR_Besar(obj)) Then
                If PSI[obj].Localidad=PSI[PSIJugador].Localidad Then
                    Print("Le das un beso carioso a " + PSI[obj].DescCorta + "." + CR)
                Else
                    Print("No ves a " + PSI[obj].DescCorta + " por aqu." + CR)
                EndIf
            EndIf
        Case *
            Print("A quin quieres besar?" + CR)
    EndSelect

Return

// --------------------------------------------------------
// dormir
// --------------------------------------------------------
Sub Dormir()

    If Not(USR_Dormir()) Then
        Print("No logras conciliar el sueo. Quiz ms tarde..." + CR)
    EndIf

Return

// --------------------------------------------------------
// decir algo a PSI
// --------------------------------------------------------
Sub Decir()
    Declare(obj)
    Declare(lista)
    Declare(txt_dice)

    obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
    If obj="" Then
        // si slo hay un PSI en la localidad nos dirigimos a l
        lista:=Search("*","",3)
        If ArrayLen(lista)=2 Then
            obj:=ArrayItem(lista,1)
            If obj=NombrePSI(PSIJugador) Then
                obj:=ArrayItem(lista,2)
            EndIf
        Else
            Print("Con quin quieres hablar?." + CR)
            Return
        EndIf
    EndIf
    lista:=Search(obj,"",3)

    Select ArrayLen(lista)
        Case 0
            Print("No ves a nadie con quien hablar." + CR)
            Return
        Case 1
            obj:=ArrayItem(lista,1)
            If obj=NombrePSI(PSIJugador) Then
                Print("No crees que te tomaran por loco si te ven hablar contigo mismo?" + CR)
            Else
                If ParseFrase="" Then
                    Print("Teclea entrecomillado lo que quieres decir a " + PSI[obj].DescCorta + ".")
                    Print(" Por ejemplo: \[N]decir a " + PSI[obj].DescCorta + " \"HOLA\"\[N]" + CR)
                Else
                    If Not(USR_Decir(obj,ParseFrase)) Then
                        txt_dice:="dice " + PSI[obj].DescCorta + "."
                        // iniciamos otro nivel de parseado
                        ParseVerbo:=""
                        ParseNombre1:=""
                        ParseAdjetivo1:=""
                        ParseNombre2:=""
                        ParseAdjetivo2:=""
                        ParsePreposicion:=""
                        Parse(ParseFrase)
                        Select ParseVerbo
                            Case "HOLA"
                                HablaPSI("Hola.",txt_dice)
                            Case "DAME"
                                PSIDame(obj)
                            Case *
                                Select Random(1,4)
                                    Case 1
                                        Print(PSI[obj].DescCorta + " no te hace caso." + CR)
                                    Case 2
                                        HablaPSI("Perdona no te prestaba atencin. Qu me decas?.",txt_dice)
                                    Case 3
                                        Print("Parece que " + PSI[obj].DescCorta + " no te ha escuchado." + CR)
                                    Case 4
                                        HablaPSI("Ehem... creo que no te entiendo.",txt_dice)
                                EndSelect
                        EndSelect
                    EndIf
                EndIf
            EndIf
        Case *
            Print("A quin quieres dirigir tus palabras?" + CR)
    EndSelect

Return

// --------------------------------------------------------
// dar objeto a PSI
// --------------------------------------------------------
Sub Dar()
    Declare(i)
    Declare(obj)
    Declare(lista)
    Declare(todo)
    Declare(psi)
    Declare(lista_psis)
    Declare(dados)

    // comprobamos si quiere dar TODO
    If ParseNombre1="TODO" Then
        lista:=Search("*","",2)
        todo:=TRUE
    Else
        obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
        If obj="" Then
            Print("Qu quieres dar?" + CR)
            Return
        EndIf
        // buscamos los objetos que lleva el jugador (y visibles) que coincidan con el objeto
        // que se pretende meter (es decir: el jugador puede haber tecleado DAR LLAVE A PEPE
        // y haber dos o ms llaves presentes)
        lista:=Search(obj,"",2)
        todo:=FALSE
    EndIf

    // a quin quiere drselo
    psi:=NombreCompleto(ParseNombre2,ParseAdjetivo2)
    If psi="" Then
        Print("A quin quieres darle eso?" + CR)
        Return
    EndIf

    // miramos si est el PSI
    lista_psis:=Search(psi,"",3)
    Select ArrayLen(lista_psis)
        Case 0
            Print("No puedes darle eso a " + UCase(psi) + ", no est por aqu." + CR)
            Return
        Case 1
            psi:=ArrayItem(lista_psis,1)
        Case *
            Print("A quin de todos ellos quieres drselo?" + CR)
            Return
    EndSelect

    Select ArrayLen(lista)
        Case 0
            If Not(todo) Then
                Print("No tienes eso." + CR)
            Else
                Print("No llevas nada que puedas darle a " + PSI[psi].DescCorta + "." + CR)
            EndIf
            Return
        Case 1
            // si hemos encontrado slo uno se lo damos
            obj:=ArrayItem(lista,1)
   
            If Not(USR_Dar(obj,psi)) Then
                OBJ[obj].TipoContenedor:=2
                OBJ[obj].Contenedor:=psi
                Print("Le das " + DescObj(obj) + " a " + PSI[psi].DescCorta + "." + CR)
            EndIf
        Case *
            If Not(todo) Then
                // si hemos encontrado ms de uno debe especificar cul quiere darle
                Print("Qu " + LCase(obj) + " quieres dar a " + PSI[psi].DescCorta + "?" + CR)
                Return
            Else
                // intentamos dar todos los objetos
                // llevamos la cuenta de los que hemos podido dar para imprimir
                // un mensaje al final
                dados:=""
                For i:=1 To ArrayLen(lista)
                    obj:=ArrayItem(lista,i)
                    If Not(USR_Dar(obj,psi)) Then
                        OBJ[obj].TipoContenedor:=2
                        OBJ[obj].Contenedor:=psi                        
                        dados:=ArrayInsert(dados,ArrayLen(dados)+1,DescObj(obj))
                    EndIf
                Next

                // mostramos un mensaje con los objetos que ha podido dar
                If ArrayLen(dados)=0 Then
                    Print("No puedes darle nada a " + PSI[psi].DescCorta + "." + CR)
                Else
                    Print("Has dado " + ArrayFormat(dados,", "," y ","","") + " a " + PSI[psi].DescCorta + "." + CR)
                EndIf
            EndIf
    EndSelect

Return

// --------------------------------------------------------
// jugador pide objeto a PSI
// recibe:
//      'psi' PSI al que nos dirigimos
// --------------------------------------------------------
Sub PSIDame(psi)
    Declare(i)
    Declare(obj)
    Declare(lista)
    Declare(todo)
    Declare(txt_dice)

    txt_dice:="dice " + PSI[psi].DescCorta + "."

    // comprobamos si quiere que le de TODO
    If ParseNombre1="TODO" Then
        lista:=PSI[psi].Objetos
        If ArrayLen(lista)=0 Then
            HablaPSI("No tengo nada que pueda darte.",txt_dice)
            Return
        EndIf
        todo:=TRUE
    Else
        obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
        If obj="" Then
            HablaPSI("Qu quieres que te d?",txt_dice)
            Return
        EndIf        
        lista:=Search(obj,"TipoContenedor=2,Contenedor=" + psi,9)
        todo:=FALSE
    EndIf

    Select ArrayLen(lista)
        Case 0
            HablaPSI("No tengo eso.",txt_dice)
            Return
        Case 1
            // si hemos encontrado slo uno se lo damos
            obj:=ArrayItem(lista,1)

            If PSI[psi].Dejar(obj) Then
                HablaPSI("Toma " + DescObj(obj) + ".",txt_dice)
                ParseVerbo:="COGER"
                ParseNombre1:=OBJ[obj].Nombre
                ParseAdjetivo1:=OBJ[obj].Adjetivo
                Coger()
            Else
                HablaPSI("No te puedo dar " + DescObj(obj) + ".",txt_dice)
            EndIf
        Case *
            If Not(todo) Then
                // si hemos encontrado ms de uno debe especificar cul debe darle
                HablaPSI("Qu " + LCase(obj) + " quieres que te d?",txt_dice)
                Return
            Else
                // intentamos dar todos los objetos
                For i:=1 To ArrayLen(lista)
                    obj:=ArrayItem(lista,i)
                    If PSI[psi].Dejar(obj) Then
                        HablaPSI("Toma " + DescObj(obj) + ".",txt_dice)
                        ParseVerbo:="COGER"
                        ParseNombre1:=OBJ[obj].Nombre
                        ParseAdjetivo1:=OBJ[obj].Adjetivo
                        Coger()
                    Else
                        HablaPSI("No te puedo dar " + DescObj(obj) + ".",txt_dice)
                    EndIf
                Next
            EndIf
    EndSelect

Return