/* Analizador YACC para el fichero de localidades de Nmesis */

%union
	{
	int entero;
	char cadena[5000];
	}
	
%{
#include <stdio.h>
FILE *fo;
FILE *fh;
FILE *faka;
int marcas[5001];
int maxima;
%}
	
%token TLOC;
%token TFINLOC;
%token TNORTE;
%token TSUR;
%token TESTE;
%token TOESTE;
%token TMAX;
%token TAKA;

%token <cadena> TCADENA;
%token <entero> TENTERO;
%token <cadena> TID;
%token <cadena> TIDM;

%type <entero> LOCM1 LOCM2 SALM1;


%%

S : {
    int i;

    for (i=1;i<=5000;i++) marcas[i]=0;
    maxima=0; /* mxima localidad definida */

    fprintf(fo,"/* DEFINICIN DE LOCALIDADES - GENERADO POR NEMLOC */\n");
    fprintf(fo,"/* Nmesis (C) 2000 Javier Basilio Prez Ramas*/\n");
    fprintf(fo,"#include %clocobj.h%c\n",'"','"');
    fprintf(fh,"/* Generado por Nemloc (C) 2000 Javier Basilio Prez Ramas*/\n");
    fprintf(fh,"#include %clocobj.h%c\n",'"','"');
    fprintf(fh,"struct local* ptrloc(int n);\n");
    fprintf(fh,"void genloc();\n");
    }
    TMAX '=' TENTERO ';' SM1 LLOCS
    {
    fprintf(fo,"}\n");
    }

SM1: {
    fprintf(fo,"struct local locs[%d];\n",($<entero>-1)+1);
    maxima=$<entero>-1;
    fprintf(faka,"#define MAXLOC %d /*mximo nm de localidades*/\n",maxima);
    fprintf(fo,"/* Funcin que devuelve un puntero a una localidad */\n");
    fprintf(fo,"struct local* ptrloc(int n)\n{\n");
    fprintf(fo,"return &(locs[n]);\n}\n/* Funcin que define las localidades */\n");
    fprintf(fo,"void genloc()\n{\n");
    fprintf(fo,"/* pone primero todas las salidas a cero */");
    fprintf(fo,"auto int i;\n");
    fprintf(fo,"for (i=1;i<=%d;i++) {\n",($<entero>-1)+1);
    fprintf(fo,"  locs[i].norte=locs[i].sur=locs[i].este=locs[i].oeste=0; }\n");
    };

LLOCS : LOC ';' LLOCS ;
       | ;
LOC : TLOC TENTERO LOCM1 TCADENA ';' LOCM2 LSALIDAS TFINLOC
	{
	marcas[$3]=1;
	}
	
LOCM1 : { $$=$<entero>0;
	  if (marcas[$$]!=0)
	  	{
	  	printf("La localidad %d fue definida ms de una vez.\n",$$);
	  	return 1;
	  	}
	  if ($$>maxima)
	  	{
	  	printf("La localidad %d excede el mximo declarado.\n",$$);
	  	return 1;
	  	}
	  }
LOCM2 : {
	fprintf(fo,"strcpy(locs[%d].descrip,%c%s%c);\n",$<entero>-2,'"',$<cadena>-1,'"');
	$$=$<entero>-2;
	};

LSALIDAS : SALIDA ';' SALM1 LSALIDAS;
	  | ;
SALM1 : {$$=$<entero>-2;};

SALIDA : TAKA '=' TIDM
	{
	fprintf(faka,"#define %s %d\n",$3,$<entero>0);
	}
	
SALIDA : TNORTE '=' TENTERO
	{
	fprintf(fo,"locs[%d].norte=%d;\n",$<entero>0,$3);
	};
SALIDA : TSUR '=' TENTERO
	{
	fprintf(fo,"locs[%d].sur=%d;\n",$<entero>0,$3);
	};
	
SALIDA : TESTE '=' TENTERO
	{
	fprintf(fo,"locs[%d].este=%d;\n",$<entero>0,$3);
	};
	
SALIDA : TOESTE '=' TENTERO
	{
	fprintf(fo,"locs[%d].oeste=%d;\n",$<entero>0,$3);
	};




%%

#include "lex.yy.c"

main(int argc,char **argv)
{
int v;
puts("NEMLOC - Compilador de fichero de localidades de Nmesis");
puts("(c) 2000 Definitive Software");
puts("Por Javier Basilio Prez Ramas");
fo=fopen("locdef.c","w");
fh=fopen("locdef.h","w");
faka=fopen("lakas.h","w");
if (!fo)
	{
	puts("No puede crearse el fichero destino.");
	return 1;
	}
v=yyparse();
fclose(fo);
fclose(fh);
fclose(faka);
if (v!=0)
	{
	printf("Compilacin detenida con error en lnea %d.\n",numlinea);
	printf("ltimo token reconocido: %s.\n",yytext);
	}
return v;
}


yyerror(char *s)
{
printf("%s\n",s);
}
