! ============================================================================
! Infit (Italian Inform Library)
! ============================================================================
!        Author: Giovanni Riccardi (giovanni@composizioni.com)
!       Version: 2.0
!      Released: 9 October 2002
! Serial Number: 021009
!   Description: "An Inform library to write Interactive Fiction in Italian."
!          Note: For use with Inform 6. (Tested with Inform compiler
!                version 6.21 and Inform library 6/10).
! ============================================================================
!
! FILES IN THE INFIT DISTRIBUTION:
!
!     Italian.h - The Inform Language Definition File for Italian.
!    ItalianG.h - The Italian Grammar File.
!     Replace.h - Some functions in the standard library are replaced
!                 here.
!   leggimi.txt - Informations in Italian.
! copyright.txt - Copyright informations (also in Italian). 
!    guida.html - An INFIT guide in Italian
!
! ============================================================================
!
! COPYRIGHT INFORMATIONS:
!
! Infit copyright (c) 1997 - 2002 by Giovanni Riccardi.
! Some part of the code in these files are copyright 
! (c) 1996 - 1999 by Graham Nelson
!
! Infit is free software. You can freely distribute it with these
! restrictions:
! (a) distributed copies are not substantially different from the
!     original copy archived in the Infit Web Site (see below).
! (b) distributed copies contain this copyright message.
! (c) no profit is involved in the distribution.
!
! Infit is distributed WITHOUT ANY WARRANTY.
!
! ============================================================================
!
! MORE INFO:
!
!   Inform Web Site: http://www.inform-fiction.org
!    Infit Web Site: http://inform.composizioni.com
!       Infit Email: inform@composizioni.com
! My personal Email: giovanni@composizioni.com
!
! ===========================================================================

! LANGUAGE NOTE:
! Since Infit is intended for use of Italian IF Designers, code comments are
! written in Italian.

! ItalianG.h (File per la grammatica Italiana). 
! Numero di Serie: 021009

System_file; 


! ---------------------------------------------------------------------------- 
!  I "meta-verbs", comandi per il gioco piuttosto che dentro il gioco. Alcuni 
!  sono lasciati in inglese per maggior coerenza con l'interprete che  in 
!  inglese. 
! ----------------------------------------------------------------------------



Verb meta 'score' 'punteggio'
				*                                -> Score
                *'completo'/'pieno'              -> FullScore;
Verb meta 'fullscore' 'full' 'punti'
                *                                -> FullScore
                * 'score'                        -> FullScore;
Verb meta 'q//' 'quit' 'die' 'uscire' 'fine' 'basta'
                *                                -> Quit;
Verb meta 'restore' 'carica' 'caricare'
                * 'partita'/'gioco'              -> Restore
                *                                -> Restore;
Verb meta 'restart' 'ricomincia' 'ricominciare'
                * 'partita'/'gioco'              -> Restart
                *                                -> Restart;
Verb meta 'verify' 'verifica' 'verificare'
                * 'gioco'                        -> Verify
                *                                -> Verify;
Verb meta 'save' 'salva' 'salvare'
                * 'partita'/'gioco'              -> Save
                *                                -> Save;
Verb meta 'script' 'transcript' 'trascrizione'
                *                                -> ScriptOn
                * 'off'/'disattivata'            -> ScriptOff
                * 'on'/'disattivata'             -> ScriptOn;
Verb meta 'noscript' 'unscript'
                *                                -> ScriptOff;
Verb meta 'modalit@`a' 'modalita'
                * 'breve'/'corta'                -> LMode3
                * 'normale'                      -> LMode1   
                * 'lunga'/'completa'             -> LMode2;
Verb meta 'superbrief' 'short' 'breve'
                *                                -> LMode3;
Verb meta 'verbose' 'long' 'lungo'
                *                                -> LMode2;
Verb meta 'brief' 'normal' 'normale'
                *                                -> LMode1;
Verb meta 'pronouns' 'nouns' 'pronomi'
                *                                -> Pronouns;
Verb meta 'notify' 'notifica'
                * 'on'/'attivata'                -> NotifyOn
                * 'off'/'disattivata'            -> NotifyOff;
Verb meta 'version' 'versione'
                *                                -> Version;
#IFNDEF NO_PLACES;
Verb meta 'places' 'luoghi' 'posti'
                *                                -> Places;
Verb meta 'objects' 'oggetti'
                *                                -> Objects;
#ENDIF;

! ----------------------------------------------------------------------------
!  Verbi utilizzati nel debug.  
!  Sono stati lasciati in inglese, poich usati solo dai game designers.
! ----------------------------------------------------------------------------

#ifdef DEBUG;
Verb meta 'trace'
                *                                -> TraceOn
                * number                         -> TraceLevel
                * 'on'                           -> TraceOn
                * 'off'                          -> TraceOff;
Verb meta 'actions'
                *                                -> ActionsOn
                * 'on'                           -> ActionsOn
                * 'off'                          -> ActionsOff;
Verb meta 'routines' 'messages'
                *                                -> RoutinesOn
                * 'on'                           -> RoutinesOn
                * 'off'                          -> RoutinesOff;
Verb meta 'timers' 'daemons'
                *                                -> TimersOn
                * 'on'                           -> TimersOn
                * 'off'                          -> TimersOff;
Verb meta 'changes'
                *                                -> ChangesOn
                * 'on'                           -> ChangesOn
                * 'off'                          -> ChangesOff;
Verb meta 'recording'
                *                                -> CommandsOn
                * 'on'                           -> CommandsOn
                * 'off'                          -> CommandsOff;
Verb meta 'replay'
                *                                -> CommandsRead;
Verb meta 'random'
                *                                -> Predictable;
Verb meta 'purloin'
                * multi                          -> XPurloin;
Verb meta 'abstract'
                * noun 'to' noun                 -> XAbstract;
Verb meta 'tree'
                *                                -> XTree
                * noun                           -> XTree;
Verb meta 'goto'
                * number                         -> Goto;
Verb meta 'gonear'
                * noun                           -> Gonear;
Verb meta 'scope'
                *                                -> Scope
                * noun                           -> Scope;
Verb meta 'showverb'
                * special                        -> Showverb;
Verb meta 'showobj'
                *                                -> Showobj
                * multi                          -> Showobj;
#endif;

! ----------------------------------------------------------------------------
!  Ecco finalmente i verbi per il gioco
! ----------------------------------------------------------------------------

Verb 'prendi' 'trasporta' 'afferra' 'raccogli'
                * multi                          -> Take
                * multiinside 'da'/'dal'/'dallo'/'dalla'/'dall^'/
                  'dagli'/'dalle'/'dai' noun         
                                                 -> Remove;
Verb 'stai' 'sta'
                * 'su'/'sul'/'sullo'/'sull^'/'sulla'/'sui'/
                  'sugli'/'sulle'/'sopra' noun 
                                                 -> Enter
                * 'dentro'/'in'/'nel'/'nello'/'nell^'/'nella'/
                  'negli'/'nelle'/'nei' noun 
                                                 -> Enter;
Verb 'rimuovi' 'togli'
                * held                           -> Disrobe
                * worn							 -> Disrobe
                * multi                          -> Take
                * multiinside 'da'/'dal'/'dallo'/'dalla'/'dall^'/
                  'dagli'/'dalle'/'dai' noun          
                                                 -> Remove;
Verb 'indossa'
                * held                           -> Wear;
Verb 'metti' 'mettiti'
                * held                            -> Wear
                * 'gi@`u'/'giu' multiheld         -> Drop
                * multiheld 'gi@`u'/'giu'         -> Drop
                * multiexcept 'dentro'/'in'/'nel'/'nello'/'nell^'/'nella'/
                  'negli'/'nelle'/'nei' noun
                                                 -> Insert
                * multiexcept 'su'/'sul'/'sullo'/'sull^'/'sulla'/'sui'/
                  'sugli'/'sulle'/'sopra' noun 
                                                  -> PutOn;
Verb 'inserisci'
                * multiexcept 'dentro'/'in'/'nel'/'nello'/'nell^'/'nella'/
                  'negli'/'nelle'/'nei' noun
                                                 -> Insert;
Verb 'svuota' 
                * noun                           -> Empty
                * noun 'su'/'sul'/'sullo'/'sull^'/'sulla'/'sui'/
                  'sugli'/'sulle'/'sopra' noun
                                                 -> EmptyT;
Verb 'trasferisci' 'sposta'
                * noun                           -> Push
                * noun 'su'/'sul'/'sullo'/'sull^'/'sulla'/'sui'/
                  'sugli'/'sulle'/'sopra' noun 
                                                 -> Transfer
                * noun 'dentro'/'in'/'nel'/'nello'/'nell^'/'nella'/
                  'negli'/'nelle'/'nei' noun
                                                 -> Transfer;

[ ADirection; if (noun in compass) rtrue; rfalse; ];
Verb 'lascia' 'lancia' 'abbandona' 'posa'
                * multiheld                      -> Drop
                * multiexcept 'dentro'/'in'/'nel'/'nello'/'nell^'/'nella'/
                  'negli'/'nelle'/'nei' noun
                                                 -> Insert
                * multiexcept 'su'/'sul'/'sullo'/'sull^'/'sulla'/'sui'/
                  'sugli'/'sulle'/'sopra' noun 
                                                 -> PutOn
                * held 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle'/'su'/'sul'/'sullo'/'sull^'/'sulla'/'sui'/
                  'sugli'/'sulle'/'sopra'/'contro' noun 
                                                 -> ThrowAt
                * noun=ADirection				 -> Go
                * noun 							 -> Exit;
Verb 'dai' 'paga' 'offri' 'da'
                * held 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' creature            
                                                 -> Give
                * 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' creature held           
                                                 -> Give reverse;
Verb 'mostra' 'presenta'
                * held 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' creature            
                                                 -> Show
                * 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' creature held            
                                                 -> Show reverse;
Verb 'fai' 'fa'
				*								 -> GenericVerb
				* 'inventario'	      			 -> Inv
				* 'vedere' held 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' creature				 -> Show
				* 'vedere' 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' creature held            
                                                 -> Show reverse
                * held 'vedere' 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' creature				 -> Show;
                                               
Verb 'vai' 'cammina' 'corri' 'va'
                *                                -> VagueGo
                * 'fuori'                        -> Exit
                * 'a'/'ad'/'verso' noun=ADirection
												 -> Go
                * noun                           -> Enter 
                * 'dentro'                       -> GoIn
                * 'in'/'nel'/'nello'/'nell^'/'nella'/'nei'/
                  'negli'/'nelle'/'dentro'/'attraverso'/
                   'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' noun
                  								 -> Enter
				* 'su'/'sul'/'sullo'/'sull^'/'sulla'/'sui'/
                  'sugli'/'sulle'/'sopra' noun	 -> Climb;
Verb 'scendi'
                * 'da'/'dal'/'dallo'/'dalla'/'dall^'/'dai'/
                  'dagli'/'dalle' noun           -> Exit
                *                                -> Exit
                * noun                           -> Exit;

Verb 'inventario' 'inv' 'i//'
                *                                -> Inv
                * 'esteso'                       -> InvTall
                * 'completo'                     -> InvWide;
Verb 'guarda' 'g//' 'vedi' 'l//'
				*                                -> Look
                * noun                           -> Examine
                * 'dentro'/'in'/'nel'/'nello'/'nell^'/'nella'/
                  'negli'/'nelle'/'nei'/'attraverso'/
                  'su'/'sul'/'sullo'/'sull^'/'sulla'/'sui'/
                  'sugli'/'sulle'/'sopra' noun
                                                 -> Search
                * 'sotto' noun                   -> LookUnder;
                !* topic 'dentro'/'in'/'nel'/'nello'/'nell^'/'nella'/
                !  'negli'/'nelle'/'nei' noun
                !                                 -> Consult reverse;

Verb 'consulta' * noun 'circa' topic             -> Consult
                * noun 'su'/'sul'/'sullo'/'sull^'/'sulla'/'sui'/
                  'sugli'/'sulle'/'sopra' topic
                                                 -> Consult;
Verb 'apri' 'scopri'
                * noun                           -> Open
                * noun 'con'/'a' held            -> Unlock;
Verb 'chiudi' 'copri'
                * noun                           -> Close
                * noun  'con'/'a' held           -> Lock;
Verb 'entra' 'attraversa' 'visita'
                *                                -> GoIn
                * 'dentro'						 -> GoIn
                * 'dentro'/'in'/'nel'/'nello'/'nell^'/'nella'/
                  'negli'/'nelle'/'nei' noun     -> Enter
                * 'dentro' 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' noun                    -> Enter
                * noun                           -> Enter;
Verb 'siedi' 'siediti' 'sdraiati'               
                * 'su'/'sul'/'sullo'/'sull^'/'sulla'/'sui'/
                  'sugli'/'sulle'/'sopra' noun
                                                 -> Enter
				* 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' noun                    -> Enter
                * 'dentro'/'in'/'nel'/'nello'/'nell^'/'nella'/
                  'negli'/'nelle'/'nei' noun
                                                 -> Enter;
Verb 'in' 'dentro'
                *                                -> GoIn;
Verb 'fuori' 'esci'
                *                                -> Exit
                * 'da'/'dal'/'dallo'/'dalla'/'dall^'/'dai'/
                  'dagli'/'dalle' noun           -> Exit;
Verb 'esamina' 'x//' 'descrivi' 'controlla'
                * noun                           -> Examine;
Verb 'leggi'
                * noun                           -> Examine
                * 'circa' topic 'dentro'/'in'/'nel'/'nello'/'nell^'/'nella'/
                  'negli'/'nelle'/'nei' noun
                                                 -> Consult
                * topic 'dentro'/'in'/'nel'/'nello'/'nell^'/'nella'/
                  'negli'/'nelle'/'nei' noun
                                                 -> Consult;
Verb 'si' 's@`i'
                *                                -> Yes;
Verb 'no//'
                *                                -> No;
Verb 'spiacente' 'scusa'
                *                                -> Sorry;
Verb 'merda' 'cazzo' 'dannazione' 'porco'
                *                                -> Strong;
Verb 'impreca' 'bestemmia' 'maledici'
                *                                -> Mild
                * topic                          -> Mild;
Verb 'cerca' 'trova' 'ricerca'
                * noun                           -> Search
                * 'dentro'/'in'/'nel'/'nello'/'nell^'/'nella'/
                  'negli'/'nelle'/'nei' noun     -> Search;
Verb 'agita' 'agitati'
				* 								 -> WaveHands
                *'mani'                          -> WaveHands
                * noun                           -> Wave;
Verb 'saluta'
                *                                -> WaveHands
                * creature                       -> WaveHands;
Verb 'imposta'
                * noun                           -> Set
                * noun 'to' special              -> SetTo;
Verb 'tira' 'trascina'
                * noun                           -> Pull;
Verb 'premi' 'muovi' 'spingi'
                * noun                           -> Push
                * noun 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' noun                    -> PushDir;
Verb 'gira' 'ruota'
                * noun                           -> Turn
                * noun 'a on'/'su on'            -> Switchon
                * noun 'a off'/'su off'          -> Switchoff;
Verb 'attiva' 'accendi'
                * noun                           -> Switchon;
Verb 'disattiva' 'spegni'
                * noun                           -> Switchoff;
Verb 'scassina' 'sblocca'
                * noun 'con'/'a' held            -> Unlock;
Verb 'serra' 'blocca'                 
                * noun 'con' held                -> Lock;
Verb 'attacca' 'rompi' 'colpisci' 'combatti'
     'uccidi' 'tortura' 'lotta' 'sfonda' 'ammazza'  
                * noun                           -> Attack
                * noun 'con' held                -> Attack;
Verb 'aspetta' 'attendi' 'z//'
                *                                -> Wait;
Verb 'rispondi' 'd@`i' 'grida' 'di' 'di^' 'dici'
                * topic 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' creature          
                                                 -> Answer;
Verb 'parla'
                * 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' creature 'circa'/'su'/'sul'/
                  'sullo'/'sull^'/'sulla'/'sugli'/'sui'/
                  'sulle'/'di'/'dello'/'della'/'dell^'/'dei'/
                  'degli'/'delle' topic   
                                                 -> Tell
                * 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' creature
                                                 -> Tell;                                        
Verb 'chiedi' 'domanda'
                * 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' creature 'circa'/'su'/'sul'/'sui'/
                  'sullo'/'sull^'/'sulla'/'sugli'/
                  'sulle'/'di'/'dello'/'della'/'dell^'/'dei'/
                  'degli'/'delle' topic   
                                                 -> Ask
                * 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' creature                -> Ask
                * 'scusa'/'scuse'				 -> Sorry
				* 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' creature noun			 -> Askfor
                *  noun 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle' creature           
                                                 -> AskFor reverse;
Verb 'mangia'
                * held                           -> Eat;
Verb 'dormi' 'sonnecchia'
                *                                -> Sleep;
Verb 'pela'
                * noun                           -> Take;
Verb 'canta'
                *                                -> Sing;
Verb 'scala' 'sali' 'arrampica' 'arrampicati'
                * 'su'/'sul'/'sullo'/'sull^'/'sulla'/'sui'/
                  'sugli'/'sulle' noun           
                                                 -> Climb
				* noun                           -> Climb;
Verb 'compra' 'acquista'
                * noun                           -> Buy;
Verb 'schiaccia' 'spremi' 'spiaccica'
                * noun                           -> Squeeze;
Verb 'nuota'
                *                                -> Swim;
Verb 'scuoti'
                * noun                           -> Swing;
Verb 'soffia'
				* 'dentro'/'in'/'nel'/'nello'/'nell^'/'nella'/
                  'negli'/'nelle'/'nei' held  
												 -> Blow
                * held                           -> Blow;
Verb 'prega'
                *                                -> Pray;
Verb 'sveglia' 'svegliati' 'risveglia' 'risvegliati'
                *                                -> Wake
                * creature                       -> WakeOther;
Verb 'bacia' 'abbraccia'
                * creature                       -> Kiss;
Verb 'pensa' 'medita'
                *                                -> Think;
Verb 'annusa' 'odora'
                *                                -> Smell
                * noun                           -> Smell;
Verb 'senti' 'ascolta'
                *                                -> Listen
                * noun                           -> Listen;
Verb 'assaggia' 'assapora' 'gusta'
                * noun                           -> Taste;
Verb 'tocca' 'accarezza' 'palpa'
                * noun                           -> Touch;
Verb 'pulisci' 'strofina' 'spolvera' 'ripulisci' 'lucida' 'lustra'
                * noun                           -> Rub;
Verb 'lega' 'fissa' 'congiungi' 'unisci' 'allaccia' 'annoda'
                * noun                           -> Tie
                * noun 'a'/'ad'/'all^'/'allo'/'alla'/'al'/'agli'/'ai'/
                  'alle'  noun                   -> Tie
                * noun 'con' noun                -> Tie;
Verb 'brucia' 'incendia'
                * noun                           -> Burn
                * noun 'con' held                -> Burn;
Verb 'bevi' 'trangugia' 'sorseggia'
                * noun                           -> Drink;
Verb 'riempi' 'colma'
                * noun                           -> Fill;
Verb 'taglia' 'affetta' 'sfronda' 'sfoltisci' 'spacca' 'strappa'
                * noun                           -> Cut
                * noun 'con' held                -> Cut;
Verb 'salta'
                *                                -> Jump
                * 'su'/'sul'/'sullo'/'sull^'/'sulla'/'sui'/
                  'sugli'/'sulle'/'sopra' noun
                                                 -> JumpOver;
Verb 'scava'    * noun                           -> Dig
                * noun 'con' held                -> Dig;

   



!   Il codice che segue  identico a quello in Grammar.h (il file per la 
!   grammatica inglese), ed  lasciato cos com' perch definisce alcune 
!   funzioni standard di libreria


! ----------------------------------------------------------------------------
!  This routine is no longer used here, but provided to help existing games
!  which use it as a general parsing routine:
! ----------------------------------------------------------------------------

[ ConTopic w; consult_from = wn;
  do w=NextWordStopped();
  until (w==-1 || (w=='to' && action_to_be==##Answer));
  wn--;
  consult_words = wn-consult_from;
  if (consult_words==0) return -1;
  if (action_to_be==##Ask or ##Answer or ##Tell)
  {   w=wn; wn=consult_from; parsed_number=NextWord();
      if (parsed_number=='the' && consult_words>1) parsed_number=NextWord();
      wn=w; return 1;
  }
  return 0;
];
! ----------------------------------------------------------------------------
!  Final task: provide trivial routines if the user hasn't already:
! ----------------------------------------------------------------------------

#Stub TimePasses      0;
#Stub Amusing         0;
#Stub DeathMessage    0;
#Stub DarkToDark      0;
#Stub NewRoom         0;
#Stub LookRoutine     0;
#Stub AfterLife       0;
#Stub GamePreRoutine  0;
#Stub GamePostRoutine 0;
#Stub AfterPrompt     0;
#Stub BeforeParsing   0;
#Stub PrintTaskName   1;
#Stub InScope         1;
#Stub UnknownVerb     1;
#Stub PrintVerb       1;
#Stub ParserError     1;
#Stub ParseNumber     2;
#Stub ChooseObjects   2;
#IFNDEF PrintRank;
Constant Make__PR;
#ENDIF;
#IFDEF Make__PR;
[ PrintRank; "."; ];
#ENDIF;
#IFNDEF ParseNoun;
Constant Make__PN;
#ENDIF;
#IFDEF Make__PN;
[ ParseNoun obj; obj=obj; return -1; ];
#ENDIF;
#Default Story 0;
#Default Headline 0;
#IFDEF INFIX;
#Include "infix";
#ENDIF;
! ----------------------------------------------------------------------------
