!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!! ZWinDefs.h
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!! V6Lib
!! Copyright 1997-2000 Jason C. Penney (jpenney@chelmsford.com)
!! May be freely redistributed, as long as it is unchanged
!! May be used in any non-commercial game as long as V6Lib version
!!  info is displayed in the game.  By default the library does this
!!  itself via the Version function included in V6.h.
!! May be used in any commercial game with my written permission.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

Message "[Including <ZWinDefs>]";
#Ifndef ZWinDefs_h;
Constant ZWinDefs_h;

System_file;

#Ifndef VN_1615;
Message "This version of Inform does not support the full v6
    @set_colour.  Don't worry, I'll work around it.";
#Endif;

!Globals
Global ActiveZWindow = NULL;
Global ActiveZWinStyle = NULL;

!Constants for Window Styles
Constant WS_WRAP 1;
Constant WS_SCROLL 2;
Constant WS_TRANSCRIPT 4;
Constant WS_BUFFER 8;

!!!!!
! ZWindow Class Definition
!!!!!!

Class 	ZWin_sub
 private GetProp [ propnum ret wn;
            wn = self.winnum;
            @get_wind_prop wn propnum -> ret;
            return ret;
        ],
	PutProp [ propnum value wn;
	    wn=self.winnum;
	    @put_wind_prop wn propnum value;
	],
	WinStyle[ bitmap op wn;
	    wn = self.winnum;
	    @window_style wn bitmap op;
	],
	winnum 0,
 with	GetYLoc [;
	    return self.GetProp(0);
	],
	GetXLoc [ ;
	    return self.GetProp(1);
	],
	GetYSize [;
	    return self.GetProp(2);
	],
	GetXSize [;
	    return self.GetProp(3);
	],
	GetYCursor[;
	    return self.GetProp(4);
	],
	GetXCursor[;
	    return self.GetProp(5);
	],
	GetLMargin[;
	    return self.GetProp(6);
	],
	GetRMargin[;
	    return self.GetProp(7);
	],
	!!!Newline stuff
	GetNewlineIntRoutine[;
	    return self.GetProp(8);
	],
	GetIntCount[ ;
	    return self.GetProp(9);
	],

	GetFontStyle[;
	    return self.GetProp(10);
	],
	GetBGColour[ret;
	    ret = self.GetProp(11);
	    ret = ret / 256;
	    return ret;
	],
	GetFGColour[ret;
	    ret = self.GetProp(11);
	    ret = ret % 256;
	    return ret;
	],
	GetFont[;
	    return self.GetProp(12);
	],
    GetCharHeight[ x;
        x = ((self.GetProp(13)) / 256);
        if (~~x) return 1;  !! protect against div by zero
        return x;           !! thanks LRR
	],
    GetCharWidth[ x ;
        x = ((self.GetProp(13)) % 256);
        if (~~x) return 1;  !! protect against div by zero
        return x;           !! thanks LRR
    ],
	GetLineCount[;
	    return self.GetProp(15);
	],
	
	!!begining of functions with side effects

	SetLoc[row col wn;
	    wn = self.winnum;
	    @move_window wn row col;
	],
	Move[rowoff coloff;
	    self.SetLoc((self.GetYLoc() + rowoff), (self.GetXLoc() +
						    coloff)); 
	],
	SetSize[height width wn;
	    wn = self.winnum;
	    @window_size wn height width;
	],
	SetCursor[row col wn;
	    wn = self.winnum;
	    if (row == 0)
	    {
		
		row = self.GetYCursor();
	    }
	    if (col == 0)
	    {
		col = self.GetXCursor();
	    }
	    @set_cursor row col wn;
	],
	!!!!!! NEW
	SetCursorByChar[row col off r c;
	    if (row > 0)
	    {
		r = (row * self.GetCharHeight()) -
		    self.GetCharHeight() + 1;
!		if (r < 1)
!		{
!		    r = 1;
!		}
	    }
	    else
	    {
		r = 0;
	    }
	    if (col > 0)
	    {
		c = (col * self.GetCharWidth()) -
		    self.GetCharWidth() + 1;
!		if (c < 1)
!		{
!		    c = 1;
!		}
	    }
	    else
	    {
		c = 0;
	    }
	    if (off ~= 0)
	    {
		r = r + (self.GetCharHeight()/off);
	    }
	    self.SetCursor(r,c);
	],
	MoveCursor[rowoff coloff;
	    self.SetCursor((self.GetYCursor() + rowoff),
			   (self.GetXCursor() + coloff));
	],
	HideCursor[;
	    self.SetCursor(-1);
	],
	UnHideCursor[;
	    self.SetCursor(-2);
	],
	SetMargins[lmar rmar wn;
	    wn = self.winnum;
	    @set_margins lmar rmar wn;
	],
	SetColours[fg bg wn;
	    wn = self.winnum;
	    !!!!!!!!!!!!!!!!!!
	    !! This is a hacky workaround, Inform won't compile
	    !! @set_colour bg fg wn
	    !! This should be fixed in Inform 6.15
	    !!!!!!!!!!!!!!!!!!
!	    #Ifndef VN_1615;
	    @set_window wn;
	    @set_colour fg bg;
	    ActiveZWindow.Activate();
	!    #Ifnot;
	 !   @set_colour fg bg wn;
	  !  #Endif;
	],
	SetBGColour[bg;
	    self.SetColours(0,bg);
	],
	SetFGColour[fg;
	    self.SetColours(fg,0);
	],
	SetFont[font ret wn;
	    wn = self.winnum;
	    @set_font font wn ret;
	    return ret;
	],
	SetFontStyle[style wn;
	    wn = self.winnum;
	    @set_window wn;
	    @set_text_style style;
	    ActiveZWindow.Activate();
	],

	!!!Newline Stuff 
	SetNewlineIntRoutine[ routine;
	    self.PutProp(8,routine);
	],
	SetIntCount[ num;
	    self.PutProp(9,num);
	],
	SetLineCount[ num;
	    self.PutProp(15,num);
	],
	
	!!!Atribute Stuff
	WinStyleSet[flags;
	    self.WinStyle(flags,0);
	],
	WinStyleOn[flags;
	    self.WinStyle(flags,1);
	],
	WinStyleOff[flags;
	    self.WinStyle(flags,2);
	],
	WinStyleToggle[flags;
	    self.WinStyle(flags,3);
	],

	Activate [ wn;
	    wn = self.winnum;
	    ActiveZWindow = self;
	    @set_window wn;
	],
	Erase[wn;
	    wn = self.winnum;
	    @erase_window wn;
	],
	Scroll[num wn;
	    wn = self.winnum;
	    @scroll_window wn num;
	];

#ifndef NOZPIC;
Class   ZWindow
 class	ZWin_sub,

 with	DrawPic [zpic y x wn;
	    wn = self.winnum;
	    @set_window wn;
	    zpic.Draw(y,x);
	    ActiveZWindow.Activate();
	],
	ErasePic [zpic y x wn;
	    wn = self.winnum;
	    @set_window wn;
	    zpic.Erase(y,x);
	    ActiveZWindow.Activate();
	],
	ResizeToPic [zpic;
	    self.SetSize(zpic.GetHeight(),zpic.GetWidth());
	];
#ifnot;
Class  	ZWindow
 class 	ZWin_sub;
#endif;


Class 	ZWinStyle
 with 	Init [ ;
	    StatusWin.SetCursor(1,1);
        ],
 	Update [ ;
	    rtrue;    
	],
	Finish [ ;
	    StatusWin.SetCursor(1,1);
	],
	Activate [ ;
	    ActiveZWinStyle.Finish();
	    ActiveZWinStyle = self;
	    give self ~general;
	    self.Init();
	];
	  
#Endif;

