
[ LockedInLab;
	labdoorguards.shutdown();
		
	! you can steal up to 4 free turns in the lab before this happens.
];

Object insidelabvoice
  with
	number 0,
	startup [;
		if (self.number)
			"^You're messing up my timing. [BUG]";
		StartDaemon(self);
	],
	daemon [ ix;
	
		if (labconsole has general) {
			! check for shutdowns
			ix = 0;
			if (cabinetcontents has general)
				ix = 6;
			else if (cabinetplate notin labcabinet)
				ix = 2;
			else if (cabinetplate has general)
				ix = 4;
			if (ix) {
				give labconsole ~general;
				labconsole.number = -1;
				print "^The console's display goes abruptly dead. ";
				labconreadout.set_active(ix);
			}
		}
		
		if (labconsole has general) {
			! ok, it's really working.
			if (labconsole.number >= 0) {
			
				if (self.number < 100) {
					! summon Himself
					self.number = 100;
				}
				
				labconsole.number--;
				if (labconsole.number == 0) {
					! it's time.
					if (gocage has open) {
						labconsole.number = -1;
						new_line;
						labconreadout.set_active(30);
					}
					else {
						OutTheWindow();
						rtrue; ! and deadflag is now set.
					}
				}
				else {
					! still in countdown.
					new_line;
					labconreadout.set_active(25);
				}
			}
		}
	
		self.number++;
		switch (self.number) {
			6:
				print "^You hear voices outside. ~Well?~^";
			8:
				print "^~The lock circuitry is knotted,~ comes a mumble
					from outside the door. ~...must have done something...~^";
			9:
				print "^~We've got shock grenades. Should we blast?~ There
					is a pause, and someone replies, ~No, wait on that.
					Whatever's in the lab, the tech crowd will burst themselves
					if we fill it full of shrapnel.~^";
			11:
				print "^A voice says, ~Someone ask around for a gas cutter.~^";
			14:
				print "^~Got anywhere with the lock?~ you hear. There is an
					irritated mutter in reply.^";
			18:
				print "^~One of the techs thinks there's a cutter in South
					Storage,~ someone reports.^";
			21:
				print "^~Right, bring that over here.~^";
			22:
				print "^You hear a faint ", (emphstring) "pop", " from the
					other side of the door. It is followed by vicious
					swearing.^";
			23:
				print "^~I bet ", (emphstring) "their", " equipment never
					fails just when it's needed,~ someone mutters.^";
			27:
				print "^You catch, ~...could be doing in there?~ ~Cursed if
					I know. They don't tell me what kind of toys they
					play with.~^";
			31:
				print "^~Got it!~ you hear. The door does not move. ~Or, 
					perhaps not,~ the voice continues irritably.^";
			34:
				print "^~Understand, it's been too long. Are there any
					explosives, things of that sort in there?~ Someone farther
					away replies, ~No, not that we've been told of.~^";
			38:
				print "^You hear running footsteps outside. ~Found another
					one!~ Someone exhales in relief.^";
			40:
				print "^There is a tight hiss from outside. ~There it runs,~
					someone says.^";
			41:
				print "^~Keep it steady, understand. We only need a hole
					big enough to fire through.~^";
			42:
				deadflag = DiedAtHome();
				"^A tiny red spot appears on the door. It quickly glows
					brighter, orange and yellow; and then metal drips away
					from a white-hot hole. The shots that come through
					moments later are astonishingly well-aimed.^";
			99:
				deadflag = 3;
				"^You're taking way too long about this. [BUG]";
			100: ! skipped, do nothing
			101: 
				print "^~Look at the power readout. Something's going on
					in there,~ comes a worried mutter from outside. 
					A louder voice calls,
					~Has the cursed Chief finished his cursed nap yet?~^";
			102:
				print "^~Yes, he cursed has.~ The tone is dry and amused,
					but the familiar voice chills you. ~What's the 
					situation?~^";
			103:
				print "^~It's under control, with',~ someone says calmly.
					~The target is trapped in the lab. We're bringing up
					a cutter.~^";
			104:
				print "^There is a choking sound.
					~Trapped in the-- in--~ In all the hours you spent
					in his chair, you never heard that voice lost for words.^";
			105:
				print "^~There's only one entrance, with-commander.
					We're standing in
					front of it,~ the voice continues, a little nervously now.
					~The walls are armor plate underneath. The ventilation
					system is secure. We haven't been briefed on any explosive
					or cutting equipment in the lab inventory. There's simply
					nowhere to go.~^";
			106:
				deadflag = DiedAtHome();
				print_ret "^~", (emphstring) "Nowhere,", "~ the familiar
					voice begins, but someone interrupts: ~The power is
					showing a dropoff, look at that.~^^~All right,~ the
					man continues after a moment. ~All right. Blast the
					door down. Now, please.~^^Orders, apparently, are orders.
					There is a deafening roar; the door tears into flying
					shards of metal. A hail of pulse-gun fire follows the
					blast in. You don't stand a moment's chance.";
		}
	];

#ifdef NOT_DEFINED;

Class OrdinaryHeatable
  with
	temperature 0,
	adjust_temp [ envval;
		self.temperature = AdjustTemperature(self.temperature, envval);
	],
	before [;
		Touch:
			switch (self.temperature) {
				1: 
					print_ret "You can feel warmth radiating from ", 
						(the) self, ".";
				2: 
					"You can feel heat radiating from ", 
						(the) self, ".";
				3: 
					"You can feel intense heat radiating from ", 
						(the) self, ".";
				default: 
					rfalse;
			}
		Take:
			switch (self.temperature) {
				2: print_ret (The) noun, " is too hot to touch.";
				3: print_ret (The) noun, " is blisteringly hot; you can't
					touch it.";
				default:
			}
	],
	after [;
		Take:
			if (self.temperature == 1)
				print_ret (The) noun, " is warm as you take it from the
					alcove, although it cools quickly.";
	];

#endif; ! NOT_DEFINED;

Object nameoffire
  with
	name 'fire' 'flame' 'flames' 'burning';

Class BurnablePaper
  with
	parse_name [ num wd;
		num = 0;
		wd = NextWord();
		while ((WordInProperty(wd, self, name) ~= 0)
			|| (self.smoking == 2 && WordInProperty(wd, nameoffire, name) ~= 0)) {
			num++;
			wd = NextWord();
		} 
		return num;
	],
	invent [;
		if (inventory_stage == 2) {
			if (self.smoking == 2)
				print " (which is burning)";
			rtrue;
		}
	],
	partinvent [; return self.invent(); ],
	temperature 0, 
	discoloration 0, 
	burnedness 0, 
	smoking 0, ! 0 = nothing, 1 = smoke, 2 = fire, 3 = entirely burnt.
	stage_list 2 4 6 8, 
		! just alight; burning; more than half burnt; nearly burnt; gone
	adjust_temp [ envval    ix printed;
		if (self.smoking >= 3) {
			return;
		}
		else if (self.smoking == 2) {
			self.burnedness++;
			ix = FindStage(self, self.burnedness);
			if (ix >= 4) {
				self.ash_and_gone();
				return;
			}
			if (ix >= 1 && (self.&stage_list)-->(ix-1) == self.burnedness) {
				switch (ix) {
					1: print "^", (The) self, " is burning brightly now.^";
					2: print "^Half of ", (the) self, " has burned away.^";
					3: print "^", (The) self, " is nearly consumed in flame.^";
				}
			}
		}
		else {
			printed = 0;
			self.temperature = AdjustTemperature(self.temperature, envval);
			
			if (anywherein(self, labtable) && papermess.burnedness >= 8
				&& self.smoking < 2) {
				self.temperature = 3;
				self.smoking = 1;
			}
			
			if (self.temperature == 3) {
				if (self.smoking == 0) {
					self.smoking = 1;
					print "^Smoke begins to curl from ", (the) self, ".^";
					printed = 1;
				}
				else {
					self.smoking = 2;
					print "^A corner of ", (the) self, " flares alight.^";
					printed = 1;
				}
			}
			else {
				if (self.smoking) {
					self.smoking = 0;
					print "^", (The) self, " is no longer smoking, but it is";
					switch (self.discoloration) {
						0: print " undamaged [BUG]";
						1: print " yellowed";
						2, 3: print " browned";
						default: print " scorched dark brown";
					}
					print " from the heat.^";
					printed = 1;
				}
			}
			
			if (self.temperature >= 2) {
				self.discoloration++;
				if (printed == 0) {
					switch (self.discoloration) {
						1: print "^", (The) self, " is yellowing with the heat.^";
						2: print "^", (The) self, " darkens.^";
						3: print "^", (The) self, " darkens.^";
						4: print "^", (The) self, " is dark and scorched-looking.^";
					}
				}
			}
		}
	],
	print_discoloration [ contentstr ix;
		if (self.smoking >= 3) {
			print (The) self, " is entirely gone, which leaves 
				the question of how you can see it. [BUG]^";
			rtrue;
		}
		if (self.smoking >= 2) {
			ix = FindStage(self, self.burnedness);
			switch (ix) {
				0: 
					print (string) contentstr, " The edge of the paper is
						burning.";
				1: 
					print (string) contentstr, " The paper is on fire.";
				2: 
					print (string) contentstr, " The paper is still burning,
						and more than half consumed.";
				3: 
					print "The paper is nearly consumed in flame.";
				default: 
					print "The paper is a ghost of its former self. [BUG]";
			}
			new_line;
			rtrue;
		}
		print (string) contentstr;
		switch (self.discoloration) {
			0: ! do nothing
			1: print " The paper is slightly yellowed.";
			2: print " The paper is browned from heat.";
			3: print " The paper is scorched brown.";
			default: print " The paper is scorched dark brown, unreadable
				in places.";
		}
		if (self.smoking) {
			print " Smoke is curling from";
			if (self.discoloration == 0)
				print " the paper.";
			else
				print " it.";
		}
		new_line;
		rtrue;
	],
	ash_and_gone [  obj dest;
		new_line;
		if (self in player) {
			print "Fire crawls up the last corner of ", (the) self, ".
				You drop it hastily, and it";
			move self to parent(player);
		}
		else {
			print (The) self;
		}
		dest = parent(self);
		if (dest == labtable && papermess.burnedness) {
			print " is submerged in the greater fire.^";
		}
		else {
			print " flickers out, leaving black ashes and a final
				wisp of smoke.^";
		}
		self.smoking = 3;
		self.temperature = 0;
		self.discoloration = 99;
		if (dest == labtable && papermess.burnedness) {
			! was on burning table;
		}
		else if (dest ~= 0) {
			obj = PaperAsh.create();
			if (obj) {
				move obj to dest;
			}
		}
		remove self;
	],
	before [;
		Smell:
			if (self.smoking)
				"You smell burning paper.";
		TouchTo:
			if (IsOnFire(second)) {
				if (self.smoking >= 2)
					print_ret (The) self, " is already burning.";
				self.smoking = 2;
				print_ret "You hold a corner of ", (the) self, " in the
					fire; it catches easily.";
			}
		TouchFrom:
			if (IsOnFire(noun))
				<<TouchTo self noun>>;
		Receive:
			if (noun ofclass BurnablePaper && IsOnFire(noun))
				<<TouchTo self noun>>;
			if (noun ofclass BurnablePaper && IsOnFire(self))
				<<TouchTo noun self>>;
		#ifdef ZDEBUG;
		Rub:
			self.smoking = 2;
			print_ret (The) self, " catches fire. [DEBUG]";
		#endif;
	];

! find the lowest value (ix+1) for which (val >= stagelist-->ix). Thats 0..4.
[ FindStage obj val    ix ptr;
	if (~~(obj ofclass BurnablePaper)) {
		print_ret "FindStage called on ", (name) obj, " -- sorry about the dull 
			message. [BUG]";
	}
	if (obj.#stage_list ~= 8)
		print_ret "FindStage says ", (name) obj, " has a bad stage list. [BUG]";
	ptr = obj.&stage_list;
	for (ix = 0 : ix < 5 : ix++) {
		if (val < ptr-->ix)
			return ix;
	}
	return 5;
];

[ IsOnFire obj;
	if (obj ofclass BurnablePaper && obj.smoking >= 2)
		rtrue;
	if (obj == papermess && papermess.burnedness)
		rtrue;
	if (obj == labtable && papermess.burnedness >= 8)
		rtrue;
	rfalse;
];

Class PaperAsh(6)
  with
	name 'black' 'heap' 'heaps' 'of' 'ash' 'ashes',
	short_name "ash",
	article "some",
	plural "heaps of ash",
	description [;
		if (verb_word == 'read')
			"That's impossible now.";
		"It's the blackened, brittle remains of some paper.";
	],
	before [;
		Touch:
			"Your finger is smeared black.";
		Smell:
			"The ash still smells faintly of burning.";
		Blow, Rub:
			PaperAsh.destroy(self);
			"The ashes are scattered.";
	],
	after [ obj objnext ix;
		Take:
			ix = 0;
			obj = child(player);
			while (obj) {
				if (obj ofclass PaperAsh && obj ~= self) {
					ix++;
					objnext = sibling(obj);
					remove obj;
					PaperAsh.destroy(obj);
					obj = objnext;
				}
				else {
					obj = sibling(obj);
				}
			}
			if (ix)
				"You add to the ash already in your hand.";
			else
				"You carefully brush the ash into your hand.";
	];
	
[ AdjustTemperature curtemp envtemp;
	! allow for -1, meaning 0
	if (envtemp < 0)
		envtemp = 0;
		
	if (curtemp == envtemp)
		return curtemp;
	if (curtemp < envtemp)
		return curtemp+1;
	else
		return curtemp-1;
];

[ FindEnvTemp obj   ix;
	if (anywherein(obj, hotplate)) {
		ix = hotplate.heat_source;
		if (ix < 0)
			ix = 0;
		switch (papermess.burnedness) {
			0: ! do nothing
			1 to 4: if (ix<2) ix = 2;
			default: if (ix<3) ix = 3;
		}
		return ix;
	}
	if (anywherein(obj, labtable)) {
		switch (papermess.burnedness) {
			0: return 0;
			1 to 4: return 2;
			default: return 3;
		}
	}
	return 0;
];

Object Laboratory "The Laboratory",
  with
	initial [;
		if (self hasnt general) {
			give self general;
			insidelabvoice.startup();
			hotplate.startup();
		}
	],
	description [ skipmat;
		print "There is no question what this place is.
			The room is high, brightly lit";
		if (self hasnt visited)
			print " -- this part of the building must have its own power
				supply --";
		else
			print ",";
		print " and filled with arcane, half-built, and unlabelled
			machinery. 
			The heavy door stands";
		if (labdoor has open)
			print " open";
		else
			print " closed";
		print " to the east; there is a small white pad and an access
			panel beside it.^";
		
		print "^At the center of the chaos, and its focus, is a great
			silver platform which is wrapped in a glittering cage of
			scan-web. 
			A control console stands next to it.
			Cables run out across the floor,
			from the platform to the console, from the console to the walls,
			and tangle around a low cabinet
			off to one side.^";
		
		switch (papermess.burnedness) {
			0:
				print "^Much paper and clutter rests on a long wooden table
					against one wall.
					The table also supports a notably large black device. ";
			1 to 4:
				print "^Much paper and clutter rests on a long wooden table
					against one wall. A few flames lick at the papers.
					The table also supports a notably large black device. ";
			5 to 7:
				print "^A long wooden table by one wall supports a notably
					large black device. The table is also covered with
					papers, many of which are burning brightly.^^";
			8 to 11:
				print "^A long wooden table by one wall supports a notably
					large black device. The table is also covered with
					papers, most of which are burning brightly.^^";
			12 to 14:
				print "^A long wooden table by one wall supports a notably
					large black device. The table is also covered with
					papers, all of which are burning brightly.^^";
			15 to 17:
				print "^A long wooden table by one wall is burning fiercely.
					You can see a black device distorting within the flames.^^";
			default:
				print "^A long wooden table by one wall is burning fiercely;
					the flames are spreading up one wall.
					You can see a black device distorting within the flames.^^";
		}
		
		print "By the other wall is a clear space ringed
			with red, with some sort of mat inside it.";
		skipmat = 0;
		if (child(labmat) == testblock && sibling(testblock) == nothing) {
			skipmat = 1;
			print " A steel cube sits on the mat.";
		}
		new_line;
		
		if (child(labmat) && skipmat == 0) {
			new_line;
			<Search labmat>;
		}
		
		if (player notin gocage && child(gocage)) {
			new_line;
			<Search gocage>;
		}
		
		rtrue;
	],
	out_to labdoorin,
	e_to labdoorin,
	in_to [; <<Enter gocage>>; ],
	cant_go "There is no door but the one you entered by.",
  has ~general; ! general, the first time you enter.

Object -> skankbarrier "skank barrier [BUG]"
  with
	cage_barrier [ obj;
		if (obj == 0 or gocage)
			rfalse; ! can always touch borders 
		if ((obj == goplatform or goplatformpattern) || anywherein(obj, gocage)) {
			! obj is inside
			if (gocage hasnt open && player notin gocage)
				print_ret "You can't reach ", (the) obj, " from outside the
					cage, while the cage is closed.";
		}
		else {
			! obj is outside
			if (player in gocage)
				print_ret "You can't reach ", (the) obj, " from inside the
					cage.";
		}
		rfalse;
	],
	react_before [;
		Examine, Search, Listen:
			rfalse;
		ShootAttack:
			rfalse; ! can shoot through cage
		Insert, PutOn, BaseTouchTo, AttackWith, WriteWith:
			if (action == ##AttackWith) {
				if (second ofclass PulseGun) {
					rfalse; ! can shoot through cage
				}
			}
			if (action == ##Insert or ##PutOn) {
				if (second == goplatform) {
					rfalse; ! can put things on platform
				}
			}
			if (noun && self.cage_barrier(noun))
				rtrue;
			if (second && self.cage_barrier(second))
				rtrue;
		default:
			if (action == ##Enter) {
				if (noun == goplatform) {
					rfalse; ! can get on platform
				}
			}
			if (noun && self.cage_barrier(noun))
				rtrue;
	],
  has scenery;

Object -> goplatform "platform"
  with
	name 'great' 'huge' 'silver' 'disc' 'disk' 'platform',
	description [;
		print "The platform is a huge disc, nearly ten feet wide; 
			it crowds the rest of the room's clutter out against
			the walls.
			The disc is a handspan tall. Cables run from beneath it
			all across the room.
			It is made of some mirror-bright metal;
			the top is incised with a fine concentric pattern, which seems to
			reflect the lights overhead into an infinite rainbow shaft.^";
		if (1) {
			new_line;
			<Search gocage>;
		}
		rtrue;
	],
	before [;
		Examine:
			rfalse;
		Search:
			<<Search gocage>>;
		Receive:
			<<Insert noun gocage>>;
		Enter:
			<<Enter gocage>>;
		GetOff:
			if (player in gocage)
				<<Exit>>;
		Touch:
			L__M(##Touch, 2, noun);
			rtrue;
	],
  has scenery transparent;

Object -> -> goplatformpattern "concentric pattern"
  with
	name 'concentric' 'pattern' 'infinite' 'rainbow' 'shaft',
	before [;
		"It's only an illusion.";
	],
  has scenery;

Object -> gocage "cage"
  with
	name 'glitter' 'glittering' 'cage' 'scan' 'web' 'scan-web' 'flap' 'canopy'
		'ring',
	description [;
		print "A glittering canopy of scan-web hangs from the ceiling.
			It runs entirely around the platform in a wide-draped ring. 
			The web is
			fine-woven, finer than you've ever seen -- it must run down
			to molecular scale, with the waveform analysis of the
			wrap-around scan.
			A six-foot-wide flap on one side of the cage is";
		if (self hasnt open)
			print " sealed shut.";
		else
			print " hanging open.";
		new_line;
		if (child(self)) {
			new_line;
			<Search self>;
		}
		rtrue;
	],
	vehicle_name " (standing on the platform)",
	vehicle_status_name ", on the platform",
	react_before [;
		Exit:
			if (player in self) {
				if (self hasnt open)
					"You can't leave the cage while the flap is closed.";
				move player to parent(self);
				if (keep_silent == 0)
					print "You step off of the platform.^";
				rtrue;
			}
	],
	before [;
		Search:
			if (child(self) == nothing)
				"The platform is empty.";
			if (player in self && children(self) == 1) {
				"The platform is empty, but for yourself.";
			}
			print "Resting on the platform";
			if (player in self)
				print " at your feet";
			WriteListFrom(child(self),
				ISARE_BIT + TERSE_BIT + ENGLISH_BIT + PARTINV_BIT + CONCEAL_BIT);
			".";
		Enter:
			if (self hasnt open)
				"You can't enter the cage while the flap is closed.";
			rfalse;
	],
	after [;
		Enter:
			"You step through the open flap and onto the platform.";
		Open:
			"You peel the flap of web away from its magnetic seals; it
				hangs open.";
		Close:
			if (player in self)
				"You pull the flap back against its seals, closing yourself
					in the cage.";
			else
				"You push the flap back against its seals.";
	],
  has scenery enterable container openable ~open transparent;

Object -> labconsole "console"
  with
	name 'control' 'console',
	description [;
		print "There is a free-standing console next to the cage, 
			facing it, with a view off to the side of the padded mat.
			On the console are two buttons, a
			grey oval of contact-pad substrate, a small rectangular
			display above the oval, and a readout strip.
			Hand-written labels are marked by each control.";
		print "^^";
		if (self has general) {
			print "The display is lit with a complex, multispectral
				waveform. ";
		}
		print "The readout strip says, ";
		labconreadout.answer_general();
		new_line;
		rtrue;
	],
	number -1, ! the fuse counter
	react_before [;
		Listen:
			if (noun == 0)
				<<Listen self>>;
	],
	before [;
		Examine:
			if (verb_word == 'read')
				<<Examine labconlabels>>;
		Listen:
			if (self hasnt general)
				rfalse;
			if (self.number < 0)
				"A faint hum is coming from somewhere.";
			"A loud hum is coming from somewhere.";
	],
  has scenery transparent; ! general means turned on.

Object -> -> labconlabels "labels"
  with
	name 'label' 'labels' 'hand-written' 'written' 'buttons',
	description "Scribbled between the grey oval and the display is
		the phrase ~Destination waveform.~ The upper button says
		~Ready,~ and the lower button is labelled ~Light the fire.~",
	before [;
		Push:
			"You'll have to say exactly what you want to push.";
	],
  has scenery;

Object -> -> labconreadybutton "upper button"
  with
	name 'upper' 'top' 'u//' 'up' 'button',
	description "The upper button is labelled ~Ready.~",
	before [ ix;
		SwitchOn, SwitchOff, Turn: <<Push self>>;
		Push:
			if (labconsole hasnt general) {
				if (cabinetcontents has general)
					ix = 5;
				else if (cabinetplate notin labcabinet)
					ix = 1;
				else if (cabinetplate has general)
					ix = 3;
				else {
					give labconsole general;
					labconsole.number = -1;
					ix = 20;
					print "There is a faint hum, and the display lights
						with a brightly colored waveform. ";
				}
				labconreadout.set_active(ix);
			}
			else {
				if (labconsole.number >= 0)
					<<Push labcongobutton>>;
				! stay ready
				labconreadout.set_active(20);
			}
			rtrue;
	],
  has scenery;

Object -> -> labcongobutton "lower button"
  with
	name 'lower' 'bottom' 'd//' 'down' 'button',
	description "The lower button is labelled ~Light the fire.~",
	before [;
		SwitchOn, SwitchOff, Turn: <<Push self>>;
		Push:
			if (labconsole hasnt general) {
				labconreadout.set_active(22);
				rtrue;
			}
			if (labconsole.number < 0) {
				! start it up.
				labconsole.number = 6;
				"The hum intensifies, coming from all around you.";
			}
			else {
				! go back to readiness
				labconsole.number = -1;
				print "The hum fades to near-inaudibility. ";
				labconreadout.set_active(21);
			}
			rtrue;
	],
  has scenery;

Object -> -> labconoval "grey oval"
  with
	name 'grey' 'gray' 'contact' 'oval' 'ellipse' 'substrate',
	description "It's an unmarked oval of grey substrate, the same material
		as the contact pad by the door. A label above the oval reads
		~Destination waveform.~",
	before [;
		Push, Rub, Attack:
			<<Touch self>>;
		TouchFrom:
			if (noun == lockpick)
				rfalse;
			<<Touch self>>;
		Touch:
			if (labconsole hasnt general)
				"Nothing happens.";
			if (self hasnt general) {
				give self general;
				"As the pressure on the oval moves, the waveform on the display
					mutates -- wave components slide up or down, shift color,
					change frequency. You cannot interpret the result... but
					a leap into the dark must be better than staying here.";
			}
			else {
				"The waveform on the display changes its configuration
					again.";
			}
	],
  has scenery; ! general means not on the mat.

Object -> -> labcondisplay "display"
  with
	name 'rectangle' 'rectangular' 'wave' 'waveform' 'component' 'components'
		'display',
	description [;
		if (labconsole hasnt general)
			"The display is blank.";
		"The display shows a complex waveform. Several different components
			slice across the rectangle, like a rainbow of mountain ranges.
			You haven't the least understanding of what they mean.";
	],
	before [;
		Search: <<Examine self>>;
	],
  has scenery;

Constant CannotInit "~Cannot initialize: ";
Constant UnexFailure "~Unexpected failure: ";

Object -> -> labconreadout "readout strip"
  with
	name 'readout' 'read' 'out' 'strip',
	description [;
		if (player in gocage)
			print "You peer at the strip, on the other side of the scan-web
				and upside down. It reads, ";
		else
			print "The strip reads, ";
		self.answer_general();
		new_line;
		rtrue;
	],
	number 0, ! output code.
	set_active [ val;
		if (val == self.number && val ~= 25) {
			print "The console readout blinks, and then repeats, ";
		}
		else {
			print "The console readout blinks; it now says, ";
		}
		self.number = val;
		self.answer_general();
		new_line;
		rtrue;
	],
	answer_general [;
		! codes < 20 are for when system is off; >= 20 for when it's on.
		switch (self.number) {
			0: print "~Shut down for logic adjustment.~";
			1: print (string) CannotInit, "unit NZ73 not connected.~";
			2: print (string) UnexFailure, "unit NZ73 disconnected.~";
			3: print (string) CannotInit, "unit NZ73 failed self-test.~";
			4: print (string) UnexFailure, "unit NZ73 functioning erratically.~";
			5: print (string) CannotInit, "central systems failed self-test.~";
			6: print (string) UnexFailure, "central systems not functioning.~";
			20: print "~Ready.~";
			21: print "~Sequence aborted.~";
			22: print "~Central systems are not active.~";
			25: 
				print "~Accumulators charging: pulse in ", labconsole.number, 
					".";
				if (gocage has open)
					print " Note: scan-web coverage not yet complete.";
				print "~";
			30: print "~Unable to initiate: scan-web coverage not complete.~";
			default: print "~Bug.~ [BUG]";
		}
		rtrue;
	],
	before [;
		Search: <<Examine self>>;
	],
  has scenery;

Object -> labcables "cables"
  with
	name 'cable' 'cables' 'tangle' 'nest' 'rubber',
	description "There are wrist-thick cables running everywhere. Some
		lead beneath the platform, to the equipment around the room,
		to the control console,
		to the walls, to a nest of cable around a low cabinet
		off to one side.",
	before [;
		Take, Push, Pull:
			"You shift a few of the cables around, but they're all
				well-anchored at both ends.";
		Attack:
			"The cables are heavy black rubber; you cannot damage them.";
	],
  has scenery pluralname;

Object -> labcabinet "cabinet"
  with
	name 'low' 'cabinet',
	description [;
		print "The cabinet is gray sheet metal, with rows of holes running
			down the sides.";
		if (self hasnt open) {
			" Clearly it is a modular rack, meant to have
				arbitrary equipment bolted inside and rearranged when necessary.
				The front is closed.";
		}
		print " The front is open. ";
		<Search self>;
		rtrue;
	],
	shortout [;
		if (self has open) {
			cabinetcontents.shortout();
			rtrue;
		}
	],
	before [;
		Search:
			if (self hasnt open)
				"The cabinet is closed.";
			print "The cabinet is stuffed with blocks of subcircuitry
				and nests of ribbon-wiring.";
			if (cabinetplate notin self)
				print " There is a gap at one point, however, as if a single
					logic plate had been removed.";
			else
				print " The logic plate has been slotted into place.";
			new_line;
			rtrue;
		Empty, EmptyT:
			if (cabinetplate in self)
				<<Take cabinetplate>>;
			"Everything in the cabinet is bolted in place.";
		Receive:
			if (cabinetplate in self)
				"You can't put anything else in the cabinet.";
			if (noun ~= cabinetplate)
				print_ret (The) noun, " won't fit in the gap.";
		Push, Pull, Take:
			"The low cabinet is too heavy to move.";
	],
	after [;
		Open:
			print "Opened. ";
			<<Search self>>;
		Receive:
			"You slide ", (the) noun, " into the gap in the cabinet.";
		LetGo:
			if (noun ~= cabinetplate)
				print_ret "What's ", (the) noun, " doing in there? [BUG]";
			print "You slide ", (the) noun, " out of the cabinet.^";
			rtrue;
	],
  has scenery container openable ~open;

Object -> -> cabinetcontents "blocks of subcircuitry"
  with
	name 'block' 'blocks' 'of' 'subcircuitry' 'circuitry' 'subcircuit'
		'circuit' 'circuits' 'nests' 'ribbon' 'wiring' 'ribbon-wiring' 
		'gap',
	shortout [;
		give self general;
		print_ret "A corona of sparks showers out of the cabinet. Blue light
			crackles along the subcircuit paths and across the ribbon wiring.";
	],
	before [;
		Examine, Search:
			<<Search labcabinet>>;
		Receive:
			<<Insert noun labcabinet>>;
		Empty:
			<<Empty labcabinet>>;
	],
  has scenery pluralname; ! general means it's fried

Object -> labmatring "red line"
  with
	name 'red' 'line' 'ring' 'paint' 'marking',
	description "It's just a red marking, painted on the floor around the
		mat.",
	before [;
		Enter: <<Enter labmat>>;
		Receive: <<PutOn noun labmat>>;
		Search: <<Search labmat>>;
	],
  has scenery;

Object -> labmat "padded mat"
  with
	name 'padded' 'padding' 'mat' 'clear' 'empty' 'space',
	description [;
		print "By one wall is an empty space, with a thick mat of padding
			inside it. A bright red line has been painted around the mat.^";
		if (child(self)) {
			new_line;
			<Search self>;
		}
		rtrue;
	],
	supporter_describe [; rtrue; ],
	before [;
		Search:
			if (child(self) == nothing)
				print_ret "There is nothing on ", (the) self, ".";
			print "On ", (the) self;
			WriteListFrom(child(self),
				ISARE_BIT + TERSE_BIT + ENGLISH_BIT + PARTINV_BIT);
			".";
		Enter:
			"There's no point.";
		Receive:
			if (receive_action == ##Insert)
				<<PutOn noun self>>;
		Touch, Push, Attack:
			"The mat yields softly.";
		Take:
			"The mat seems to be fastened down.";
	],
  has scenery supporter;

Object -> -> testblock "steel cube"
  with
	name 'steel' 'cube' 'polished' 'block',
	description "It's a featureless cube of polished steel.",
	before [;
		Touch:
			"The steel is cool.";
		Attack:
			"It's like hitting a solid block of metal.";
	];

Object -> labtable "wooden table"
  with
	name 'long' 'wood' 'wooden' 'table' 'clutter',
	description [;
		
		print "There is a long wooden table against one wall";
		switch (papermess.burnedness) {
			0:
				print ". It is covered
					with astonishing piles of paper -- scraps, notes, diagrams,
					all spread unevenly around in varying stages of sortedness
					and immediacy.^^At one end of the table is a notable black
					device.";
			1 to 4:
				print ". It is covered
					with astonishing piles of paper -- scraps, notes, diagrams,
					all spread unevenly around in varying stages of sortedness
					and immediacy. Flames lick at a few of the papers.^^At
					one end of the table is a notable black device.";
			5 to 7:
				print ". It supports a notable black device, and also astonishing
					piles of paper -- scraps, notes, diagrams -- many of
					which are burning brightly.";
			8 to 11:
				print ". It supports a notable black device, and also astonishing
					piles of paper -- scraps, notes, diagrams -- most of
					which are burning brightly.";
			12 to 14:
				print ". It supports a notable black device, and also astonishing
					piles of paper -- all of which are covered with sheets
					of fire.";
			15 to 17:
				print "; it is burning fiercely.
					You can see a black device distorting within the flames.";
			default:
				print "; it is burning fiercely, and the flames are spreading up
					the wall.
					You can see a black device distorting within the flames.";
		}
		
		
		if (self.just_a_pile()) {
			new_line;
		}
		else {
			print " The table also contains ";
			WriteListFrom(child(self),
				CONCEAL_BIT + TERSE_BIT + ENGLISH_BIT + RECURSE_BIT + PARTINV_BIT);
			print ".^";
		}
		rtrue;
	],
	just_a_pile [ ix;
		objectloop (ix in self) {
			if (ix == papermess)
				continue;
			if (ix == cabinetplate && cabinetplate has scenery)
				continue;
			rfalse;
		}
		rtrue;
	],
	supporter_describe [;
		! only called if there's something non-scenery to describe.
		switch (papermess.burnedness) {
			0:
				print "^On the table, aside from ", (the) papermess, " and 
					the black device, you see ";
			1 to 4:
				print "^Also on the table, near the flames, you see ";
			default:
				print "^Also on the table, amid the flames, you see ";
		}
		WriteListFrom(child(self),
			ENGLISH_BIT + RECURSE_BIT + PARTINV_BIT
			+ TERSE_BIT + CONCEAL_BIT);
		".";
	],
	react_before [;
		Examine, Search, Listen:
			rfalse;
		default:
			if (noun) {
				if ((noun == hotplate or hotplateswitch)
					|| anywherein(noun, self) || anywherein(noun, hotplate)) {
					if (noun == papermess)
						rfalse; ! the papermess has its own handlers.
					if (self.heat_barrier(noun)) rtrue;
				}
			}
			rfalse;
	],
	before [;
		Search:
			if (papermess hasnt general) {
				if (papermess.burnedness < 8)
					<<Search papermess>>;
				print "You cannot approach the table to search it
					thoroughly. But you can make out";
			}
			else {
				print "There are";
			}
			print " piles of useless papers covering the table,
				and a notable black device at one end.";
			switch (papermess.burnedness) {
				0: ! nothing
				1 to 4: print " Some of the papers are on fire.";
				5 to 7: print " Many of the papers are on fire.";
				8 to 11: print " Most of the papers are on fire.";
				default: print " The papers are blazing hotly.";
			}
			if (self.just_a_pile()) {
				new_line;
			}
			else {
				print " You also see ";
				WriteListFrom(child(self),
					CONCEAL_BIT + TERSE_BIT + ENGLISH_BIT + RECURSE_BIT + PARTINV_BIT);
				print ".^";
			}
			rtrue;
		Push, Pull:
			"The wooden table is too heavy to move.";
		#ifdef ZDEBUG;
		Rub:
			papermess.startup();
			"The table catches fire. [DEBUG]";
		#endif;
		LookUnder:
			if (self.heat_barrier()) rtrue;
			"There is nothing interesting under the wooden table.";
		LetGo:
			if (self.heat_barrier(noun)) rtrue;
			rfalse;
		Touch:
			if (self.heat_barrier()) rtrue;
			rfalse;
	],
	after [;
		LetGo:
			if (papermess.burnedness)
				print_ret "You yank ", (the) noun, " out of the way of
					the fire.";
		Receive:
			if (papermess.burnedness >= 8) {
				print_ret "You toss ", (the) noun, " into the flames on
					the table.";
			}
	],
	heat_barrier [ obj;
		if (papermess.burnedness >= 8) {
			if (obj)
				print "You can no longer reach ", (the) obj, " or anything
					else on the table.";
			else
				print "You can no longer reach the table, or anything on it.";
			" The heat is too intense.";
		}
		rfalse;
	],
  has scenery supporter;

Object -> -> papermess 
  with
	name 'paper' 'papers' 'of' 'pile' 'piles',
	parse_name [ num wd;
		self.parse_used_scrapword = 0;
		num = 0;
		wd = NextWord();
		while ((WordInProperty(wd, self, name) ~= 0)
			|| (self.burnedness && WordInProperty(wd, nameoffire, name) ~= 0)
			|| (self has general && wd == 'useless')
			|| (parent(uselesspaper) == 0 && wd == 'scrap')) {
			if (wd == 'scrap')
				self.parse_used_scrapword = 1;
			num++;
			wd = NextWord();
		}
		if (self.parse_used_scrapword) {
			print "(", (the) self, ")^";
			self.parse_used_scrapword = 0;
		}
		return num;
	],
	parse_used_scrapword 0,
	short_name [;
		if (self hasnt general)
			print "piles of paper";
		else
			print "piles of useless papers";
		rtrue;
	],
	description [;
		if (self.burnedness >= 8) {
			"You can see nothing of the piles of papers but waves of
				flame.";
		}
		if (self hasnt general) {
			<<Search self>>;
		}
		print "The remaining papers on the table consist of schedules, personal
			notes, diagrams of unimportant equipment -- power supplies and
			the like -- blank sheets,
			and an amazing number of rounds of a children's
			paper game, all dots and curves.";
		switch (self.burnedness) {
			0: ! do nothing
			1, 2: print " One sheet of paper is burning.";
			3, 4: print " A few of the papers are on fire.";
			default: print " Some of the papers are on fire.";
		}
		new_line;
		rtrue;
	],
	before [;
		Search:
			if (self.burnedness >= 8) {
				"You can see nothing of the piles of papers but waves of
					flame. You'll never get anything from the table now.";
			}
			if (player in gocage) {
				"You can't reach the table from inside the cage.";
			}
			if (self hasnt general) {
				if (self.burnedness == 0) 
					print "You quickly sort through the papers, as best you
						can from your briefing lectures.";
				else
					print "You hastily sort through the papers, working
						around the flames as best you can, moving
						important-looking papers to the floor.";
				print " In a few moments, you
					have piled up a single stack of the most
					critical diagrams, tables, formulae, and notes.
					Everything else is left scattered across the table in 
					more disarray than when you started.^";
				give self general;
				if (self.burnedness) {
					move usefulstack to parent(labtable);
				}
				else {
					move usefulstack to labtable;
				}
				if (cabinetplate has scenery) {
					give cabinetplate ~scenery;
					print "^While sorting, you discovered
						a logic plate buried under a spread of
						scribbled diagrams.";
					if (self.burnedness) {
						move cabinetplate to player;
						print " You snatch it away from the flames.";
					}
					new_line;
				}
				rtrue;
			}
			else {
				"You have already sorted out everything that looks useful.";
			}
		LookUnder:
			if (self.burnedness >= 8)
				<<Search self>>;
			if (self.burnedness)
				print "You shuffle papers around, avoiding the flames. ";
			if (cabinetplate has scenery) {
				give cabinetplate ~scenery;
				"You find a logic plate underneath a spread of scribbled
					diagrams.";
			}
			else {
				"There is nothing else underneath the paper except
					more paper.";
			}
		Take:
			if (self.burnedness >= 8)
				<<Search self>>;
			if (parent(uselesspaper) == 0) {
				move uselesspaper to player;
				PronounNotice(uselesspaper);
				if (self.burnedness)
					print "Carefully avoiding the flames, you";
				else
					print "You";
				if (self hasnt general)
					" randomly pull out a scrap of paper. But you'll
						have to search more carefully to find anything
						worth carrying away.";
				else
					" randomly pull a scrap of paper out of the useless
						piles that remain on the table.";
			}
			else {
				if (self hasnt general)
					"You've already taken some scrap paper. You'll
						have to search more carefully to find anything
						worth carrying away.";
				else
					"You've already taken some of the scrap paper, and
						you already know there's no value in what's left
						on the table.";
			}
		Receive:
			<<PutOn noun labtable>>;
		TouchFrom:
			if (IsOnFire(noun)) {
				if (self.burnedness)
					rfalse;
				self.startup();
				print_ret "You hold ", (the) noun, " against one of the papers
					on the table. The fire catches within moments.";
			}
		TouchTo:
			if (IsOnFire(second))
				<<BaseTouchTo second self>>;
	],
	burnedness 0, ! 1 or more means burning.
	startup [;
		! start the fire
		if (self.burnedness)
			return;
		self.burnedness = 1;
		! move tableash to labtable;
	],
	daemon [ ix;
		! subdaemon of fire stuff. This is called before other items.
		
		if (self.burnedness == 0) {
			! check for fires on table
			ix = 0;
			if (uselesspaper in labtable && uselesspaper.smoking >= 2)
				ix = uselesspaper;
			if (usefulstack in labtable && usefulstack.smoking >= 2)
				ix = usefulstack;
			if (ix) {
				self.startup();
				print "^", (The) ix, " has set one of the other papers
					on the table alight.^"; 
			}
		}
		
		if (self.burnedness == 0)
			return;
			
		self.burnedness++;
		switch (self.burnedness) {
			3:
				print "^More of the papers on the table are burning now.^";
			5:
				print "^The flames on the table spread.^";
			8:
				print "^With a hiss, fire leaps to another pile of
					paper. Most of the papers on the table are now
					aflame.^";
			12:
				print "^The surface of the table is a sheet of fire,
					in-swept and pulled high in the center.^";
			14:
				print "^The flames crackle.^";
			18:
				print "^The wall above the table is beginning to catch.
					You can feel heat shining on your skin.^";
			22:
				print "^The table itself is burning hotly now.^";
			24:
				print "^Flames are crawling up the wall. Smoke is thick
					across the ceiling -- fortunately, high enough
					that you are still below it.^";
			28:
				print "^The flames crackle.^";
			default:
				if (self.burnedness >= 30) {
					if (self.burnedness % 4 == 0)
						print "^The flames crackle.^";
				}
		}
		
	],
  has scenery pluralname; ! general means it's been sorted.

Object -> -> cabinetplate "logic plate"
  with
	name 'logic' 'plate' 'resin',
	description "It's a logic plate like most, though fairly large --
		wider than your two spread hands. Circuit paths are dimly visible
		inside the smoky resin, and the edges sparkle with link bands.",
	shortout [;
		give self general;
		"A corona of sparks surrounds the logic plate. Blue light crackles
			along the circuit paths.";
	],
	before [;
		Take, Push, Push, Search, Examine:
			if (self has scenery) {
				give self ~scenery;
				print "(finding ", (the) self, " under the papers)^";
				rfalse;
			}
	],
  has scenery ~general; ! general means it's fried. 

Object -> hotplate "notable device"
  with
	name 'notable' 'notably' 'large' 'black' 'device'
		'alcove',
	description [;
		print "The black device doesn't have the half-built, rigged
			quality of the other machinery nearby. It is curved, polished,
			and sleek. It has faired vents along the top.
			There is a round alcove in its front,";
		if (child(self))
			print " which contains ", (a) child(self);
		else
			print " which is empty";
		print ". The only control is a";
		if (self hasnt general)
			print " tiny black switch";
		else
			print " tiny switch, which is glowing red";
		".";
	],
	react_before [;
		Examine:
			rfalse;
		Touch:
			if (noun in self) {
				if (noun provides adjust_temp)
					rfalse;
				switch (self.temperature) {
					1: 
						print_ret "You can feel warmth radiating from ", 
							(the) noun, ".";
					2: 
						"You can feel heat radiating from ", 
							(the) noun, ".";
					3: 
						"You can feel intense heat radiating from ", 
							(the) noun, ".";
					default: 
						rfalse;
				}
			}
			rfalse;
	],
	before [;
		Search:
			if (child(self))
				print_ret "There is ", (a) child(self), " in the device's
					alcove.";
			else
				print_ret "The device's alcove is empty.";
		Take, Push, Pull:
			"The device is a bit too heavy to move.";
		Touch:
			switch (self.heat_source) {
				1: "You can feel warmth radiating from the alcove.";
				2: "You can feel heat radiating from the alcove.";
				3: "You can feel intense heat radiating from the alcove.";
				default: "The surface is streamlined smooth.";
			}
		SwitchOn, SwitchOff:
			<<(action) hotplateswitch>>;
		Receive:
			if (labtable.heat_barrier(self)) rtrue;
			if (child(self))
				print_ret "There is already ", (a) child(self), " in the
					device's alcove.";
			else
				rfalse;
		LetGo:
			if (labtable.heat_barrier(noun)) rtrue;
			if (noun provides adjust_temp)
				rfalse;
			switch (self.temperature) {
				2: print_ret (The) noun, " is too hot to touch.";
				3: print_ret (The) noun, " is blisteringly hot; you can't
					touch it.";
				default:
			}
	],
	after [;
		LetGo:
			if (noun provides adjust_temp)
				rfalse;
			if (self.temperature == 1)
				print_ret (The) noun, " is warm as you take it from the
					alcove, although it cools quickly.";
	],
	startup [;
		StartDaemon(self);
		self.heat_source = -1;
	],
	heat_source 0, ! temperature of heating element
	temperature 0, ! temperature of contents, if applicable
	daemon_priority -30, ! lower than insidevoice
	daemon [ ix obj;
		! this handles all the heat and fire
		! temperatures are 0=cool, 1=warm, 2=hot, 3=damn hot
		! heat_source can also be -1, meaning cool but bored
		
		! the alcove
		if (self has general) {
			if (self.heat_source < 3)
				self.heat_source++;
		}
		else {
			if (self.heat_source >= 0)
				self.heat_source--;
		}
		
		! generic contents
		obj = child(self);
		if (obj == 0) {
			self.temperature = 0;
		}
		else if (obj provides adjust_temp) {
			! do nothing; it will be handled separately
		}
		else {
			self.temperature = AdjustTemperature(self.temperature, self.heat_source);
		}
		
		! adjust_temp properties are called every round.
		
		papermess.daemon();
		
		ix = FindEnvTemp(uselesspaper);
		uselesspaper.adjust_temp(ix);
		
		ix = FindEnvTemp(usefulstack);
		usefulstack.adjust_temp(ix);
		
		ix = FindEnvTemp(hotpot);
		hotpot.adjust_temp(ix);
	],
  has scenery open container; ! general means on, of course

Object -> -> hotpot "glass pot"
  with
	name 'glass' 'pot' 'lid' 'spout',
	description [;
		print "It's a fat glass pot with a spout and a close-fitting 
			lid, which leaves the spout open. There is a wooden handle on
			one side. ";
		<<Search self>>;
	],
	temperature 0,
	adjust_temp [ envval oldval;
		oldval = self.temperature;
		self.temperature = AdjustTemperature(self.temperature, envval);
		if (papermess.burnedness == 0) {
			! skip the smell if the table is on fire
			switch (self.temperature) {
				0, 1:
					if (oldval > 1)
						print "^The odor is fading away.^";
				2:
					if (oldval < 2)
						print "^You smell something burning.^";
				3:
					if (oldval < 3)
						print "^An oily, burning odor fills the room, although
							you cannot see any smoke.^";
			}
		}
	],
	before [;
		Receive:
			print_ret (The) noun, " won't fit through the spout.";
		Search:
			"The pot is empty; but the inside bottom surface
				seems to be crusted with some burnt substance.";
		Open:
			"The lid seems to be locked on.";
		Empty, EmptyT:
			"The burnt crust is stuck to the bottom of the pot.";
		Smell:
			<<Smell hotpotcrust>>;
		Touch:
			switch (self.temperature) {
				0: "It feels like glass.";
				1: "The glass is warm.";
				2: "The glass is hot.";
				3: "The glass is burning hot; you jerk away.";
			}
	],
	after [;
		Take:
			switch (self.temperature) {
				2: "You feel the heat radiating from the glass.
						Fortunately, the handle is cool.";
				3: "You feel blistering heat radiating from the glass.
						Fortunately, the handle is merely warm.";
			}
	],
  has transparent;

Object -> -> -> hotpotcrust "burnt substance"
  with
	name 'bottom' 'burnt' 'burned' 'crust' 'substance',
	description "There is a burnt crust of some dark substance caking
		the bottom of the glass pot.",
	before [;
		Examine:
			rfalse;
		Smell:
			switch (hotpot.temperature) {
				0, 1: "It smells faintly burnt.";
				2: "An oily, burnt odor rises from the pot.";
				3: "A powerful odor emanates from the pot -- oily,
					burnt, but aromatic nevertheless.";
			}
		default:
			"You can't reach through the spout to the burnt substance.";
	],
  has scenery;

Object -> hotplateswitch
  with
	name 'tiny' 'switch',
	parse_name [ num wd val1 val2;
		if (hotplate has general) {
			val1 = 'red';
			val2 = 'glowing';
		}
		else {
			val1 = 'black';
			val2 = 'black';
		}
		num = 0;
		wd = NextWord();
		while ((WordInProperty(wd, self, name) ~= 0)
			|| wd == val1 or val2) {
			num++;
			wd = NextWord();
		} 
		return num;
	],
	short_name [;
		if (hotplate has general)
			print "tiny glowing red switch";
		else
			print "tiny black switch";
		rtrue;
	],
	before [;
		SwitchOn:
			if (hotplate has general)
				"The tiny switch is already on.";
			give hotplate general;
			"The tiny switch begins to glow red as you turn it on.";
		SwitchOff:
			if (hotplate hasnt general)
				"The tiny switch is already off.";
			give hotplate ~general;
			"The tiny switch turns black again.";
		Turn, Push:
			if (hotplate has general)
				<<SwitchOff self>>;
			else
				<<SwitchOn self>>;
		Take:
			print_ret "That's part of ", (the) hotplate, ".";
	],
  has scenery;

Object -> scenerymachinery "unlabelled machinery"
  with
	name 'arcane' 'half-built' 'unlabelled' 'machine' 'machinery' 'machines',
	before [;
		default:
			print_ret "There's not much you can do with ", (the) self, ".";
	],
  has scenery;

Object -> labwalls "walls"
  with
	name 'tough' 'white' 'composite' 'wall' 'walls',
	description [;
		print "The walls are faced with tough white composite.";
		if (papermess.burnedness >= 18) {
			print " Flames are licking up the wall above the table. It takes
				a while for composite to catch, but apparently it has.";
		}
		new_line;
		rtrue;
	],
	before [;
		Examine:
			rfalse;
		Search:
			<<Examine self>>;
		default:
			<<(action) whitewalls second>>;
	],
  has pluralname scenery;

Object -> labceiling "ceiling"
  with
	name 'roof' 'ceiling',
	description "The ceiling is high, more than twice as high as the
		panelling you have seen elsewhere. You cannot see what it is made of.",
	before [;
		Examine:
			rfalse;
		default:
			"The ceiling here is far out of reach.";
	],
  has scenery;

Object -> labdoorin "laboratory door"
  with
	name 'heavy' 'lab' 'laboratory' 'door',
	description [;
		print "It's still huge, it's still heavy, and it's";
		if (labdoor hasnt open)
			print " closed.";
		else
			print " still open.";
		" There is a small white pad beside it, and an access panel.";
	],
	door_to OutsideLab, 
	door_dir e_to,
	door_try [;
		if (labdoor hasnt open) {
			PronounNotice(self);
			"The door is shut tight.";
		}
	],
  has door open scenery;

Object -> labpad
  class ContactPad,
  with
	description "It's a dull white rectangle, about the width of two of 
		your fingers. There's an access panel below it.",
	shortout [;
		give labdoor locked;
	],
	is_active [ noisy;
		if (noisy == 0) {
			if (labdoor has locked)
				rfalse;
			else
				rtrue;
		}
		else {
			if (labdoor has locked)
				"The door does not move.";
			give labdoor locked;
			"There is a sharp blue spark somewhere under the surface
				of the pad.";
		}
	],
	before [;
		Touch:
			if (labdoor has locked)
				"Nothing happens.";
			if (labdoor has open) {
				give labdoor ~open;
				"The door swings closed again.";
			}
			else {
				give labdoor open;
				"The heavy door swings open.";
			}
	];

Object -> labaccess "access panel"
  with
	name 'access' 'panel',
	description [;
		print "There is a small access panel next to the door, below the 
			contact pad.";
		if (self hasnt open)
			" It is closed.";
		else
			" It is open; you can see a layer of subcircuitry inside.";
	],
	shortout [;
		if (self hasnt open)
			rfalse;
		accesscircuits.shortout();
		rtrue;
	],
	before [;
		Empty, EmptyT:
			if (self hasnt open)
				<<Search self>>;
			else
				<<Take accesscircuits>>;
		Search:
			if (self hasnt open)
				"The panel is closed.";
			else
				"You see subcircuitry behind the open panel.";
		Receive:
			if (self hasnt open)
				<<Search self>>;
			else
				"You can't put anything in the panel.";
		Attack, AttackWith:
			if (self hasnt open)
				rfalse;
			<<(action) accesscircuits second>>;
	],
	after [;
		Open:
			"You pull the panel open, revealing a layer of subcircuitry.";
	],
  has scenery container openable ~open;

Object -> -> accesscircuits "layer of subcircuitry"
  with
	name 'layer' 'of' 'subcircuitry' 'subcircuit' 'circuitry' 'circuit'
		'circuits',
	description "You can't analyze subcircuitry with the unaided eye.",
	shortout [;
		give labdoor locked;
		print_ret (The) self, " showers a corona of sparks. Blue light
			crackles along the subcircuit paths.";
	],
	before [;
		Take:
			"The circuitry is fixed in place.";
		AttackWith:
			if (second ofclass PulseGun)
				rfalse;
			if (self hasnt general) {
				give labdoor locked;
				give self general;
				print_ret "You ram ", (the) second, " into the circuitry,
					which makes
					a very satisfactory crunching sound.";
			}
			else {
				"You've already done that.";
			}
		Attack:
			if (self hasnt general) {
				give labdoor locked;
				give self general;
				"You smack the circuitry with the heel of your hand. It makes
					a very satisfactory crunching sound.";
			}
			else {
				"You've already done that.";
			}
	],
  has scenery; ! general for broken

Object tableash "ash"
  with
	name 'ash' 'ashes',
	before [;
		Examine:
			rfalse;
		default:
			"The table is still on fire.";
	],
  has scenery;

Object uselesspaper "scrap of paper"
  class BurnablePaper,
  with
	name 'scrap' 'of' 'blank' 'paper',
	stage_list 1 2 4 5, 
	description [;
		self.print_discoloration("It's a nearly blank sheet, with a 
			few sums scribbled on it.");
		rtrue;
	],
	before [ ix;
		Examine:
			if (verb_word == 'read')
				<<Search self>>;
		Search:
			if (self has general)
				ix = "It's no more interesting than the last one.";
			else
				ix = "Your people probably already know that 844.625 times 6.283
					is 5306.779.";
			self.print_discoloration(ix);
			rtrue;
	],
	ash_and_gone [;
		self.BurnablePaper::ash_and_gone();
		self.temperature = 0;
		self.smoking = 0;
		self.burnedness = 0;
		self.discoloration = 0;
		give self general;
		remove self;
	],
  has ~general; ! general means it's not the first scrap you've got.

Object usefulstack "stack of important papers"
  class BurnablePaper,
  with
	name 'stack' 'of' 'important' 'critical' 'paper' 'papers',
	stage_list 1 3 6 8, 
	description [;
		self.print_discoloration("You have no notion what any of it means, 
			but it all
			matches the profile you were given of material relevant to
			the work done here.");
	],
	before [;
		Search:
			<<Examine self>>;
	];

[ DiedAtHome;
	
	! Endings: basically, you can have torched the lab, or not.
	
	if (papermess.burnedness >= 8) {
		return 4;
	}
	
	return 3;
];

[ OutTheWindow   ix;

	! Endings: seven of them.
	!   jumped to the mat (captured)
	!   jumped to the mat, but burned the lab
	!   just leave (don't take papers)
	!   take papers
	!   burn papers
	!   burn lab, take papers
	!   burn lab and papers
	! Of these, burning just the papers is almost the same as leaving them
	! behind, because there are backups.
	
	deadflag = 3;
	
	print "^~", (emphstring) "Nowhere...", "~ the familiar voice begins,
		and there is a terrible silence.^^Then, ~Blast it down,~ he says,
		very quietly. And screams, ~", (emphstring) "BLAST IT!", "~^";
	
	if (anywherein(player, gocage) == 0) {
		print "^But a light is pouring out of the scan-web cage, a sourceless
			glow that seems to shine straight through solidity, as if metal
			and plastic were starlit ice. The light builds and builds...^";
		print "^...and vanishes with a silent ", (emphstring) "snap", ".";
		ix = children(gocage);
		if (ix) {
			print " The ";
			WriteListFrom(child(gocage), TERSE_BIT + ENGLISH_BIT + NOARTICLE_BIT);
			if (ix > 1)
				print " vanish";
			else
				print " vanishes";
			print " as well, leaving the cage empty";
			if (labconoval hasnt general) {
				if (ix > 1)
					print ". They reappear";
				else
					print ". It reappears";
				print " without any fuss on the padded mat";
			}
			else {
				! off without you.
			}
			print ".";
		}
		else {
			! nothing transmitted.
		}
		
		print "^^You shake your head in slow wonder. Unfortunately, a
			moment later, the guards outside recall you to yourself.
			There is a deafening roar; the door tears into flying
			shards of metal. A hail of pulse-gun fire follows the
			blast in. You don't stand a moment's chance.^";
		return;
	}
	
	! the player is definitely going for a ride.
	deadflag = 5;
	
	print "^But a light is pouring out around you, a sourceless
		glow that seems to shine straight through solidity, as if metal
		and plastic were starlit ice. The light builds and builds...^";
	
	print "^Beyond the light you see the door burst open, with a distant,
		dreamlike roar. The lucent faces that crowd through seem to move
		in slow motion.
		Their guns are firing, but the pulses are frozen in space.
		You can see their eyes slide across you, the cage
		around you";
	if (anywherein(usefulstack, gocage)) {
		print ", the papers";
		if (anywherein(usefulstack, player))
			print " in your hand";
		else
			print " beside you";
	}
	print ", the light";
	if (papermess.burnedness) {
		deadflag = 4;
		print " -- the flames that are devouring everything";
		if (labconoval hasnt general)
			print " around you";
		else
			print " that you leave behind";
	}
	print ".^";
	
	if (labconoval hasnt general) {
		print "^Then blackness slaps into you with
			a silent ", (emphstring) "snap", ". You can dimly feel yourself
			falling to a padded surface, and the shouts of the guards go
			on -- until you are hauled to your feet, and the muzzle of
			a pulse-gun is pressed to the back of your head.^";
	}
	else {
		deadflag = 4;
		print "^Then the world vanishes. Blackness slaps into you with
			a silent ", (emphstring) "snap", ".^";
	}
];

