/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.instructions;

import org.zmpp.instructions.AbstractInstruction;
import org.zmpp.instructions.InstructionStaticInfo;
import org.zmpp.instructions.Short0StaticInfo;
import org.zmpp.vm.Machine;

public class Short0Instruction
extends AbstractInstruction {
    public Short0Instruction(Machine machine, int n) {
        super(machine, n);
    }

    public AbstractInstruction.InstructionResult doInstruction() {
        switch (this.getOpcode()) {
            case 0: {
                this.returnFromRoutine((short)1);
                break;
            }
            case 1: {
                this.returnFromRoutine((short)0);
                break;
            }
            case 4: {
                this.nextInstruction();
                break;
            }
            case 5: {
                this.saveToStorage(this.getMachine().getCpu().getProgramCounter() + 1);
                break;
            }
            case 6: {
                this.restoreFromStorage();
                break;
            }
            case 7: {
                this.getMachine().restart();
                break;
            }
            case 10: {
                this.getMachine().quit();
                break;
            }
            case 8: {
                this.returnFromRoutine(this.getCpu().getVariable(0));
                break;
            }
            case 9: {
                if (this.getStoryFileVersion() < 5) {
                    this.pop();
                    break;
                }
                this.z_catch();
                break;
            }
            case 11: {
                this.getMachine().getOutput().newline();
                this.nextInstruction();
                break;
            }
            case 12: {
                this.getMachine().updateStatusLine();
                this.nextInstruction();
                break;
            }
            case 13: {
                this.branchOnTest(this.getMachine().getGameData().hasValidChecksum());
                break;
            }
            case 15: {
                this.branchOnTest(true);
                break;
            }
            default: {
                this.throwInvalidOpcode();
            }
        }
        return new AbstractInstruction.InstructionResult(1, false);
    }

    public AbstractInstruction.InstructionForm getInstructionForm() {
        return AbstractInstruction.InstructionForm.SHORT;
    }

    public AbstractInstruction.OperandCount getOperandCount() {
        return AbstractInstruction.OperandCount.C0OP;
    }

    protected InstructionStaticInfo getStaticInfo() {
        return Short0StaticInfo.getInstance();
    }

    private void pop() {
        this.getCpu().getVariable(0);
        this.nextInstruction();
    }

    private void z_catch() {
        this.storeResult((short)(this.getCpu().getRoutineContexts().size() - 1));
        this.nextInstruction();
    }
}

